/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.impl.store.raw.data.BufferedByteHolderInputStream;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.shared.common.error.StandardException;

public class DecryptInputStream
extends BufferedByteHolderInputStream {
    protected DataFactory dataFactory;
    protected InputStream in;

    public DecryptInputStream(InputStream inputStream, ByteHolder byteHolder, DataFactory dataFactory) throws IOException {
        super(byteHolder);
        this.in = inputStream;
        this.dataFactory = dataFactory;
        this.fillByteHolder();
    }

    @Override
    public void fillByteHolder() throws IOException {
        if (this.bh.available() == 0) {
            this.bh.clear();
            try {
                int n = CompressedNumber.readInt(this.in);
                if (n == -1) {
                    return;
                }
                int n2 = n % this.dataFactory.getEncryptionBlockSize();
                int n3 = n2 == 0 ? 0 : this.dataFactory.getEncryptionBlockSize() - n2;
                int n4 = n + n3;
                byte[] byArray = new byte[n4];
                this.in.read(byArray, 0, n4);
                byte[] byArray2 = new byte[n4];
                this.dataFactory.decrypt(byArray, 0, n4, byArray2, 0);
                this.bh.write(byArray2, n3, n);
            }
            catch (StandardException standardException) {
                throw new IOException();
            }
            this.bh.startReading();
        }
    }
}

