/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.StatementUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.BulkInsertCounter;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.TargetResultSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.BulkTableScanResultSet;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.DMLWriteGeneratedColumnsResultSet;
import org.apache.derby.impl.sql.execute.DeferredConstraintsMemory;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.InsertConstantAction;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.RIBulkChecker;
import org.apache.derby.impl.sql.execute.RISetChecker;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.TriggerEventActivator;
import org.apache.derby.impl.sql.execute.TriggerEvents;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;
import org.apache.derby.impl.sql.execute.UniqueWithDuplicateNullsIndexSortObserver;
import org.apache.derby.shared.common.error.StandardException;

class InsertResultSet
extends DMLWriteGeneratedColumnsResultSet
implements TargetResultSet {
    NoPutResultSet savedSource;
    InsertConstantAction constants;
    private GeneratedMethod generationClauses;
    private GeneratedMethod checkGM;
    private long heapConglom;
    private RowChanger rowChanger;
    private TransactionController tc;
    private ExecRow row;
    boolean userSpecifiedBulkInsert;
    boolean bulkInsertPerformed;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    private boolean firstRow = true;
    private boolean[] needToDropSort;
    private Hashtable<Long, Long> indexConversionTable;
    private FormatableBitSet indexedCols;
    private ConglomerateController bulkHeapCC;
    protected DataDictionary dd;
    protected TableDescriptor td;
    private ExecIndexRow[] indexRows;
    private final int fullTemplateId;
    private final String schemaName;
    private final String tableName;
    private long[] sortIds;
    private RowLocationRetRowSource[] rowSources;
    private ScanController bulkHeapSC;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private SortController[] sorters;
    private TemporaryRowHolderImpl rowHolder;
    private RowLocation rl;
    private boolean hasBeforeRowTrigger;
    private BulkTableScanResultSet tableScan;
    private int numOpens;
    private boolean firstExecute;
    private FKInfo[] fkInfoArray;
    private TriggerInfo triggerInfo;
    private RISetChecker fkChecker;
    private TriggerEventActivator triggerActivator;
    private BulkInsertCounter[] bulkInsertCounters;
    private BackingStoreHashtable deferredChecks;
    private List<UUID> violatingCheckConstraints;

    @Override
    public void changedRow(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        if (this.constants.irgs.length > 0) {
            int n;
            RowLocation rowLocation2 = (RowLocation)rowLocation.cloneValue(false);
            for (n = 0; n < execRow.getRowArray().length; ++n) {
                if (!this.constants.indexedCols[n] || !(execRow.getRowArray()[n] instanceof StreamStorable)) continue;
                execRow.getRowArray()[n].getObject();
            }
            if (this.firstRow) {
                this.firstRow = false;
                this.indexRows = new ExecIndexRow[this.constants.irgs.length];
                this.setUpAllSorts(execRow.getNewNullRow(), rowLocation2);
            }
            for (n = 0; n < this.constants.irgs.length; ++n) {
                this.indexRows[n].getNewObjectArray();
                this.constants.irgs[n].getIndexRow(execRow, rowLocation2, this.indexRows[n], null);
                this.sorters[n].insert(this.indexRows[n].getRowArray());
            }
        }
    }

    @Override
    public ExecRow preprocessSourceRow(ExecRow execRow) throws StandardException {
        boolean bl;
        if (this.triggerInfo != null) {
            // empty if block
        }
        if (this.generationClauses != null) {
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.sourceResultSet, execRow, false);
        }
        if (this.checkGM == null || !(bl = this.evaluateCheckConstraints())) {
            // empty if block
        }
        if (this.constants.irgs.length > 0) {
            return execRow.getClone(this.indexedCols);
        }
        return execRow;
    }

    @Override
    public void offendingRowLocation(RowLocation rowLocation, long l) throws StandardException {
        if (this.violatingCheckConstraints != null) {
            this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(this.lcc, this.constants.targetUUID, this.schemaName, this.tableName, this.deferredChecks, this.violatingCheckConstraints, rowLocation, new DeferredConstraintsMemory.CheckInfo[1]);
            this.violatingCheckConstraints.clear();
        }
    }

    private boolean evaluateCheckConstraints() throws StandardException {
        boolean bl = true;
        if (this.checkGM != null) {
            SQLBoolean sQLBoolean = (SQLBoolean)this.checkGM.invoke(this.activation);
            bl = sQLBoolean.isNull() || sQLBoolean.getBoolean();
        }
        return bl;
    }

    InsertResultSet(NoPutResultSet noPutResultSet, GeneratedMethod generatedMethod, GeneratedMethod generatedMethod2, int n, String string, String string2, Activation activation) throws StandardException {
        super(activation);
        this.sourceResultSet = noPutResultSet;
        this.constants = (InsertConstantAction)this.constantAction;
        this.generationClauses = generatedMethod;
        this.checkGM = generatedMethod2;
        this.fullTemplateId = n;
        this.schemaName = string;
        this.tableName = string2;
        this.heapConglom = this.constants.conglomId;
        this.identitySequenceUUIDString = this.constants.identitySequenceUUIDString;
        this.tc = activation.getTransactionController();
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.hasBeforeRowTrigger = this.triggerInfo != null ? this.triggerInfo.hasTrigger(true, true) : false;
        this.resultDescription = this.sourceResultSet.getResultDescription();
        String string3 = this.constants.getProperty("insertMode");
        this.initializeAIcache(this.constants.getAutoincRowLocation());
        if (string3 != null) {
            if (StringUtil.SQLEqualsIgnoreCase(string3, "BULKINSERT")) {
                this.userSpecifiedBulkInsert = true;
            } else if (StringUtil.SQLEqualsIgnoreCase(string3, "REPLACE")) {
                this.userSpecifiedBulkInsert = true;
                this.bulkInsertReplace = true;
                this.bulkInsert = true;
                if (this.triggerInfo != null) {
                    TriggerDescriptor triggerDescriptor = this.triggerInfo.getTriggerArray()[0];
                    throw StandardException.newException("X0Y72.S", this.constants.getTableName(), triggerDescriptor.getName());
                }
            }
        }
    }

    @Override
    public void open() throws StandardException {
        this.setup();
        this.firstExecute = this.rowChanger == null;
        this.autoincrementGenerated = false;
        this.dd = this.lcc.getDataDictionary();
        this.verifyAutoGeneratedRScolumnsList(this.constants.targetUUID);
        this.rowCount = 0L;
        if (this.numOpens++ == 0) {
            this.sourceResultSet.openCore();
        } else {
            this.sourceResultSet.reopenCore();
        }
        if (this.userSpecifiedBulkInsert) {
            if (!this.bulkInsertReplace) {
                this.bulkInsert = this.verifyBulkInsert();
            } else {
                this.getExclusiveTableLock();
            }
        }
        if (this.bulkInsert) {
            this.sourceResultSet.setTargetResultSet(this);
            ExecRow execRow = ((ExecRowBuilder)this.activation.getPreparedStatement().getSavedObject(this.fullTemplateId)).build(this.activation.getExecutionFactory());
            this.bulkInsertCore(this.lcc, execRow, this.heapConglom);
            if (this.triggerInfo != null) {
                // empty if block
            }
            this.bulkValidateForeignKeys(this.tc, this.lcc.getContextManager(), execRow);
            this.bulkInsertPerformed = true;
        } else {
            this.row = this.getNextRowCore(this.sourceResultSet);
            this.normalInsertCore(this.lcc, this.firstExecute);
        }
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.sourceResultSet;
        }
        this.cleanUp();
        this.saveAIcacheInformation(this.constants.getSchemaName(), this.constants.getTableName(), this.constants.getColumnNames());
        this.endTime = this.getCurrentTimeMillis();
    }

    @Override
    public void close() throws StandardException {
        this.close(this.constants.underMerge());
        if (this.autoGeneratedKeysRowsHolder != null) {
            this.autoGeneratedKeysRowsHolder.close();
        }
    }

    private int[] generatedColumnPositionsArray() throws StandardException {
        TableDescriptor tableDescriptor = this.dd.getTableDescriptor(this.constants.targetUUID);
        int n = tableDescriptor.getMaxColumnID();
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(i + 1);
            if (columnDescriptor.isAutoincrement()) {
                ++n2;
                nArray[i] = i + 1;
                continue;
            }
            if (columnDescriptor.getDefaultValue() == null && columnDescriptor.getDefaultInfo() == null) continue;
            ++n2;
            nArray[i] = i + 1;
        }
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == -1) continue;
            nArray2[n3++] = nArray[i];
        }
        return nArray2;
    }

    @Override
    public NumberDataValue getSetAutoincrementValue(int n, long l) throws StandardException {
        int n2 = n - 1;
        this.setIdentity = !this.autoincrementGenerated && this.isSourceRowResultSet();
        this.autoincrementGenerated = true;
        if (this.bulkInsert) {
            if (this.identitySequenceUUIDString == null) {
                this.getOldStyleBulkInsertValue(n2, l);
            } else {
                if (this.bulkInsertCounters[n2] == null) {
                    this.bulkInsertCounters[n2] = this.dd.getBulkInsertCounter(this.identitySequenceUUIDString, this.bulkInsertReplace);
                }
                this.bulkInsertCounters[n2].getCurrentValueAndAdvance((NumberDataValue)this.aiCache[n2]);
            }
        } else {
            NumberDataValue numberDataValue = this.identitySequenceUUIDString == null ? this.getOldStyleIdentityValue(n2) : this.activation.getCurrentValueAndAdvance(this.identitySequenceUUIDString, this.aiCache[n2].getTypeFormatId());
            this.aiCache[n2] = numberDataValue;
            if (this.setIdentity) {
                this.identityVal = numberDataValue.getLong();
            }
        }
        return (NumberDataValue)this.aiCache[n2];
    }

    private void getOldStyleBulkInsertValue(int n, long l) throws StandardException {
        int n2 = n + 1;
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(n2);
        if (this.aiCache[n].isNull()) {
            long l2;
            if (this.bulkInsertReplace) {
                l2 = columnDescriptor.getAutoincStart();
            } else {
                NumberDataValue numberDataValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n], this.tc, false, (NumberDataValue)this.aiCache[n], true);
                l2 = numberDataValue.getLong();
            }
            this.lcc.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), columnDescriptor.getColumnName(), l2, l, n2);
        }
        long l3 = this.lcc.nextAutoincrementValue(this.td.getSchemaName(), this.td.getName(), columnDescriptor.getColumnName());
        this.aiCache[n2 - 1].setValue(l3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NumberDataValue getOldStyleIdentityValue(int n) throws StandardException {
        NumberDataValue numberDataValue;
        block11: {
            TransactionController transactionController;
            TransactionController transactionController2 = null;
            try {
                transactionController = transactionController2 = this.tc.startNestedUserTransaction(false, false);
            }
            catch (StandardException standardException) {
                transactionController = this.tc;
            }
            try {
                numberDataValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n], transactionController, true, (NumberDataValue)this.aiCache[n], transactionController == this.tc);
            }
            catch (StandardException standardException) {
                if (transactionController == this.tc) {
                    throw standardException;
                }
                if (standardException.getMessageId().equals("40XL1") || standardException.isSelfDeadlock()) {
                    numberDataValue = this.dd.getSetAutoincrementValue(this.constants.autoincRowLocation[n], this.tc, true, (NumberDataValue)this.aiCache[n], true);
                    break block11;
                }
                if (standardException.getMessageId().equals("22003")) {
                    throw StandardException.newException("42Z24", standardException, this.constants.getTableName(), this.constants.getColumnName(n));
                }
                throw standardException;
            }
            finally {
                if (transactionController2 != null) {
                    transactionController2.commitNoSync(1);
                    transactionController2.destroy();
                }
            }
        }
        return numberDataValue;
    }

    private boolean isSourceRowResultSet() {
        boolean bl = false;
        if (this.sourceResultSet instanceof NormalizeResultSet) {
            bl = ((NormalizeResultSet)this.sourceResultSet).source instanceof RowResultSet;
        }
        return bl;
    }

    private boolean isSingleRowResultSet() {
        boolean bl = false;
        if (this.sourceResultSet instanceof RowResultSet) {
            bl = true;
        } else if (this.sourceResultSet instanceof NormalizeResultSet) {
            bl = ((NormalizeResultSet)this.sourceResultSet).source instanceof RowResultSet;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void normalInsertCore(LanguageConnectionContext languageConnectionContext, boolean bl) throws StandardException {
        Object object;
        boolean bl2 = this.constants.hasAutoincrement() && this.isSingleRowResultSet();
        long l = 0L;
        if (bl) {
            this.rowChanger = languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.heapConglom, this.constants.heapSCOCI, this.heapDCOCI, this.constants.irgs, this.constants.indexCIDS, this.constants.indexSCOCIs, this.indexDCOCIs, 0, this.tc, null, this.constants.getStreamStorableHeapColIds(), this.activation);
            this.rowChanger.setIndexNames(this.constants.indexNames);
        }
        int n = this.decodeLockMode(this.constants.lockMode);
        this.rowChanger.open(n);
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (this.fkInfoArray != null) {
            if (this.fkChecker == null) {
                this.fkChecker = new RISetChecker(languageConnectionContext, this.tc, this.fkInfoArray);
            } else {
                this.fkChecker.reopen();
            }
        }
        if (bl && this.constants.deferred) {
            object = new Properties();
            this.rowChanger.getHeapConglomerateController().getInternalTablePropertySet((Properties)object);
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, (Properties)object, this.resultDescription);
            this.rowChanger.setRowHolder(this.rowHolder);
        }
        this.firstExecuteSpecialHandlingAutoGen(bl, this.rowChanger, this.constants.targetUUID);
        while (this.row != null) {
            if (this.activation.getAutoGeneratedKeysResultsetMode() && this.autoGeneratedKeysColumnIndexes.length > 0) {
                this.autoGeneratedKeysRowsHolder.insert(this.getCompactRow(this.row, this.autoGeneratedKeysColumnIndexes));
            }
            this.evaluateGenerationClauses(this.generationClauses, this.activation, this.sourceResultSet, this.row, false);
            if (this.constants.deferred) {
                this.rowHolder.insert(this.row);
            } else {
                Object object2;
                boolean bl3 = this.evaluateCheckConstraints();
                if (this.fkChecker != null) {
                    this.fkChecker.doFKCheck(this.activation, this.row);
                }
                if (this.constants.irgs.length > 0) {
                    object2 = this.row.getRowArray();
                    for (int i = 0; i < ((DataValueDescriptor[])object2).length; ++i) {
                        if (!this.constants.indexedCols[i] || !(object2[i] instanceof StreamStorable)) continue;
                        object2[i].getObject();
                    }
                }
                if (bl3) {
                    this.rowChanger.insertRow(this.row, false);
                } else {
                    object2 = this.rowChanger.insertRow(this.row, true);
                    this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(languageConnectionContext, this.constants.targetUUID, this.schemaName, this.tableName, this.deferredChecks, this.violatingCheckConstraints, (RowLocation)object2, new DeferredConstraintsMemory.CheckInfo[1]);
                }
            }
            ++this.rowCount;
            if (bl2) {
                ColumnDescriptor columnDescriptor;
                int n2;
                this.dd = languageConnectionContext.getDataDictionary();
                this.td = this.dd.getTableDescriptor(this.constants.targetUUID);
                int n3 = this.td.getMaxColumnID();
                for (n2 = 1; n2 <= n3 && !(columnDescriptor = this.td.getColumnDescriptor(n2)).isAutoincrement(); ++n2) {
                }
                if (n2 <= n3) {
                    DataValueDescriptor dataValueDescriptor = this.row.cloneColumn(n2);
                    l = dataValueDescriptor.getLong();
                }
            }
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.sourceResultSet);
        }
        if (this.constants.deferred) {
            ExecRow execRow;
            if (this.triggerInfo != null) {
                object = null;
                if (this.aiCache != null) {
                    object = new Vector<AutoincrementCounter>();
                    for (int i = 0; i < this.aiCache.length; ++i) {
                        if (this.aiCache[i] == null) continue;
                        String string = this.constants.getSchemaName();
                        String string2 = this.constants.getTableName();
                        String string3 = this.constants.getColumnName(i);
                        Long l2 = languageConnectionContext.lastAutoincrementValue(string, string2, string3);
                        AutoincrementCounter autoincrementCounter = new AutoincrementCounter(l2, this.constants.getAutoincIncrement(i), this.aiCache[i].getLong(), string, string2, string3, i + 1);
                        ((Vector)object).addElement(autoincrementCounter);
                    }
                }
                if (this.triggerActivator == null) {
                    this.triggerActivator = new TriggerEventActivator(languageConnectionContext, this.constants.targetUUID, this.triggerInfo, 3, this.activation, (Vector<AutoincrementCounter>)object);
                } else {
                    this.triggerActivator.reopen();
                }
                this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_INSERT, null, this.rowHolder.getResultSet(), null);
            }
            object = this.rowHolder.getResultSet();
            try {
                object.open();
                while ((execRow = object.getNextRow()) != null) {
                    this.sourceResultSet.setCurrentRow(execRow);
                    boolean bl4 = this.evaluateCheckConstraints();
                    if (bl4) {
                        this.rowChanger.insertRow(execRow, false);
                        continue;
                    }
                    RowLocation rowLocation = this.rowChanger.insertRow(execRow, true);
                    this.deferredChecks = DeferredConstraintsMemory.rememberCheckViolations(languageConnectionContext, this.constants.targetUUID, this.schemaName, this.tableName, this.deferredChecks, this.violatingCheckConstraints, rowLocation, new DeferredConstraintsMemory.CheckInfo[1]);
                }
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                object.close();
            }
            if (this.fkChecker != null) {
                object = this.rowHolder.getResultSet();
                try {
                    object.open();
                    while ((execRow = object.getNextRow()) != null) {
                        this.fkChecker.doFKCheck(this.activation, execRow);
                    }
                }
                finally {
                    object.close();
                }
            }
            if (this.triggerActivator != null) {
                this.triggerActivator.notifyEvent(TriggerEvents.AFTER_INSERT, null, this.rowHolder.getResultSet(), null);
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
            this.fkChecker = null;
        }
        if (this.setIdentity) {
            languageConnectionContext.setIdentityValue(this.identityVal);
        } else if (bl2) {
            languageConnectionContext.setIdentityValue(l);
        }
    }

    @Override
    protected ExecRow getNextRowCore(NoPutResultSet noPutResultSet) throws StandardException {
        ExecRow execRow = super.getNextRowCore(noPutResultSet);
        if (execRow != null && this.constants.underMerge()) {
            execRow = this.processMergeRow(noPutResultSet, execRow);
        }
        return execRow;
    }

    private ExecRow processMergeRow(NoPutResultSet noPutResultSet, ExecRow execRow) throws StandardException {
        if (this.constants.hasAutoincrement()) {
            boolean bl;
            int n = this.constants.getAutoGenColumn();
            long l = this.constants.getAutoincIncrement(n);
            DataValueDescriptor dataValueDescriptor = execRow.getColumn(n + 1);
            boolean bl2 = bl = dataValueDescriptor == null || this.constants.autoincrementColumnSetToDEFAULT();
            if (bl) {
                NumberDataValue numberDataValue = this.getSetAutoincrementValue(n + 1, l);
                execRow.setColumn(n + 1, numberDataValue);
            }
        }
        return this.normalizeRow(noPutResultSet, execRow);
    }

    private void bulkInsertCore(LanguageConnectionContext languageConnectionContext, ExecRow execRow, long l) throws StandardException {
        Object object;
        this.bulkHeapCC = this.tc.openCompiledConglomerate(false, 4, 7, 5, this.constants.heapSCOCI, this.heapDCOCI);
        Properties properties = new Properties();
        this.bulkHeapCC.getInternalTablePropertySet(properties);
        if (this.triggerInfo != null) {
            // empty if block
        }
        if (this.hasBeforeRowTrigger && this.rowHolder != null) {
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties, this.resultDescription);
        }
        Properties properties2 = this.constants.getTargetProperties();
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            properties.put(object, properties2.getProperty((String)object));
        }
        if (this.constants.irgs.length > 0) {
            this.sourceResultSet.setNeedsRowLocation(true);
        }
        if (this.constants.hasDeferrableChecks) {
            this.sourceResultSet.setHasDeferrableChecks();
        }
        this.dd = languageConnectionContext.getDataDictionary();
        this.td = this.dd.getTableDescriptor(this.constants.targetUUID);
        object = new long[1];
        long l2 = this.bulkInsertReplace ? this.tc.createAndLoadConglomerate("heap", execRow.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0, this.sourceResultSet, (long[])object) : this.tc.recreateAndLoadConglomerate("heap", false, execRow.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0, l, this.sourceResultSet, (long[])object);
        if (l2 == l) {
            return;
        }
        this.rowCount = (long)object[0];
        this.setEstimatedRowCount(l2);
        this.dd.startWriting(languageConnectionContext);
        if (this.identitySequenceUUIDString == null) {
            languageConnectionContext.autoincrementFlushCache(this.constants.targetUUID);
        } else {
            for (BulkInsertCounter bulkInsertCounter : this.bulkInsertCounters) {
                if (bulkInsertCounter == null) continue;
                this.dd.flushBulkInsertCounter(this.identitySequenceUUIDString, bulkInsertCounter);
            }
        }
        DependencyManager dependencyManager = this.dd.getDependencyManager();
        dependencyManager.invalidateFor(this.td, 15, languageConnectionContext);
        if (this.constants.irgs.length > 0) {
            this.updateAllIndexes(l2, this.constants, this.td, this.dd, execRow);
        }
        this.bulkHeapCC.close();
        this.bulkHeapCC = null;
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(l);
        this.dd.updateConglomerateDescriptor(conglomerateDescriptor, l2, this.tc);
        this.tc.dropConglomerate(l);
    }

    private void bulkValidateForeignKeys(TransactionController transactionController, ContextManager contextManager, ExecRow execRow) throws StandardException {
        if (this.indexRows == null && !this.bulkInsertReplace || this.fkInfoArray == null) {
            return;
        }
        for (FKInfo fKInfo : this.fkInfoArray) {
            if (this.bulkInsertReplace) {
                for (int i = 0; i < fKInfo.fkConglomNumbers.length; ++i) {
                    long l;
                    long l2;
                    if (fKInfo.fkIsSelfReferencing[i] && this.indexRows == null) continue;
                    if (fKInfo.fkIsSelfReferencing[i]) {
                        l2 = this.indexConversionTable.get(fKInfo.refConglomNumber);
                        l = this.indexConversionTable.get(fKInfo.fkConglomNumbers[i]);
                    } else {
                        Long l3 = this.indexConversionTable.get(fKInfo.refConglomNumber);
                        Long l4 = this.indexConversionTable.get(fKInfo.fkConglomNumbers[i]);
                        l2 = l3 == null ? fKInfo.refConglomNumber : l3;
                        l = l4 == null ? fKInfo.fkConglomNumbers[i] : l4;
                    }
                    this.bulkValidateForeignKeysCore(transactionController, contextManager, fKInfo, l, l2, fKInfo.fkConstraintNames[i], execRow);
                }
                continue;
            }
            Long l = this.indexConversionTable.get(fKInfo.fkConglomNumbers[0]);
            this.bulkValidateForeignKeysCore(transactionController, contextManager, fKInfo, l, fKInfo.refConglomNumber, fKInfo.fkConstraintNames[0], execRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkValidateForeignKeysCore(TransactionController transactionController, ContextManager contextManager, FKInfo fKInfo, long l, long l2, String string, ExecRow execRow) throws StandardException {
        GenericScanController genericScanController = null;
        GenericScanController genericScanController2 = null;
        try {
            ExecRow execRow2 = this.makeIndexTemplate(fKInfo, execRow, contextManager);
            genericScanController2 = transactionController.openGroupFetchScan(l, false, 0, 7, 2, null, null, 1, null, null, -1);
            genericScanController = transactionController.openGroupFetchScan(l2, false, 0, l == l2 ? 7 : 6, 2, null, null, 1, null, null, -1);
            ExecRow execRow3 = execRow2.getClone();
            RIBulkChecker rIBulkChecker = new RIBulkChecker(this.activation, (GroupFetchScanController)genericScanController, (GroupFetchScanController)genericScanController2, execRow2, true, null, execRow3, fKInfo.schemaName, fKInfo.tableName, fKInfo.fkIds[0], fKInfo.deferrable[0], l, l2);
            int n = rIBulkChecker.doCheck();
            if (n > 0) {
                StandardException standardException = StandardException.newException("23503", string, fKInfo.tableName, StatementUtil.typeName(fKInfo.stmtType), RowUtil.toString(execRow3, 0, fKInfo.colArray.length - 1));
                throw standardException;
            }
        }
        finally {
            if (genericScanController2 != null) {
                genericScanController2.close();
            }
            if (genericScanController != null) {
                genericScanController.close();
            }
        }
    }

    private ExecRow makeIndexTemplate(FKInfo fKInfo, ExecRow execRow, ContextManager contextManager) throws StandardException {
        ExecIndexRow execIndexRow = RowUtil.getEmptyIndexRow(fKInfo.colArray.length + 1, this.lcc);
        DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray2 = execIndexRow.getRowArray();
        for (int i = 0; i < fKInfo.colArray.length; ++i) {
            dataValueDescriptorArray2[i] = dataValueDescriptorArray[fKInfo.colArray[i] - 1].cloneValue(false);
        }
        dataValueDescriptorArray2[i] = fKInfo.rowLocation.cloneValue(false);
        return execIndexRow;
    }

    private void setUpAllSorts(ExecRow execRow, RowLocation rowLocation) throws StandardException {
        int n;
        int n2 = this.constants.irgs.length;
        int n3 = this.td.getNumberOfColumns();
        this.ordering = new ColumnOrdering[n2][];
        this.collation = new int[n2][];
        this.needToDropSort = new boolean[n2];
        this.sortIds = new long[n2];
        this.rowSources = new RowLocationRetRowSource[n2];
        this.indexedCols = new FormatableBitSet(n3 + 1);
        for (n = 0; n < n2; ++n) {
            BasicSortObserver basicSortObserver;
            int n4;
            int[] nArray = this.constants.irgs[n].baseColumnPositions();
            for (int i = 0; i < nArray.length; ++i) {
                this.indexedCols.set(nArray[i]);
            }
            this.indexRows[n] = this.constants.irgs[n].getIndexRowTemplate();
            this.constants.irgs[n].getIndexRow(execRow, rowLocation, this.indexRows[n], null);
            ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.constants.indexCIDS[n]);
            int[] nArray2 = this.constants.irgs[n].baseColumnPositions();
            boolean[] blArray = this.constants.irgs[n].isAscending();
            boolean bl = n2 == 1;
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            Properties properties = null;
            String string = conglomerateDescriptor.getConglomerateName();
            boolean bl2 = false;
            boolean bl3 = false;
            UUID uUID = null;
            if (conglomerateDescriptor.isConstraint()) {
                ConstraintDescriptor constraintDescriptor = this.dd.getConstraintDescriptor(this.td, conglomerateDescriptor.getUUID());
                string = constraintDescriptor.getConstraintName();
                bl2 = this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(this.activation), constraintDescriptor.getUUID());
                bl3 = constraintDescriptor.deferrable();
                uUID = constraintDescriptor.getUUID();
            }
            if (indexRowGenerator.isUnique() || indexRowGenerator.isUniqueDeferrable()) {
                n4 = indexRowGenerator.isUnique() ? nArray2.length : nArray2.length + 1;
                basicSortObserver = new UniqueIndexSortObserver(this.lcc, uUID, false, bl3, bl2, string, this.indexRows[n], bl, this.td.getName());
            } else if (indexRowGenerator.isUniqueWithDuplicateNulls()) {
                n4 = nArray2.length + 1;
                properties = new Properties();
                properties.put("implType", "sort almost unique external");
                basicSortObserver = new UniqueWithDuplicateNullsIndexSortObserver(this.lcc, uUID, true, bl3, bl2, string, this.indexRows[n], true, this.td.getName());
            } else {
                n4 = nArray2.length + 1;
                basicSortObserver = new BasicSortObserver(false, false, this.indexRows[n], bl);
            }
            this.ordering[n] = new ColumnOrdering[n4];
            for (int i = 0; i < blArray.length; ++i) {
                this.ordering[n][i] = new IndexColumnOrder(i, blArray[i]);
            }
            if (n4 > blArray.length) {
                this.ordering[n][blArray.length] = new IndexColumnOrder(blArray.length);
            }
            this.collation[n] = this.constants.irgs[n].getColumnCollationIds(this.td.getColumnDescriptorList());
            this.sortIds[n] = this.tc.createSort(properties, this.indexRows[n].getRowArrayClone(), this.ordering[n], basicSortObserver, false, (int)this.sourceResultSet.getEstimatedRowCount(), -1);
            this.needToDropSort[n] = true;
        }
        this.sorters = new SortController[n2];
        for (n = 0; n < n2; ++n) {
            this.sorters[n] = this.tc.openSort(this.sortIds[n]);
            this.needToDropSort[n] = true;
        }
    }

    private void updateAllIndexes(long l, InsertConstantAction insertConstantAction, TableDescriptor tableDescriptor, DataDictionary dataDictionary, ExecRow execRow) throws StandardException {
        int n = insertConstantAction.irgs.length;
        if (this.indexRows == null) {
            if (this.bulkInsertReplace) {
                this.emptyIndexes(l, insertConstantAction, tableDescriptor, dataDictionary, execRow);
            }
            return;
        }
        dataDictionary.dropStatisticsDescriptors(tableDescriptor.getUUID(), null, this.tc);
        long[] lArray = new long[n];
        this.indexConversionTable = new Hashtable(n);
        for (int i = 0; i < n; ++i) {
            Properties properties = new Properties();
            ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[i]);
            ConglomerateController conglomerateController = this.tc.openCompiledConglomerate(false, 4, 7, 5, insertConstantAction.indexSCOCIs[i], this.indexDCOCIs[i]);
            conglomerateController.getInternalTablePropertySet(properties);
            int n2 = this.indexRows[i].nColumns();
            properties.put("baseConglomerateId", Long.toString(l));
            if (conglomerateDescriptor.getIndexDescriptor().isUnique()) {
                properties.put("nUniqueColumns", Integer.toString(n2 - 1));
            } else {
                properties.put("nUniqueColumns", Integer.toString(n2));
            }
            if (conglomerateDescriptor.getIndexDescriptor().isUniqueWithDuplicateNulls() && !conglomerateDescriptor.getIndexDescriptor().hasDeferrableChecking()) {
                properties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
            }
            properties.put("rowLocationColumn", Integer.toString(n2 - 1));
            properties.put("nKeyFields", Integer.toString(n2));
            conglomerateController.close();
            this.sorters[i].completedInserts();
            this.sorters[i] = null;
            this.rowSources[i] = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[i]));
            lArray[i] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[i].getRowArray(), this.ordering[i], this.collation[i], properties, 0, this.rowSources[i], null);
            CardinalityCounter cardinalityCounter = (CardinalityCounter)this.rowSources[i];
            long l2 = cardinalityCounter.getRowCount();
            if (l2 > 0L) {
                long[] lArray2 = cardinalityCounter.getCardinality();
                for (int j = 0; j < lArray2.length; ++j) {
                    StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), tableDescriptor.getUUID(), "I", new StatisticsImpl(l2, lArray2[j]), j + 1);
                    dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, this.tc);
                }
            }
            dataDictionary.updateConglomerateDescriptor(tableDescriptor.getConglomerateDescriptors(insertConstantAction.indexCIDS[i]), lArray[i], this.tc);
            this.tc.dropConglomerate(insertConstantAction.indexCIDS[i]);
            this.indexConversionTable.put(insertConstantAction.indexCIDS[i], lArray[i]);
        }
    }

    @Override
    public void cleanUp() throws StandardException {
        int n;
        if (this.tableScan != null) {
            this.tableScan.close();
            this.tableScan = null;
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.cleanup();
        }
        if (this.sourceResultSet != null) {
            this.sourceResultSet.close();
        }
        this.numOpens = 0;
        if (this.rowChanger != null) {
            this.rowChanger.close();
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
        if (this.fkChecker != null) {
            this.fkChecker.close();
        }
        if (this.bulkHeapCC != null) {
            this.bulkHeapCC.close();
            this.bulkHeapCC = null;
        }
        if (this.bulkHeapSC != null) {
            this.bulkHeapSC.close();
            this.bulkHeapSC = null;
        }
        if (this.sorters != null) {
            for (n = 0; n < this.constants.irgs.length; ++n) {
                if (this.sorters[n] != null) {
                    this.sorters[n].completedInserts();
                }
                this.sorters[n] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (n = 0; n < this.needToDropSort.length; ++n) {
                if (!this.needToDropSort[n]) continue;
                this.tc.dropSort(this.sortIds[n]);
                this.needToDropSort[n] = false;
            }
        }
        if (this.rowSources != null) {
            for (n = 0; n < this.rowSources.length; ++n) {
                if (this.rowSources[n] == null) continue;
                this.rowSources[n].closeRowSource();
                this.rowSources[n] = null;
            }
        }
        this.close(this.constants.underMerge());
    }

    protected boolean verifyBulkInsert() throws StandardException {
        if (this.constants.deferred) {
            return false;
        }
        return this.getExclusiveTableLock();
    }

    private boolean getExclusiveTableLock() throws StandardException {
        boolean bl = false;
        this.bulkHeapSC = this.tc.openCompiledScan(false, 4, 7, 5, null, null, 0, null, null, 0, this.constants.heapSCOCI, this.heapDCOCI);
        if (!this.bulkInsertReplace) {
            bl = this.bulkHeapSC.next();
        } else {
            this.rl = this.bulkHeapSC.newRowLocationTemplate();
        }
        this.bulkHeapSC.close();
        this.bulkHeapSC = null;
        return !bl;
    }

    private void setEstimatedRowCount(long l) throws StandardException {
        this.bulkHeapSC = this.tc.openCompiledScan(false, 4, 7, 5, null, null, 0, null, null, 0, this.constants.heapSCOCI, this.heapDCOCI);
        this.bulkHeapSC.setEstimatedRowCount(this.rowCount);
        this.bulkHeapSC.close();
        this.bulkHeapSC = null;
    }

    private void emptyIndexes(long l, InsertConstantAction insertConstantAction, TableDescriptor tableDescriptor, DataDictionary dataDictionary, ExecRow execRow) throws StandardException {
        Object object;
        Object object2;
        int n;
        int n2;
        int n3 = insertConstantAction.irgs.length;
        ExecIndexRow[] execIndexRowArray = new ExecIndexRow[n3];
        ColumnOrdering[][] columnOrderingArrayArray = new ColumnOrdering[n3][];
        int n4 = tableDescriptor.getNumberOfColumns();
        this.collation = new int[n3][];
        FormatableBitSet formatableBitSet = new FormatableBitSet(n4 + 1);
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            int[] nArray = insertConstantAction.irgs[n2].baseColumnPositions();
            for (int i = 0; i < nArray.length; ++i) {
                if (formatableBitSet.get(nArray[i])) continue;
                formatableBitSet.set(nArray[i]);
                ++n5;
            }
        }
        ExecRow execRow2 = this.activation.getExecutionFactory().getValueRow(n5);
        n2 = 0;
        for (n = 0; n < n4; ++n) {
            if (!formatableBitSet.get(n + 1)) continue;
            execRow2.setColumn(++n2, execRow.getColumn(n + 1).cloneValue(false));
        }
        this.needToDropSort = new boolean[n3];
        this.sortIds = new long[n3];
        for (n = 0; n < n3; ++n) {
            int n6;
            execIndexRowArray[n] = insertConstantAction.irgs[n].getIndexRowTemplate();
            insertConstantAction.irgs[n].getIndexRow(execRow2, this.rl, execIndexRowArray[n], formatableBitSet);
            ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[n]);
            int[] nArray = insertConstantAction.irgs[n].baseColumnPositions();
            object2 = insertConstantAction.irgs[n].isAscending();
            IndexRowGenerator indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
            if (indexRowGenerator.isUnique() || indexRowGenerator.isUniqueDeferrable()) {
                n6 = indexRowGenerator.isUnique() ? nArray.length : nArray.length + 1;
                String string = conglomerateDescriptor.getConglomerateName();
                boolean bl = false;
                boolean bl2 = false;
                UUID uUID = null;
                if (conglomerateDescriptor.isConstraint()) {
                    ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                    string = constraintDescriptor.getConstraintName();
                    bl = this.lcc.isEffectivelyDeferred(this.lcc.getCurrentSQLSessionContext(this.activation), constraintDescriptor.getUUID());
                    bl2 = constraintDescriptor.deferrable();
                    uUID = constraintDescriptor.getUUID();
                }
                object = new UniqueIndexSortObserver(this.lcc, uUID, false, bl2, bl, string, execIndexRowArray[n], true, tableDescriptor.getName());
            } else {
                n6 = nArray.length + 1;
                object = new BasicSortObserver(false, false, execIndexRowArray[n], true);
            }
            columnOrderingArrayArray[n] = new ColumnOrdering[n6];
            for (int i = 0; i < ((Object)object2).length; ++i) {
                columnOrderingArrayArray[n][i] = new IndexColumnOrder(i, (boolean)object2[i]);
            }
            if (n6 > ((Object)object2).length) {
                columnOrderingArrayArray[n][((Object)object2).length] = new IndexColumnOrder(((Object)object2).length);
            }
            this.sortIds[n] = this.tc.createSort(null, execIndexRowArray[n].getRowArrayClone(), columnOrderingArrayArray[n], (SortObserver)object, false, this.rowCount, -1);
            this.needToDropSort[n] = true;
        }
        this.rowSources = new RowLocationRetRowSource[n3];
        SortController[] sortControllerArray = new SortController[n3];
        for (int i = 0; i < n3; ++i) {
            sortControllerArray[i] = this.tc.openSort(this.sortIds[i]);
            sortControllerArray[i].completedInserts();
            this.rowSources[i] = this.tc.openSortRowSource(this.sortIds[i]);
        }
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            Properties properties = new Properties();
            object = tableDescriptor.getConglomerateDescriptor(insertConstantAction.indexCIDS[i]);
            object2 = this.tc.openCompiledConglomerate(false, 4, 7, 5, insertConstantAction.indexSCOCIs[i], this.indexDCOCIs[i]);
            object2.getInternalTablePropertySet(properties);
            int n7 = execIndexRowArray[i].nColumns();
            properties.put("baseConglomerateId", Long.toString(l));
            if (((ConglomerateDescriptor)object).getIndexDescriptor().isUnique()) {
                properties.put("nUniqueColumns", Integer.toString(n7 - 1));
            } else {
                properties.put("nUniqueColumns", Integer.toString(n7));
            }
            if (((ConglomerateDescriptor)object).getIndexDescriptor().isUniqueWithDuplicateNulls() && !((ConglomerateDescriptor)object).getIndexDescriptor().hasDeferrableChecking()) {
                properties.put("uniqueWithDuplicateNulls", Boolean.toString(true));
            }
            properties.put("rowLocationColumn", Integer.toString(n7 - 1));
            properties.put("nKeyFields", Integer.toString(n7));
            object2.close();
            this.collation[i] = insertConstantAction.irgs[i].getColumnCollationIds(tableDescriptor.getColumnDescriptorList());
            lArray[i] = this.tc.createAndLoadConglomerate("BTREE", execIndexRowArray[i].getRowArray(), null, this.collation[i], properties, 0, this.rowSources[i], null);
            dataDictionary.updateConglomerateDescriptor(tableDescriptor.getConglomerateDescriptors(insertConstantAction.indexCIDS[i]), lArray[i], this.tc);
            this.tc.dropConglomerate(insertConstantAction.indexCIDS[i]);
        }
    }

    private BulkTableScanResultSet getTableScanResultSet(long l) throws StandardException {
        if (this.tableScan == null) {
            this.tableScan = new BulkTableScanResultSet(l, this.tc.getStaticCompiledConglomInfo(l), this.activation, this.fullTemplateId, 0, null, 0, null, 0, false, null, "tableName", null, null, false, false, -1, -1, 7, true, 2, 16, false, false, 0.0, 0.0);
            this.tableScan.openCore();
        } else {
            this.tableScan.reopenCore();
        }
        return this.tableScan;
    }

    private String[] getColumnNames(int[] nArray) {
        int n = nArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.constants.getColumnName(i);
        }
        return stringArray;
    }

    @Override
    public void finish() throws StandardException {
        this.sourceResultSet.finish();
        super.finish();
    }

    @Override
    public void rememberConstraint(UUID uUID) throws StandardException {
        if (this.violatingCheckConstraints == null) {
            this.violatingCheckConstraints = new ArrayList<UUID>();
        }
        if (!this.violatingCheckConstraints.contains(uUID)) {
            this.violatingCheckConstraints.add(uUID);
        }
    }

    protected void initializeAIcache(RowLocation[] rowLocationArray) throws StandardException {
        rowLocationArray = this.constants.getAutoincRowLocation();
        if (rowLocationArray != null) {
            this.aiCache = new DataValueDescriptor[rowLocationArray.length];
            this.bulkInsertCounters = new BulkInsertCounter[rowLocationArray.length];
            for (int i = 0; i < this.resultDescription.getColumnCount(); ++i) {
                if (rowLocationArray[i] == null) continue;
                ResultColumnDescriptor resultColumnDescriptor = this.resultDescription.getColumnDescriptor(i + 1);
                this.aiCache[i] = resultColumnDescriptor.getType().getNull();
            }
        }
    }
}

