/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

public final class CurrentOfNode
extends FromTable {
    private String cursorName;
    private ExecPreparedStatement preStmt;
    private TableName exposedTableName;
    private TableName baseTableName;
    private CostEstimate singleScanCostEstimate;
    private FromBaseTable dummyTargetTable;

    CurrentOfNode(String string, String string2, Properties properties, ContextManager contextManager) {
        super(string, properties, contextManager);
        this.cursorName = string2;
    }

    static CurrentOfNode makeForMerge(String string, FromBaseTable fromBaseTable, ContextManager contextManager) {
        CurrentOfNode currentOfNode = new CurrentOfNode(null, string, null, contextManager);
        currentOfNode.dummyTargetTable = fromBaseTable;
        return currentOfNode;
    }

    @Override
    public CostEstimate estimateCost(OptimizablePredicateList optimizablePredicateList, ConglomerateDescriptor conglomerateDescriptor, CostEstimate costEstimate, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.singleScanCostEstimate == null) {
            this.singleScanCostEstimate = this.getOptimizerFactory().getCostEstimate();
        }
        this.singleScanCostEstimate.setCost(0.0, 1.0, 1.0);
        this.getBestAccessPath().setCostEstimate(this.singleScanCostEstimate);
        this.getBestSortAvoidancePath().setCostEstimate(this.singleScanCostEstimate);
        return this.singleScanCostEstimate;
    }

    @Override
    ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromList) throws StandardException {
        this.preStmt = this.getCursorStatement();
        if (this.preStmt == null) {
            throw StandardException.newException("42X30", this.cursorName);
        }
        this.preStmt.rePrepare(this.getLanguageConnectionContext());
        if (this.preStmt.getUpdateMode() != 2) {
            String string = this.cursorName == null ? "" : this.cursorName;
            throw StandardException.newException("42X23", string);
        }
        ExecCursorTableReference execCursorTableReference = this.preStmt.getTargetTable();
        String string = execCursorTableReference.getSchemaName();
        this.exposedTableName = this.makeTableName(null, execCursorTableReference.getExposedName());
        this.baseTableName = this.makeTableName(string, execCursorTableReference.getBaseName());
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor(execCursorTableReference.getSchemaName());
        if (schemaDescriptor == null) {
            throw StandardException.newException("42Y07", execCursorTableReference.getSchemaName());
        }
        TableDescriptor tableDescriptor = this.getTableDescriptor(execCursorTableReference.getBaseName(), schemaDescriptor);
        if (tableDescriptor == null) {
            throw StandardException.newException("42X05", execCursorTableReference.getBaseName());
        }
        this.setResultColumns(new ResultColumnList(this.getContextManager()));
        ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
        int n = columnDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
            BaseColumnNode baseColumnNode = new BaseColumnNode(columnDescriptor.getColumnName(), this.exposedTableName, columnDescriptor.getType(), this.getContextManager());
            ResultColumn resultColumn = new ResultColumn(columnDescriptor, (ValueNode)baseColumnNode, this.getContextManager());
            this.getResultColumns().addResultColumn(resultColumn);
        }
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    @Override
    void bindExpressions(FromList fromList) {
    }

    @Override
    ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        if (this.dummyTargetTable != null) {
            return this.dummyTargetTable.getMatchingColumn(columnReference);
        }
        ResultColumn resultColumn = null;
        TableName tableName = columnReference.getQualifiedTableName();
        if (tableName != null && tableName.getSchemaName() == null && this.correlationName == null) {
            tableName.bind();
        }
        if (this.baseTableName != null && this.baseTableName.getSchemaName() == null && this.correlationName == null) {
            this.baseTableName.bind();
        }
        if (tableName == null || tableName.getFullTableName().equals(this.baseTableName.getFullTableName()) || this.correlationName != null && this.correlationName.equals(tableName.getTableName())) {
            boolean bl;
            resultColumn = this.getResultColumns().getResultColumn(columnReference.getColumnName());
            if (resultColumn != null) {
                columnReference.setTableNumber(this.tableNumber);
                columnReference.setColumnNumber(resultColumn.getColumnPosition());
                bl = resultColumn.updatableByCursor() && !this.preStmt.isUpdateColumn(columnReference.getColumnName());
            } else {
                bl = true;
            }
            if (bl) {
                String string = this.cursorName == null ? "" : this.cursorName;
                throw StandardException.newException("42X31", columnReference.getColumnName(), string);
            }
        }
        return resultColumn;
    }

    @Override
    ResultSetNode preprocess(int n, GroupByList groupByList, FromList fromList) throws StandardException {
        this.setReferencedTableMap(new JBitSet(n));
        return this;
    }

    @Override
    ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double d) throws StandardException {
        this.bestCostEstimate = this.getOptimizerFactory().getCostEstimate();
        this.bestCostEstimate.setCost(0.0, d, d);
        return this;
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        methodBuilder.pushThis();
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        methodBuilder.push(this.cursorName);
        activationClassBuilder.pushThisAsActivation(methodBuilder);
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.callMethod((short)185, null, "getCurrentOfResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 3);
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        methodBuilder.putField(null, activationClassBuilder.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
        methodBuilder.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        MethodBuilder methodBuilder2 = activationClassBuilder.startResetMethod();
        methodBuilder2.pushThis();
        methodBuilder2.push(this.cursorName);
        methodBuilder2.push(this.preStmt.getObjectName());
        methodBuilder2.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "checkPositionedStatement", "void", 2);
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
    }

    @Override
    void printSubNodes(int n) {
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    String getExposedName() {
        if (this.dummyTargetTable != null) {
            return this.dummyTargetTable.getExposedName();
        }
        return this.exposedTableName.getFullTableName();
    }

    @Override
    public int updateTargetLockMode() {
        return 6;
    }

    TableName getExposedTableName() {
        return this.exposedTableName;
    }

    TableName getBaseCursorTargetTableName() {
        return this.baseTableName;
    }

    String getCursorName() {
        return this.cursorName;
    }

    ExecPreparedStatement getCursorStatement() {
        CursorActivation cursorActivation = this.getLanguageConnectionContext().lookupCursorActivation(this.cursorName);
        if (cursorActivation == null) {
            return null;
        }
        return cursorActivation.getPreparedStatement();
    }

    @Override
    void acceptChildren(Visitor visitor) throws StandardException {
        super.acceptChildren(visitor);
        if (this.exposedTableName != null) {
            this.exposedTableName = (TableName)this.exposedTableName.accept(visitor);
        }
        if (this.baseTableName != null) {
            this.baseTableName = (TableName)this.baseTableName.accept(visitor);
        }
    }
}

