/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.util.Properties;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.io.WritableStorageFactory;
import org.apache.derby.shared.common.error.PassThroughException;
import org.apache.derby.shared.common.error.StandardException;

public class UpdateServiceProperties
extends Properties {
    private PersistentService serviceType;
    private String serviceName;
    private volatile WritableStorageFactory storageFactory;
    private boolean serviceBooted;

    public UpdateServiceProperties(PersistentService persistentService, String string, Properties properties, boolean bl) {
        super(properties);
        this.serviceType = persistentService;
        this.serviceName = string;
        this.serviceBooted = bl;
    }

    public void setServiceBooted() {
        this.serviceBooted = true;
    }

    public void setStorageFactory(WritableStorageFactory writableStorageFactory) {
        this.storageFactory = writableStorageFactory;
    }

    public WritableStorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    @Override
    public Object put(Object object, Object object2) {
        Object object3 = this.defaults.put(object, object2);
        if (!((String)object).startsWith("derby.__rt.")) {
            this.update();
        }
        return object3;
    }

    @Override
    public Object remove(Object object) {
        Object object2 = this.defaults.remove(object);
        if (object2 != null && !((String)object).startsWith("derby.__rt.")) {
            this.update();
        }
        return object2;
    }

    public void saveServiceProperties() {
        try {
            this.serviceType.saveServiceProperties(this.serviceName, this.storageFactory, BaseMonitor.removeRuntimeProperties(this.defaults), false);
        }
        catch (StandardException standardException) {
            throw new PassThroughException(standardException);
        }
    }

    private void update() {
        try {
            if (this.serviceBooted) {
                this.serviceType.saveServiceProperties(this.serviceName, this.storageFactory, BaseMonitor.removeRuntimeProperties(this.defaults), true);
            }
        }
        catch (StandardException standardException) {
            throw new PassThroughException(standardException);
        }
    }
}

