/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiThreadedIterations;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_Undoable;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_RawStoreFactory
extends T_MultiThreadedIterations {
    protected static final String REC_001 = "McLaren";
    protected static final String REC_002 = "Ferrari";
    protected static final String REC_003 = "Benetton";
    protected static final String REC_004 = "Prost";
    protected static final String REC_005 = "Tyrell";
    protected static final String REC_006 = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
    protected static final String REC_007 = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    protected static final String REC_008 = "z";
    protected static final String REC_009 = "nanonano";
    protected static final String REC_010 = "fuzzbutt";
    protected static final String REC_011 = "mork";
    protected static final String REC_012 = "orson";
    protected static final String REC_013 = "mindy";
    protected static final String REC_014 = "thomas";
    protected static final String REC_015 = "henry";
    protected static final String REC_016 = "gordon";
    protected static final String REC_017 = "mavis";
    protected static final String REC_018 = "fatcontroller";
    protected static final String REC_UNDO = "Lotus";
    protected static final String REC_NULL = "NULL";
    static final FormatableBitSet BS_COL_0 = new FormatableBitSet(1);
    protected static final String SP1 = "savepoint1";
    protected static final String SP2 = "savepoint2";
    private static final String TEST_ROLLBACK_OFF = "derby.RawStore.RollbackTestOff";
    private static boolean testRollbackProperty;
    protected static boolean testRollback;
    protected static RawStoreFactory factory;
    protected static LockFactory lf;
    protected static ContextService contextService;
    protected static UUIDFactory uuidfactory;
    protected T_Util t_util;
    protected int openMode;
    protected boolean logDataForPurges = true;

    public T_RawStoreFactory() {
        BS_COL_0.set(0);
    }

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        super.boot(bl, properties);
        contextService = T_RawStoreFactory.getContextService();
    }

    @Override
    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    @Override
    protected void setupTest() throws T_Fail {
        String string = PropertyUtil.getSystemProperty((String)TEST_ROLLBACK_OFF);
        testRollbackProperty = testRollback = Boolean.valueOf(string) == false;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            factory = (RawStoreFactory)T_RawStoreFactory.createPersistentService(this.getModuleToTestProtocolName(), this.getTestService(), this.startParams);
            if (factory == null) {
                throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
            }
            lf = factory.getLockFactory();
            if (lf == null) {
                throw T_Fail.testFailMsg("LockFactory.MODULE not found");
            }
            uuidfactory = T_RawStoreFactory.getMonitor().getUUIDFactory();
        }
        catch (StandardException standardException) {
            throw T_Fail.exceptionFail(standardException);
        }
        this.REPORT("testRollback=" + testRollback);
    }

    protected String getTestService() {
        return "rawStoreTest";
    }

    @Override
    protected void joinSetupTest() throws T_Fail {
        T_Fail.T_ASSERT(factory != null, "raw store factory not setup ");
        T_Fail.T_ASSERT(lf != null, "Lock factory not setup ");
        T_Fail.T_ASSERT(contextService != null, "Context service not setup ");
        testRollback = testRollbackProperty;
    }

    @Override
    protected T_MultiThreadedIterations newTestObject() {
        try {
            Class<?> clazz = this.getClass();
            return (T_MultiThreadedIterations)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException instantiationException) {
            return new T_RawStoreFactory();
        }
        catch (IllegalAccessException illegalAccessException) {
            return new T_RawStoreFactory();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return new T_RawStoreFactory();
        }
        catch (InvocationTargetException invocationTargetException) {
            return new T_RawStoreFactory();
        }
    }

    @Override
    protected void runTestSet() throws T_Fail {
        this.t_util = new T_Util(factory, lf, contextService);
        ContextManager contextManager = contextService.newContextManager();
        contextService.setCurrentContextManager(contextManager);
        try {
            this.REPORT("Running tests with no data logged  for purges");
            this.openMode = 0;
            this.runPurgeWithNoDataLoggesTests();
            this.REPORT("Running tests with logging requested");
            this.openMode = 0;
            this.runEachTest();
            this.REPORT("Running tests for temp tables");
            testRollback = false;
            this.runTempTests();
            this.REPORT("Running tests in unlogged mode");
            this.openMode = 3;
            testRollback = false;
            this.runEachTest();
        }
        catch (StandardException standardException) {
            contextManager.cleanupOnError((Throwable)standardException, false);
            throw T_Fail.exceptionFail(standardException);
        }
        finally {
            contextService.resetCurrentContextManager(contextManager);
        }
    }

    protected void runEachTest() throws T_Fail, StandardException {
        this.t_util.setOpenMode(this.openMode);
        this.T000();
        this.T001();
        this.T002();
        this.T003();
        this.T004();
        this.T005();
        this.T006();
        this.T007();
        this.T008();
        this.T009();
        this.T010();
        this.T011();
        this.T012();
        this.C010(0);
        this.C011();
        this.C012(1L);
        this.C014();
        this.C200();
        this.C201(0);
        this.C201(1);
        this.P001(0L);
        this.P002(0L);
        this.P005(0L);
        this.P006();
        this.P007(0L);
        this.P008(0L);
        this.P009(0L);
        this.P011(0L);
        this.P012(0L);
        this.P013();
        this.P014();
        this.P015();
        this.P016();
        this.P017();
        this.P018();
        this.P019();
        this.P020();
        this.P021();
        this.P022();
        this.P023(0);
        this.P024(0L);
        this.P030(0L);
        this.P031(0L);
        this.P032(0L);
        this.P033(0L);
        this.P034(0L);
        this.P035(0L);
        if ((this.openMode & 1) == 1) {
            this.openMode = 0;
            this.t_util.setOpenMode(this.openMode);
        }
        this.P036();
        this.P037();
        this.P038();
        this.P039();
        this.P040();
        this.P041();
        this.P042();
        this.P043();
        this.P050();
        this.P051();
        this.P053();
        this.P054();
        this.P055(0L);
        this.P056(0L);
        this.P061();
        this.P071();
        this.P701(0L);
        this.P702(0L);
        this.P703(0L);
        this.P704(0L);
        this.P705(0L);
        this.P706(0L, false);
        this.P706(0L, true);
        this.P707(0L);
        this.P708(0L, false);
        this.P708(0L, true);
        this.L001();
        this.CP001();
    }

    protected void runTempTests() throws T_Fail, StandardException {
        this.REPORT("Thread " + this.threadNumber + " entering temp tests ");
        this.openMode = 0;
        this.t_util.setOpenMode(this.openMode);
        this.C010(-1);
        this.C012(-1L);
        this.P005(-1L);
        this.P011(-1L);
        this.P012(-1L);
        this.P030(-1L);
        this.P055(-1L);
        this.P056(-1L);
        this.P701(-1L);
        this.P702(-1L);
        this.P703(-1L);
        this.P704(-1L);
        this.P705(-1L);
        this.P706(-1L, false);
        this.P706(-1L, true);
        this.P707(-1L);
        this.TC001();
        this.TC002(16, true);
        this.TC002(16, false);
        this.TC002(0, false);
        this.TC003(16, true);
        this.TC003(16, false);
        this.TC003(0, false);
        this.TC003(0, true);
        this.TC003(32, true);
        this.TC003(32, false);
        this.TC004all();
        this.REPORT("Thread " + this.threadNumber + " exiting temp tests ");
    }

    protected void runPurgeWithNoDataLoggesTests() throws T_Fail, StandardException {
        this.REPORT("Thread " + this.threadNumber + " entering purges with no data logged tests ");
        this.logDataForPurges = false;
        this.P005(0L);
        this.P006();
        this.P014();
        this.P036();
        this.P037();
        this.P709();
        this.P710();
        this.P711();
        this.REPORT("Thread " + this.threadNumber + " exiting purge with no data logged tests ");
        this.logDataForPurges = true;
    }

    protected void T000() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        transaction.close();
        transaction = this.t_util.t_startInternalTransaction();
        transaction.close();
        transaction = this.t_util.t_startTransaction();
        Transaction transaction2 = this.t_util.t_startInternalTransaction();
        transaction2.close();
        transaction.close();
        this.PASS("T000");
    }

    protected void T001() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("T001");
    }

    protected void T002() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        this.t_util.t_abort(transaction);
        transaction.close();
        this.PASS("T002");
    }

    protected void T003() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        this.t_util.t_commit(transaction);
        this.t_util.t_commit(transaction);
        this.t_util.t_abort(transaction);
        transaction.close();
        this.PASS("T003");
    }

    protected void T004() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        this.t_util.t_abort(transaction);
        this.t_util.t_commit(transaction);
        this.t_util.t_abort(transaction);
        transaction.close();
        this.PASS("T004");
    }

    protected void T005() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        GlobalTransactionId globalTransactionId = transaction.getGlobalId();
        if (globalTransactionId != null) {
            throw T_Fail.testFailMsg("null not returned from local Transaction.getId()");
        }
        transaction.close();
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
        byte[] byArray2 = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
        transaction = this.t_util.t_startGlobalTransaction(42, byArray, byArray2);
        globalTransactionId = transaction.getGlobalId();
        if (!globalTransactionId.equals((Object)globalTransactionId)) {
            throw T_Fail.testFailMsg("TransactionId does not compare equal to itself");
        }
        if (!globalTransactionId.equals((Object)transaction.getGlobalId())) {
            throw T_Fail.testFailMsg("TransactionId has changed without any activity on Transaction");
        }
        if (globalTransactionId.equals((Object)this)) {
            throw T_Fail.testFailMsg("TransactionId compared equal to an non-transaction id object");
        }
        transaction.close();
        transaction = null;
        byArray2[63] = 82;
        Transaction transaction2 = this.t_util.t_startGlobalTransaction(42, byArray, byArray2);
        GlobalTransactionId globalTransactionId2 = transaction2.getGlobalId();
        if (globalTransactionId2 == null) {
            throw T_Fail.testFailMsg("null returned from Transaction.getId()");
        }
        if (globalTransactionId.equals((Object)globalTransactionId2)) {
            throw T_Fail.testFailMsg("TransactionId's returned equal from different transactions");
        }
        if (globalTransactionId2.equals((Object)globalTransactionId)) {
            throw T_Fail.testFailMsg("TransactionId's returned equal from different transactions");
        }
        transaction2.close();
        this.PASS("T005");
    }

    protected void T006() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        T_Util.t_checkInvalidSavePoint(transaction, "sdfjsdfg");
        transaction.setSavePoint(SP1, null);
        transaction.rollbackToSavePoint(SP1, null);
        transaction.rollbackToSavePoint(SP1, null);
        transaction.releaseSavePoint(SP1, null);
        T_Util.t_checkInvalidSavePoint(transaction, SP1);
        transaction.setSavePoint(SP1, null);
        transaction.rollbackToSavePoint(SP1, null);
        transaction.rollbackToSavePoint(SP1, null);
        transaction.releaseSavePoint(SP1, null);
        T_Util.t_checkInvalidSavePoint(transaction, SP1);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("T006");
    }

    protected void T007() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        int n = 0;
        transaction.setSavePoint(SP1, null);
        transaction.setSavePoint(SP2, null);
        n = transaction.releaseSavePoint(SP1, null);
        if (n != 0) {
            throw T_Fail.testFailMsg("Save Point Position in the stack isincorrect:" + n);
        }
        T_Util.t_checkInvalidSavePoint(transaction, SP1);
        T_Util.t_checkInvalidSavePoint(transaction, SP2);
        transaction.setSavePoint(SP1, null);
        transaction.setSavePoint(SP2, null);
        transaction.rollbackToSavePoint(SP2, null);
        n = transaction.rollbackToSavePoint(SP2, null);
        if (n != 2) {
            throw T_Fail.testFailMsg("Save Point Position in the stack isincorrect:" + n);
        }
        n = transaction.releaseSavePoint(SP2, null);
        if (n != 1) {
            throw T_Fail.testFailMsg("Save Point Position in the stack is incorrect:" + n);
        }
        T_Util.t_checkInvalidSavePoint(transaction, SP2);
        transaction.rollbackToSavePoint(SP1, null);
        transaction.releaseSavePoint(SP1, null);
        T_Util.t_checkInvalidSavePoint(transaction, SP1);
        transaction.setSavePoint(SP1, null);
        transaction.setSavePoint(SP2, null);
        n = transaction.rollbackToSavePoint(SP1, null);
        if (n != 1) {
            throw T_Fail.testFailMsg("Save Point Position in the stack is incorrect:" + n);
        }
        T_Util.t_checkInvalidSavePoint(transaction, SP2);
        transaction.rollbackToSavePoint(SP1, null);
        transaction.releaseSavePoint(SP1, null);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("T007");
    }

    protected void T008() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        int n = 0;
        int n2 = 0;
        n = transaction.setSavePoint(SP1, null);
        n2 = transaction.setSavePoint(SP2, null);
        if (n != 1 && n2 != 2) {
            throw T_Fail.testFailMsg("Save Point Position in the Stack seeme to wrong");
        }
        transaction.commit();
        T_Util.t_checkInvalidSavePoint(transaction, SP1);
        T_Util.t_checkInvalidSavePoint(transaction, SP2);
        n = transaction.setSavePoint(SP1, null);
        n2 = transaction.setSavePoint(SP2, null);
        if (n != 1 && n2 != 2) {
            throw T_Fail.testFailMsg("Save Point Position in the Stack seeme to wrong");
        }
        transaction.abort();
        n = transaction.setSavePoint(SP1, null);
        n2 = transaction.setSavePoint(SP2, null);
        if (n != 1 && n2 != 2) {
            throw T_Fail.testFailMsg("Save Point Position in the Stack seeme to wrong");
        }
        transaction.abort();
        T_Util.t_checkInvalidSavePoint(transaction, SP1);
        T_Util.t_checkInvalidSavePoint(transaction, SP2);
        transaction.close();
        this.PASS("T008");
    }

    protected void T009() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L, 4096);
        this.t_util.t_dropContainer(transaction, 0L, l);
        ContainerKey containerKey = new ContainerKey(0L, l);
        ContainerHandle containerHandle = transaction.openContainer(containerKey, 8);
        if (containerHandle != null) {
            throw T_Fail.testFailMsg("Dropped Container should not open");
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("T009");
    }

    protected void T010() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_dropContainer(transaction, 0L, l);
        ContainerKey containerKey = new ContainerKey(0L, l);
        ContainerHandle containerHandle = transaction.openContainer(containerKey, 8);
        if (containerHandle != null) {
            throw T_Fail.testFailMsg("Dropped Container should not open");
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("T010");
    }

    protected void T011() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startInternalTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        transaction.commit();
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        transaction.commit();
        if (!page.isLatched()) {
            throw T_Fail.testFailMsg("page not latched after commit of internal transaction");
        }
        page.unlatch();
        containerHandle.close();
        transaction.commit();
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        transaction.abort();
        if (page.isLatched()) {
            throw T_Fail.testFailMsg("page latched after abort of internal transaction");
        }
        try {
            page = this.t_util.t_getLastPage(containerHandle);
            throw T_Fail.testFailMsg("container open after abort of internal transaction");
        }
        catch (StandardException standardException) {
            this.t_util.t_dropContainer(transaction, 0L, l);
            this.t_util.t_commit(transaction);
            transaction.close();
            this.PASS("T011");
            return;
        }
    }

    protected void T012() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        RecordHandle recordHandle2 = containerHandle.makeRecordHandle(recordHandle.getPageNumber(), recordHandle.getId());
        T_Util.t_checkFetch(page, recordHandle2, REC_001);
        RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        if (recordHandle3 != null) {
            RecordHandle recordHandle4 = containerHandle.makeRecordHandle(recordHandle3.getPageNumber(), recordHandle3.getId());
            T_Util.t_checkFetch(page, recordHandle3, REC_002);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("T012");
    }

    protected void C010(int n) throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, (long)n);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, (long)n, l, true);
        containerHandle = this.t_util.t_openContainer(transaction, (long)n, l, true);
        this.t_util.t_dropContainer(transaction, n, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("C010");
    }

    protected void C011() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("C011");
    }

    protected void C012(long l) throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        this.t_util.t_dropContainer(transaction, l, l2);
        if (testRollback) {
            this.t_util.t_abort(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            this.REPORT("rollback of drop container tested");
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        ContainerKey containerKey = new ContainerKey(l, l2);
        containerHandle = transaction.openContainer(containerKey, 4 | this.openMode);
        if (containerHandle != null) {
            throw T_Fail.testFailMsg("Deleted Container should fail to open");
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("C012");
    }

    protected void C014() throws T_Fail, StandardException {
        ContainerKey containerKey;
        Transaction transaction = this.t_util.t_startTransaction();
        ContainerHandle containerHandle = transaction.openContainer(containerKey = new ContainerKey(77L, 45L), 64);
        if (containerHandle == null) {
            throw T_Fail.testFailMsg("open of a container for lock only failed.");
        }
        RecordHandle recordHandle = containerHandle.makeRecordHandle(23L, 456);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("makeRecordHandle returned null");
        }
        containerHandle.getLockingPolicy().lockRecordForRead(transaction, containerHandle, recordHandle, true, true);
        RecordHandle recordHandle2 = containerHandle.makeRecordHandle(23L, 7);
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("makeRecordHandle returned null");
        }
        containerHandle.getLockingPolicy().lockRecordForRead(transaction, containerHandle, recordHandle2, true, false);
        RecordHandle recordHandle3 = containerHandle.makeRecordHandle(23L, 9);
        containerHandle.getLockingPolicy().lockRecordForWrite(transaction, recordHandle3, false, true);
        if (recordHandle3 == null) {
            throw T_Fail.testFailMsg("makeRecordHandle returned null");
        }
        containerHandle.getLockingPolicy().unlockRecordAfterRead(transaction, containerHandle, recordHandle2, false, true);
        containerHandle.close();
        transaction.commit();
        transaction.close();
        this.PASS("C014");
    }

    protected void C200() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        this.REPORT("see if the container can be opened again");
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        containerHandle.close();
        this.t_util.t_commit(transaction);
        this.REPORT("insert a record into the container.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        if (page.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + page.getPageNumber());
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        if (!page.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("Failed to insert record");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        containerHandle = null;
        this.REPORT("read record just inserted.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        T_Util.t_checkFetchFirst(page, REC_001);
        T_Util.t_checkFetchLast(page, REC_001);
        this.t_util.t_commit(transaction);
        page = null;
        containerHandle = null;
        this.REPORT("insert 2 more records.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        if (page.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + page.getPageNumber());
        }
        t_RawStoreRow = new T_RawStoreRow(REC_002);
        if (!page.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record 001 has vanished");
        }
        RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        t_RawStoreRow = new T_RawStoreRow(REC_003);
        RecordHandle recordHandle3 = T_Util.t_insert(page, t_RawStoreRow);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        containerHandle = null;
        this.REPORT("checks on all 3 records.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        T_Util.t_checkFetch(page, recordHandle2, REC_002);
        T_Util.t_checkFetch(page, recordHandle3, REC_003);
        T_Util.t_checkFetch(page, page.getRecordHandle(recordHandle.getId()), REC_001);
        T_Util.t_checkFetch(page, page.getRecordHandle(recordHandle2.getId()), REC_002);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        this.REPORT("start deleting.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        T_Util.t_checkFetch(page, recordHandle2, REC_002);
        T_Util.t_checkFetch(page, recordHandle3, REC_003);
        int n = page.getSlotNumber(recordHandle);
        page.deleteAtSlot(n, true, null);
        if (page.fetchFromSlot(recordHandle, n, (Object[])new DataValueDescriptor[0], null, false) != null) {
            throw T_Fail.testFailMsg("deleted record is still present");
        }
        T_Util.t_checkFetch(page, recordHandle2, REC_002);
        T_Util.t_checkFetch(page, recordHandle3, REC_003);
        T_Util.t_checkFetchNext(page, recordHandle2, REC_003);
        T_Util.t_checkFetchPrevious(page, recordHandle3, REC_002);
        int n2 = page.getSlotNumber(recordHandle2);
        page.deleteAtSlot(n2, true, null);
        if (page.fetchFromSlot(recordHandle2, n2, (Object[])new DataValueDescriptor[0], null, false) != null) {
            throw T_Fail.testFailMsg("deleted record is still present");
        }
        T_Util.t_checkFetch(page, recordHandle3, REC_003);
        T_Util.t_checkFetchFirst(page, REC_003);
        T_Util.t_checkFetchLast(page, REC_003);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        this.REPORT("update the remaining record.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(page, recordHandle3, REC_003);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_004);
        int n3 = page.getSlotNumber(recordHandle3);
        if (page.updateAtSlot(n3, (Object[])t_RawStoreRow2.getRow(), null) == null) {
            throw T_Fail.testFailMsg("updateAtSlot returned null");
        }
        T_Util.t_checkFetch(page, recordHandle3, REC_004);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("C200");
    }

    protected void C201(int n) throws T_Fail, StandardException {
        int n2 = n == 0 ? 4096 : 32768;
        Transaction transaction = this.t_util.t_startTransaction();
        this.REPORT("create container with pageSize " + n2 + ", spareSpace 0, minimumRecordSize " + n2 / 2);
        long l = this.t_util.t_addContainer(transaction, 0L, n2, 0, n2 / 2, false);
        this.t_util.t_commit(transaction);
        this.REPORT("see if the container can be opened again");
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        containerHandle.close();
        this.t_util.t_commit(transaction);
        this.REPORT("insert a record into the container.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        if (page.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + page.getPageNumber());
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        if (!page.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("Failed to insert record");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        containerHandle = null;
        this.REPORT("read record just inserted.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        T_Util.t_checkFetchFirst(page, REC_001);
        T_Util.t_checkFetchLast(page, REC_001);
        this.t_util.t_commit(transaction);
        page = null;
        containerHandle = null;
        this.REPORT("try inserting 1 more record, but there should be no room on page for it.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        if (page.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + page.getPageNumber());
        }
        t_RawStoreRow = new T_RawStoreRow(REC_002);
        if (page.spaceForInsert()) {
            throw T_Fail.testFailMsg("Did not get no room for record on page error");
        }
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record 001 has vanished");
        }
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        containerHandle = null;
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        this.REPORT("create container with pageSize " + n2 + ", spareSpace 0, minimumRecordSize " + n2);
        this.REPORT("this should set minimumRecordSize to the default 100");
        l = this.t_util.t_addContainer(transaction, 0L, n2, 0, n2, false);
        this.t_util.t_commit(transaction);
        this.REPORT("see if the container can be opened again");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        containerHandle.close();
        this.t_util.t_commit(transaction);
        this.REPORT("insert a record into the container.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        if (page.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + page.getPageNumber());
        }
        t_RawStoreRow = new T_RawStoreRow(REC_001);
        if (!page.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        recordHandle = T_Util.t_insert(page, t_RawStoreRow);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("Failed to insert record");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        containerHandle = null;
        this.REPORT("read record just inserted.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        T_Util.t_checkFetchFirst(page, REC_001);
        T_Util.t_checkFetchLast(page, REC_001);
        this.t_util.t_commit(transaction);
        page = null;
        containerHandle = null;
        this.REPORT("insert 2 more records.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        if (page.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + page.getPageNumber());
        }
        t_RawStoreRow = new T_RawStoreRow(REC_002);
        if (!page.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record 001 has vanished");
        }
        RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        t_RawStoreRow = new T_RawStoreRow(REC_003);
        RecordHandle recordHandle3 = T_Util.t_insert(page, t_RawStoreRow);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        containerHandle = null;
        this.REPORT("checks on all 3 records.");
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        page = this.t_util.t_getLastPage(containerHandle);
        if (page == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(page, recordHandle, REC_001);
        T_Util.t_checkFetch(page, recordHandle2, REC_002);
        T_Util.t_checkFetch(page, recordHandle3, REC_003);
        T_Util.t_checkFetch(page, page.getRecordHandle(recordHandle.getId()), REC_001);
        T_Util.t_checkFetch(page, page.getRecordHandle(recordHandle2.getId()), REC_002);
        page.unlatch();
        page = null;
        this.t_util.t_commit(transaction);
        containerHandle = null;
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("C201 - " + n);
    }

    protected void P001(long l) throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, false);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        page.unlatch();
        page = null;
        page = this.t_util.t_getLastPage(containerHandle);
        T_Util.t_checkPageNumber(page, 1L);
        T_Util.t_checkEmptyPage(page);
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_addPage(containerHandle);
        T_Util.t_checkPageNumber(page, 2L);
        page.unlatch();
        page = this.t_util.t_addPage(containerHandle);
        T_Util.t_checkPageNumber(page, 3L);
        page.unlatch();
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_updateSlotOutOfRange(page, 0);
        T_Util.t_updateSlotOutOfRange(page, -1);
        T_Util.t_updateSlotOutOfRange(page, 1);
        this.t_util.t_dropContainer(transaction, l, l2);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P001");
    }

    protected void P002(long l) throws StandardException, T_Fail {
        int n;
        RecordHandle recordHandle;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        int[] nArray = new int[]{0, 0, 0};
        int n2 = 0;
        while (n2 < 3) {
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001 + n2 + "X" + nArray[n2]);
            boolean bl = page.spaceForInsert();
            recordHandle = T_Util.t_insert(page, t_RawStoreRow);
            if (recordHandle != null) {
                int n3 = n2;
                nArray[n3] = nArray[n3] + 1;
                if (!bl) {
                    this.REPORT("record inserted after spaceForInsert() returned false, count is " + nArray[n2]);
                }
            } else if (bl) {
                this.REPORT("record insert failed after spaceForInsert() returned true, count is " + nArray[n2]);
            }
            T_Util.t_checkRecordCount(page, nArray[n2], nArray[n2]);
            if (recordHandle != null) continue;
            page.unlatch();
            page = null;
            if (++n2 >= 3) continue;
            page = this.t_util.t_addPage(containerHandle);
            T_Util.t_checkEmptyPage(page);
        }
        this.t_util.t_commit(transaction);
        for (n2 = 0; n2 < 3; ++n2) {
            this.REPORT("RecordCount on page " + n2 + "=" + nArray[n2]);
        }
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, false);
        long l3 = 1L;
        int n4 = 0;
        while (n4 < 3) {
            page = this.t_util.t_getPage(containerHandle, l3);
            T_Util.t_checkRecordCount(page, nArray[n4], nArray[n4]);
            recordHandle = T_Util.t_checkFetchFirst(page, REC_001 + n4 + "X0");
            for (n = 1; n < nArray[n4]; ++n) {
                recordHandle = T_Util.t_checkFetchNext(page, recordHandle, REC_001 + n4 + "X" + n);
            }
            try {
                recordHandle = page.fetchFromSlot(null, page.getSlotNumber(recordHandle) + 1, (Object[])new DataValueDescriptor[0], (FetchDescriptor)null, false);
                throw T_Fail.testFailMsg("reading more rows on page than were written");
            }
            catch (StandardException standardException) {
                recordHandle = T_Util.t_checkFetchLast(page, REC_001 + n4 + "X" + (nArray[n4] - 1));
                for (n = nArray[n4] - 2; n >= 0; --n) {
                    recordHandle = T_Util.t_checkFetchPrevious(page, recordHandle, REC_001 + n4 + "X" + n);
                }
                page.unlatch();
                page = null;
                ++n4;
                ++l3;
            }
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, false);
        l3 = 1L;
        n4 = 0;
        while (n4 < 3) {
            page = this.t_util.t_getPage(containerHandle, l3);
            for (n = 0; n < nArray[n4]; ++n) {
                T_Util.t_checkFetchBySlot(page, n, REC_001 + n4 + "X" + n, false, false);
            }
            T_Util.t_readOnlySlotOutOfRange(page, nArray[n4]);
            page.unlatch();
            page = null;
            ++n4;
            ++l3;
        }
        this.t_util.t_dropContainer(transaction, l, l2);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P002");
    }

    protected void P005(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getLastPage(containerHandle);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow("long row xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx long row ");
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow("medium row yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy medium row");
        T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        int n = 0;
        while (page.spaceForInsert()) {
            if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2) == null) break;
            ++n;
        }
        int n2 = page.recordCount();
        Page page2 = this.t_util.t_addPage(containerHandle);
        T_Util.t_insertAtSlot(page2, 0, t_RawStoreRow);
        n = 1;
        while (page2.spaceForInsert()) {
            if (T_Util.t_insertAtSlot(page2, n++, t_RawStoreRow2) != null) continue;
        }
        int n3 = page2.recordCount();
        page.purgeAtSlot(1, page.recordCount() - 1, this.logDataForPurges);
        page2.purgeAtSlot(1, page2.recordCount() - 1, this.logDataForPurges);
        if (page.recordCount() != 1) {
            throw T_Fail.testFailMsg("purge did not clean up page");
        }
        if (page2.recordCount() != 1) {
            throw T_Fail.testFailMsg("purge did not clean up page");
        }
        n = 0;
        while (page.spaceForInsert()) {
            if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2) == null) {
                return;
            }
            ++n;
        }
        if (page.recordCount() != n2) {
            throw T_Fail.testFailMsg("cannot insert back same number of rows we purged");
        }
        n = 1;
        while (page2.spaceForInsert()) {
            if (T_Util.t_insertAtSlot(page2, n++, t_RawStoreRow2) != null) continue;
        }
        if (page2.recordCount() != n3) {
            throw T_Fail.testFailMsg("cannot insert back same number of rows we purged");
        }
        page.unlatch();
        page2.unlatch();
        this.t_util.t_dropContainer(transaction, l, l2);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P005");
    }

    protected void P006() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getLastPage(containerHandle);
        PageTimeStamp pageTimeStamp = page.currentTimeStamp();
        if (pageTimeStamp != null && !page.equalTimeStamp(pageTimeStamp)) {
            throw T_Fail.testFailMsg("page returns non-null time stamp which is not equal to its current time stamp");
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
        if (page.equalTimeStamp(pageTimeStamp)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after insert operation");
        }
        page.setTimeStamp(pageTimeStamp);
        if (pageTimeStamp != null && !page.equalTimeStamp(pageTimeStamp)) {
            throw T_Fail.testFailMsg("page returns non-null time stamp which is not equal to its current time stamp");
        }
        T_Util.t_updateSlotOutOfRange(page, 3);
        if (pageTimeStamp != null && !page.equalTimeStamp(pageTimeStamp)) {
            throw T_Fail.testFailMsg("failed pdate should not change time stamp");
        }
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
        int n = page.getSlotNumber(recordHandle);
        page.updateAtSlot(n, (Object[])t_RawStoreRow2.getRow(), null);
        if (page.equalTimeStamp(pageTimeStamp)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after update operation");
        }
        page.setTimeStamp(pageTimeStamp);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
        int n2 = page.getSlotNumber(recordHandle);
        page.updateAtSlot(n2, (Object[])t_RawStoreRow3.getRow(), BS_COL_0);
        if (page.equalTimeStamp(pageTimeStamp)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after update field operation");
        }
        page.setTimeStamp(pageTimeStamp);
        page.deleteAtSlot(n2, true, null);
        if (page.equalTimeStamp(pageTimeStamp)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after delete operation");
        }
        page.setTimeStamp(pageTimeStamp);
        page.purgeAtSlot(0, 1, this.logDataForPurges);
        if (page.equalTimeStamp(pageTimeStamp)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after delete operation");
        }
        page.setTimeStamp(pageTimeStamp);
        page.unlatch();
        if (testRollback) {
            this.t_util.t_abort(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getLastPage(containerHandle);
            if (page.equalTimeStamp(pageTimeStamp)) {
                throw T_Fail.testFailMsg("timestamp on page not changed after rollback");
            }
            page.setTimeStamp(pageTimeStamp);
        }
        Page page2 = containerHandle.addPage();
        Page page3 = containerHandle.addPage();
        page2.setTimeStamp(pageTimeStamp);
        if (pageTimeStamp != null) {
            try {
                if (page3.equalTimeStamp(pageTimeStamp)) {
                    throw T_Fail.testFailMsg("timestamp on 2 different pages should not equate");
                }
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P006");
    }

    protected void P007(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096, 0, 1, false);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getLastPage(containerHandle);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(new String(new char[300]));
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        Object object = REC_001;
        for (int i = 0; i <= 900; ++i) {
            T_Util.t_checkFetch(page, recordHandle, (String)object);
            object = (String)object + REC_008;
            t_RawStoreRow = new T_RawStoreRow((String)object);
            page.updateAtSlot(0, (Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null);
        }
        this.t_util.t_dropContainer(transaction, l, l2);
        l2 = this.t_util.t_addContainer(transaction, l, 4096, 0, 1, false);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getLastPage(containerHandle);
        long l3 = page.getPageNumber();
        t_RawStoreRow = new T_RawStoreRow(2);
        t_RawStoreRow.setColumn(0, REC_001);
        t_RawStoreRow.setColumn(1, new String(new char[400]));
        recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        t_RawStoreRow.setColumn(0, REC_001 + new String(new char[300]));
        t_RawStoreRow.setColumn(1, new String(new char[100]));
        page.updateAtSlot(0, (Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null);
        Page page2 = this.t_util.t_addPage(containerHandle);
        long l4 = page2.getPageNumber();
        if (l4 != l3 + 1L) {
            throw T_Fail.testFailMsg("The update should not have overflowed the record");
        }
        t_RawStoreRow.setColumn(0, REC_001);
        t_RawStoreRow.setColumn(1, new String(new char[400]));
        page.updateAtSlot(0, (Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null);
        Page page3 = this.t_util.t_addPage(containerHandle);
        long l5 = page3.getPageNumber();
        if (l5 != l4 + 1L) {
            throw T_Fail.testFailMsg("The update should not have overflowed the record");
        }
        this.t_util.t_dropContainer(transaction, l, l2);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P007");
    }

    protected void P008(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096, 0, 1, false);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getLastPage(containerHandle);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        int n = 0;
        while (page.spaceForInsert((Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null, 100)) {
            if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow) == null) {
                throw T_Fail.testFailMsg("There is space for this insert.  It shouldn't have failed.  record #" + n);
            }
            ++n;
        }
        this.REPORT(n + " rows inserted.");
        if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow) != null) {
            throw T_Fail.testFailMsg("There is no space for this insert.  It should have failed.");
        }
        String[] stringArray = new String[7];
        stringArray[6] = "McLare";
        stringArray[5] = "McLar";
        stringArray[4] = "McLa";
        stringArray[3] = "McL";
        stringArray[2] = "Mc";
        stringArray[1] = "M";
        stringArray[0] = null;
        n = 6;
        boolean bl = true;
        do {
            if (page.spaceForInsert((Object[])(t_RawStoreRow = new T_RawStoreRow(stringArray[n])).getRow(), (FormatableBitSet)null, 100)) {
                if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow) == null) {
                    throw T_Fail.testFailMsg("There should be space for this insert, row is " + stringArray[n]);
                }
                bl = false;
                continue;
            }
            --n;
        } while (bl && n >= 0);
        page.unlatch();
        this.t_util.t_dropContainer(transaction, l, l2);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P008");
    }

    protected void P009(long l) throws StandardException, T_Fail {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Object object = REC_001;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(13);
        t_RawStoreRow.setColumn(0, (String)null);
        t_RawStoreRow.setColumn(1, REC_001);
        t_RawStoreRow.setColumn(2, REC_002);
        t_RawStoreRow.setColumn(3, REC_003);
        t_RawStoreRow.setColumn(4, REC_004);
        t_RawStoreRow.setColumn(5, REC_005);
        t_RawStoreRow.setColumn(6, REC_006);
        t_RawStoreRow.setColumn(7, REC_007);
        t_RawStoreRow.setColumn(8, (String)null);
        t_RawStoreRow.setColumn(9, (String)null);
        t_RawStoreRow.setColumn(10, REC_007);
        t_RawStoreRow.setColumn(11, (String)null);
        t_RawStoreRow.setColumn(12, REC_006);
        int n4 = 0;
        n = 0;
        while (page.spaceForInsert((Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null, 100)) {
            T_Util.t_insert(page, t_RawStoreRow);
            ++n4;
        }
        this.REPORT(n4 + " rows inserted ");
        SQLChar sQLChar = new SQLChar();
        n2 = 0;
        while (true) {
            if (n2 >= 0 + 2) break;
            for (n = n2; n <= n4 - 1; n += 2) {
                for (n3 = 0; n3 <= 12; ++n3) {
                    if (page.updateFieldAtSlot(n, n3, (Object)sQLChar, null) != null) continue;
                    throw T_Fail.testFailMsg("Failed to update field " + n3 + ", in row " + n);
                }
            }
            sQLChar = new SQLChar(REC_001);
            ++n2;
        }
        SQLChar sQLChar2 = new SQLChar();
        object = null;
        n2 = 0;
        while (true) {
            if (n2 >= 0 + 2) break;
            for (n = n2; n <= n4 - 1; n += 2) {
                for (n3 = 0; n3 <= 12; ++n3) {
                    T_Util.t_checkFetchColFromSlot(page, n, n3, (DataValueDescriptor)sQLChar2, false, (String)object);
                }
            }
            object = REC_001;
            ++n2;
        }
        if (page.spaceForInsert()) {
            throw T_Fail.testFailMsg("Did not get no room for record on page error");
        }
        sQLChar = new SQLChar(REC_006);
        for (n = 0; n <= n4 - 1; ++n) {
            if (page.updateFieldAtSlot(n, 0, (Object)sQLChar, null) != null && page.updateFieldAtSlot(n, 12, (Object)sQLChar, null) != null) continue;
            throw T_Fail.testFailMsg("Failed to update fields to REC_006 in row " + n);
        }
        sQLChar = new SQLChar(REC_007);
        for (n = 0; n <= n4 - 1; ++n) {
            if (page.updateFieldAtSlot(n, 5, (Object)sQLChar, null) != null && page.updateFieldAtSlot(n, 6, (Object)sQLChar, null) != null) continue;
            throw T_Fail.testFailMsg("Failed to update fields to REC_007 in row " + n);
        }
        n2 = 0;
        while (true) {
            if (n2 >= 0 + 2) break;
            for (n = n2; n <= n4 - 1; n += 2) {
                for (n3 = 0; n3 <= 12; ++n3) {
                    switch (n3) {
                        case 0: 
                        case 12: {
                            object = REC_006;
                            break;
                        }
                        case 5: 
                        case 6: {
                            object = REC_007;
                            break;
                        }
                        default: {
                            object = n % 2 == 0 ? null : REC_001;
                        }
                    }
                    T_Util.t_checkFetchColFromSlot(page, n, n3, (DataValueDescriptor)sQLChar2, false, (String)object);
                }
            }
            ++n2;
        }
        if (page.spaceForInsert()) {
            throw T_Fail.testFailMsg("Did not get no room for record on page error");
        }
        object = REC_007;
        n2 = 0;
        String string = null;
        while (true) {
            if (n2 % 5 != 0) {
                string = object;
                object = (String)object + REC_008;
            } else {
                object = string;
            }
            if (n2 % 10 == 3 || n2 % 10 == 7) {
                page.unlatch();
                page = null;
                factory.idle();
                page = this.t_util.t_getPage(containerHandle, 1L);
            }
            sQLChar = new SQLChar((String)object);
            try {
                page.updateFieldAtSlot(0, 5, (Object)sQLChar, null);
            }
            catch (StandardException standardException) {
                if (n2 < 809) {
                    throw T_Fail.testFailMsg("should be able to update Row 0 Column 5 809 times, but only updated " + n2 + " times.  Note: you maybe getting this error if your page format has changed.");
                }
                this.REPORT("Row 0 Column 5 was updated " + n2 + " times.");
                break;
            }
            ++n2;
        }
        page.unlatch();
        page = null;
        factory.idle();
        page = this.t_util.t_getPage(containerHandle, 1L);
        sQLChar = new SQLChar(REC_002);
        if (page.updateFieldAtSlot(1, 1, (Object)sQLChar, null) == null) {
            throw T_Fail.testFailMsg("update Row 1 and Column 1 to same length data failed.");
        }
        this.REPORT("updated col1 in row 1 to same length");
        page.unlatch();
        page = null;
        factory.idle();
        page = this.t_util.t_getPage(containerHandle, 1L);
        object = "Ferrariz";
        sQLChar = new SQLChar((String)object);
        try {
            page.updateFieldAtSlot(1, 1, (Object)sQLChar, null);
            throw T_Fail.testFailMsg("update Row 1 and Column 1 to longer length should have failed.");
        }
        catch (StandardException standardException) {
            if (l != -1L) {
                this.t_util.t_dropContainer(transaction, l, l2);
            }
            this.t_util.t_commit(transaction);
            transaction.close();
            this.PASS("P009: segment " + l);
            return;
        }
    }

    protected void P011(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
        T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
        try {
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, -1, t_RawStoreRow);
            throw T_Fail.testFailMsg("insert at slot -1 succeeded");
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() > 20000) {
                throw standardException;
            }
            try {
                RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow);
                throw T_Fail.testFailMsg("insert at slot 1 succeeded");
            }
            catch (StandardException standardException2) {
                if (standardException2.getSeverity() > 20000) {
                    throw standardException2;
                }
                RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow3);
                T_Util.t_checkFetch(page, recordHandle, REC_003);
                T_Util.t_checkFetchBySlot(page, 0, REC_003, false, false);
                RecordHandle recordHandle2 = null;
                RecordHandle recordHandle3 = null;
                RecordHandle recordHandle4 = null;
                recordHandle4 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
                if (recordHandle4 == null) {
                    this.t_util.t_abort(transaction);
                    transaction.close();
                    this.REPORT("P011 not run - could not fit 4 rows on page");
                    return;
                }
                T_Util.t_checkFetch(page, recordHandle4, REC_001);
                T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
                recordHandle3 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
                if (recordHandle3 == null) {
                    this.t_util.t_abort(transaction);
                    transaction.close();
                    this.REPORT("P011 not completed - could not fit 4 rows on page");
                    return;
                }
                T_Util.t_checkFetch(page, recordHandle3, REC_002);
                T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
                recordHandle2 = T_Util.t_insertAtSlot(page, 3, t_RawStoreRow4);
                if (recordHandle2 == null) {
                    this.t_util.t_abort(transaction);
                    transaction.close();
                    this.REPORT("P011 not completed - could not fit 4 rows on page");
                    return;
                }
                T_Util.t_checkFetch(page, recordHandle2, REC_004);
                T_Util.t_checkFetchBySlot(page, 3, REC_004, false, false);
                T_Util.t_checkFetchFirst(page, REC_001);
                T_Util.t_checkFetchNext(page, recordHandle4, REC_002);
                T_Util.t_checkFetchNext(page, recordHandle3, REC_003);
                T_Util.t_checkFetchNext(page, recordHandle, REC_004);
                T_Util.t_checkFetchLast(page, REC_004);
                T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
                T_Util.t_checkFetchBySlot(page, 2, REC_003, false, true);
                T_Util.t_checkFetchBySlot(page, 3, REC_004, false, false);
                this.t_util.t_dropContainer(transaction, l, l2);
                this.t_util.t_commit(transaction);
                transaction.close();
                this.PASS("P011");
                return;
            }
        }
    }

    protected void P012(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(2);
        t_RawStoreRow2.setColumn(0, (String)null);
        t_RawStoreRow2.setColumn(1, REC_001);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(3);
        t_RawStoreRow3.setColumn(0, REC_001);
        t_RawStoreRow3.setColumn(1, REC_002);
        t_RawStoreRow3.setColumn(2, REC_003);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        RecordHandle recordHandle2 = null;
        RecordHandle recordHandle3 = null;
        recordHandle3 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        if (recordHandle3 == null) {
            this.REPORT("P012 not completed - cannot insert second row");
            return;
        }
        recordHandle2 = T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3);
        if (recordHandle2 == null) {
            this.REPORT("P012 not completed - cannot insert third row");
            return;
        }
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow2);
        T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow3);
        T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(2);
        t_RawStoreRow4.setColumn(0, (String)null);
        t_RawStoreRow4.setColumn(1, REC_001);
        recordHandle = page.updateAtSlot(0, (Object[])t_RawStoreRow4.getRow(), (FormatableBitSet)null);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow4);
        T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow2);
        T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow3);
        T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_004);
        recordHandle3 = page.updateAtSlot(1, (Object[])t_RawStoreRow5.getRow(), (FormatableBitSet)null);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow4);
        T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow5);
        T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow3);
        T_RawStoreRow t_RawStoreRow6 = new T_RawStoreRow(3);
        t_RawStoreRow6.setColumn(0, REC_003);
        t_RawStoreRow6.setColumn(1, REC_002);
        t_RawStoreRow6.setColumn(2, REC_001);
        recordHandle2 = page.updateAtSlot(2, (Object[])t_RawStoreRow6.getRow(), (FormatableBitSet)null);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow4);
        T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow5);
        T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow6);
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P012");
    }

    protected void P013() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        if (recordHandle2 == null) {
            this.REPORT("P013 not completed - could not fit two rows on a page");
            return;
        }
        T_Util.t_checkRecordCount(page, 2, 2);
        page.deleteAtSlot(0, true, (LogicalUndo)null);
        T_Util.t_checkRecordCount(page, 2, 1);
        if (!page.isDeletedAtSlot(0)) {
            throw T_Fail.testFailMsg("Failed to delete record 0");
        }
        if (page.isDeletedAtSlot(1)) {
            throw T_Fail.testFailMsg("Record mistakenly deleted");
        }
        page.deleteAtSlot(1, true, (LogicalUndo)null);
        T_Util.t_checkRecordCount(page, 2, 0);
        if (!page.isDeletedAtSlot(1)) {
            throw T_Fail.testFailMsg("Failed to delete record 1");
        }
        page.deleteAtSlot(0, false, (LogicalUndo)null);
        T_Util.t_checkRecordCount(page, 2, 1);
        if (page.isDeletedAtSlot(0)) {
            throw T_Fail.testFailMsg("Failed to undelete record 0");
        }
        if (!page.isDeletedAtSlot(1)) {
            throw T_Fail.testFailMsg("Record mistakenly undeleted");
        }
        page.deleteAtSlot(1, false, (LogicalUndo)null);
        T_Util.t_checkRecordCount(page, 2, 2);
        if (page.isDeletedAtSlot(1)) {
            throw T_Fail.testFailMsg("Failed to undelete record 1");
        }
        try {
            page.deleteAtSlot(0, false, (LogicalUndo)null);
            throw T_Fail.testFailMsg("undeleted on undeleted record succeeded");
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() > 20000) {
                throw standardException;
            }
            page.deleteAtSlot(0, true, (LogicalUndo)null);
            try {
                page.deleteAtSlot(0, true, (LogicalUndo)null);
                throw T_Fail.testFailMsg("deleted on deleted record succeeded");
            }
            catch (StandardException standardException2) {
                if (standardException2.getSeverity() > 20000) {
                    throw standardException2;
                }
                T_Util.t_checkRecordCount(page, 2, 1);
                this.PASS("P013");
                this.t_util.t_dropContainer(transaction, 0L, l);
                this.t_util.t_commit(transaction);
                transaction.close();
                return;
            }
        }
    }

    protected void P014() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_002);
        T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_003);
        T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_004);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3);
        RecordHandle recordHandle4 = T_Util.t_insertAtSlot(page, 3, t_RawStoreRow4);
        RecordHandle recordHandle5 = T_Util.t_insertAtSlot(page, 4, t_RawStoreRow5);
        if (recordHandle4 != null) {
            page.deleteAtSlot(3, true, (LogicalUndo)null);
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            page.purgeAtSlot(-1, 1, this.logDataForPurges);
            throw T_Fail.testFailMsg("negative slot number did not cause an exception");
        }
        catch (StandardException standardException) {
            try {
                page.purgeAtSlot(4, 4, this.logDataForPurges);
                throw T_Fail.testFailMsg("purging more rows than is on page did not cause an exception");
            }
            catch (StandardException standardException2) {
                if (recordHandle5 == null) {
                    int n = page.recordCount();
                    page.purgeAtSlot(0, 1, this.logDataForPurges);
                    if (page.recordCount() != n - 1) {
                        T_Fail.testFailMsg("failed to purge a record, expect " + (n - 1) + " got " + page.recordCount());
                    }
                    if (testRollback) {
                        this.t_util.t_abort(transaction);
                        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                        page = this.t_util.t_getPage(containerHandle, 1L);
                        if (this.logDataForPurges) {
                            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        } else {
                            T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        }
                        if (page.recordCount() != n) {
                            T_Fail.testFailMsg("failed to rollback purge, expect " + n + " got " + page.recordCount());
                        }
                    } else {
                        this.t_util.t_commit(transaction);
                    }
                    this.PASS("minimal P014");
                    return;
                }
                page.purgeAtSlot(1, 2, this.logDataForPurges);
                T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_003, true, true);
                T_Util.t_checkFetchBySlot(page, 2, REC_004, false, true);
                if (page.recordCount() != 3) {
                    T_Fail.testFailMsg("page expect to have 3 records, recordCount() = " + page.recordCount());
                }
                page.purgeAtSlot(0, 3, this.logDataForPurges);
                if (page.recordCount() != 0) {
                    T_Fail.testFailMsg("page expect to have 0 records, recordCount() = " + page.recordCount());
                }
                if (testRollback) {
                    this.REPORT("testing rollback");
                    this.t_util.t_abort(transaction);
                    containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                    page = this.t_util.t_getPage(containerHandle, 1L);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_002, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_004, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_NULL, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 5) {
                        T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                    }
                    page.purgeAtSlot(2, 3, this.logDataForPurges);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 2) {
                        T_Fail.testFailMsg("page expect to have 2 records, recordCount() = " + page.recordCount());
                    }
                    this.t_util.t_abort(transaction);
                    containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                    page = this.t_util.t_getPage(containerHandle, 1L);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_002, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_004, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_NULL, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 5) {
                        T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                    }
                    if (page.isDeletedAtSlot(1)) {
                        T_Fail.testFailMsg("rolled back purged undeleted record cause record to be deleted");
                    }
                    if (!page.isDeletedAtSlot(3)) {
                        T_Fail.testFailMsg("rolled back purged deleted record cause record to be undeleted");
                    }
                }
                this.PASS("P014");
                this.t_util.t_dropContainer(transaction, 0L, l);
                this.t_util.t_commit(transaction);
                transaction.close();
                return;
            }
        }
    }

    protected void P015() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(2);
        t_RawStoreRow2.setColumn(0, (String)null);
        t_RawStoreRow2.setColumn(1, REC_001);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(3);
        t_RawStoreRow3.setColumn(0, REC_001);
        t_RawStoreRow3.setColumn(1, REC_002);
        t_RawStoreRow3.setColumn(2, REC_003);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        RecordHandle recordHandle2 = null;
        RecordHandle recordHandle3 = null;
        recordHandle3 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        if (recordHandle3 == null) {
            this.REPORT("P015 not completed - cannot insert second row");
            return;
        }
        recordHandle2 = T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3);
        if (recordHandle2 == null) {
            this.REPORT("P015 not completed - cannot insert third row");
            return;
        }
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow2);
        T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow3);
        T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(2);
        t_RawStoreRow4.setColumn(0, REC_006);
        t_RawStoreRow4.setColumn(1, "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
        page.updateAtSlot(1, (Object[])t_RawStoreRow4.getRow(), (FormatableBitSet)null);
        T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow4);
        t_RawStoreRow.setColumn(0, REC_007);
        FormatableBitSet formatableBitSet = new FormatableBitSet(2);
        formatableBitSet.clear();
        formatableBitSet.set(0);
        page.updateAtSlot(0, (Object[])t_RawStoreRow.getRow(), formatableBitSet);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        t_RawStoreRow3.setColumn(1, "XXabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz");
        formatableBitSet.clear();
        formatableBitSet.set(1);
        page.updateAtSlot(2, (Object[])t_RawStoreRow3.getRow(), formatableBitSet);
        T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow3);
        this.PASS("P015");
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
    }

    protected void P016() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        long l2 = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        Page page2 = this.t_util.t_addPage(containerHandle);
        long l3 = page.getPageNumber();
        long l4 = page2.getPageNumber();
        T_Util.t_checkEmptyPage(page2);
        int n = 0;
        int n2 = 0;
        n = 0;
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow("row at slot " + n);
        while (page.spaceForInsert()) {
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, n, t_RawStoreRow);
            if (recordHandle == null) break;
            if (n % 3 == 1) {
                ++n2;
                page.deleteAtSlot(n, true, null);
            }
            t_RawStoreRow = new T_RawStoreRow("row at slot " + ++n);
        }
        int n3 = n;
        ContainerHandle containerHandle2 = this.t_util.t_openContainer(transaction, 0L, l2, true);
        Page page3 = this.t_util.t_getPage(containerHandle2, 1L);
        try {
            page.copyAndPurge(page3, 0, n3, 0);
            throw T_Fail.testFailMsg("copying to page from a different contaier should cause and exception");
        }
        catch (StandardException standardException) {
            try {
                page.copyAndPurge(page2, 1, 0, 0);
                throw T_Fail.testFailMsg("copying zero rows should cause an exception");
            }
            catch (StandardException standardException2) {
                try {
                    page.copyAndPurge(page2, 1, n3, 0);
                    throw T_Fail.testFailMsg("copying more rows than page contains should cause an exception");
                }
                catch (StandardException standardException3) {
                    try {
                        page.copyAndPurge(page2, 0, 1, 1);
                        throw T_Fail.testFailMsg("copying rows to nonexistant slot should cause an exception");
                    }
                    catch (StandardException standardException4) {
                        page.copyAndPurge(page2, 0, n3, 0);
                        T_Util.t_checkEmptyPage(page);
                        for (n = 0; n < n3; ++n) {
                            T_Util.t_checkFetchBySlot(page2, n, "row at slot " + n, n % 3 == 1, true);
                        }
                        T_Util.t_checkRecordCount(page2, n3, n3 - n2);
                        this.t_util.t_commit(transaction);
                        if (n3 > 2) {
                            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                            page = this.t_util.t_getPage(containerHandle, l3);
                            page2 = this.t_util.t_getPage(containerHandle, l4);
                            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_001);
                            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_002);
                            T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2);
                            T_Util.t_insertAtSlot(page, 1, t_RawStoreRow3);
                            page2.copyAndPurge(page, 1, n3 - 2, 1);
                            T_Util.t_checkFetchBySlot(page2, 0, "row at slot 0", false, true);
                            boolean bl = (n3 - 1) % 3 == 1;
                            T_Util.t_checkFetchBySlot(page2, 1, "row at slot " + (n3 - 1), bl, true);
                            if ((n3 - 1) % 3 == 1) {
                                T_Util.t_checkRecordCount(page2, 2, 1);
                            } else {
                                T_Util.t_checkRecordCount(page2, 2, 2);
                            }
                            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
                            for (n = 1; n < n3 - 1; ++n) {
                                T_Util.t_checkFetchBySlot(page, n, "row at slot " + n, n % 3 == 1, false);
                            }
                            T_Util.t_checkFetchBySlot(page, n3 - 1, REC_002, false, false);
                            if ((n3 - 1) % 3 == 1) {
                                T_Util.t_checkRecordCount(page, n3, n3 - n2 + 1);
                            } else {
                                T_Util.t_checkRecordCount(page, n3, n3 - n2);
                            }
                            if (testRollback) {
                                this.t_util.t_abort(transaction);
                                containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                                page = this.t_util.t_getPage(containerHandle, l3);
                                page2 = this.t_util.t_getPage(containerHandle, l4);
                                T_Util.t_checkFetchBySlot(page, 0, REC_001, true, false);
                                T_Util.t_checkFetchBySlot(page, 1, REC_002, true, false);
                                T_Util.t_checkRecordCount(page, 2, 0);
                                for (n = 0; n < n3; ++n) {
                                    T_Util.t_checkFetchBySlot(page2, n, "row at slot " + n, n % 3 == 1, true);
                                }
                                T_Util.t_checkRecordCount(page2, n3, n3 - n2);
                                this.REPORT("tested roll back of copyAndPurge");
                            }
                            this.PASS("P016");
                        }
                        this.t_util.t_dropContainer(transaction, 0L, l);
                        this.t_util.t_dropContainer(transaction, 0L, l2);
                        this.t_util.t_commit(transaction);
                        transaction.close();
                        return;
                    }
                }
            }
        }
    }

    protected void P017() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
        RecordHandle[] recordHandleArray = new RecordHandle[]{page.getInvalidRecordHandle(), page.makeRecordHandle(1), page.makeRecordHandle(2), page.makeRecordHandle(3), page.makeRecordHandle(4), page.makeRecordHandle(5)};
        for (int i = 0; i < 6; ++i) {
            try {
                page.recordExists(recordHandleArray[i], true);
                throw T_Fail.testFailMsg("record exists for invalid record " + String.valueOf(recordHandleArray[i]));
            }
            catch (StandardException standardException) {
                try {
                    int n = page.getSlotNumber(recordHandleArray[i]);
                    page.fetchFromSlot(recordHandleArray[i], n, (Object[])new DataValueDescriptor[0], null, false);
                    throw T_Fail.testFailMsg("fetched an invalid record " + String.valueOf(recordHandleArray[i]));
                }
                catch (StandardException standardException2) {
                    try {
                        int n = page.getSlotNumber(recordHandleArray[i]);
                        page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), null);
                        throw T_Fail.testFailMsg("updated an invalid record " + String.valueOf(recordHandleArray[i]));
                    }
                    catch (StandardException standardException3) {
                        try {
                            int n = page.getSlotNumber(recordHandleArray[i]);
                            page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), BS_COL_0);
                            throw T_Fail.testFailMsg("updated an invalid record field");
                        }
                        catch (StandardException standardException4) {
                            try {
                                int n = page.getSlotNumber(recordHandleArray[i]);
                                page.deleteAtSlot(n, true, null);
                                throw T_Fail.testFailMsg("delete an invalid record " + String.valueOf(recordHandleArray[i]));
                            }
                            catch (StandardException standardException5) {
                                try {
                                    page.fetchNumFields(recordHandleArray[i]);
                                    throw T_Fail.testFailMsg("fetch num fields on invalid record " + String.valueOf(recordHandleArray[i]));
                                }
                                catch (StandardException standardException6) {
                                    try {
                                        page.getSlotNumber(recordHandleArray[i]);
                                        throw T_Fail.testFailMsg("got slot number of invalid record " + String.valueOf(recordHandleArray[i]));
                                    }
                                    catch (StandardException standardException7) {
                                        continue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.PASS("P017");
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
    }

    protected void P018() throws StandardException, T_Fail {
        RecordHandle recordHandle;
        T_RawStoreRow t_RawStoreRow;
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L, 4096, 0, 1, false);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        Page page2 = this.t_util.t_addPage(containerHandle);
        long l2 = page.getPageNumber();
        long l3 = page2.getPageNumber();
        T_Util.t_checkEmptyPage(page2);
        int n = 0;
        boolean bl = false;
        for (n = 0; n < 100; ++n) {
            t_RawStoreRow = new T_RawStoreRow("r" + n);
            recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
        }
        n = 0;
        while (true) {
            t_RawStoreRow = new T_RawStoreRow("r" + n);
            recordHandle = T_Util.t_insertAtSlot(page2, n, t_RawStoreRow);
            if (recordHandle == null) break;
            ++n;
        }
        try {
            page2.copyAndPurge(page, 0, page2.recordCount(), 0);
            throw T_Fail.testFailMsg("copying rows with expanding recids should cause an exception");
        }
        catch (StandardException standardException) {
            this.t_util.t_dropContainer(transaction, 0L, l);
            this.t_util.t_commit(transaction);
            l = this.t_util.t_addContainer(transaction, 0L, 4096, 0, 1, true);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            page2 = this.t_util.t_addPage(containerHandle);
            l2 = page.getPageNumber();
            l3 = page2.getPageNumber();
            T_Util.t_checkEmptyPage(page2);
            n = 0;
            for (n = 0; n < 100; ++n) {
                t_RawStoreRow = new T_RawStoreRow("r" + n);
                recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
                page.purgeAtSlot(0, 1, this.logDataForPurges);
            }
            n = 0;
            while (true) {
                t_RawStoreRow = new T_RawStoreRow("r" + n);
                recordHandle = T_Util.t_insertAtSlot(page2, n, t_RawStoreRow);
                if (recordHandle == null) break;
                ++n;
            }
            long l4 = page2.getPageNumber();
            int n2 = page2.recordCount();
            try {
                page2.copyAndPurge(page, 0, page2.recordCount(), 0);
                throw T_Fail.testFailMsg("copying rows with expanding recids should cause an exception");
            }
            catch (StandardException standardException2) {
                this.t_util.t_removePage(containerHandle, page);
                this.t_util.t_commit(transaction);
                containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                page = this.t_util.t_addPage(containerHandle);
                int n3 = 0;
                while (page.getPageNumber() != 1L) {
                    this.REPORT("getting page " + page.getPageNumber());
                    this.t_util.t_commit(transaction);
                    if (n3++ > 100) {
                        throw T_Fail.testFailMsg("failed to get back first page after " + n3 + " tries");
                    }
                    containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                    page = this.t_util.t_addPage(containerHandle);
                }
                page2 = this.t_util.t_getPage(containerHandle, l4);
                T_Util.t_checkRecordCount(page2, n2, n2);
                T_Util.t_checkEmptyPage(page);
                try {
                    page2.copyAndPurge(page, 0, page2.recordCount(), 0);
                }
                catch (StandardException standardException3) {
                    throw T_Fail.testFailMsg("copying rows with non-expanding recids should not cause an exception");
                }
                this.PASS("P018");
                this.t_util.t_dropContainer(transaction, 0L, l);
                this.t_util.t_commit(transaction);
                transaction.close();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P019() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L, 4096, 0, 1, false);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = containerHandle.addPage(2);
        long l2 = page.getPageNumber();
        page.unlatch();
        Page page2 = containerHandle.addPage();
        long l3 = page2.getPageNumber();
        page2.unlatch();
        Page page3 = containerHandle.addPage(2);
        long l4 = page3.getPageNumber();
        page3.unlatch();
        Page page4 = containerHandle.getFirstPage();
        try {
            long l5 = page4.getPageNumber();
            page4.unlatch();
            page4 = containerHandle.getNextPage(l5);
            if (page4.getPageNumber() != l2) {
                throw T_Fail.testFailMsg("expected pagenum " + l2 + " got " + page4.getPageNumber());
            }
            page4.unlatch();
            page4 = null;
            page4 = containerHandle.getNextPage(l2);
            if (page4.getPageNumber() != l3) {
                throw T_Fail.testFailMsg("expected pagenum " + l3 + " got " + page4.getPageNumber());
            }
            page4.unlatch();
            page4 = null;
            page4 = containerHandle.getNextPage(l3);
            if (page4.getPageNumber() != l4) {
                throw T_Fail.testFailMsg("expected pagenum " + l4 + " got " + page4.getPageNumber());
            }
            page4.unlatch();
            page4 = null;
            page4 = containerHandle.getNextPage(l4);
            if (page4 != null) {
                throw T_Fail.testFailMsg("expected null page after " + l4 + " got " + page4.getPageNumber());
            }
            if (testRollback) {
                this.t_util.t_abort(transaction);
                containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                page4 = this.t_util.t_getPage(containerHandle, l5);
                T_Util.t_checkEmptyPage(page4);
                page4.unlatch();
                page4 = null;
                page4 = this.t_util.t_getPage(containerHandle, l2);
                T_Util.t_checkEmptyPage(page4);
                page4.unlatch();
                page4 = null;
                page4 = this.t_util.t_getPage(containerHandle, l3);
                T_Util.t_checkEmptyPage(page4);
                page4.unlatch();
                page4 = null;
                page4 = this.t_util.t_getPage(containerHandle, l4);
                T_Util.t_checkEmptyPage(page4);
                page4.unlatch();
                page4 = null;
                page4 = this.t_util.t_getLastPage(containerHandle);
                if (page4.getPageNumber() != l4) {
                    throw T_Fail.testFailMsg("expect last page to be " + l4 + " got " + page4.getPageNumber());
                }
                page4.unlatch();
                page4 = null;
            }
            this.t_util.t_dropContainer(transaction, 0L, l);
        }
        finally {
            if (page4 != null) {
                page4.unlatch();
            }
            page4 = null;
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P019 - container " + l);
    }

    protected void P020() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", Integer.toString(4096));
        properties.put("derby.storage.initialPages", Integer.toString(100));
        long l = this.t_util.t_addContainer(transaction, 0L, properties);
        if (l < 0L) {
            throw T_Fail.testFailMsg("addContainer");
        }
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = containerHandle.getFirstPage();
        if (page.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("expect first page to have FIRST_PAGE_NUMBER");
        }
        page.unlatch();
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("expect to have only 1 page allocated");
        }
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P020 - container " + l);
    }

    protected void P021() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        containerHandle.preAllocate(10);
        Page page = containerHandle.getFirstPage();
        if (page.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("expect first page to have FIRST_PAGE_NUMBER");
        }
        page.unlatch();
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("expect to have only 1 page allocated");
        }
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P021 - container " + l);
    }

    protected void P022() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L, 4096, 0, 9, false);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        for (int i = 0; i < 60; ++i) {
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow("r" + i);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        }
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P022");
    }

    protected void P023(int n) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, n, 4096, 0, 0, false);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, (long)n, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        int n2 = 50;
        T_Util.t_checkEmptyPage(page);
        boolean bl = true;
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(1);
        t_RawStoreRow.setColumn(0, 200, REC_001);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)(bl ? 1 : 0), n2);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow, (byte)(bl ? 1 : 0), n2);
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("insert of second long row failed.");
        }
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow);
        page.unlatch();
        page = null;
        this.REPORT("test 1: 2 rows under threshold inserted...");
        page = this.t_util.t_addPage(containerHandle);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(1);
        t_RawStoreRow2.setColumn(0, 2000, REC_001);
        recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)(bl ? 1 : 0), n2);
        if (recordHandle != null) {
            throw T_Fail.testFailMsg("insert of 1st over threshold row should failed.");
        }
        recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)(bl ? 1 : 0), n2);
        if (recordHandle2 != null) {
            throw T_Fail.testFailMsg("insert of 2nd over threshold row should failed.");
        }
        page.unlatch();
        page = null;
        this.REPORT("test 2: 2 rows over threshold not inserted...");
        page = this.t_util.t_addPage(containerHandle);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(2);
        t_RawStoreRow3.setColumn(0, 400, REC_001);
        t_RawStoreRow3.setColumn(1, 400, REC_001);
        recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow3, (byte)(bl ? 1 : 0), n2);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("insert of 1st 2-column row failed.");
        }
        recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow3, (byte)(bl ? 1 : 0), n2);
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("insert of 2nd 2-column row failed.");
        }
        page.unlatch();
        page = null;
        this.REPORT("test 3: 2 rows with 2 columns under the threshold inserted...");
        page = this.t_util.t_addPage(containerHandle);
        T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(2);
        t_RawStoreRow4.setColumn(0, 800, REC_001);
        t_RawStoreRow4.setColumn(1, 800, REC_001);
        recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow4, (byte)(bl ? 1 : 0), n2);
        if (recordHandle != null) {
            SanityManager.DEBUG_PRINT((String)"bug", (String)("page = " + String.valueOf(page)));
            throw T_Fail.testFailMsg("insert of 1st 2-column row (OT) should failed.");
        }
        recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow4, (byte)(bl ? 1 : 0), n2);
        if (recordHandle2 != null) {
            throw T_Fail.testFailMsg("insert of 2nd 2-column row (OT) should failed.");
        }
        page.unlatch();
        page = null;
        this.REPORT("test 4: 2 rows with 2 columns over the threshold not inserted...");
        this.t_util.t_dropContainer(transaction, n, l);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P023");
    }

    protected void P024(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096, 0, 1, false);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getLastPage(containerHandle);
        Page page2 = this.t_util.t_addPage(containerHandle);
        long l3 = page.getPageNumber();
        long l4 = page2.getPageNumber();
        this.t_util.t_checkGetLatchedPage(containerHandle, l3);
        this.t_util.t_checkGetLatchedPage(containerHandle, l4);
        page.unlatch();
        this.t_util.t_checkGetLatchedPage(containerHandle, l4);
        page = this.t_util.t_getPage(containerHandle, l3);
        page.unlatch();
        page2.unlatch();
        this.t_util.t_dropContainer(transaction, l, l2);
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P024");
    }

    protected void P030(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(0);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(null);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow("0123456789");
        T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3);
        T_Util.t_checkRecordCount(page, 3, 3);
        page.unlatch();
        page = null;
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        this.t_util.t_checkStringLengthFetch(page, 1, -1);
        this.t_util.t_checkStringLengthFetch(page, 2, 10);
        T_Util.t_checkFieldCount(page, 0, 0);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(String.valueOf(new char[1937]));
        page.updateAtSlot(1, (Object[])t_RawStoreRow4.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 10);
        T_Util.t_checkFieldCount(page, 0, 0);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(String.valueOf(new char[1099]));
        page = this.t_util.t_getPage(containerHandle, 1L);
        page.updateAtSlot(2, (Object[])t_RawStoreRow5.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 0);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 0);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow6 = new T_RawStoreRow(String.valueOf(new char[423]));
        page.updateAtSlot(0, (Object[])t_RawStoreRow6.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 0, 423);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 1);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        t_RawStoreRow6 = new T_RawStoreRow(String.valueOf(new char[399]));
        page.updateAtSlot(0, (Object[])t_RawStoreRow6.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 0, 399);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 1);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        t_RawStoreRow6 = new T_RawStoreRow(String.valueOf(new char[1400]));
        page.updateAtSlot(0, (Object[])t_RawStoreRow6.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 0, 1400);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 1);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (containerHandle.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P030: segment = " + l);
    }

    protected void P031(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(4);
        t_RawStoreRow.setColumn(0, 256, REC_001);
        t_RawStoreRow.setColumn(1, 256, REC_002);
        t_RawStoreRow.setColumn(2, 256, REC_003);
        t_RawStoreRow.setColumn(3, 256, REC_004);
        int n = 0;
        n |= 8;
        RecordHandle recordHandle = null;
        try {
            recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
        }
        catch (StandardException standardException) {
            throw T_Fail.testFailMsg("insert of long row failed.");
        }
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        this.REPORT("about to check fetch...");
        SQLChar sQLChar = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, REC_001, 256);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_002, 256);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, false, REC_003, 256);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)sQLChar, false, REC_004, 256);
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P031: segment = " + l);
    }

    protected void P032(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        int n = 0;
        n |= 8;
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(60);
        for (int i = 0; i < 60; ++i) {
            t_RawStoreRow.setColumn(i, 1200, REC_001);
        }
        RecordHandle recordHandle = null;
        try {
            recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
        }
        catch (StandardException standardException) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("insert of a 60-column (300 bytes per column) row failed.");
        }
        this.REPORT("about to check fetch the first long row inserted...");
        SQLChar sQLChar = new SQLChar();
        for (int i = 0; i < 60; ++i) {
            T_Util.t_checkFetchColFromSlot(page, 0, i, (DataValueDescriptor)sQLChar, false, REC_001, 1200);
        }
        for (int i = 0; i < 60; ++i) {
            t_RawStoreRow.setColumn(i, REC_001);
        }
        RecordHandle recordHandle2 = null;
        try {
            recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow, (byte)n);
        }
        catch (StandardException standardException) {
            throw T_Fail.testFailMsg("insert of second long row failed.");
        }
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("insert of a 60-column (~10 bytes per column) row failed.");
        }
        this.REPORT("about to check fetch the second long row inserted ...");
        SQLChar sQLChar2 = new SQLChar();
        for (int i = 0; i < 60; ++i) {
            T_Util.t_checkFetchColFromSlot(page, 1, i, (DataValueDescriptor)sQLChar2, false, REC_001);
        }
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P032: segment = " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P033(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            int n;
            T_Util.t_checkEmptyPage(page);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(100);
            for (n = 0; n < 100; ++n) {
                t_RawStoreRow.setColumn(n, REC_007);
            }
            n = 8;
            RecordHandle recordHandle = null;
            try {
                recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            }
            catch (StandardException standardException) {
                throw T_Fail.testFailMsg("insert of long row failed.");
            }
            if (recordHandle == null) {
                throw T_Fail.testFailMsg("insert of first long row failed.");
            }
            this.REPORT("about to check fetch...");
            SQLChar sQLChar = new SQLChar();
            for (int i = 0; i < 100; ++i) {
                T_Util.t_checkFetchColFromSlot(page, 0, i, (DataValueDescriptor)sQLChar, false, REC_007);
            }
            page.unlatch();
            page = null;
            if (l != -1L) {
                this.t_util.t_dropContainer(transaction, l, l2);
            }
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P033: segment = " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P034(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(401);
            for (int i = 0; i < 400; ++i) {
                t_RawStoreRow.setColumn(i, REC_001);
            }
            t_RawStoreRow.setColumn(400, 1500, REC_001);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            page.unlatch();
            page = null;
            if (l != -1L) {
                this.t_util.t_dropContainer(transaction, l, l2);
            }
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P034: segment = " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P035(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(1);
            t_RawStoreRow.setColumn(0, 500, REC_001);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            this.REPORT("row 1 inserted...");
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(6);
            t_RawStoreRow2.setColumn(0, 400, REC_001);
            t_RawStoreRow2.setColumn(1, 500, REC_002);
            t_RawStoreRow2.setColumn(2, 400, REC_001);
            t_RawStoreRow2.setColumn(3, 500, REC_002);
            t_RawStoreRow2.setColumn(4, 400, REC_001);
            t_RawStoreRow2.setColumn(5, 500, REC_002);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)n);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            this.REPORT("row 2 inserted...");
            t_RawStoreRow.setColumn(0, 1500, REC_001);
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            if (recordHandle3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            if (l != -1L) {
                this.t_util.t_dropContainer(transaction, l, l2);
            }
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P035: segment = " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P036() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(400);
            for (int i = 0; i < 400; ++i) {
                t_RawStoreRow.setColumn(i, 100 + i, REC_001);
            }
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.REPORT("P036 - Nextpage is " + l3);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow);
            page.unlatch();
            page = null;
            page2 = this.t_util.t_addPage(containerHandle);
            long l4 = page2.getPageNumber();
            page2.unlatch();
            if (l3 != l4) {
                throw T_Fail.testFailMsg("fail to reuse row pieces expect next page=" + l3 + " but got " + l4);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            transaction.setSavePoint(SP1, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            page.unlatch();
            page = null;
            Page page3 = this.t_util.t_addPage(containerHandle);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_001);
            T_Util.t_insert(page3, t_RawStoreRow2);
            page3.unlatch();
            transaction.rollbackToSavePoint(SP1, null);
            page3 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page3, t_RawStoreRow2);
            page3.unlatch();
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page3 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page3, t_RawStoreRow2);
            page3.unlatch();
            if ((this.openMode & 1) == 0) {
                page = this.t_util.t_getPage(containerHandle, 1L);
                if (this.logDataForPurges) {
                    T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow);
                } else {
                    int n2;
                    T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(400);
                    for (n2 = 0; n2 < 18; ++n2) {
                        t_RawStoreRow3.setColumn(n2, 4, REC_NULL);
                    }
                    for (n2 = 18; n2 < 400; ++n2) {
                        t_RawStoreRow3.setColumn(n2, 100 + n2, REC_001);
                    }
                    T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow3);
                }
                page.unlatch();
                page = null;
            }
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P036");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P037() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(1);
            t_RawStoreRow.setColumn(0, 5500, REC_001);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(6);
            t_RawStoreRow2.setColumn(0, 660, REC_001);
            t_RawStoreRow2.setColumn(1, 5000, REC_002);
            t_RawStoreRow2.setColumn(2, 660, REC_001);
            t_RawStoreRow2.setColumn(3, 5000, REC_002);
            t_RawStoreRow2.setColumn(4, 660, REC_001);
            t_RawStoreRow2.setColumn(5, 5000, REC_002);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)n);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            if (recordHandle3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.REPORT("P037 - Nextpage is " + l3);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)n);
            recordHandle3 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            if (recordHandle3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            page2 = this.t_util.t_addPage(containerHandle);
            long l4 = page2.getPageNumber();
            page2.unlatch();
            if (l3 != l4) {
                throw T_Fail.testFailMsg("fail to reuse row pieces expect next page=" + l3 + " but got " + l4);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            transaction.setSavePoint(SP1, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            Page page3 = this.t_util.t_addPage(containerHandle);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_001);
            T_Util.t_insert(page3, t_RawStoreRow3);
            page3.unlatch();
            transaction.rollbackToSavePoint(SP1, null);
            page3 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page3, t_RawStoreRow3);
            page3.unlatch();
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page3 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page3, t_RawStoreRow3);
            page3.unlatch();
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            if (this.logDataForPurges) {
                T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            } else {
                T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(6);
                t_RawStoreRow4.setColumn(0, 4, REC_NULL);
                t_RawStoreRow4.setColumn(1, 5000, REC_002);
                t_RawStoreRow4.setColumn(2, 4, REC_NULL);
                t_RawStoreRow4.setColumn(3, 5000, REC_002);
                t_RawStoreRow4.setColumn(4, 4, REC_NULL);
                t_RawStoreRow4.setColumn(5, 5000, REC_002);
                T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow4);
            }
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P037");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P038() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 10;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(1);
            t_RawStoreRow.setColumn(0, 1500, REC_001);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(6);
            t_RawStoreRow2.setColumn(0, 400, REC_001);
            t_RawStoreRow2.setColumn(1, 500, REC_002);
            t_RawStoreRow2.setColumn(2, 400, REC_001);
            t_RawStoreRow2.setColumn(3, 500, REC_002);
            t_RawStoreRow2.setColumn(4, 400, REC_001);
            t_RawStoreRow2.setColumn(5, 500, REC_002);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)n);
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            if (recordHandle3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page = null;
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.REPORT("P038 - Nextpage is " + l3);
            this.t_util.t_abort(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page2 = this.t_util.t_getPage(containerHandle, l3);
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkEmptyPage(page);
            recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)n);
            recordHandle3 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            if (recordHandle3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            page2 = this.t_util.t_addPage(containerHandle);
            long l4 = page2.getPageNumber();
            page2.unlatch();
            if (l3 != l4) {
                throw T_Fail.testFailMsg("fail to reuse row pieces expect next page=" + l3 + " but got " + l4);
            }
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P038");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P039() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 8192);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(3);
        t_RawStoreRow.setColumn(0, 50, REC_001);
        t_RawStoreRow.setColumn(1, 750, REC_002);
        t_RawStoreRow.setColumn(2, 200, REC_003);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
            RecordHandle recordHandle2 = T_Util.t_insert(page, t_RawStoreRow);
            RecordHandle recordHandle3 = T_Util.t_insert(page, t_RawStoreRow);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow);
            T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(1);
            t_RawStoreRow2.setColumn(0, 500, REC_004);
            while (page.spaceForInsert()) {
                if (T_Util.t_insert(page, t_RawStoreRow2) != null) continue;
            }
            this.REPORT("P039: " + (page.recordCount() - 3) + " small rows have been inserted");
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            t_RawStoreRow.setColumn(1, 2000, REC_005);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), null);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            if (T_Util.t_insert(page, t_RawStoreRow2) == null) {
                throw T_Fail.testFailMsg("expect row to have shrunk (1)");
            }
            while (page.spaceForInsert()) {
                if (T_Util.t_insert(page, t_RawStoreRow2) != null) continue;
            }
            this.REPORT("P039: " + (page.recordCount() - 3) + " small rows have been inserted");
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            FormatableBitSet formatableBitSet = new FormatableBitSet(2);
            formatableBitSet.set(1);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(2);
            t_RawStoreRow3.setColumn(1, 8000, REC_006);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            int n2 = page.getSlotNumber(recordHandle2);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow3.getRow(), formatableBitSet);
            t_RawStoreRow.setColumn(1, 8000, REC_006);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            if (T_Util.t_insert(page, t_RawStoreRow2) == null) {
                throw T_Fail.testFailMsg("expect row to have shrunk (2)");
            }
            while (page.spaceForInsert()) {
                if (T_Util.t_insert(page, t_RawStoreRow2) != null) continue;
            }
            this.REPORT("P039: " + (page.recordCount() - 3) + " small rows have been inserted");
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            t_RawStoreRow.setColumn(0, 100, REC_001);
            t_RawStoreRow.setColumn(1, 200, REC_002);
            t_RawStoreRow.setColumn(2, 200, REC_003);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            int n3 = page.getSlotNumber(recordHandle3);
            page.updateAtSlot(n3, (Object[])t_RawStoreRow.getRow(), null);
            T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            if (T_Util.t_insert(page, t_RawStoreRow2) == null) {
                throw T_Fail.testFailMsg("expect row to have shrunk (3)");
            }
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P039");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P040() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, 0L, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            int n = 10;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(3);
            t_RawStoreRow.setColumn(0, 400, REC_001);
            t_RawStoreRow.setColumn(1, 800, REC_002);
            t_RawStoreRow.setColumn(2, 400, REC_003);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_commit(transaction);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(3);
            t_RawStoreRow2.setColumn(0, 1200, REC_001);
            t_RawStoreRow2.setColumn(1, 1200, REC_002);
            t_RawStoreRow2.setColumn(2, 400, REC_003);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2, (byte)n);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            page.unlatch();
            page = null;
            page2 = this.t_util.t_addPage(containerHandle);
            long l4 = page2.getPageNumber();
            if (l4 == l3) {
                throw T_Fail.testFailMsg("expected to allocate more pages");
            }
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_commit(transaction);
            l3 = l4;
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(2);
            t_RawStoreRow3.setColumn(1, 400, REC_004);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(2);
            t_RawStoreRow4.setColumn(0, 400, REC_004);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            FormatableBitSet formatableBitSet = new FormatableBitSet(2);
            formatableBitSet.set(1);
            int n2 = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow3.getRow(), formatableBitSet);
            formatableBitSet.clear(1);
            formatableBitSet.set(0);
            int n3 = page.getSlotNumber(recordHandle2);
            page.updateAtSlot(n3, (Object[])t_RawStoreRow4.getRow(), formatableBitSet);
            t_RawStoreRow.setColumn(1, 400, REC_004);
            t_RawStoreRow2.setColumn(0, 400, REC_004);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(2);
            t_RawStoreRow5.setColumn(0, 400, REC_001);
            t_RawStoreRow5.setColumn(1, 800, REC_002);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            if (!page.spaceForInsert()) {
                throw T_Fail.testFailMsg("No space for insert after shrink row");
            }
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow5, (byte)n);
            T_Util.t_checkFetch(page, recordHandle3, t_RawStoreRow5);
            page.unlatch();
            page = null;
            page2 = this.t_util.t_addPage(containerHandle);
            l4 = page2.getPageNumber();
            if (l4 != l3) {
                throw T_Fail.testFailMsg("not expected to allocate more pages " + l3 + "," + l4);
            }
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P040");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P041() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(6);
            t_RawStoreRow.setColumn(0, 400, REC_001);
            t_RawStoreRow.setColumn(1, 500, REC_002);
            t_RawStoreRow.setColumn(2, 400, REC_001);
            t_RawStoreRow.setColumn(3, 500, REC_002);
            t_RawStoreRow.setColumn(4, 400, REC_001);
            t_RawStoreRow.setColumn(5, 500, REC_002);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(6);
            t_RawStoreRow2.setColumn(0, 100, REC_003);
            t_RawStoreRow2.setColumn(1, 100, REC_004);
            t_RawStoreRow2.setColumn(2, 100, REC_003);
            t_RawStoreRow2.setColumn(3, 500, REC_005);
            t_RawStoreRow2.setColumn(4, 500, REC_006);
            t_RawStoreRow2.setColumn(5, 500, REC_005);
            int n2 = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow2.getRow(), null);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
            page.unlatch();
            page = null;
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
            transaction.setSavePoint(SP1, null);
            n2 = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n2, (Object[])t_RawStoreRow.getRow(), null);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            page.unlatch();
            page = null;
            page2 = this.t_util.t_addPage(containerHandle);
            long l4 = page2.getPageNumber();
            page2.unlatch();
            if (l4 != l3) {
                throw T_Fail.testFailMsg("expect next page to be unchanged");
            }
            transaction.rollbackToSavePoint(SP1, null);
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P041");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P042() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(1);
            t_RawStoreRow2.setColumn(0, 6400, REC_001);
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow2.getRow(), null);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
            page.unlatch();
            page = null;
            Page page3 = this.t_util.t_addPage(containerHandle);
            long l4 = page3.getPageNumber();
            if (l4 == l3) {
                throw T_Fail.testFailMsg("expect to have allocated more pages");
            }
            this.t_util.t_removePage(containerHandle, page3);
            this.t_util.t_abort(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page3 = this.t_util.t_getPage(containerHandle, l4);
            this.t_util.t_removePage(containerHandle, page3);
            page2 = this.t_util.t_addPage(containerHandle);
            if (page2.getPageNumber() != l3) {
                throw T_Fail.testFailMsg("rollback of update to long column did not release the long column chain pages");
            }
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_commit(transaction);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(6);
            t_RawStoreRow3.setColumn(0, 1600, REC_001);
            t_RawStoreRow3.setColumn(1, 2000, REC_002);
            t_RawStoreRow3.setColumn(2, 1600, REC_001);
            t_RawStoreRow3.setColumn(3, 2000, REC_002);
            t_RawStoreRow3.setColumn(4, 1600, REC_001);
            t_RawStoreRow3.setColumn(5, 2000, REC_002);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            transaction.setSavePoint(SP1, null);
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow3.getRow(), null);
            page2 = this.t_util.t_addPage(containerHandle);
            l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            transaction.rollbackToSavePoint(SP1, null);
            page2 = this.t_util.t_getPage(containerHandle, l3);
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            Page page4 = this.t_util.t_addPage(containerHandle);
            if (page4.getPageNumber() == l3) {
                throw T_Fail.testFailMsg("expect some pages to be freed by update rollback");
            }
            this.t_util.t_removePage(containerHandle, page4);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow3.getRow(), null);
            page2 = this.t_util.t_addPage(containerHandle);
            l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.t_util.t_commit(transaction);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(5);
            t_RawStoreRow4.setColumn(0, 4000, REC_003);
            t_RawStoreRow4.setColumn(1, 4000, REC_004);
            t_RawStoreRow4.setColumn(2, REC_001);
            t_RawStoreRow4.setColumn(3, REC_001);
            t_RawStoreRow4.setColumn(4, 4000, REC_003);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow4.getRow(), null);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow4);
            page.unlatch();
            page = null;
            this.t_util.t_abort(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page2 = this.t_util.t_addPage(containerHandle);
            if (page2.getPageNumber() != l3) {
                throw T_Fail.testFailMsg("expect pages to be freed by update rollback");
            }
            page2.unlatch();
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P042");
    }

    protected void P043() {
    }

    protected void P050() throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        transaction.setSavePoint(SP1, null);
        transaction.dropContainer(new ContainerKey(0L, l));
        transaction.rollbackToSavePoint(SP1, null);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        this.t_util.t_addPage(containerHandle);
        this.t_util.t_commit(transaction);
        long l2 = this.t_util.t_addContainer(transaction, 0L);
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l2, true);
        this.t_util.t_addPage(containerHandle);
        this.t_util.t_addPage(containerHandle);
        this.t_util.t_addPage(containerHandle);
        this.t_util.t_addPage(containerHandle);
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, false);
        this.PASS("P050");
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_dropContainer(transaction, 0L, l2);
        this.t_util.t_commit(transaction);
        transaction.close();
    }

    protected void P051() throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        this.t_util.t_checkFetch(containerHandle, recordHandle, REC_001);
        t_RawStoreRow = new T_RawStoreRow(REC_002);
        RecordHandle recordHandle2 = this.t_util.t_insert(containerHandle, t_RawStoreRow);
        this.t_util.t_checkFetch(containerHandle, recordHandle, REC_001);
        this.t_util.t_checkFetch(containerHandle, recordHandle2, REC_002);
        this.t_util.t_abort(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        this.t_util.t_checkFetch(containerHandle, recordHandle, REC_001);
        page = this.t_util.t_getPage(containerHandle, recordHandle2.getPageNumber());
        if (page.recordExists(recordHandle2, false)) {
            throw T_Fail.testFailMsg("record insert was not undone");
        }
        page.unlatch();
        this.PASS("P051");
        this.t_util.t_dropContainer(transaction, 0L, l);
        this.t_util.t_commit(transaction);
        transaction.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P053() throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            this.t_util.t_commit(transaction);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_addPage(containerHandle);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_001);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_002);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_003);
            T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_004);
            T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)2);
            if (T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2) == null) {
                return;
            }
            if (T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3, (byte)2) == null) {
                return;
            }
            if (T_Util.t_insertAtSlot(page, 3, t_RawStoreRow4) == null) {
                return;
            }
            if (T_Util.t_insertAtSlot(page, 4, t_RawStoreRow5, (byte)2) == null) {
                return;
            }
            int n = 0;
            while (page.spaceForInsert()) {
                T_Util.t_insertAtSlot(page, 4, t_RawStoreRow5);
                ++n;
            }
            T_Util.t_checkRecordCount(page, n + 5, n + 5);
            this.t_util.t_abort(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getLastPage(containerHandle);
            T_Util.t_checkRecordCount(page, 2 + n, 0);
            T_Util.t_insert(page, t_RawStoreRow);
            T_Util.t_insert(page, t_RawStoreRow3);
            T_Util.t_insert(page, t_RawStoreRow5);
            T_Util.t_checkRecordCount(page, 5 + n, 3);
            page.unlatch();
            this.PASS("P053");
            this.t_util.t_dropContainer(transaction, 0L, l);
        }
        finally {
            this.t_util.t_commit(transaction);
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P054() throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        ContextManager contextManager = contextService.getCurrentContextManager();
        ContextManager contextManager2 = contextService.newContextManager();
        contextService.setCurrentContextManager(contextManager2);
        Transaction transaction = this.t_util.t_startTransaction();
        Transaction transaction2 = null;
        try {
            long l = this.t_util.t_addContainer(transaction, 0L);
            ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            Page page = this.t_util.t_addPage(containerHandle);
            this.t_util.t_commit(transaction);
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getLastPage(containerHandle);
            RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
            this.REPORT("starting internal transaction");
            transaction2 = this.t_util.t_startInternalTransaction();
            long l2 = this.t_util.t_addContainer(transaction2, 0L);
            ContainerHandle containerHandle2 = this.t_util.t_openContainer(transaction2, 0L, l2, true);
            Page page2 = this.t_util.t_addPage(containerHandle2);
            RecordHandle recordHandle2 = T_Util.t_insert(page2, t_RawStoreRow);
            transaction2.commit();
            transaction2.abort();
            transaction2.close();
            transaction2 = null;
            this.REPORT("commit internal transaction");
            this.t_util.t_abort(transaction);
            this.REPORT("rollback user transaction");
            containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
            page = this.t_util.t_getPage(containerHandle, recordHandle.getPageNumber());
            if (page.recordExists(recordHandle, false)) {
                throw T_Fail.testFailMsg("user transaction failed to rollback");
            }
            containerHandle2 = this.t_util.t_openContainer(transaction, 0L, l2, true);
            this.t_util.t_checkFetch(containerHandle2, recordHandle2, REC_001);
            page2 = this.t_util.t_getLastPage(containerHandle2);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
            if (!page2.spaceForInsert()) {
                this.REPORT("P054 not run, page cannot accomodate 2 rows");
                return;
            }
            RecordHandle recordHandle3 = T_Util.t_insert(page2, t_RawStoreRow2);
            transaction2 = this.t_util.t_startInternalTransaction();
            long l3 = this.t_util.t_addContainer(transaction2, 0L);
            ContainerHandle containerHandle3 = this.t_util.t_openContainer(transaction2, 0L, l3, true);
            Page page3 = this.t_util.t_addPage(containerHandle3);
            RecordHandle recordHandle4 = T_Util.t_insert(page3, t_RawStoreRow);
            try {
                T_Util.t_insertAtSlot(page3, 100, t_RawStoreRow);
            }
            catch (StandardException standardException) {
                this.REPORT("cleanup on error");
                contextManager2.cleanupOnError((Throwable)standardException, false);
                this.REPORT("done cleanup on error");
            }
            transaction2 = null;
            containerHandle2 = this.t_util.t_openContainer(transaction, 0L, l2, true);
            this.t_util.t_checkFetch(containerHandle2, recordHandle2, REC_001);
            page2 = this.t_util.t_getPage(containerHandle2, recordHandle3.getPageNumber());
            if (page2.recordExists(recordHandle3, false)) {
                throw T_Fail.testFailMsg("expect user transaction to rollback");
            }
            ContainerKey containerKey = new ContainerKey(0L, l3);
            containerHandle3 = transaction.openContainer(containerKey, 8);
            if (containerHandle3 != null) {
                throw T_Fail.testFailMsg("expect internal transaction to rollback");
            }
            LockingPolicy lockingPolicy = transaction.newLockingPolicy(0, 0, false);
            RawContainerHandle rawContainerHandle = ((RawTransaction)transaction).openDroppedContainer(containerKey, lockingPolicy);
            if (rawContainerHandle == null) {
                throw T_Fail.testFailMsg("expect container to be dropped");
            }
            if (rawContainerHandle.getContainerStatus() != 4) {
                throw T_Fail.testFailMsg("expect container to be committed dropped");
            }
            page3 = rawContainerHandle.getPage(recordHandle4.getPageNumber());
            if (page3 != null) {
                throw T_Fail.testFailMsg("should not getpage with committed dropped container");
            }
            this.PASS("P054");
            this.t_util.t_dropContainer(transaction, 0L, l2);
            this.t_util.t_dropContainer(transaction, 0L, l);
            if (transaction2 != null) {
                this.t_util.t_abort(transaction2);
                transaction2.close();
            }
            if (transaction != null) {
                this.t_util.t_commit(transaction);
                transaction.close();
            }
        }
        finally {
            contextService.resetCurrentContextManager(contextManager2);
        }
    }

    protected void P055(long l) throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        int n = 90;
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(10);
        t_RawStoreRow.setColumn(0, n, REC_001);
        t_RawStoreRow.setColumn(1, n, REC_002);
        t_RawStoreRow.setColumn(2, n, REC_003);
        t_RawStoreRow.setColumn(3, n, REC_004);
        t_RawStoreRow.setColumn(4, n, REC_005);
        t_RawStoreRow.setColumn(5, n, REC_009);
        t_RawStoreRow.setColumn(6, n, REC_010);
        t_RawStoreRow.setColumn(7, n, REC_011);
        t_RawStoreRow.setColumn(8, n, REC_012);
        t_RawStoreRow.setColumn(9, n, REC_013);
        int n2 = 0;
        n2 |= 8;
        RecordHandle recordHandle = null;
        try {
            recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n2);
        }
        catch (StandardException standardException) {
            throw T_Fail.testFailMsg("insert of long row failed.");
        }
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        this.REPORT("about to check fetch...");
        Object object = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)object, false, REC_001, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)object, false, REC_002, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)object, false, REC_003, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)object, false, REC_004, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)object, false, REC_005, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)object, false, REC_009, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)object, false, REC_010, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)object, false, REC_011, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)object, false, REC_012, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)object, false, REC_013, n);
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        object = new T_RawStoreRow(10);
        for (int i = 0; i < 10; ++i) {
            ((T_RawStoreRow)object).setColumn(i, (String)null);
        }
        ((T_RawStoreRow)object).setColumn(5, n * 2, REC_009);
        FormatableBitSet formatableBitSet = new FormatableBitSet(10);
        formatableBitSet.set(5);
        page.updateAtSlot(0, (Object[])((T_RawStoreRow)object).getRow(), formatableBitSet);
        this.REPORT("about to check fetch after update ...");
        SQLChar sQLChar = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, REC_001, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_002, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, false, REC_003, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)sQLChar, false, REC_004, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)sQLChar, false, REC_005, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)sQLChar, false, REC_009, n * 2);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)sQLChar, false, REC_010, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)sQLChar, false, REC_011, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)sQLChar, false, REC_012, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)sQLChar, false, REC_013, n);
        page.unlatch();
        this.t_util.t_abort(transaction);
        this.REPORT("about to check fetch after abort ...");
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, false);
        page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, REC_001, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_002, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, false, REC_003, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)sQLChar, false, REC_004, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)sQLChar, false, REC_005, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)sQLChar, false, REC_009, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)sQLChar, false, REC_010, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)sQLChar, false, REC_011, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)sQLChar, false, REC_012, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)sQLChar, false, REC_013, n);
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P055: segment = " + l);
    }

    protected void P056(long l) throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        int n = 90;
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(15);
        t_RawStoreRow.setColumn(0, n, REC_001);
        t_RawStoreRow.setColumn(1, n, REC_002);
        t_RawStoreRow.setColumn(2, n, REC_003);
        t_RawStoreRow.setColumn(3, n, REC_004);
        t_RawStoreRow.setColumn(4, n, REC_005);
        t_RawStoreRow.setColumn(5, n, REC_009);
        t_RawStoreRow.setColumn(6, n, REC_010);
        t_RawStoreRow.setColumn(7, n, REC_011);
        t_RawStoreRow.setColumn(8, n, REC_012);
        t_RawStoreRow.setColumn(9, n, REC_013);
        t_RawStoreRow.setColumn(10, n, REC_014);
        t_RawStoreRow.setColumn(11, n, REC_015);
        t_RawStoreRow.setColumn(12, n, REC_016);
        t_RawStoreRow.setColumn(13, n, REC_017);
        t_RawStoreRow.setColumn(14, n, REC_018);
        int n2 = 0;
        n2 |= 8;
        RecordHandle recordHandle = null;
        try {
            recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n2);
        }
        catch (StandardException standardException) {
            throw T_Fail.testFailMsg("insert of long row failed.");
        }
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        this.REPORT("about to check fetch...");
        Object object = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)object, false, REC_001, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)object, false, REC_002, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)object, false, REC_003, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)object, false, REC_004, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)object, false, REC_005, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)object, false, REC_009, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)object, false, REC_010, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)object, false, REC_011, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)object, false, REC_012, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)object, false, REC_013, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 10, (DataValueDescriptor)object, false, REC_014, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 11, (DataValueDescriptor)object, false, REC_015, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 12, (DataValueDescriptor)object, false, REC_016, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 13, (DataValueDescriptor)object, false, REC_017, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 14, (DataValueDescriptor)object, false, REC_018, n);
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        object = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            ((T_RawStoreRow)object).setColumn(i, (String)null);
        }
        ((T_RawStoreRow)object).setColumn(5, n * 2, REC_009);
        FormatableBitSet formatableBitSet = new FormatableBitSet(15);
        formatableBitSet.set(5);
        page.updateAtSlot(0, (Object[])((T_RawStoreRow)object).getRow(), formatableBitSet);
        this.REPORT("about to check fetch after update ...");
        SQLChar sQLChar = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, REC_001, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_002, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, false, REC_003, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)sQLChar, false, REC_004, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)sQLChar, false, REC_005, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)sQLChar, false, REC_009, n * 2);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)sQLChar, false, REC_010, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)sQLChar, false, REC_011, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)sQLChar, false, REC_012, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)sQLChar, false, REC_013, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 10, (DataValueDescriptor)sQLChar, false, REC_014, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 11, (DataValueDescriptor)sQLChar, false, REC_015, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 12, (DataValueDescriptor)sQLChar, false, REC_016, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 13, (DataValueDescriptor)sQLChar, false, REC_017, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 14, (DataValueDescriptor)sQLChar, false, REC_018, n);
        page.unlatch();
        this.t_util.t_abort(transaction);
        this.REPORT("about to check fetch after abort ...");
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, false);
        page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)sQLChar, false, REC_001, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)sQLChar, false, REC_002, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)sQLChar, false, REC_003, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)sQLChar, false, REC_004, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)sQLChar, false, REC_005, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)sQLChar, false, REC_009, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)sQLChar, false, REC_010, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)sQLChar, false, REC_011, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)sQLChar, false, REC_012, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)sQLChar, false, REC_013, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 10, (DataValueDescriptor)sQLChar, false, REC_014, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 11, (DataValueDescriptor)sQLChar, false, REC_015, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 12, (DataValueDescriptor)sQLChar, false, REC_016, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 13, (DataValueDescriptor)sQLChar, false, REC_017, n);
        T_Util.t_checkFetchColFromSlot(page, 0, 14, (DataValueDescriptor)sQLChar, false, REC_018, n);
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P056: segment = " + l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P061() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l);
        int n = 6;
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n);
        t_RawStoreRow.setColumn(0, (String)null);
        t_RawStoreRow.setColumn(1, REC_001);
        t_RawStoreRow.setColumn(2, (String)null);
        t_RawStoreRow.setColumn(3, REC_002);
        t_RawStoreRow.setColumn(4, (String)null);
        t_RawStoreRow.setColumn(5, REC_003);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
            T_Util.t_checkFetchCol(page, recordHandle, 1, n, REC_001);
            T_Util.t_checkFetchCol(page, recordHandle, 3, n, REC_002);
            T_Util.t_checkFetchCol(page, recordHandle, 5, n, REC_003);
            this.t_util.t_checkUpdateCol(page, recordHandle, 1, n, "woody");
            this.t_util.t_checkUpdateCol(page, recordHandle, 3, n, "buzz");
            this.t_util.t_checkUpdateCol(page, recordHandle, 5, n, "andy");
            this.t_util.t_checkUpdateCol(page, recordHandle, 2, n, "dino");
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P061");
    }

    protected void P071() throws StandardException, T_Fail {
        this.PASS("P071");
    }

    protected void P701(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(0);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)8);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        page.unlatch();
        page = this.t_util.t_getPage(containerHandle, 1L);
        for (int i = 0; i < 10; ++i) {
            int n;
            this.REPORT("P701 - iteration " + i);
            t_RawStoreRow = new T_RawStoreRow(i);
            for (n = 0; n < i; ++n) {
                t_RawStoreRow.setColumn(n, 256, "XX" + n + "YY");
            }
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), null);
            page.unlatch();
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        }
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P701: segment = " + l);
    }

    protected void P702(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(0);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)8);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        page.unlatch();
        page = this.t_util.t_getPage(containerHandle, 1L);
        for (int i = 0; i < 10; ++i) {
            this.REPORT("P702 - iteration " + i);
            FormatableBitSet formatableBitSet = new FormatableBitSet(i + 1);
            formatableBitSet.set(i);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(i + 1);
            t_RawStoreRow2.setColumn(i, 256, "XX" + i + "YY");
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow2.getRow(), formatableBitSet);
            page.unlatch();
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(i + 1);
            for (int j = 0; j <= i; ++j) {
                t_RawStoreRow3.setColumn(j, 256, "XX" + j + "YY");
            }
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow3);
        }
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P702: segment = " + l);
    }

    protected void P703(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        this.REPORT("P703 - start ");
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(2);
        t_RawStoreRow.setColumn(0, REC_001);
        t_RawStoreRow.setColumn(1, REC_002);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)8);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        this.REPORT("P703 - insert Ok ");
        page.unlatch();
        page = this.t_util.t_getPage(containerHandle, 1L);
        this.P703Helper(page, recordHandle, 0, REC_006, REC_002);
        this.REPORT("P703 - case 1 passed");
        this.P703Helper(page, recordHandle, 1, REC_007, REC_006);
        this.REPORT("P703 - case 2 passed");
        this.P703Helper(page, recordHandle, 0, REC_003, REC_007);
        this.REPORT("P703 - case 3 passed");
        this.P703Helper(page, recordHandle, 1, REC_004, REC_003);
        this.REPORT("P703 - case 4 passed");
        this.P703Helper(page, recordHandle, 0, null, REC_004);
        this.REPORT("P703 - case 5 passed");
        this.P703Helper(page, recordHandle, 1, null, null);
        this.REPORT("P703 - case 6 passed");
        this.P703Helper(page, recordHandle, 0, REC_002, null);
        this.REPORT("P703 - case 7 passed");
        this.P703Helper(page, recordHandle, 1, REC_001, REC_002);
        this.REPORT("P703 - case 8 passed");
        this.P703Helper(page, recordHandle, -1, REC_002, REC_001);
        this.REPORT("P703 - case 9 passed");
        FormatableBitSet formatableBitSet = new FormatableBitSet(2);
        formatableBitSet.set(0);
        formatableBitSet.set(1);
        t_RawStoreRow.setColumn(0, REC_004);
        t_RawStoreRow.setColumn(1, REC_003);
        int n = page.getSlotNumber(recordHandle);
        page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), formatableBitSet);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        this.REPORT("P703 - case 10 passed");
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        transaction.commit();
        transaction.close();
        this.PASS("P703: segment = " + l);
    }

    private void P703Helper(Page page, RecordHandle recordHandle, int n, String string, String string2) throws StandardException, T_Fail {
        FormatableBitSet formatableBitSet = new FormatableBitSet(2);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(2);
        if (n != -1) {
            formatableBitSet.grow(n + 1);
            formatableBitSet.set(n);
            t_RawStoreRow.setColumn(n, string);
        } else {
            n = 0;
        }
        int n2 = page.getSlotNumber(recordHandle);
        page.updateAtSlot(n2, (Object[])t_RawStoreRow.getRow(), formatableBitSet);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(2);
        t_RawStoreRow2.setColumn(n, string);
        t_RawStoreRow2.setColumn(n == 0 ? 1 : 0, string2);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
    }

    protected void P704(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            t_RawStoreRow.setColumn(i, 100, "XX" + i + "YY");
        }
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)8);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        page.unlatch();
        page = this.t_util.t_getPage(containerHandle, 1L);
        for (int i = 0; i < 15; ++i) {
            this.REPORT("P704 - col " + i);
            FormatableBitSet formatableBitSet = new FormatableBitSet(i + 1);
            formatableBitSet.set(i);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(i + 1);
            t_RawStoreRow2.setColumn(i, 400, "WW" + i + "UU");
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow2.getRow(), formatableBitSet);
            page.unlatch();
            t_RawStoreRow.setColumn(i, 400, "WW" + i + "UU");
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        }
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P704: segment = " + l);
    }

    protected void P705(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            t_RawStoreRow.setColumn(i, 100, "XX" + i + "YY");
        }
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)8);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        page.unlatch();
        page = this.t_util.t_getPage(containerHandle, 1L);
        for (int i = 14; i >= 0; --i) {
            this.REPORT("P705 - col " + i);
            FormatableBitSet formatableBitSet = new FormatableBitSet(i + 1);
            formatableBitSet.set(i);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(i + 1);
            t_RawStoreRow2.setColumn(i, 400, "WW" + i + "UU");
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow2.getRow(), formatableBitSet);
            page.unlatch();
            t_RawStoreRow.setColumn(i, 400, "WW" + i + "UU");
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        }
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P705: segment = " + l);
    }

    protected void P706(long l, boolean bl) throws StandardException, T_Fail {
        int n;
        T_RawStoreRow t_RawStoreRow;
        FormatableBitSet formatableBitSet;
        int n2;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            t_RawStoreRow2.setColumn(i, bl ? 100 : 10, "XX" + i + "YY");
        }
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)8);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
        page.unlatch();
        page = this.t_util.t_getPage(containerHandle, 1L);
        for (n2 = 0; n2 < 15; ++n2) {
            if (n2 % 2 == 0) continue;
            this.REPORT("P706 : multiPortion " + bl + " - col " + n2);
            formatableBitSet = new FormatableBitSet(n2 + 1);
            formatableBitSet.set(n2);
            t_RawStoreRow = new T_RawStoreRow(n2 + 1);
            t_RawStoreRow.setColumn(n2, 3000, "WW" + n2 + "UU");
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), formatableBitSet);
            page.unlatch();
            t_RawStoreRow2.setColumn(n2, 3000, "WW" + n2 + "UU");
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        for (n2 = 0; n2 < 15; ++n2) {
            this.REPORT("P706 : update to null " + bl + " - col " + n2);
            formatableBitSet = new FormatableBitSet(n2 + 1);
            formatableBitSet.set(n2);
            t_RawStoreRow = new T_RawStoreRow(n2 + 1);
            t_RawStoreRow.setColumn(n2, (String)null);
            n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), formatableBitSet);
            page.unlatch();
            t_RawStoreRow2.setColumn(n2, (String)null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow2);
        }
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P706: multiPortion " + bl + " segment = " + l);
    }

    protected void P707(long l) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(20);
        for (int i = 0; i < 20; ++i) {
            if (i % 2 == 0) {
                t_RawStoreRow.setColumn(i, 200, "XX" + i + "YY");
                continue;
            }
            t_RawStoreRow.setColumn(i, 4000, "XX" + i + "YY");
        }
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)8);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P707: segment = " + l);
    }

    protected void P708(long l, boolean bl) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            t_RawStoreRow.setColumn(i, bl ? 100 : 10, "XX" + i + "YY");
        }
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)8);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        page.unlatch();
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        for (int i = 0; i < 15; ++i) {
            if (i % 2 == 0) continue;
            this.REPORT("P708 : multiPortion " + bl + " - col " + i);
            FormatableBitSet formatableBitSet = new FormatableBitSet(i + 1);
            formatableBitSet.set(i);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(i + 1);
            t_RawStoreRow2.setColumn(i, 3000, "WW" + i + "UU");
            int n = page.getSlotNumber(recordHandle);
            page.updateAtSlot(n, (Object[])t_RawStoreRow2.getRow(), formatableBitSet);
        }
        this.t_util.t_abort(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, l, l2, false);
        page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        page.unlatch();
        if (l != -1L) {
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("P708: multiPortion " + bl + " segment = " + l);
    }

    protected void P709() throws StandardException, T_Fail {
        this.logDataForPurges = false;
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, 0L);
        this.t_util.t_commit(transaction);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_001);
        T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_002);
        T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_003);
        T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_004);
        RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow);
        RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 1, t_RawStoreRow2);
        RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 2, t_RawStoreRow3);
        RecordHandle recordHandle4 = T_Util.t_insertAtSlot(page, 3, t_RawStoreRow4);
        RecordHandle recordHandle5 = T_Util.t_insertAtSlot(page, 4, t_RawStoreRow5);
        if (recordHandle4 != null) {
            page.deleteAtSlot(3, true, (LogicalUndo)null);
        }
        this.t_util.t_commit(transaction);
        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
        page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            page.purgeAtSlot(-1, 1, this.logDataForPurges);
            throw T_Fail.testFailMsg("negative slot number did not cause an exception");
        }
        catch (StandardException standardException) {
            try {
                page.purgeAtSlot(4, 4, this.logDataForPurges);
                throw T_Fail.testFailMsg("purging more rows than is on page did not cause an exception");
            }
            catch (StandardException standardException2) {
                if (recordHandle5 == null) {
                    int n = page.recordCount();
                    page.purgeAtSlot(0, 1, this.logDataForPurges);
                    if (page.recordCount() != n - 1) {
                        T_Fail.testFailMsg("failed to purge a record, expect " + (n - 1) + " got " + page.recordCount());
                    }
                    if (testRollback) {
                        this.t_util.t_abort(transaction);
                        containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                        page = this.t_util.t_getPage(containerHandle, 1L);
                        if (this.logDataForPurges) {
                            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        } else {
                            T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        }
                        if (page.recordCount() != n) {
                            T_Fail.testFailMsg("failed to rollback purge, expect " + n + " got " + page.recordCount());
                        }
                    } else {
                        this.t_util.t_commit(transaction);
                    }
                    this.PASS("mimimal purging P709");
                    return;
                }
                page.purgeAtSlot(1, 2, this.logDataForPurges);
                T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_003, true, true);
                T_Util.t_checkFetchBySlot(page, 2, REC_004, false, true);
                if (page.recordCount() != 3) {
                    T_Fail.testFailMsg("page expect to have 3 records, recordCount() = " + page.recordCount());
                }
                page.purgeAtSlot(0, 3, this.logDataForPurges);
                if (page.recordCount() != 0) {
                    T_Fail.testFailMsg("page expect to have 0 records, recordCount() = " + page.recordCount());
                }
                if (testRollback) {
                    this.REPORT("testing rollback");
                    this.t_util.t_abort(transaction);
                    containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                    page = this.t_util.t_getPage(containerHandle, 1L);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_002, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_004, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_NULL, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 5) {
                        T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                    }
                    page.purgeAtSlot(2, 3, this.logDataForPurges);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 2) {
                        T_Fail.testFailMsg("page expect to have 2 records, recordCount() = " + page.recordCount());
                    }
                    this.t_util.t_abort(transaction);
                    containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                    page = this.t_util.t_getPage(containerHandle, 1L);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_002, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_004, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_NULL, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 5) {
                        T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                    }
                    if (page.isDeletedAtSlot(1)) {
                        T_Fail.testFailMsg("rolled back purged undeleted record cause record to be deleted");
                    }
                    if (!page.isDeletedAtSlot(3)) {
                        T_Fail.testFailMsg("rolled back purged deleted record cause record to be undeleted");
                    }
                }
                this.REPORT("purging again the purges rolled back earlier");
                page.purgeAtSlot(1, 2, this.logDataForPurges);
                T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_NULL, true, true);
                T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                if (page.recordCount() != 3) {
                    T_Fail.testFailMsg("page expect to have 3 records, recordCount() = " + page.recordCount());
                }
                page.purgeAtSlot(0, 3, this.logDataForPurges);
                if (page.recordCount() != 0) {
                    T_Fail.testFailMsg("page expect to have 0 records, recordCount() = " + page.recordCount());
                }
                this.t_util.t_abort(transaction);
                containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                page = this.t_util.t_getPage(containerHandle, 1L);
                if (page.recordCount() != 5) {
                    T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                }
                page.purgeAtSlot(2, 3, this.logDataForPurges);
                T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                if (page.recordCount() != 2) {
                    T_Fail.testFailMsg("page expect to have 2 records, recordCount() = " + page.recordCount());
                }
                this.t_util.t_commit(transaction);
                containerHandle = this.t_util.t_openContainer(transaction, 0L, l, true);
                page = this.t_util.t_getPage(containerHandle, 1L);
                T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                if (page.recordCount() != 2) {
                    T_Fail.testFailMsg("page expect to have 2 records, recordCount() = " + page.recordCount());
                }
                this.PASS("P709");
                this.t_util.t_dropContainer(transaction, 0L, l);
                this.t_util.t_commit(transaction);
                transaction.close();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P710() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(100);
            for (int i = 0; i < 100; ++i) {
                t_RawStoreRow.setColumn(i, 100 + i, REC_001);
            }
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.REPORT("P710 - Nextpage is " + l3);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow);
            page.unlatch();
            page = null;
            page2 = this.t_util.t_addPage(containerHandle);
            long l4 = page2.getPageNumber();
            page2.unlatch();
            if (l3 != l4) {
                throw T_Fail.testFailMsg("fail to reuse row pieces expect next page=" + l3 + " but got " + l4);
            }
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            transaction.setSavePoint(SP1, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            page.unlatch();
            page = null;
            Page page3 = this.t_util.t_addPage(containerHandle);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_001);
            T_Util.t_insert(page3, t_RawStoreRow2);
            page3.unlatch();
            transaction.rollbackToSavePoint(SP1, null);
            page3 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page3, t_RawStoreRow2);
            page3.unlatch();
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page3 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page3, t_RawStoreRow2);
            page3.unlatch();
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            this.t_util.t_abort(transaction);
            page = null;
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            page.unlatch();
            page = null;
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 0, 0);
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P710");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P711() throws StandardException, T_Fail {
        long l = 0L;
        Transaction transaction = this.t_util.t_startTransaction();
        long l2 = this.t_util.t_addContainer(transaction, l, 4096);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int n = 8;
            T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(1);
            t_RawStoreRow.setColumn(0, 5000, REC_001);
            RecordHandle recordHandle = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(6);
            t_RawStoreRow2.setColumn(0, 600, REC_001);
            t_RawStoreRow2.setColumn(1, 5000, REC_002);
            t_RawStoreRow2.setColumn(2, 600, REC_001);
            t_RawStoreRow2.setColumn(3, 5000, REC_002);
            t_RawStoreRow2.setColumn(4, 600, REC_001);
            t_RawStoreRow2.setColumn(5, 5000, REC_002);
            RecordHandle recordHandle2 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow2, (byte)n);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow2);
            RecordHandle recordHandle3 = T_Util.t_insertAtSlot(page, 0, t_RawStoreRow, (byte)n);
            if (recordHandle3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            Page page2 = this.t_util.t_addPage(containerHandle);
            long l3 = page2.getPageNumber();
            this.t_util.t_removePage(containerHandle, page2);
            this.REPORT("P711 - Nextpage is " + l3);
            this.t_util.t_commit(transaction);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_abort(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            transaction.setSavePoint(SP1, null);
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            Page page3 = this.t_util.t_addPage(containerHandle);
            T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_001);
            T_Util.t_insert(page3, t_RawStoreRow3);
            page3.unlatch();
            transaction.rollbackToSavePoint(SP1, null);
            page3 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page3, t_RawStoreRow3);
            page3.unlatch();
            this.t_util.t_commit(transaction);
            T_Util.t_wait(10);
            containerHandle = this.t_util.t_openContainer(transaction, l, l2, true);
            page3 = this.t_util.t_addPage(containerHandle);
            T_Util.t_insert(page3, t_RawStoreRow3);
            page3.unlatch();
            page = this.t_util.t_getPage(containerHandle, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
            T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(6);
            t_RawStoreRow4.setColumn(0, 4, REC_NULL);
            t_RawStoreRow4.setColumn(1, 5000, REC_002);
            t_RawStoreRow4.setColumn(2, 4, REC_NULL);
            t_RawStoreRow4.setColumn(3, 5000, REC_002);
            t_RawStoreRow4.setColumn(4, 4, REC_NULL);
            t_RawStoreRow4.setColumn(5, 5000, REC_002);
            T_Util.t_checkFetch(page, recordHandle2, t_RawStoreRow4);
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(transaction, l, l2);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(transaction);
            transaction.close();
        }
        this.PASS("P711");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void L001() throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        int n = 10;
        int n2 = this.threadNumber == 0 ? 50000 : 50;
        try {
            T_Undoable t_Undoable;
            int n3;
            for (n3 = 0; n3 < n; ++n3) {
                t_Undoable = new T_Undoable(transaction.getGlobalId(), -1, -1, 0, 0, true, 10, false, n3 * n2, false);
                transaction.logAndDo((Loggable)t_Undoable);
            }
            transaction.commit();
            transaction.close();
            transaction = null;
            transaction = this.t_util.t_startTransaction();
            for (n3 = 0; n3 < n; ++n3) {
                t_Undoable = new T_Undoable(transaction.getGlobalId(), -1, -1, 0, 0, true, 10, false, n3 * n2, false);
                transaction.logAndDo((Loggable)t_Undoable);
            }
            this.PASS("L001");
        }
        finally {
            transaction.commit();
            transaction.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CP001() throws StandardException, T_Fail {
        Transaction transaction;
        ContextManager contextManager;
        Transaction transaction2;
        ContextManager contextManager2;
        block13: {
            if (!testRollback) {
                return;
            }
            contextManager2 = contextService.getCurrentContextManager();
            transaction2 = null;
            contextManager = null;
            transaction = null;
            ContextManager contextManager3 = null;
            Transaction transaction3 = null;
            try {
                T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001);
                T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(REC_002);
                T_RawStoreRow t_RawStoreRow3 = new T_RawStoreRow(REC_003);
                T_RawStoreRow t_RawStoreRow4 = new T_RawStoreRow(REC_004);
                T_RawStoreRow t_RawStoreRow5 = new T_RawStoreRow(REC_005);
                transaction2 = this.t_util.t_startTransaction();
                long l = this.t_util.t_addContainer(transaction2, 0L);
                ContainerHandle containerHandle = this.t_util.t_openContainer(transaction2, 0L, l, true);
                RecordHandle recordHandle = this.t_util.t_insert(containerHandle, t_RawStoreRow);
                RecordHandle recordHandle2 = this.t_util.t_insert(containerHandle, t_RawStoreRow2);
                this.t_util.t_commit(transaction2);
                containerHandle = this.t_util.t_openContainer(transaction2, 0L, l, true);
                Page page = this.t_util.t_getPage(containerHandle, recordHandle2.getPageNumber());
                int n = page.getSlotNumber(recordHandle2);
                page.updateAtSlot(n, (Object[])t_RawStoreRow5.getRow(), null);
                page.unlatch();
                contextManager = contextService.newContextManager();
                contextService.setCurrentContextManager(contextManager);
                transaction = this.t_util.t_startTransaction();
                long l2 = this.t_util.t_addContainer(transaction, 0L);
                ContainerHandle containerHandle2 = this.t_util.t_openContainer(transaction, 0L, l2, true);
                RecordHandle recordHandle3 = this.t_util.t_insert(containerHandle2, t_RawStoreRow3);
                RecordHandle recordHandle4 = this.t_util.t_insert(containerHandle2, t_RawStoreRow4);
                contextService.resetCurrentContextManager(contextManager);
                contextManager3 = contextService.newContextManager();
                contextService.setCurrentContextManager(contextManager3);
                transaction3 = this.t_util.t_startTransaction();
                long l3 = this.t_util.t_addContainer(transaction3, 0L);
                ContainerHandle containerHandle3 = this.t_util.t_openContainer(transaction3, 0L, l3, true);
                RecordHandle recordHandle5 = this.t_util.t_insert(containerHandle3, t_RawStoreRow);
                this.t_util.t_commit(transaction3);
                containerHandle3 = this.t_util.t_openContainer(transaction3, 0L, l3, true);
                Page page2 = this.t_util.t_getPage(containerHandle3, recordHandle5.getPageNumber());
                int n2 = page2.getSlotNumber(recordHandle5);
                page2.updateAtSlot(n2, (Object[])t_RawStoreRow5.getRow(), null);
                page2.unlatch();
                factory.checkpoint();
                contextService.resetCurrentContextManager(contextManager3);
                contextService.setCurrentContextManager(contextManager2);
                this.t_util.t_checkFetch(containerHandle, recordHandle, REC_001);
                this.t_util.t_checkFetch(containerHandle, recordHandle2, REC_005);
                contextService.resetCurrentContextManager(contextManager2);
                contextService.setCurrentContextManager(contextManager);
                this.t_util.t_checkFetch(containerHandle2, recordHandle3, REC_003);
                this.t_util.t_checkFetch(containerHandle2, recordHandle4, REC_004);
                contextService.resetCurrentContextManager(contextManager);
                contextService.setCurrentContextManager(contextManager3);
                this.t_util.t_checkFetch(containerHandle3, recordHandle5, REC_005);
                factory.checkpoint();
                contextService.resetCurrentContextManager(contextManager3);
                contextService.setCurrentContextManager(contextManager2);
                Page page3 = this.t_util.t_addPage(containerHandle);
                RecordHandle recordHandle6 = T_Util.t_insertAtSlot(page3, 0, t_RawStoreRow, (byte)2);
                page3.unlatch();
                contextService.resetCurrentContextManager(contextManager2);
                contextService.setCurrentContextManager(contextManager);
                this.t_util.t_commit(transaction);
                contextService.resetCurrentContextManager(contextManager);
                contextService.setCurrentContextManager(contextManager3);
                this.t_util.t_abort(transaction3);
                contextService.resetCurrentContextManager(contextManager3);
                contextService.setCurrentContextManager(contextManager2);
                this.t_util.t_checkFetch(containerHandle, recordHandle, REC_001);
                this.t_util.t_checkFetch(containerHandle, recordHandle2, REC_005);
                this.t_util.t_checkFetch(containerHandle, recordHandle6, REC_001);
                contextService.resetCurrentContextManager(contextManager2);
                contextService.setCurrentContextManager(contextManager);
                containerHandle2 = this.t_util.t_openContainer(transaction, 0L, l2, true);
                this.t_util.t_checkFetch(containerHandle2, recordHandle3, REC_003);
                this.t_util.t_checkFetch(containerHandle2, recordHandle4, REC_004);
                contextService.resetCurrentContextManager(contextManager);
                contextService.setCurrentContextManager(contextManager3);
                containerHandle3 = this.t_util.t_openContainer(transaction3, 0L, l3, true);
                this.t_util.t_checkFetch(containerHandle3, recordHandle5, REC_001);
                factory.checkpoint();
                contextService.resetCurrentContextManager(contextManager3);
                contextService.setCurrentContextManager(contextManager2);
                this.t_util.t_abort(transaction2);
                containerHandle = this.t_util.t_openContainer(transaction2, 0L, l, true);
                this.t_util.t_checkFetch(containerHandle, recordHandle, REC_001);
                this.t_util.t_checkFetch(containerHandle, recordHandle2, REC_002);
                Page page4 = this.t_util.t_getPage(containerHandle, recordHandle6.getPageNumber());
                T_Util.t_checkEmptyPage(page4);
                page4.unlatch();
                this.t_util.t_dropContainer(transaction2, 0L, l);
                contextService.resetCurrentContextManager(contextManager2);
                contextService.setCurrentContextManager(contextManager);
                this.t_util.t_checkFetch(containerHandle2, recordHandle3, REC_003);
                this.t_util.t_checkFetch(containerHandle2, recordHandle4, REC_004);
                this.t_util.t_dropContainer(transaction, 0L, l2);
                contextService.resetCurrentContextManager(contextManager);
                contextService.setCurrentContextManager(contextManager3);
                this.t_util.t_checkFetch(containerHandle3, recordHandle5, REC_001);
                this.t_util.t_dropContainer(transaction3, 0L, l3);
                factory.checkpoint();
                contextService.resetCurrentContextManager(contextManager3);
                this.PASS("CP001");
                if (transaction3 == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    throwable.printStackTrace(System.err);
                    if (contextManager != null) {
                        contextManager.cleanupOnError(throwable, false);
                    }
                    if (contextManager3 != null) {
                        contextManager3.cleanupOnError(throwable, false);
                    }
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (transaction3 != null) {
                        contextService.setCurrentContextManager(contextManager3);
                        this.t_util.t_commit(transaction3);
                        transaction3.close();
                        contextService.resetCurrentContextManager(contextManager3);
                    }
                    if (transaction != null) {
                        contextService.setCurrentContextManager(contextManager);
                        this.t_util.t_commit(transaction);
                        transaction.close();
                        contextService.resetCurrentContextManager(contextManager);
                    }
                    if (transaction2 != null) {
                        contextService.setCurrentContextManager(contextManager2);
                        this.t_util.t_commit(transaction2);
                        transaction2.close();
                        contextService.resetCurrentContextManager(contextManager2);
                    }
                }
            }
            contextService.setCurrentContextManager(contextManager3);
            this.t_util.t_commit(transaction3);
            transaction3.close();
            contextService.resetCurrentContextManager(contextManager3);
        }
        if (transaction != null) {
            contextService.setCurrentContextManager(contextManager);
            this.t_util.t_commit(transaction);
            transaction.close();
            contextService.resetCurrentContextManager(contextManager);
        }
        if (transaction2 != null) {
            contextService.setCurrentContextManager(contextManager2);
            this.t_util.t_commit(transaction2);
            transaction2.close();
            contextService.resetCurrentContextManager(contextManager2);
        }
    }

    protected void TC001() throws T_Fail, StandardException {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, -1L);
        this.t_util.setOpenMode(this.openMode | 0x20);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, -1L, l, true);
        this.t_util.t_commit(transaction);
        ContainerKey containerKey = new ContainerKey(-1L, l);
        containerHandle = transaction.openContainer(containerKey, 8);
        if (containerHandle != null) {
            throw T_Fail.testFailMsg("Temp Container should not exist");
        }
        l = this.t_util.t_addContainer(transaction, -1L);
        containerHandle = this.t_util.t_openContainer(transaction, -1L, l, true);
        containerHandle.close();
        containerHandle = this.t_util.t_openContainer(transaction, -1L, l, true);
        containerHandle.close();
        this.t_util.t_commit(transaction);
        containerKey = new ContainerKey(-1L, l);
        containerHandle = transaction.openContainer(containerKey, 8);
        if (containerHandle != null) {
            throw T_Fail.testFailMsg("Temp Container should not exist");
        }
        l = this.t_util.t_addContainer(transaction, -1L);
        this.t_util.setOpenMode(this.openMode | 0x20);
        containerHandle = this.t_util.t_openContainer(transaction, -1L, l, true);
        this.t_util.t_abort(transaction);
        containerKey = new ContainerKey(-1L, l);
        containerHandle = transaction.openContainer(containerKey, 8);
        if (containerHandle != null) {
            throw T_Fail.testFailMsg("Temp Container should not exist");
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("TC001");
    }

    private int[] populateTempTable(ContainerHandle containerHandle) throws StandardException, T_Fail {
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        int[] nArray = new int[]{0, 0, 0};
        int n = 0;
        while (n < 3) {
            while (true) {
                T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(REC_001 + n + "X" + nArray[n]);
                RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
                if (recordHandle == null) break;
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
                T_Util.t_checkRecordCount(page, nArray[n], nArray[n]);
            }
            page.unlatch();
            page = null;
            if (++n >= 3) continue;
            page = this.t_util.t_addPage(containerHandle);
            T_Util.t_checkEmptyPage(page);
        }
        return nArray;
    }

    protected void TC002(int n, boolean bl) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, -1L);
        this.REPORT("TC002 container id = " + l);
        this.t_util.setOpenMode(this.openMode | n);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, -1L, l, true);
        int[] nArray = this.populateTempTable(containerHandle);
        for (int i = 0; i < nArray.length; ++i) {
            this.REPORT("RecordCount on page " + i + "=" + nArray[i]);
        }
        long l2 = 1L;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            Page page = this.t_util.t_getPage(containerHandle, l2);
            T_Util.t_checkRecordCount(page, nArray[n2], nArray[n2]);
            RecordHandle recordHandle = T_Util.t_checkFetchFirst(page, REC_001 + n2 + "X0");
            for (n3 = 1; n3 < nArray[n2]; ++n3) {
                recordHandle = T_Util.t_checkFetchNext(page, recordHandle, REC_001 + n2 + "X" + n3);
            }
            try {
                recordHandle = page.fetchFromSlot(null, nArray[n2], (Object[])new DataValueDescriptor[0], (FetchDescriptor)null, false);
                throw T_Fail.testFailMsg("reading more rows on page than were written");
            }
            catch (StandardException standardException) {
                recordHandle = T_Util.t_checkFetchLast(page, REC_001 + n2 + "X" + (nArray[n2] - 1));
                for (n3 = nArray[n2] - 2; n3 >= 0; --n3) {
                    recordHandle = T_Util.t_checkFetchPrevious(page, recordHandle, REC_001 + n2 + "X" + n3);
                }
                page.unlatch();
                page = null;
                ++n2;
                ++l2;
            }
        }
        containerHandle.close();
        if (bl) {
            this.t_util.t_commit(transaction);
        } else {
            this.t_util.t_abort(transaction);
        }
        this.t_util.setOpenMode(this.openMode);
        containerHandle = this.t_util.t_openContainer(transaction, -1L, l, true);
        Page page = this.t_util.t_getPage(containerHandle, 1L);
        T_Util.t_checkEmptyPage(page);
        page.unlatch();
        page = null;
        page = containerHandle.getPage(2L);
        if (page != null) {
            throw T_Fail.testFailMsg("truncate of temp container did not succeed");
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("TC002 " + n + " " + bl);
    }

    protected void TC003(int n, boolean bl) throws StandardException, T_Fail {
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, -1L);
        this.REPORT("TC003 container id = " + l);
        this.t_util.setOpenMode(this.openMode | n);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, -1L, l, true);
        this.populateTempTable(containerHandle);
        this.t_util.t_dropContainer(transaction, -1L, l);
        ContainerKey containerKey = new ContainerKey(-1L, l);
        ContainerHandle containerHandle2 = transaction.openContainer(containerKey, 8);
        if (containerHandle2 != null) {
            throw T_Fail.testFailMsg("Dropped Container should not open");
        }
        if (bl) {
            this.t_util.t_commit(transaction);
        } else {
            this.t_util.t_abort(transaction);
        }
        ContainerHandle containerHandle3 = transaction.openContainer(containerKey, 8);
        if (containerHandle3 != null) {
            throw T_Fail.testFailMsg("Dropped Container should not open");
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS("TC003 " + n + " " + bl);
    }

    protected void TC004all() throws StandardException, T_Fail {
        int[] nArray = new int[]{0, 32, 16};
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray.length; ++j) {
                for (int k = 0; k < nArray.length; ++k) {
                    this.TC004(i, j, k, false, false);
                    this.TC004(i, j, k, false, true);
                    this.TC004(i, j, k, true, false);
                    this.TC004(i, j, k, true, false);
                }
            }
        }
    }

    protected void TC004(int n, int n2, int n3, boolean bl, boolean bl2) throws StandardException, T_Fail {
        String string = "TC004 mode1 " + n + " mode2 " + n2 + " mode3 " + n3 + " doCommit " + bl + " closeThem " + bl2;
        this.REPORT("start " + string);
        Transaction transaction = this.t_util.t_startTransaction();
        long l = this.t_util.t_addContainer(transaction, -1L);
        this.REPORT("TC004 container id = " + l);
        this.t_util.setOpenMode(this.openMode | n);
        ContainerHandle containerHandle = this.t_util.t_openContainer(transaction, -1L, l, true);
        this.populateTempTable(containerHandle);
        if (bl2) {
            containerHandle.close();
        }
        this.t_util.setOpenMode(this.openMode | n2);
        ContainerHandle containerHandle2 = this.t_util.t_openContainer(transaction, -1L, l, true);
        if (bl2) {
            containerHandle2.close();
        }
        this.t_util.setOpenMode(this.openMode | n3);
        ContainerHandle containerHandle3 = this.t_util.t_openContainer(transaction, -1L, l, true);
        if (bl2) {
            containerHandle2.close();
        }
        if (bl) {
            this.t_util.t_commit(transaction);
        } else {
            this.t_util.t_abort(transaction);
        }
        int n4 = n | n2 | n3;
        if ((n4 & 0x20) == 32) {
            ContainerKey containerKey = new ContainerKey(-1L, l);
            ContainerHandle containerHandle4 = transaction.openContainer(containerKey, 8);
            if (containerHandle4 != null) {
                throw T_Fail.testFailMsg("Dropped Container should not open");
            }
        } else if (!bl || (n4 & 0x10) == 16) {
            ContainerHandle containerHandle5 = this.t_util.t_openContainer(transaction, -1L, l, true);
            Page page = this.t_util.t_getPage(containerHandle5, 1L);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
        }
        this.t_util.t_commit(transaction);
        transaction.close();
        this.PASS(string);
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object createPersistentService(String string, String string2, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)string, (String)string2, (Properties)properties);
    }
}

