/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import org.apache.derby.iapi.services.cache.CacheManager;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.services.T_CacheException;
import org.apache.derbyTesting.unitTests.services.T_CacheService;
import org.apache.derbyTesting.unitTests.services.T_Cacheable;
import org.apache.derbyTesting.unitTests.services.T_Key;

public class T_CacheUser
implements Runnable {
    protected CacheManager cm;
    protected int iterations;
    protected HeaderPrintWriter out;
    protected T_CacheService parent;

    public T_CacheUser(CacheManager cacheManager, int n, T_CacheService t_CacheService, HeaderPrintWriter headerPrintWriter) {
        this.cm = cacheManager;
        this.iterations = n;
        this.parent = t_CacheService;
        this.out = headerPrintWriter;
    }

    @Override
    public void run() {
        try {
            this.thrashCache();
        }
        catch (T_Fail t_Fail) {
            this.parent.setChildException(t_Fail);
        }
        catch (StandardException standardException) {
            this.parent.setChildException(T_Fail.exceptionFail(standardException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void thrashCache() throws StandardException, T_Fail {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        for (int i = 0; i < this.iterations; ++i) {
            T_Cacheable t_Cacheable;
            T_Key t_Key;
            block24: {
                if (i % 100 == 0) {
                    this.out.printlnWithHeader("iteration " + i);
                }
                t_Key = T_Key.randomKey();
                double d = Math.random();
                t_Cacheable = null;
                if (d < 0.5) {
                    ++n;
                    try {
                        t_Cacheable = (T_Cacheable)this.cm.find((Object)t_Key);
                        if (t_Cacheable == null) {
                            ++n3;
                            continue;
                        }
                        ++n2;
                        break block24;
                    }
                    catch (T_CacheException t_CacheException) {
                        if (t_CacheException.getType() == 0) {
                            throw t_CacheException;
                        }
                        ++n4;
                        continue;
                    }
                }
                if (d < 0.8) {
                    ++n5;
                    t_Cacheable = (T_Cacheable)this.cm.findCached((Object)t_Key);
                    if (t_Cacheable == null) {
                        ++n7;
                        continue;
                    }
                    ++n6;
                } else {
                    ++n8;
                    try {
                        t_Cacheable = (T_Cacheable)this.cm.create((Object)t_Key, (Object)Thread.currentThread());
                        if (t_Cacheable == null) {
                            ++n10;
                            continue;
                        }
                        ++n9;
                    }
                    catch (T_CacheException t_CacheException) {
                        if (t_CacheException.getType() == 0) {
                            throw t_CacheException;
                        }
                        ++n11;
                        continue;
                    }
                    catch (StandardException standardException) {
                        if (standardException.getMessageId().equals("XBCA0.S")) {
                            ++n12;
                            continue;
                        }
                        throw standardException;
                    }
                }
            }
            this.cm.release(this.parent.t_findCachedSucceed(this.cm, t_Key));
            if (Math.random() < 0.25) {
                t_Cacheable.setDirty();
            }
            if (Math.random() < 0.75) {
                Thread.yield();
            }
            if (Math.random() < 0.1 && t_Cacheable.canRemove()) {
                ++n16;
                this.cm.remove((Cacheable)t_Cacheable);
            } else {
                ++n15;
                this.cm.release((Cacheable)t_Cacheable);
            }
            t_Cacheable = null;
            double d = Math.random();
            if (d < 0.02) {
                ++n13;
                this.cm.cleanAll();
                continue;
            }
            if (!(d < 0.04)) continue;
            ++n14;
            this.cm.ageOut();
        }
        T_CacheService t_CacheService = this.parent;
        synchronized (t_CacheService) {
            this.out.printlnWithHeader("find()       calls " + n + " : found/not found/exception : " + n2 + "/" + n3 + "/" + n4);
            this.out.printlnWithHeader("findCached() calls " + n5 + " : found/not found           : " + n6 + "/" + n7);
            this.out.printlnWithHeader("create()     calls " + n8 + " : found/not found/exception/standard exception : " + n9 + "/" + n10 + "/" + n11 + "/" + n12);
            this.out.printlnWithHeader("release()    calls " + n15);
            this.out.printlnWithHeader("remove()     calls " + n16);
            this.out.printlnWithHeader("cleanAll()   calls " + n13);
            this.out.printlnWithHeader("ageOut()     calls " + n14);
        }
    }
}

