/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import junit.framework.Assert;
import junit.framework.AssertionFailedError;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBC {
    private static final int GENERATED_NAME_LENGTH = 50;
    public static final String[] GET_TABLES_TABLE;
    public static final String[] GET_TABLES_VIEW;
    public static final String[] GET_TABLES_SYNONYM;
    public static final int SQLXML = 2009;
    private static final boolean HAVE_DRIVER;
    private static final boolean HAVE_SAVEPOINT;
    private static final boolean HAVE_SQLXML;
    public static final boolean HAVE_LUCENE_CORE;
    public static final boolean HAVE_LUCENE_ANALYZERS;
    public static final boolean HAVE_LUCENE_QUERYPARSER;
    public static final boolean HAVE_JSON_SIMPLE;
    private static final boolean HAVE_AUTO_CLOSEABLE_RESULT_SET;
    private static final boolean HAVE_REFERENCEABLE;
    private static final boolean HAVE_SQLTYPE;
    private static final boolean HAVE_MBEAN_SERVER;

    static boolean haveClass(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean vmSupportsJDBC42() {
        return JDBC.vmSupportsJDBC41() && HAVE_SQLTYPE;
    }

    public static boolean vmSupportsJDBC41() {
        return JDBC.vmSupportsJDBC4() && HAVE_AUTO_CLOSEABLE_RESULT_SET;
    }

    public static boolean vmSupportsJDBC4() {
        return HAVE_DRIVER && HAVE_SQLXML;
    }

    public static boolean vmSupportsJDBC3() {
        return HAVE_DRIVER && HAVE_SAVEPOINT;
    }

    public static boolean vmSupportsJSR169() {
        return !HAVE_DRIVER && HAVE_SAVEPOINT;
    }

    public static boolean vmSupportsJNDI() {
        return HAVE_REFERENCEABLE;
    }

    public static boolean vmSupportsJMX() {
        return HAVE_MBEAN_SERVER;
    }

    public static void cleanup(Connection connection) throws SQLException {
        if (connection == null) {
            return;
        }
        if (connection.isClosed()) {
            return;
        }
        SQLException sQLException = null;
        try {
            connection.rollback();
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException3) {
            if (sQLException == null) {
                sQLException = sQLException3;
            } else {
                sQLException.setNextException(sQLException3);
            }
            throw sQLException;
        }
    }

    public static void dropSchema(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        Object object;
        Connection connection = databaseMetaData.getConnection();
        Assert.assertFalse((boolean)connection.getAutoCommit());
        Statement statement = databaseMetaData.getConnection().createStatement();
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT TRIGGERNAME FROM SYS.SYSSCHEMAS S, SYS.SYSTRIGGERS T WHERE S.SCHEMAID = T.SCHEMAID AND SCHEMANAME = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            object = resultSet.getString(1);
            statement.execute("DROP TRIGGER " + JDBC.escape(string, (String)object));
        }
        resultSet.close();
        preparedStatement.close();
        object = connection.prepareStatement("SELECT ALIAS FROM SYS.SYSALIASES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID  AND CHAR(A.ALIASTYPE) = ?  AND S.SCHEMANAME = ?");
        object.setString(1, "F");
        object.setString(2, string);
        ResultSet resultSet2 = object.executeQuery();
        JDBC.dropUsingDMD(statement, resultSet2, string, "ALIAS", "FUNCTION");
        resultSet2 = databaseMetaData.getProcedures(null, string, null);
        JDBC.dropUsingDMD(statement, resultSet2, string, "PROCEDURE_NAME", "PROCEDURE");
        resultSet2 = databaseMetaData.getTables(null, string, null, GET_TABLES_VIEW);
        JDBC.dropUsingDMD(statement, resultSet2, string, "TABLE_NAME", "VIEW");
        resultSet2 = databaseMetaData.getTables(null, string, null, GET_TABLES_TABLE);
        JDBC.dropUsingDMD(statement, resultSet2, string, "TABLE_NAME", "TABLE");
        ResultSet resultSet3 = databaseMetaData.getTables(null, string, null, GET_TABLES_TABLE);
        while (resultSet3.next()) {
            String string2 = resultSet3.getString("TABLE_NAME");
            resultSet2 = databaseMetaData.getExportedKeys(null, string, string2);
            while (resultSet2.next()) {
                String string3;
                short s = resultSet2.getShort("KEY_SEQ");
                if (s != 1 || (string3 = resultSet2.getString("FK_NAME")) == null) continue;
                String string4 = resultSet2.getString("FKTABLE_SCHEM");
                String string5 = resultSet2.getString("FKTABLE_NAME");
                String string6 = "ALTER TABLE " + JDBC.escape(string4, string5) + " DROP FOREIGN KEY " + JDBC.escape(string3);
                statement.executeUpdate(string6);
            }
            resultSet2.close();
        }
        resultSet3.close();
        connection.commit();
        resultSet2 = databaseMetaData.getTables(null, string, null, GET_TABLES_TABLE);
        JDBC.dropUsingDMD(statement, resultSet2, string, "TABLE_NAME", "TABLE");
        object.setString(1, "A");
        object.setString(2, string);
        resultSet2 = object.executeQuery();
        JDBC.dropUsingDMD(statement, resultSet2, string, "ALIAS", "TYPE");
        object.setString(1, "G");
        object.setString(2, string);
        resultSet2 = object.executeQuery();
        JDBC.dropUsingDMD(statement, resultSet2, string, "ALIAS", "DERBY AGGREGATE");
        object.close();
        resultSet2 = databaseMetaData.getTables(null, string, null, GET_TABLES_SYNONYM);
        JDBC.dropUsingDMD(statement, resultSet2, string, "TABLE_NAME", "SYNONYM");
        if (JDBC.sysSequencesExists(connection)) {
            object = connection.prepareStatement("SELECT SEQUENCENAME FROM SYS.SYSSEQUENCES A, SYS.SYSSCHEMAS S WHERE A.SCHEMAID = S.SCHEMAID  AND S.SCHEMANAME = ?");
            object.setString(1, string);
            resultSet2 = object.executeQuery();
            JDBC.dropUsingDMD(statement, resultSet2, string, "SEQUENCENAME", "SEQUENCE");
            object.close();
        }
        if (!string.equals("APP")) {
            statement.executeUpdate("DROP SCHEMA " + JDBC.escape(string) + " RESTRICT");
        }
        connection.commit();
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sysSequencesExists(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("select count(*) from sys.systables t, sys.sysschemas s\nwhere t.schemaid = s.schemaid\nand ( cast(s.schemaname as varchar(128)))= 'SYS'\nand ( cast(t.tablename as varchar(128))) = 'SYSSEQUENCES'");
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            boolean bl = resultSet.getInt(1) > 0;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement != null) {
                preparedStatement.close();
            }
        }
    }

    private static void dropUsingDMD(Statement statement, ResultSet resultSet, String string, String string2, String string3) throws SQLException {
        boolean bl;
        Object object;
        String string4 = "DROP " + string3 + " ";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (resultSet.next()) {
            String string5 = resultSet.getString(string2);
            object = string4 + JDBC.escape(string, string5);
            if ("TYPE".equals(string3) || "SEQUENCE".equals(string3) || "DERBY AGGREGATE".equals(string3)) {
                object = (String)object + " restrict ";
            }
            arrayList.add(object);
        }
        resultSet.close();
        if (arrayList.isEmpty()) {
            return;
        }
        statement.clearBatch();
        int n = 0;
        for (Object e : arrayList) {
            if (e == null) continue;
            statement.addBatch(e.toString());
            ++n;
        }
        try {
            object = statement.executeBatch();
            Assert.assertNotNull((Object)object);
            Assert.assertEquals((String)"Incorrect result length from executeBatch", (int)n, (int)((Object)object).length);
            boolean bl2 = false;
        }
        catch (BatchUpdateException batchUpdateException) {
            object = batchUpdateException.getUpdateCounts();
            Assert.assertNotNull((Object)object);
            Assert.assertTrue((String)"Too many results in BatchUpdateException", (((Object)object).length <= n ? 1 : 0) != 0);
            boolean bl3 = true;
        }
        boolean bl4 = false;
        for (int i = 0; i < ((Object)object).length; ++i) {
            Object object2 = object[i];
            if (object2 == -3) {
                bl = true;
                continue;
            }
            if (object2 == -2 || object2 >= 0) {
                bl4 = true;
                arrayList.set(i, null);
                continue;
            }
            Assert.fail((String)"Negative executeBatch status");
        }
        statement.clearBatch();
        if (bl4) {
            statement.getConnection().commit();
        }
        if (bl) {
            boolean bl5;
            do {
                bl5 = false;
                bl4 = false;
                ListIterator listIterator = arrayList.listIterator();
                while (listIterator.hasNext()) {
                    String string5 = (String)listIterator.next();
                    if (string5 == null) continue;
                    try {
                        statement.executeUpdate(string5);
                        listIterator.set(null);
                        bl4 = true;
                    }
                    catch (SQLException sQLException) {
                        bl5 = true;
                    }
                }
                if (!bl4) continue;
                statement.getConnection().commit();
            } while (bl5 && bl4);
        }
    }

    public static void assertMetaDataMatch(DatabaseMetaData databaseMetaData, ResultSetMetaData resultSetMetaData) throws SQLException {
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            ResultSet resultSet = databaseMetaData.getColumns(resultSetMetaData.getCatalogName(i), resultSetMetaData.getSchemaName(i), resultSetMetaData.getTableName(i), resultSetMetaData.getColumnName(i));
            Assert.assertTrue((String)("Column missing " + resultSetMetaData.getColumnName(i)), (boolean)resultSet.next());
            Assert.assertEquals((int)resultSet.getInt("DATA_TYPE"), (int)resultSetMetaData.getColumnType(i));
            Assert.assertEquals((int)resultSet.getInt("NULLABLE"), (int)resultSetMetaData.isNullable(i));
            Assert.assertEquals((String)resultSet.getString("TYPE_NAME"), (String)resultSetMetaData.getColumnTypeName(i));
            resultSet.close();
        }
    }

    public static void assertEmpty(ResultSet resultSet) throws SQLException {
        JDBC.assertDrainResults(resultSet, 0);
    }

    public static void assertClosed(ResultSet resultSet) {
        try {
            resultSet.next();
            Assert.fail((String)"ResultSet not closed");
        }
        catch (SQLException sQLException) {
            Assert.assertEquals((String)"XCL16", (String)sQLException.getSQLState());
        }
    }

    public static void assertNoWarnings(SQLWarning sQLWarning) {
        if (sQLWarning == null) {
            return;
        }
        Assert.fail((String)("Expected no SQLWarnings - got: " + sQLWarning.getSQLState() + " " + sQLWarning.getMessage()));
    }

    public static void assertNoMoreResults(Statement statement) throws SQLException {
        Assert.assertFalse((boolean)statement.getMoreResults());
        Assert.assertTrue((statement.getUpdateCount() == -1 ? 1 : 0) != 0);
        Assert.assertNull((Object)statement.getResultSet());
    }

    public static void assertGeneratedKeyResultSet(String string, ResultSet resultSet) throws SQLException {
        Assert.assertNotNull((String)string, (Object)resultSet);
        Assert.assertEquals((String)(string + " - Required CONCUR_READ_ONLY for generated key result sets"), (int)1007, (int)resultSet.getConcurrency());
        int n = resultSet.getType();
        if (n != 1003 && n != 1004) {
            Assert.fail((String)(string + " - Invalid type for generated key result set" + n));
        }
    }

    public static void assertDrainResultsHasData(ResultSet resultSet) throws SQLException {
        int n = JDBC.assertDrainResults(resultSet, -1);
        Assert.assertTrue((String)"ResultSet expected to have data", (n > 0 ? 1 : 0) != 0);
    }

    public static int assertDrainResults(ResultSet resultSet) throws SQLException {
        return JDBC.assertDrainResults(resultSet, -1);
    }

    public static int assertDrainResults(ResultSet resultSet, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = 0;
        while (resultSet.next()) {
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String string = resultSet.getString(i);
                arrayList2.add(string);
                Assert.assertEquals((string == null ? 1 : 0) != 0, (boolean)resultSet.wasNull());
                if (!resultSet.wasNull()) continue;
                JDBC.assertResultColumnNullable(resultSet, arrayList, arrayList2, i);
            }
            ++n2;
            arrayList.add(new ArrayList(arrayList2));
            arrayList2.clear();
        }
        resultSet.close();
        if (n >= 0) {
            try {
                Assert.assertEquals((String)"Unexpected row count:", (int)n, (int)n2);
            }
            catch (AssertionFailedError assertionFailedError) {
                throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, arrayList, arrayList2, resultSet);
            }
        }
        return n2;
    }

    private static void assertResultColumnNullable(ResultSet resultSet, List<List<String>> list, List<String> list2, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        try {
            Assert.assertFalse((resultSetMetaData.isNullable(n) == 0 ? 1 : 0) != 0);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, list, list2, resultSet);
        }
    }

    public static void assertColumnNames(ResultSet resultSet, String ... stringArray) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)stringArray.length, (int)resultSetMetaData.getColumnCount());
        for (int i = 0; i < n; ++i) {
            Assert.assertEquals((String)"Column names do not match:", (String)stringArray[i], (String)resultSetMetaData.getColumnName(i + 1));
        }
    }

    public static void assertDatabaseMetaDataColumns(ResultSet resultSet, int[] nArray, String ... stringArray) throws SQLException {
        JDBC.assertDatabaseMetaDataColumns(resultSet, null, nArray, stringArray);
    }

    public static void assertDatabaseMetaDataColumns(ResultSet resultSet, boolean[] blArray, int[] nArray, String ... stringArray) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        Object object = "[";
        for (n = 0; n < resultSetMetaData.getColumnCount(); ++n) {
            object = n == 0 ? (String)object + resultSetMetaData.getColumnName(n + 1) : (String)object + ", " + resultSetMetaData.getColumnName(n + 1);
        }
        object = (String)object + "]";
        if (blArray != null) {
            Assert.assertEquals((String)"Number of items in expected ColumnNames and expected nullability arrays don't match; fix up the test", (int)stringArray.length, (int)blArray.length);
        }
        if (nArray != null) {
            Assert.assertEquals((String)"Number of items in expected ColumnNames and expected ColumnTypes arrays don't match; fix up the test", (int)stringArray.length, (int)nArray.length);
        }
        if (stringArray.length == resultSetMetaData.getColumnCount()) {
            for (n = 0; n < n2; ++n) {
                Assert.assertEquals((String)"Column names do not match:", (String)stringArray[n], (String)resultSetMetaData.getColumnName(n + 1));
                if (nArray != null) {
                    Assert.assertEquals((String)("Column types do not match for column " + (n + 1)), (int)nArray[n], (int)resultSetMetaData.getColumnType(n + 1));
                }
                if (blArray == null) continue;
                int n3 = blArray[n] ? 1 : 0;
                Assert.assertEquals((String)("Column nullability do not match for column " + (n + 1)), (int)n3, (int)resultSetMetaData.isNullable(n + 1));
            }
        } else {
            for (n = 0; n < stringArray.length; ++n) {
                String string = stringArray[n];
                boolean bl = false;
                for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
                    if (!stringArray[n].equalsIgnoreCase(resultSetMetaData.getColumnName(i + 1))) continue;
                    bl = true;
                    if (nArray != null) {
                        Assert.assertEquals((String)("Column Type does not match for column " + stringArray[n] + "(" + n + ")"), (int)nArray[n], (int)resultSetMetaData.getColumnType(i + 1));
                    }
                    if (blArray == null) break;
                    int n4 = blArray[n] ? 1 : 0;
                    Assert.assertEquals((String)("Column nullability does not match for column " + n), (int)n4, (int)resultSetMetaData.isNullable(i + 1));
                    break;
                }
                Assert.assertTrue((String)("Missing an expected column: " + string + "\n Expected: " + Arrays.toString(stringArray) + "\n Actual  : " + (String)object), (boolean)bl);
            }
        }
    }

    public static void assertColumnTypes(ResultSet resultSet, int[] nArray) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)nArray.length, (int)resultSetMetaData.getColumnCount());
        for (int i = 0; i < n; ++i) {
            Assert.assertEquals((String)("Column types do not match for column " + (i + 1)), (int)nArray[i], (int)resultSetMetaData.getColumnType(i + 1));
        }
    }

    public static void assertParameterTypes(PreparedStatement preparedStatement, int[] nArray) throws Exception {
        if (JDBC.vmSupportsJSR169()) {
            Assert.fail((String)"The assertParameterTypes() method only works on platforms which support ParameterMetaData.");
        }
        Object object = preparedStatement.getClass().getMethod("getParameterMetaData", null).invoke((Object)preparedStatement, null);
        int n = (Integer)object.getClass().getMethod("getParameterCount", null).invoke(object, null);
        Assert.assertEquals((String)"Unexpected parameter count:", (int)nArray.length, (int)n);
        Method method = object.getClass().getMethod("getParameterType", Integer.TYPE);
        for (int i = 0; i < n; ++i) {
            Assert.assertEquals((String)("Types do not match for parameter " + (i + 1)), (int)nArray[i], (int)((Integer)method.invoke(object, i + 1)));
        }
    }

    public static void assertNullability(ResultSet resultSet, boolean[] blArray) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        Assert.assertEquals((String)"Unexpected column count:", (int)blArray.length, (int)resultSetMetaData.getColumnCount());
        for (int i = 0; i < n; ++i) {
            int n2 = blArray[i] ? 1 : 0;
            Assert.assertEquals((String)("Column nullability do not match for column " + (i + 1)), (int)n2, (int)resultSetMetaData.isNullable(i + 1));
        }
    }

    public static void assertSingleValueResultSet(ResultSet resultSet, String string) throws SQLException {
        String[] stringArray = new String[]{string};
        String[][] stringArray2 = new String[][]{stringArray};
        JDBC.assertFullResultSet(resultSet, stringArray2);
    }

    public static void assertFullResultSet(ResultSet resultSet, String[][] stringArray) throws SQLException {
        JDBC.assertFullResultSet(resultSet, (Object[][])stringArray, true);
    }

    public static void assertFullResultSet(ResultSet resultSet, Object[][] objectArray, boolean bl) throws SQLException {
        JDBC.assertFullResultSet(resultSet, objectArray, bl, true);
    }

    public static void assertFullResultSet(ResultSet resultSet, Object[][] objectArray, boolean bl, boolean bl2) throws SQLException {
        JDBC.assertFullResultSetMinion(resultSet, objectArray, bl, bl2, null);
    }

    public static void assertFullResultSet(ResultSet resultSet, Object[][] objectArray, String[] stringArray) throws SQLException {
        JDBC.assertFullResultSetMinion(resultSet, objectArray, true, true, stringArray);
    }

    private static void assertFullResultSetMinion(ResultSet resultSet, Object[][] objectArray, boolean bl, boolean bl2, String[] stringArray) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (objectArray.length > 0) {
            try {
                Assert.assertEquals((String)"Unexpected column count:", (int)objectArray[0].length, (int)resultSetMetaData.getColumnCount());
            }
            catch (AssertionFailedError assertionFailedError) {
                throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, arrayList, arrayList2, resultSet);
            }
        }
        int n = 0;
        while (resultSet.next()) {
            if (TestConfiguration.getCurrent().getJDBCClient().isEmbedded() && stringArray != null) {
                SQLWarning sQLWarning = resultSet.getWarnings();
                String string = null;
                if (sQLWarning != null) {
                    string = sQLWarning.getSQLState();
                }
                try {
                    Assert.assertEquals((String)("Warning assertion error on row " + (n + 1)), (String)stringArray[n], (String)string);
                }
                catch (AssertionFailedError assertionFailedError) {
                    throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, arrayList, arrayList2, resultSet);
                }
            }
            if (n < objectArray.length) {
                JDBC.assertRowInResultSet(resultSet, arrayList, arrayList2, n + 1, objectArray[n], bl);
            }
            arrayList.add(new ArrayList<String>(arrayList2));
            arrayList2.clear();
            ++n;
        }
        if (bl2) {
            resultSet.close();
        }
        try {
            Assert.assertEquals((String)"Unexpected row count:", (int)objectArray.length, (int)n);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, arrayList, arrayList2, resultSet);
        }
    }

    public static void assertPartialResultSet(ResultSet resultSet, Object[][] objectArray, BitSet bitSet) throws SQLException {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (objectArray.length > 0) {
            Assert.assertEquals((String)"Unexpected column count:", (int)objectArray[0].length, (int)bitSet.cardinality());
        }
        int n = 0;
        while (resultSet.next()) {
            if (n < objectArray.length) {
                JDBC.assertRowInResultSet(resultSet, arrayList, arrayList2, n + 1, objectArray[n], true, bitSet);
            }
            arrayList.add(new ArrayList(arrayList2));
            arrayList2.clear();
            ++n;
        }
        resultSet.close();
        try {
            Assert.assertEquals((String)"Unexpected row count:", (int)objectArray.length, (int)n);
        }
        catch (AssertionFailedError assertionFailedError) {
            throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, arrayList, arrayList2, resultSet);
        }
    }

    private static void assertRowInResultSet(ResultSet resultSet, List<List<String>> list, List<String> list2, int n, Object[] objectArray, boolean bl) throws SQLException {
        JDBC.assertRowInResultSet(resultSet, list, list2, n, objectArray, bl, null);
    }

    private static void assertRowInResultSet(ResultSet resultSet, List<List<String>> list, List<String> list2, int n, Object[] objectArray, boolean bl, BitSet bitSet) throws SQLException {
        int n2 = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 0; i < objectArray.length; ++i) {
            boolean bl2;
            Object object;
            int n3 = n2 = bitSet == null ? i + 1 : bitSet.nextSetBit(n2) + 1;
            if (bl) {
                String string;
                if (objectArray[i] != null) {
                    objectArray[i] = ((String)objectArray[i]).trim();
                }
                object = objectArray[i] != null && resultSetMetaData.getColumnType(n2) == 5 ? ((string = objectArray[i].toString()).equals("true") || string.equals("false") ? (resultSet.getShort(n2) == 0 ? "false" : "true") : resultSet.getString(n2)) : resultSet.getString(n2);
                if (object != null) {
                    object = ((String)object).trim();
                }
            } else {
                object = resultSet.getObject(n2);
            }
            list2.add(object == null ? "null" : object.toString());
            boolean bl3 = bl2 = resultSet.wasNull() && objectArray[i] == null || !resultSet.wasNull() && objectArray[i] != null && (objectArray[i].equals(object) || object instanceof byte[] && Arrays.equals((byte[])object, (byte[])objectArray[i]));
            if (!bl2) {
                Object object2 = objectArray[i];
                Object object3 = object;
                if (object instanceof byte[]) {
                    object2 = JDBC.bytesToString((byte[])objectArray[i]);
                    object3 = JDBC.bytesToString((byte[])object);
                }
                try {
                    Assert.fail((String)("Column value mismatch @ column '" + resultSetMetaData.getColumnName(n2) + "', row " + n + ":\n    Expected: >" + String.valueOf(object2) + "<\n    Found:    >" + String.valueOf(object3) + "<"));
                }
                catch (AssertionFailedError assertionFailedError) {
                    throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, list, list2, resultSet);
                }
            }
            if (!resultSet.wasNull()) continue;
            JDBC.assertResultColumnNullable(resultSet, list, list2, n2);
        }
    }

    public static void assertSameContents(ResultSet resultSet, ResultSet resultSet2) throws SQLException, IOException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        while (resultSet.next()) {
            Assert.assertTrue((boolean)resultSet2.next());
            for (int i = 1; i <= n; ++i) {
                switch (resultSetMetaData.getColumnType(i)) {
                    case 4: 
                    case 5: {
                        Assert.assertEquals((int)resultSet.getInt(i), (int)resultSet2.getInt(i));
                        break;
                    }
                    case -5: {
                        Assert.assertEquals((long)resultSet.getLong(i), (long)resultSet2.getLong(i));
                        break;
                    }
                    case 2004: {
                        BaseJDBCTestCase.assertEquals(resultSet.getBlob(i), resultSet2.getBlob(i));
                        break;
                    }
                    case 2005: {
                        BaseJDBCTestCase.assertEquals(resultSet.getClob(i), resultSet2.getClob(i));
                        break;
                    }
                    default: {
                        Assert.assertEquals((String)resultSet.getString(i), (String)resultSet2.getString(i));
                    }
                }
                Assert.assertEquals((boolean)resultSet.wasNull(), (boolean)resultSet2.wasNull());
            }
        }
        Assert.assertFalse((boolean)resultSet2.next());
        resultSet.close();
        resultSet2.close();
    }

    public static void assertUnorderedResultSet(ResultSet resultSet, String[][] stringArray) throws SQLException {
        JDBC.assertUnorderedResultSet(resultSet, stringArray, true);
    }

    public static void assertUnorderedResultSet(ResultSet resultSet, Object[][] objectArray, boolean bl) throws SQLException {
        JDBC.assertRSContains(resultSet, objectArray, bl, true);
    }

    public static void assertResultSetContains(ResultSet resultSet, Object[][] objectArray) throws SQLException {
        JDBC.assertRSContains(resultSet, objectArray, true, false);
    }

    private static void assertRSContains(ResultSet resultSet, Object[][] objectArray, boolean bl, boolean bl2) throws SQLException {
        String string;
        int n;
        Object object;
        if (objectArray.length == 0) {
            if (bl2) {
                JDBC.assertEmpty(resultSet);
            }
            return;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            Assert.assertEquals((String)"Unexpected column count", (int)objectArray[0].length, (int)resultSetMetaData.getColumnCount());
        }
        catch (AssertionFailedError assertionFailedError) {
            throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, arrayList, arrayList2, resultSet);
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            Assert.assertEquals((String)"Different column count in expectedRows", (int)objectArray[0].length, (int)objectArray[i].length);
            object = new ArrayList(objectArray[i].length);
            for (n = 0; n < objectArray[i].length; ++n) {
                string = (String)objectArray[i][n];
                object.add(bl ? (string == null ? null : string.trim()) : string);
            }
            arrayList3.add(object);
        }
        ArrayList<Object> arrayList4 = new ArrayList<Object>(objectArray.length);
        while (resultSet.next()) {
            object = new ArrayList(objectArray[0].length);
            for (n = 1; n <= objectArray[0].length; ++n) {
                string = resultSet.getString(n);
                arrayList2.add(string);
                object.add(bl ? (string == null ? null : string.trim()) : string);
                if (!resultSet.wasNull()) continue;
                JDBC.assertResultColumnNullable(resultSet, arrayList, arrayList2, n);
            }
            arrayList4.add(object);
            arrayList.add(new ArrayList<String>(arrayList2));
            arrayList2.clear();
        }
        resultSet.close();
        try {
            if (bl2) {
                object = "Unexpected row count, expected: " + objectArray.length + ", actual: " + arrayList4.size() + "\n\t expected rows: \n\t\t" + String.valueOf(arrayList3) + "\n\t actual result: \n\t\t" + String.valueOf(arrayList4) + "\n";
                Assert.assertEquals((String)object, (int)objectArray.length, (int)arrayList4.size());
            }
            if (!arrayList4.containsAll(arrayList3)) {
                arrayList3.removeAll(arrayList4);
                BaseTestCase.println("These expected rows don't appear in the actual result: " + String.valueOf(arrayList3));
                object = "Missing rows in ResultSet; \n\t expected rows: \n\t\t" + String.valueOf(arrayList3) + "\n\t actual result: \n\t\t" + String.valueOf(arrayList4);
                Assert.fail((String)object);
            }
        }
        catch (AssertionFailedError assertionFailedError) {
            throw JDBC.addRsToReport(assertionFailedError, resultSetMetaData, arrayList, arrayList2, resultSet);
        }
    }

    public static void assertCurrentSchema(Connection connection, String string) throws SQLException {
        try (Statement statement = connection.createStatement();){
            JDBC.assertSingleValueResultSet(statement.executeQuery("VALUES CURRENT SCHEMA"), string);
        }
    }

    public static void assertCurrentUser(Connection connection, String string) throws SQLException {
        try (Statement statement = connection.createStatement();){
            JDBC.assertSingleValueResultSet(statement.executeQuery("VALUES CURRENT_USER"), string);
        }
    }

    private static String bytesToString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        stringBuffer.append('\"');
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append('\"');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    private static String compressQuotes(String string, String string2) {
        Object object = string;
        int n = ((String)object).indexOf(string2);
        while (n != -1) {
            object = ((String)object).substring(0, n + 1) + ((String)object).substring(n + 2);
            n = ((String)object).indexOf(string2, n + 1);
        }
        return object;
    }

    public static String identifierToCNF(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.charAt(0) == '\"' && string.length() >= 3 && string.charAt(string.length() - 1) == '\"') {
            return JDBC.compressQuotes(string.substring(1, string.length() - 1), "\"\"");
        }
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String escape(String string, String string2) {
        return JDBC.escape(string) + "." + JDBC.escape(string2);
    }

    public static String sqlNameFromJdbc(int n) {
        switch (n) {
            case -7: {
                return "Types.BIT";
            }
            case 16: {
                return "Types.BOOLEAN";
            }
            case -6: {
                return "Types.TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "Types.FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "Types.NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONG VARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "CHAR () FOR BIT DATA";
            }
            case -3: {
                return "VARCHAR () FOR BIT DATA";
            }
            case -4: {
                return "LONG VARCHAR FOR BIT DATA";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "Types.OTHER";
            }
            case 0: {
                return "Types.NULL";
            }
        }
        return String.valueOf(n);
    }

    public static void checkPlan(Statement statement, String[] stringArray) throws SQLException {
        ResultSet resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        RuntimeStatisticsParser runtimeStatisticsParser = new RuntimeStatisticsParser(string);
        runtimeStatisticsParser.assertSequence(stringArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AssertionFailedError addRsToReport(AssertionFailedError assertionFailedError, ResultSetMetaData resultSetMetaData, List<List<String>> list, List<String> list2, ResultSet resultSet) throws SQLException {
        try {
            int n;
            int n2;
            if (resultSet == null) {
                return BaseTestCase.newAssertionFailedError(assertionFailedError.getMessage() + "\n<NULL>", assertionFailedError);
            }
            int n3 = resultSetMetaData.getColumnCount();
            StringBuilder stringBuilder = new StringBuilder("    ");
            StringBuilder stringBuilder2 = new StringBuilder("    ");
            for (int i = 1; i <= n3; ++i) {
                if (i > 1) {
                    stringBuilder.append(",");
                    stringBuilder2.append(" ");
                }
                n2 = stringBuilder.length();
                stringBuilder.append(resultSetMetaData.getColumnLabel(i));
                for (n = n2 = stringBuilder.length() - n2; n > 0; --n) {
                    stringBuilder2.append("-");
                }
            }
            stringBuilder.append("\n");
            stringBuilder2.append("\n");
            StringBuilder stringBuilder3 = new StringBuilder();
            stringBuilder3.append(assertionFailedError.getMessage()).append("\n\n").append(stringBuilder.toString()).append(stringBuilder2.toString());
            if (!resultSet.isClosed()) {
                n2 = list2.size();
                for (n = 0; n < n3 - n2; ++n) {
                    String string;
                    block15: {
                        string = null;
                        try {
                            string = resultSet.getString(n2 + n + 1);
                        }
                        catch (SQLException sQLException) {
                            if (!sQLException.getSQLState().equals("24000")) break block15;
                            if (!resultSet.next()) break;
                            string = resultSet.getString(n2 + n + 1);
                        }
                    }
                    list2.add(string);
                }
                if (list2.size() > 0) {
                    list.add(new ArrayList<String>(list2));
                    list2.clear();
                }
                while (resultSet.next()) {
                    for (n = 0; n < n3; ++n) {
                        list2.add(resultSet.getString(n + 1));
                    }
                    list.add(new ArrayList<String>(list2));
                    list2.clear();
                }
            }
            Iterator<List<String>> iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return BaseTestCase.newAssertionFailedError(stringBuilder3.toString(), assertionFailedError);
                }
                List<String> list3 = iterator.next();
                stringBuilder3.append("   ").append(list3.toString()).append("\n");
            }
        }
        catch (Throwable throwable) {
            BaseTestCase.printStackTrace(throwable);
            return assertionFailedError;
        }
    }

    static {
        boolean bl;
        GET_TABLES_TABLE = new String[]{"TABLE"};
        GET_TABLES_VIEW = new String[]{"VIEW"};
        GET_TABLES_SYNONYM = new String[]{"SYNONYM"};
        HAVE_DRIVER = JDBC.haveClass("java.sql.Driver");
        HAVE_SAVEPOINT = JDBC.haveClass("java.sql.Savepoint");
        HAVE_SQLXML = JDBC.haveClass("java.sql.SQLXML");
        HAVE_LUCENE_CORE = JDBC.haveClass("org.apache.lucene.analysis.Analyzer");
        HAVE_LUCENE_ANALYZERS = JDBC.haveClass("org.apache.lucene.analysis.en.EnglishAnalyzer");
        HAVE_LUCENE_QUERYPARSER = JDBC.haveClass("org.apache.lucene.queryparser.surround.parser.QueryParser");
        HAVE_JSON_SIMPLE = JDBC.haveClass("org.json.simple.JSONArray");
        try {
            Class<ResultSet> clazz = Class.forName("java.lang.AutoCloseable");
            bl = clazz.isAssignableFrom(ResultSet.class);
        }
        catch (Throwable throwable) {
            bl = false;
        }
        HAVE_AUTO_CLOSEABLE_RESULT_SET = bl;
        bl = false;
        try {
            Class.forName("javax.naming.Referenceable");
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAVE_REFERENCEABLE = bl;
        bl = false;
        try {
            Class.forName("java.sql.SQLType");
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HAVE_SQLTYPE = bl;
        HAVE_MBEAN_SERVER = JDBC.haveClass("javax.management.MBeanServer");
    }

    public static class GeneratedId {
        public boolean equals(Object object) {
            String string = (String)object;
            if (!(object instanceof String)) {
                return false;
            }
            if (!string.startsWith("SQL")) {
                return false;
            }
            if (string.length() != 50) {
                return false;
            }
            for (int i = 3; i < 50; ++i) {
                char c = string.charAt(i);
                if (Character.digit(c, 16) >= 0 || c == '-') continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return "xxxxGENERATED-IDxxxx";
        }
    }
}

