/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.ScriptTestCase;

public class IjTestCase
extends ScriptTestCase {
    String scriptName = this.getName() + ".sql";
    String outfileName = "extinout/" + this.getName() + ".out";
    File outfile = new File(this.outfileName);

    public IjTestCase(String string) {
        super(string);
    }

    @Override
    public void setUp() {
        super.setUp();
        IjTestCase.setSystemProperty("ij.outfile", this.outfileName);
        IjTestCase.setSystemProperty("ij.defaultResourcePackage", "/org/apache/derbyTesting/functionTests/tests/" + this.getArea() + "/");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        IjTestCase.removeSystemProperty("ij.outfile");
        IjTestCase.removeSystemProperty("ij.defaultResourcePackage");
    }

    @Override
    public void runTest() throws Throwable {
        int n;
        String[] stringArray = new String[]{"-fr", this.scriptName};
        ij.main((String[])stringArray);
        String string = "org/apache/derbyTesting/functionTests/master/" + this.getName() + ".out";
        File file = this.outfile;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            IjTestCase.fail((String)"Could not open ij output file.");
        }
        OutputStream outputStream = this.getOutputStream();
        while ((n = fileInputStream.read()) != -1) {
            outputStream.write(n);
        }
        fileInputStream.close();
        boolean bl = PrivilegedFileOpsForTests.delete(this.outfile);
        if (!bl) {
            IjTestCase.println("Could not delete outfile for " + this.scriptName);
        }
        this.compareCanon(string);
    }
}

