/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.BaseTest;

public class OnlineCompressTest
extends BaseTest {
    boolean verbose = false;

    protected void callCompress(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?, ?, ?, ?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.setInt(3, bl ? 1 : 0);
        callableStatement.setInt(4, bl2 ? 1 : 0);
        callableStatement.setInt(5, bl3 ? 1 : 0);
        callableStatement.execute();
        if (bl4) {
            connection.commit();
        }
    }

    protected void createAndLoadTable(Connection connection, boolean bl, String string, int n, int n2) throws SQLException {
        Statement statement;
        if (bl) {
            statement = connection.createStatement();
            statement.execute("create table " + string + "(keycol int, indcol1 int, indcol2 int, indcol3 int, data1 varchar(2000), data2 varchar(2000))");
            statement.close();
        }
        statement = connection.prepareStatement("insert into " + string + " values(?, ?, ?, ?, ?, ?)");
        char[] cArray = new char[500];
        char[] cArray2 = new char[500];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 97;
            cArray2[i] = 98;
        }
        String string2 = new String(cArray);
        String string3 = new String(cArray2);
        int n3 = 0;
        try {
            int n4 = n2;
            while (n3 < n) {
                statement.setInt(1, n4);
                statement.setInt(2, n4 * 10);
                statement.setInt(3, n4 * 100);
                statement.setInt(4, -n4);
                statement.setString(5, string2);
                statement.setString(6, string3);
                statement.execute();
                ++n3;
                ++n4;
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Exception while trying to insert row number: " + n3);
            throw sQLException;
        }
        if (bl) {
            Statement statement2 = connection.createStatement();
            statement2.execute("create index " + string + "_idx_keycol on " + string + "(keycol)");
            statement2.execute("create index " + string + "_idx_indcol1 on " + string + "(indcol1)");
            statement2.execute("create index " + string + "_idx_indcol2 on " + string + "(indcol2)");
            statement2.execute("create unique index " + string + "_idx_indcol3 on " + string + "(indcol3)");
            statement2.close();
        }
        connection.commit();
    }

    protected void createAndLoadLargeTable(Connection connection, boolean bl, String string, int n, int n2) throws SQLException {
        int n3;
        Statement statement;
        if (bl) {
            statement = connection.createStatement();
            statement.execute("create table " + string + "(keycol int, indcol1 int, indcol2 int, data1 char(24), data2 char(24), data3 char(24),data4 char(24), data5 char(24), data6 char(24), data7 char(24), data8 char(24),data9 char(24), data10 char(24), inddec1 decimal(8), indcol3 int, indcol4 int, data11 varchar(50))");
            statement.close();
        }
        statement = connection.prepareStatement("insert into " + string + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        char[] cArray = new char[24];
        char[] cArray2 = new char[24];
        char[] cArray3 = new char[24];
        char[] cArray4 = new char[24];
        char[] cArray5 = new char[24];
        char[] cArray6 = new char[24];
        char[] cArray7 = new char[24];
        char[] cArray8 = new char[24];
        char[] cArray9 = new char[24];
        char[] cArray10 = new char[24];
        char[] cArray11 = new char[50];
        for (n3 = 0; n3 < cArray.length; ++n3) {
            cArray[n3] = 97;
            cArray2[n3] = 98;
            cArray3[n3] = 99;
            cArray4[n3] = 100;
            cArray5[n3] = 101;
            cArray6[n3] = 102;
            cArray7[n3] = 103;
            cArray8[n3] = 104;
            cArray9[n3] = 105;
            cArray10[n3] = 106;
        }
        for (n3 = 0; n3 < cArray11.length; ++n3) {
            cArray11[n3] = 122;
        }
        String string2 = new String(cArray);
        String string3 = new String(cArray2);
        String string4 = new String(cArray3);
        String string5 = new String(cArray4);
        String string6 = new String(cArray5);
        String string7 = new String(cArray6);
        String string8 = new String(cArray7);
        String string9 = new String(cArray8);
        String string10 = new String(cArray9);
        String string11 = new String(cArray10);
        String string12 = new String(cArray11);
        int n4 = 0;
        try {
            int n5 = n2;
            while (n4 < n) {
                statement.setInt(1, n5);
                statement.setInt(2, n5 * 10);
                statement.setInt(3, n5 * 100);
                statement.setString(4, string2);
                statement.setString(5, string3);
                statement.setString(6, string4);
                statement.setString(7, string5);
                statement.setString(8, string6);
                statement.setString(9, string7);
                statement.setString(10, string8);
                statement.setString(11, string9);
                statement.setString(12, string10);
                statement.setString(13, string11);
                statement.setInt(14, n5 * 20);
                statement.setInt(15, n5 * 200);
                statement.setInt(16, n5 * 50);
                statement.setString(17, string12);
                statement.execute();
                ++n4;
                ++n5;
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Exception while trying to insert row number: " + n4);
            throw sQLException;
        }
        if (bl) {
            Statement statement2 = connection.createStatement();
            statement2.execute("create index " + string + "_idx_keycol on " + string + "(keycol)");
            statement2.execute("create index " + string + "_idx_indcol1 on " + string + "(indcol1)");
            statement2.execute("create index " + string + "_idx_indcol2 on " + string + "(indcol2)");
            statement2.execute("create unique index " + string + "_idx_indcol3 on " + string + "(indcol3)");
            statement2.close();
        }
        connection.commit();
    }

    private void createAndLoadLongTable(Connection connection, boolean bl, String string, int n) throws SQLException {
        Statement statement;
        if (bl) {
            statement = connection.createStatement();
            statement.execute("create table " + string + " (keycol   int, longcol1 clob(200k), longrow1 varchar(10000), longrow2 varchar(10000), longrow3 varchar(10000), longrow4 varchar(10000), indcol1  int, indcol2  int, indcol3  int, data1    varchar(2000), data2    varchar(2000), longrow5 varchar(10000), longrow6 varchar(10000), longrow7 varchar(10000), longrow8 varchar(10000), longcol2 clob(200k))");
            statement.close();
        }
        statement = connection.prepareStatement("insert into " + string + " values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        char[] cArray = new char[500];
        char[] cArray2 = new char[500];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 97;
            cArray2[i] = 98;
        }
        String string2 = new String(cArray);
        String string3 = new String(cArray2);
        char[] cArray3 = new char[10000];
        char[] cArray4 = new char[10000];
        for (int i = 0; i < cArray3.length; ++i) {
            cArray3[i] = 99;
            cArray4[i] = 100;
        }
        String string4 = new String(cArray3);
        String string5 = new String(cArray4);
        char[] cArray5 = new char[200000];
        char[] cArray6 = new char[200000];
        for (int i = 0; i < cArray5.length; ++i) {
            cArray5[i] = 101;
            cArray6[i] = 102;
        }
        String string6 = new String(cArray5);
        String string7 = new String(cArray6);
        for (int i = 0; i < n; ++i) {
            statement.setInt(1, i);
            statement.setString(2, string6);
            statement.setString(3, string4);
            statement.setString(4, string4);
            statement.setString(5, string4);
            statement.setString(6, string4);
            statement.setInt(7, i * 10);
            statement.setInt(8, i * 100);
            statement.setInt(9, -i);
            statement.setString(10, string2);
            statement.setString(11, string3);
            statement.setString(12, string5);
            statement.setString(13, string5);
            statement.setString(14, string5);
            statement.setString(15, string5);
            statement.setString(16, string6);
            statement.execute();
        }
        if (bl) {
            Statement statement2 = connection.createStatement();
            statement2.execute("create index " + string + "_idx_keycol on " + string + "(keycol)");
            statement2.execute("create index " + string + "_idx_indcol1 on " + string + "(indcol1)");
            statement2.execute("create index " + string + "_idx_indcol2 on " + string + "(indcol2)");
            statement2.execute("create unique index " + string + "_idx_indcol3 on " + string + "(indcol3)");
            statement2.close();
        }
        connection.commit();
    }

    private void log_wrong_count(String string, String string2, int n, int n2, int n3, int[] nArray, int[] nArray2) {
        System.out.println(string);
        System.out.println("ERROR: for " + n + " row  test. Expected " + n2 + ", but got " + n3);
        System.out.println("before_info:");
        System.out.println("    IS_INDEX         =" + nArray[0] + "\n    NUM_ALLOC        =" + nArray[1] + "\n    NUM_FREE         =" + nArray[2] + "\n    NUM_UNFILLED     =" + nArray[3] + "\n    PAGE_SIZE        =" + nArray[4] + "\n    ESTIMSPACESAVING =" + nArray[5]);
        System.out.println("after_info:");
        System.out.println("    IS_INDEX         =" + nArray2[0] + "\n    NUM_ALLOC        =" + nArray2[1] + "\n    NUM_FREE         =" + nArray2[2] + "\n    NUM_UNFILLED     =" + nArray2[3] + "\n    PAGE_SIZE        =" + nArray2[4] + "\n    ESTIMSPACESAVING =" + nArray2[5]);
    }

    private void deleteAllRows(Connection connection, boolean bl, boolean bl2, String string, String string2, int n) throws SQLException {
        this.testProgress("begin deleteAllRows," + n + " row test, create = " + bl + ".");
        if (bl2) {
            this.createAndLoadLongTable(connection, bl, string2, n);
        } else {
            this.createAndLoadTable(connection, bl, string2, n, 0);
        }
        if (this.verbose) {
            this.testProgress("Calling compress.");
        }
        int[] nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.callCompress(connection, "APP", string2, true, true, true, true);
        int[] nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (nArray2[1] != nArray[1]) {
            this.log_wrong_count("Expected no alloc page change.", string2, n, nArray[1], nArray2[1], nArray, nArray2);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        this.testProgress("no delete case complete.");
        nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.executeQuery(connection, "delete from " + string2, true);
        OnlineCompressTest.callWaitForPostCommit(connection);
        if (this.verbose) {
            this.testProgress("deleted all rows, now calling compress.");
        }
        this.callCompress(connection, "APP", string2, true, true, true, true);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (nArray2[1] != 1) {
            this.log_wrong_count("Expected all pages to be truncated.", string2, n, 1, nArray2[1], nArray, nArray2);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        this.testProgress("delete all rows case succeeded.");
        connection.commit();
        this.testProgress("end deleteAllRows," + n + " row test.");
    }

    private void simpleDeleteAllRows(Connection connection, boolean bl, boolean bl2, String string, String string2, int n) throws SQLException {
        this.testProgress("begin simpleDeleteAllRows," + n + " row test, create = " + bl + ".");
        if (bl2) {
            this.createAndLoadLongTable(connection, bl, string2, n);
        } else {
            this.createAndLoadTable(connection, bl, string2, n, 0);
        }
        if (this.verbose) {
            this.testProgress("Calling compress.");
        }
        int[] nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.callCompress(connection, "APP", string2, true, true, true, true);
        int[] nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (nArray2[1] != nArray[1]) {
            this.log_wrong_count("Expected no alloc page change.", string2, n, nArray[1], nArray2[1], nArray, nArray2);
        }
        this.testProgress("no delete case complete.");
        nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.executeQuery(connection, "delete from " + string2, true);
        OnlineCompressTest.callWaitForPostCommit(connection);
        if (this.verbose) {
            this.testProgress("deleted all rows, now calling compress.");
        }
        this.callCompress(connection, "APP", string2, true, true, true, true);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (nArray2[1] != 1) {
            this.log_wrong_count("Expected all pages to be truncated.", string2, n, 1, nArray2[1], nArray, nArray2);
        }
        this.testProgress("delete all rows case succeeded.");
        connection.commit();
        this.testProgress("end simple deleteAllRows," + n + " row test.");
    }

    private void checkPurgePhase(Connection connection, boolean bl, boolean bl2, String string, String string2, int n) throws SQLException {
        this.testProgress("begin checkPurgePhase" + n + " row test, create = " + bl + ".");
        if (bl2) {
            this.createAndLoadLongTable(connection, bl, string2, n);
        } else {
            this.createAndLoadTable(connection, bl, string2, n, 0);
        }
        int[] nArray = this.getSpaceInfo(connection, "APP", string2, false);
        this.executeQuery(connection, "delete from " + string2, false);
        this.callCompress(connection, "APP", string2, true, false, false, false);
        int[] nArray2 = this.getSpaceInfo(connection, "APP", string2, false);
        if (nArray2[1] != nArray[1]) {
            this.log_wrong_count("Expected no alloc page change(1).", string2, n, nArray[1], nArray2[1], nArray, nArray2);
        }
        if (nArray2[2] != nArray[2]) {
            this.log_wrong_count("Expected no free page change(1).", string2, n, nArray[2], nArray2[2], nArray, nArray2);
        }
        this.callCompress(connection, "APP", string2, true, false, false, false);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, false);
        if (nArray2[1] != nArray[1]) {
            this.log_wrong_count("Expected no alloc page change(2).", string2, n, nArray[1], nArray2[1], nArray, nArray2);
        }
        if (nArray2[2] != nArray[2]) {
            this.log_wrong_count("Expected no free page change(2).", string2, n, nArray[2], nArray2[2], nArray, nArray2);
        }
        try {
            this.callCompress(connection, "APP", string2, false, true, false, false);
            this.logError("Defragment pass did not get a lock timeout.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        nArray2 = this.getSpaceInfo(connection, "APP", string2, false);
        if (nArray2[1] != nArray[1]) {
            this.log_wrong_count("Expected no alloc page change(3).", string2, n, nArray[1], nArray2[1], nArray, nArray2);
        }
        if (nArray2[2] != nArray[2]) {
            this.log_wrong_count("Expected no free page change(3).", string2, n, nArray[2], nArray2[2], nArray, nArray2);
        }
        this.executeQuery(connection, "delete from " + string2, true);
        OnlineCompressTest.callWaitForPostCommit(connection);
        this.callCompress(connection, "APP", string2, true, true, true, true);
        if (bl2) {
            this.createAndLoadLongTable(connection, bl, string2, n);
        } else {
            this.createAndLoadTable(connection, bl, string2, n, 0);
        }
        connection.commit();
        this.executeQuery(connection, "delete from " + string2, false);
        nArray = this.getSpaceInfo(connection, "APP", string2, false);
        this.callCompress(connection, "APP", string2, false, false, true, false);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, false);
        if (nArray2[1] != nArray[1]) {
            this.log_wrong_count("Expected no alloc page change(4).", string2, n, nArray[1], nArray2[1], nArray, nArray2);
        }
        if (nArray2[2] > nArray[2]) {
            this.log_wrong_count("Expected no increase in free pages(4).", string2, n, nArray[2], nArray2[2], nArray, nArray2);
        }
        connection.commit();
        OnlineCompressTest.callWaitForPostCommit(connection);
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        this.callCompress(connection, "APP", string2, true, false, false, false);
        this.callCompress(connection, "APP", string2, false, true, false, false);
        this.callCompress(connection, "APP", string2, false, false, true, false);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, false);
        if (nArray2[1] != 1) {
            this.log_wrong_count("Expected all pages to be truncated.", string2, n, 1, nArray2[1], nArray, nArray2);
        }
        if (nArray2[2] != 0) {
            this.log_wrong_count("Expected no free page after all pages truncated.", string2, n, 1, nArray2[1], nArray, nArray2);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        this.testProgress("end checkPurgePhase" + n + " row test.");
    }

    private void test1(Connection connection, String string, String string2) throws SQLException {
        this.beginTest(connection, string);
        int[] nArray = new int[]{0, 1, 50, 4000};
        for (int i = 0; i < nArray.length; ++i) {
            this.deleteAllRows(connection, true, false, "APP", string2, nArray[i]);
            this.deleteAllRows(connection, false, false, "APP", string2, nArray[i]);
            this.checkPurgePhase(connection, false, false, "APP", string2, nArray[i]);
            this.executeQuery(connection, "drop table " + string2, true);
        }
        this.endTest(connection, string);
    }

    private void test2(Connection connection, String string, String string2) throws SQLException {
        this.beginTest(connection, string);
        int[] nArray = new int[]{4000};
        for (int i = 0; i < nArray.length; ++i) {
            this.simpleDeleteAllRows(connection, true, false, "APP", string2, nArray[i]);
            for (int j = 0; j < 100; ++j) {
                this.deleteAllRows(connection, false, false, "APP", string2, nArray[i]);
            }
            this.executeQuery(connection, "drop table " + string2, true);
        }
        this.endTest(connection, string);
    }

    private void test3(Connection connection, String string, String string2) throws SQLException {
        this.beginTest(connection, string);
        int[] nArray = new int[]{1, 2, 50};
        for (int i = 0; i < nArray.length; ++i) {
            this.deleteAllRows(connection, true, true, "APP", string2, nArray[i]);
            this.deleteAllRows(connection, false, true, "APP", string2, nArray[i]);
            this.checkPurgePhase(connection, false, true, "APP", string2, nArray[i]);
            this.executeQuery(connection, "drop table " + string2, true);
        }
        this.endTest(connection, string);
    }

    private void test4(Connection connection, String string, String string2) throws SQLException {
        this.beginTest(connection, string);
        int[] nArray = new int[]{4000};
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < 100; ++j) {
                this.simpleDeleteAllRows(connection, true, false, "APP", string2, nArray[i]);
                this.deleteAllRows(connection, false, false, "APP", string2, nArray[i]);
                this.executeQuery(connection, "drop table " + string2, true);
            }
        }
        this.endTest(connection, string);
    }

    private void test5_load(Connection connection, String string, String string2, int n) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("create table " + string2 + " (keycol integer primary key, onehalf integer, onethird integer, c varchar(300))");
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + string2 + " values(?, ?, ?, ?)");
        char[] cArray = new char[200];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 98;
        }
        String string3 = new String(cArray);
        for (int i = 0; i < n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i % 2);
            preparedStatement.setInt(3, i % 3);
            preparedStatement.setString(4, string3);
            preparedStatement.execute();
        }
        connection.commit();
    }

    private void test5_run(Connection connection, String string, String string2, int n) throws SQLException {
        this.testProgress("begin test5: " + n + " row test.");
        if (this.verbose) {
            this.testProgress("Calling compress.");
        }
        int[] nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.callCompress(connection, "APP", string2, true, true, true, true);
        int[] nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (nArray2[1] != nArray[1]) {
            this.log_wrong_count("Expected no alloc page change.", string2, n, nArray[1], nArray2[1], nArray, nArray2);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.executeQuery(connection, "delete from " + string2 + " where onehalf = 0", true);
        OnlineCompressTest.callWaitForPostCommit(connection);
        if (this.verbose) {
            this.testProgress("deleted every other row, now calling compress.");
        }
        this.callCompress(connection, "APP", string2, true, true, true, true);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (this.total_pages(nArray2) != this.total_pages(nArray)) {
            this.log_wrong_count("Expected no truncation.", string2, n, 1, nArray2[1], nArray, nArray2);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.executeQuery(connection, "delete from " + string2 + " where onethird = 0", true);
        OnlineCompressTest.callWaitForPostCommit(connection);
        if (this.verbose) {
            this.testProgress("deleted every third row, now calling compress.");
        }
        this.callCompress(connection, "APP", string2, true, true, true, true);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (this.total_pages(nArray2) != this.total_pages(nArray)) {
            this.log_wrong_count("Expected no truncation.", string2, n, 1, nArray2[1], nArray, nArray2);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.executeQuery(connection, "delete from " + string2 + " where keycol > " + n / 2, true);
        OnlineCompressTest.callWaitForPostCommit(connection);
        if (this.verbose) {
            this.testProgress("deleted top half of the rows, now calling compress.");
        }
        this.callCompress(connection, "APP", string2, true, true, true, true);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (this.verbose) {
            this.log_wrong_count("deleted top half keys, spaceinfo:", string2, n, this.total_pages(nArray) / 2 + 2, nArray2[1], nArray, nArray2);
        }
        if (this.total_pages(nArray2) > this.total_pages(nArray) / 2 + 2) {
            this.log_wrong_count("Expected at least " + (nArray[1] / 2 + 2) + " pages to be truncated.", string2, n, 1, nArray2[1], nArray, nArray2);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        nArray = this.getSpaceInfo(connection, "APP", string2, true);
        this.executeQuery(connection, "delete from " + string2 + " where keycol < 500 ", true);
        OnlineCompressTest.callWaitForPostCommit(connection);
        if (this.verbose) {
            this.testProgress("deleted keys < 500, now calling compress.");
        }
        this.callCompress(connection, "APP", string2, true, true, true, true);
        nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
        if (this.verbose) {
            this.log_wrong_count("deleted bottom 500 keys, spaceinfo:", string2, n, this.total_pages(nArray) - 33, nArray2[1], nArray, nArray2);
        }
        if (this.total_pages(nArray2) > this.total_pages(nArray) - 33) {
            this.log_wrong_count("Expected at least 33 pages reclaimed.", string2, n, 1, nArray2[1], nArray, nArray2);
        }
        if (this.verbose) {
            this.testProgress("calling consistency checker.");
        }
        if (!this.checkConsistency(connection, string, string2)) {
            this.logError("conistency check failed.");
        }
        connection.commit();
        this.testProgress("end test5: " + n + " row test.");
    }

    private void test5_cleanup(Connection connection, String string, String string2, int n) throws SQLException {
        this.executeQuery(connection, "drop table " + string2, true);
    }

    private void test5(Connection connection, String string, String string2) throws SQLException {
        this.beginTest(connection, string);
        int[] nArray = new int[]{2000, 10000};
        for (int i = 0; i < nArray.length; ++i) {
            this.test5_load(connection, "APP", string2, nArray[i]);
            this.test5_run(connection, "APP", string2, nArray[i]);
            this.test5_cleanup(connection, "APP", string2, nArray[i]);
        }
        this.endTest(connection, string);
    }

    private void test6(Connection connection, String string, String string2) throws SQLException {
        this.beginTest(connection, string);
        int[] nArray = new int[]{104000};
        for (int i = 0; i < nArray.length; ++i) {
            this.createAndLoadLargeTable(connection, true, string2, nArray[i], 0);
            if (this.verbose) {
                this.testProgress("Calling compress.");
            }
            int[] nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
            this.callCompress(connection, "APP", string2, true, true, true, true);
            int[] nArray3 = this.getSpaceInfo(connection, "APP", string2, true);
            if (nArray3[1] != nArray2[1]) {
                this.log_wrong_count("Expected no alloc page change.", string2, nArray[i], nArray2[1], nArray3[1], nArray2, nArray3);
            }
            this.testProgress("no delete case complete.");
            nArray2 = this.getSpaceInfo(connection, "APP", string2, true);
            this.executeQuery(connection, "delete from " + string2, true);
            OnlineCompressTest.callWaitForPostCommit(connection);
            connection.commit();
            if (this.verbose) {
                this.testProgress("deleted all rows, now calling compress.");
            }
            this.callCompress(connection, "APP", string2, true, true, true, true);
            nArray3 = this.getSpaceInfo(connection, "APP", string2, true);
            if (nArray3[1] != 1) {
                this.log_wrong_count("Expected all pages to be truncated.", string2, nArray[i], 1, nArray3[1], nArray2, nArray3);
            }
            this.testProgress("delete all rows case succeeded.");
            this.testProgress("end simple deleteAllRows," + nArray[i] + " row test.");
            this.executeQuery(connection, "drop table " + string2, true);
        }
        this.endTest(connection, string);
    }

    private void test7(Connection connection, String string, String string2) throws SQLException {
        this.beginTest(connection, string);
        Statement statement = connection.createStatement();
        statement.execute("create table " + string2 + "(keycol int)");
        statement.close();
        PreparedStatement preparedStatement = connection.prepareStatement("insert into " + string2 + " values(?)");
        try {
            for (int i = 0; i < 1200; ++i) {
                preparedStatement.setInt(1, i);
                preparedStatement.execute();
            }
        }
        catch (SQLException sQLException) {
            System.out.println("Exception while trying to insert a row");
            throw sQLException;
        }
        connection.commit();
        this.executeQuery(connection, "delete from " + string2 + " where keycol < 1000", true);
        OnlineCompressTest.callWaitForPostCommit(connection);
        connection.commit();
        if (this.verbose) {
            this.testProgress("deleted first 1000 rows, now calling compress.");
        }
        this.callCompress(connection, "APP", string2, true, true, true, true);
        this.testProgress("delete rows case succeeded.");
        this.executeQuery(connection, "drop table " + string2, true);
        this.endTest(connection, string);
    }

    @Override
    public void testList(Connection connection) throws SQLException {
        this.test1(connection, "test1", "TEST1");
        this.test3(connection, "test3", "TEST3");
        this.test5(connection, "test5", "TEST5");
        this.test6(connection, "test6", "TEST6");
        this.test7(connection, "test7", "TEST7");
    }

    public static void callWaitForPostCommit(Connection connection) throws SQLException {
        CallableStatement callableStatement = connection.prepareCall("call wait_for_post_commit()");
        callableStatement.execute();
        callableStatement.close();
    }

    public static void main(String[] stringArray) throws Throwable {
        OnlineCompressTest onlineCompressTest = new OnlineCompressTest();
        ij.getPropertyArg((String[])stringArray);
        Connection connection = ij.startJBMS();
        Statement statement = connection.createStatement();
        statement.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
        connection.setAutoCommit(false);
        statement.close();
        try {
            onlineCompressTest.testList(connection);
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }
}

