/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LockTableVtiTest
extends BaseJDBCTestCase {
    private List<AsyncThread> threads = new ArrayList<AsyncThread>();

    public LockTableVtiTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.locks.waitTimeout", "60");
        Object object = TestConfiguration.defaultSuite(LockTableVtiTest.class);
        object = new DatabasePropertyTestSetup((Test)object, properties, true);
        return new CleanDatabaseTestSetup((Test)object);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("create table account (a int primary key not null, b int)");
        statement.executeUpdate("insert into account values (0,1)");
        statement.executeUpdate("insert into account values (1,1)");
        statement.executeUpdate("insert into account values (2,1)");
        statement.close();
        connection.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        block3: {
            this.rollback();
            for (AsyncThread asyncThread : this.threads) {
                asyncThread.waitFor();
            }
            this.threads = null;
            this.setAutoCommit(false);
            try {
                Statement statement = this.createStatement();
                statement.executeUpdate("drop table account");
                JDBC.dropSchema(this.getConnection().getMetaData(), "APP");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equalsIgnoreCase("42X05") || sQLException.getSQLState().equalsIgnoreCase("42Y55")) break block3;
                LockTableVtiTest.fail((String)"oops in teardown, encountered some other error than 'object does not exist' or 'cannot drop object because it doesn't exist'");
                sQLException.printStackTrace();
                sQLException.getMessage();
            }
        }
        super.tearDown();
    }

    public void testDisplayWaitState() throws Exception {
        Statement statement = this.createStatement();
        this.setAutoCommit(false);
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.locks.waitTimeout','-1')");
        BaseJDBCTestCase.assertUpdateCount(statement, 3, "update account set b = b + 11");
        final Barrier barrier = new Barrier(2);
        new AsyncThread(new AsyncTask(){

            @Override
            public void doWork(Connection connection) throws Exception {
                connection.setAutoCommit(false);
                Statement statement = connection.createStatement();
                statement.executeUpdate("update account set b = b + 11");
                statement.close();
                barrier.await();
            }
        });
        int n = 0;
        boolean bl = false;
        do {
            Thread.sleep(500L);
        } while (!(bl = this.getWaitState()) && (n += 500) < 6000);
        this.commit();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.locks.waitTimeout','5')");
        this.commit();
        barrier.await();
        LockTableVtiTest.assertTrue((String)"expected to find a 'WAIT' state, but did not", (boolean)bl);
        LockTableVtiTest.assertFalse((String)"expected to not find a 'WAIT' state, but did", (boolean)this.getWaitState());
    }

    private boolean getWaitState() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT state from syscs_diag.lock_table where state like 'WAIT' order by state");
        String string = "";
        try {
            resultSet.next();
            string = resultSet.getString(1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        resultSet.close();
        return string != null && string.length() > 0;
    }

    private class AsyncThread
    implements Runnable {
        private final Thread thread = new Thread(this);
        private final AsyncTask task;
        private Exception error;

        public AsyncThread(AsyncTask asyncTask) {
            this.task = asyncTask;
            this.thread.start();
            LockTableVtiTest.this.threads.add(this);
        }

        @Override
        public void run() {
            try {
                Connection connection = LockTableVtiTest.this.openDefaultConnection();
                try {
                    this.task.doWork(connection);
                }
                finally {
                    JDBC.cleanup(connection);
                }
            }
            catch (Exception exception) {
                this.error = exception;
            }
        }

        void waitFor() throws Exception {
            this.thread.join();
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    private static interface AsyncTask {
        public void doWork(Connection var1) throws Exception;
    }
}

