/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UDAPermsTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String TONY = "TONY";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK", "TONY"};
    private static final String MISSING_ROUTINE = "42Y03";
    private static final String IMPLICIT_CAST_ERROR = "42Y22";
    private static final String PARSE_ERROR = "42X01";
    private static final String BAD_DISTINCT = "42XAS";

    public UDAPermsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(UDAPermsTest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        Test test = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanDatabaseTestSetup, LEGAL_USERS, "udaPermissions");
        Test test2 = TestConfiguration.sqlAuthorizationDecorator(test);
        return test2;
    }

    public void test_001_basicGrant() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        Connection connection3 = this.openUserConnection(ALICE);
        this.goodStatement(connection2, "create derby aggregate mode_01 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection2, "create table mode_inputs_01( a int, b int )\n");
        this.goodStatement(connection2, "insert into mode_inputs_01( a, b ) values ( 1, 1 ), ( 1, 2 ), ( 1, 2 ), ( 1, 2 ), ( 2, 3 ), ( 2, 3 ), ( 2, 4 )\n");
        this.goodStatement(connection2, "grant select on mode_inputs_01 to public\n");
        this.expectExecutionError(connection3, "42504", "select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a\n");
        this.expectExecutionError(connection3, "42504", "create view v_alice_01( a, modeOfA ) as select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a\n");
        this.assertResults(connection, "select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.goodStatement(connection, "create view v_dbo_01( a, modeOfA ) as select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a\n");
        this.assertResults(connection, "select * from v_dbo_01", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.goodStatement(connection2, "grant usage on derby aggregate mode_01 to public\n");
        this.assertResults(connection3, "select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a", new String[][]{{"1", "2"}, {"2", "3"}}, false);
        this.goodStatement(connection3, "create view v_alice_01( a, modeOfA ) as select a, ruth.mode_01( b ) from ruth.mode_inputs_01 group by a\n");
        this.assertResults(connection3, "select * from v_alice_01", new String[][]{{"1", "2"}, {"2", "3"}}, false);
    }

    public void test_002_basicRevoke() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        Connection connection3 = this.openUserConnection(ALICE);
        this.goodStatement(connection2, "create derby aggregate mode_02 for int\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ModeAggregate'\n");
        this.goodStatement(connection2, "create table mode_inputs_02( a int, b int )\n");
        this.goodStatement(connection2, "grant select on mode_inputs_02 to public\n");
        this.goodStatement(connection2, "insert into mode_inputs_02( a, b ) values ( 1, 1 ), ( 1, 2 ), ( 1, 2 ), ( 1, 2 ), ( 2, 3 ), ( 2, 3 ), ( 2, 4 )\n");
        this.expectCompilationError(connection2, PARSE_ERROR, "revoke usage on derby aggregate mode_02 from ruth\n");
        this.expectCompilationError(connection2, "42509", "revoke usage on derby aggregate mode_02 from ruth restrict\n");
        String string = "grant usage on derby aggregate mode_02 to alice\n";
        String string2 = "revoke usage on derby aggregate mode_02 from alice restrict\n";
        String string3 = "create view v_alice_02( a, modeOfA ) as select a, ruth.mode_02( b ) from ruth.mode_inputs_02 group by a";
        String string4 = "drop view v_alice_02\n";
        String string5 = "X0Y23";
        this.verifyRevokePrivilege(connection2, connection3, string, string2, string3, string4, string5);
        this.goodStatement(connection3, "create table t_source_02( a int )\n");
        this.goodStatement(connection3, "create table t_target_02( a int )\n");
        string3 = "create trigger t_insert_trigger_02\nafter insert on t_source_02\nfor each row\ninsert into t_target_02( a ) select ruth.mode_02( b ) from ruth.mode_inputs_02\n";
        string4 = "drop trigger t_insert_trigger_02\n";
        string5 = "X0Y25";
        this.verifyRevokePrivilege(connection2, connection3, string, string2, string3, string4, string5);
    }

    public void test_003_typePrivs() throws Exception {
        Connection connection = this.openUserConnection(RUTH);
        Connection connection2 = this.openUserConnection(ALICE);
        this.goodStatement(connection, "create type Price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        String string = "grant usage on type Price to public";
        String string2 = "revoke usage on type Price from public restrict";
        String string3 = "create derby aggregate priceMode for ruth.Price\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'\n";
        String string4 = "drop derby aggregate priceMode restrict";
        String string5 = "X0Y30";
        this.verifyRevokePrivilege(connection, connection2, string, string2, string3, string4, string5);
        this.goodStatement(connection, "create type Price_input external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(connection, "create type Price_return external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(connection, "grant usage on type Price_return to public");
        string = "grant usage on type Price_input to public";
        string2 = "revoke usage on type Price_input from public restrict";
        string3 = "create derby aggregate priceMode for ruth.Price_input returns ruth.Price_return\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'\n";
        string4 = "drop derby aggregate priceMode restrict";
        string5 = "X0Y30";
        this.verifyRevokePrivilege(connection, connection2, string, string2, string3, string4, string5);
        this.goodStatement(connection, "create type Price_input_2 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(connection, "create type Price_return_2 external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java");
        this.goodStatement(connection, "grant usage on type Price_input_2 to public");
        string = "grant usage on type Price_return_2 to public";
        string2 = "revoke usage on type Price_return_2 from public restrict";
        string3 = "create derby aggregate priceMode for ruth.Price_input_2 returns ruth.Price_return_2\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.GenericMode'\n";
        string4 = "drop derby aggregate priceMode restrict";
        string5 = "X0Y30";
        this.verifyRevokePrivilege(connection, connection2, string, string2, string3, string4, string5);
    }

    public void test_004_emptySchema() throws Exception {
        Connection connection = this.openUserConnection(TONY);
        this.expectCompilationError(connection, MISSING_ROUTINE, "values toString( 100 )");
    }

    public void test_005_builtinAggregators() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        this.createSchema_005(connection2);
        this.vetStatsBuiltins_005(connection);
        this.vetStatsBuiltins_005(connection2);
        this.dropSchema_005(connection2);
    }

    private void vetStatsBuiltins_005(Connection connection) throws Exception {
        this.vetBuiltinAgg_005(connection, "var_pop", new String[][]{{"8.079999999999991"}}, (String[][])new String[][]{{"8.0"}});
        this.vetBuiltinAgg_005(connection, "var_samp", new String[][]{{"10.099999999999994"}}, (String[][])new String[][]{{"10.0"}});
        this.vetBuiltinAgg_005(connection, "stddev_pop", new String[][]{{"2.8425340807103776"}}, (String[][])new String[][]{{"2.8284271247461903"}});
        this.vetBuiltinAgg_005(connection, "stddev_samp", new String[][]{{"3.1780497164141397"}}, (String[][])new String[][]{{"3.1622776601683795"}});
    }

    private void vetBuiltinAgg_005(Connection connection, String string, String[][] stringArray, String[][] stringArray2) throws Exception {
        this.vetBuiltinAgg_005(connection, string, "doubles", stringArray);
        this.vetBuiltinAgg_005(connection, string, "floats", stringArray);
        this.vetBuiltinAgg_005(connection, string, "bigints", stringArray2);
        this.vetBuiltinAgg_005(connection, string, "ints", stringArray2);
        this.vetBuiltinAgg_005(connection, string, "smallints", stringArray2);
        this.vetBuiltinNegative_005(connection, string);
    }

    private void vetBuiltinAgg_005(Connection connection, String string, String string2, String[][] stringArray) throws Exception {
        this.assertResults(connection, "select " + string + "( a ) from ruth." + string2, stringArray, false);
    }

    private void vetBuiltinNegative_005(Connection connection, String string) throws Exception {
        this.expectCompilationError(connection, IMPLICIT_CAST_ERROR, "select " + string + "( a ) from ruth.varchars");
        this.expectCompilationError(connection, MISSING_ROUTINE, "select sys." + string + "( a ) from ruth.doubles");
        this.expectCompilationError(connection, PARSE_ERROR, "select " + string + "( all a ) from ruth.doubles");
        this.expectCompilationError(connection, BAD_DISTINCT, "select " + string + "( distinct a ) from ruth.doubles");
    }

    private void createSchema_005(Connection connection) throws Exception {
        this.goodStatement(connection, "create table doubles( a double )");
        this.goodStatement(connection, "insert into doubles values ( 1.2 ), ( 3.4 ), (5.6), (7.8), (9.0)");
        this.goodStatement(connection, "create table floats( a double )");
        this.goodStatement(connection, "insert into floats values ( 1.2 ), ( 3.4 ), (5.6), (7.8), (9.0)");
        this.goodStatement(connection, "create table bigints( a bigint )");
        this.goodStatement(connection, "insert into bigints values ( 1 ), ( 3 ), (5), (7), (9)");
        this.goodStatement(connection, "create table ints( a bigint )");
        this.goodStatement(connection, "insert into ints values ( 1 ), ( 3 ), (5), (7), (9)");
        this.goodStatement(connection, "create table smallints( a bigint )");
        this.goodStatement(connection, "insert into smallints values ( 1 ), ( 3 ), (5), (7), (9)");
        this.goodStatement(connection, "create table varchars( a varchar( 10 ) )");
        this.goodStatement(connection, "insert into varchars values ( '1' ), ( '3' ), ( '5' ), ( '7' ), ( '9' )");
    }

    private void dropSchema_005(Connection connection) throws Exception {
        this.goodStatement(connection, "drop table varchars");
        this.goodStatement(connection, "drop table smallints");
        this.goodStatement(connection, "drop table ints");
        this.goodStatement(connection, "drop table bigints");
        this.goodStatement(connection, "drop table floats");
        this.goodStatement(connection, "drop table doubles");
    }
}

