/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ScrollCursors2Test
extends BaseJDBCTestCase {
    private static boolean isDerbyNetClient = ScrollCursors2Test.usingDerbyNetClient();

    public ScrollCursors2Test(String string) {
        super(string);
    }

    public void setUp() throws SQLException {
        Statement statement = this.createStatement(1004, 1007);
        statement.execute("create table t (i int, c50 char(50))");
        statement.execute("insert into t (i) values (2), (3), (4), (5), (6)");
        statement.execute("update t set c50 = RTRIM(CAST (i AS CHAR(50)))");
        statement.close();
        isDerbyNetClient = ScrollCursors2Test.usingDerbyNetClient();
    }

    @Override
    public void tearDown() throws SQLException, Exception {
        this.dropTable("T");
        this.commit();
        super.tearDown();
    }

    public void testForwardOnlyNegative() throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        statement = this.createStatement(1003, 1007);
        JDBC.assertNoWarnings(connection.getWarnings());
        connection.clearWarnings();
        try {
            statement.setMaxRows(-1);
            ScrollCursors2Test.fail((String)"setMaxRows(-1) expected to fail");
        }
        catch (SQLException sQLException) {
            ScrollCursors2Test.assertEquals((String)"XJ063", (String)sQLException.getSQLState());
        }
        ScrollCursors2Test.assertEquals((String)"getMaxRows() expected to return 0", (int)0, (int)statement.getMaxRows());
        ResultSet resultSet = statement.executeQuery("select * from t");
        ScrollCursors2Test.assertEquals((int)1003, (int)resultSet.getType());
        ScrollCursors2Test.assertEquals((int)1007, (int)resultSet.getConcurrency());
        try {
            resultSet.first();
            ScrollCursors2Test.fail((String)"first() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        try {
            resultSet.beforeFirst();
            ScrollCursors2Test.fail((String)"beforeFirst() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        try {
            resultSet.isBeforeFirst();
            ScrollCursors2Test.fail((String)"isBeforeFirst() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        try {
            resultSet.isAfterLast();
            ScrollCursors2Test.fail((String)"isAfterLast() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        try {
            resultSet.isFirst();
            ScrollCursors2Test.fail((String)"isFirst() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        try {
            resultSet.isLast();
            ScrollCursors2Test.fail((String)"isLast() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        try {
            resultSet.absolute(1);
            ScrollCursors2Test.fail((String)"absolute() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        try {
            resultSet.relative(1);
            ScrollCursors2Test.fail((String)"relative() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        try {
            resultSet.setFetchDirection(1000);
            ScrollCursors2Test.fail((String)"setFetchDirection() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        if (isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((int)0, (int)resultSet.getFetchSize());
        } else {
            ScrollCursors2Test.assertEquals((int)1, (int)resultSet.getFetchSize());
        }
        resultSet.setFetchSize(5);
        ScrollCursors2Test.assertEquals((int)5, (int)resultSet.getFetchSize());
        ScrollCursors2Test.assertEquals((int)1000, (int)resultSet.getFetchDirection());
        resultSet.close();
        statement.close();
        preparedStatement = this.prepareStatement("select * from t", 1003, 1007);
        JDBC.assertNoWarnings(connection.getWarnings());
        connection.clearWarnings();
        resultSet = preparedStatement.executeQuery();
        ScrollCursors2Test.assertEquals((int)1003, (int)resultSet.getType());
        ScrollCursors2Test.assertEquals((int)1007, (int)resultSet.getConcurrency());
        try {
            resultSet.first();
            ScrollCursors2Test.fail((String)"first() expected to fail");
        }
        catch (SQLException sQLException) {
            this.assertOnlyOnScrollableException(sQLException);
        }
        resultSet.close();
        preparedStatement.close();
    }

    public void testForwardOnlyPositive() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement(1003, 1007);
        JDBC.assertNoWarnings(connection.getWarnings());
        connection.clearWarnings();
        statement.setMaxRows(5);
        ScrollCursors2Test.assertEquals((int)5, (int)statement.getMaxRows());
        ResultSet resultSet = statement.executeQuery("values 1, 2, 3, 4, 5, 6");
        JDBC.assertDrainResults(resultSet, 5);
        statement.close();
    }

    public void testScrollSensitive() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = null;
        Statement statement2 = null;
        statement = this.createStatement(1005, 1007);
        SQLWarning sQLWarning = connection.getWarnings();
        ScrollCursors2Test.assertNotNull((Object)sQLWarning);
        connection.clearWarnings();
        ResultSet resultSet = statement.executeQuery("select * from t");
        ScrollCursors2Test.assertEquals((int)1004, (int)resultSet.getType());
        ScrollCursors2Test.assertEquals((int)1007, (int)resultSet.getConcurrency());
        resultSet.close();
        statement.close();
        statement2 = this.createStatement(1005, 1008);
        sQLWarning = connection.getWarnings();
        ScrollCursors2Test.assertNotNull((Object)sQLWarning);
        connection.clearWarnings();
        resultSet = statement2.executeQuery("select * from t");
        ScrollCursors2Test.assertEquals((int)1004, (int)resultSet.getType());
        ScrollCursors2Test.assertEquals((int)1008, (int)resultSet.getConcurrency());
        resultSet.close();
    }

    public void testScrollInsensitivePositive() throws SQLException {
        int n;
        Connection connection = this.getConnection();
        Statement statement = this.createStatement(1004, 1007);
        JDBC.assertNoWarnings(connection.getWarnings());
        connection.clearWarnings();
        ResultSet resultSet = statement.executeQuery("select * from t");
        ScrollCursors2Test.assertEquals((int)1004, (int)resultSet.getType());
        ScrollCursors2Test.assertEquals((int)1007, (int)resultSet.getConcurrency());
        ScrollCursors2Test.assertTrue((boolean)resultSet.isBeforeFirst());
        ScrollCursors2Test.assertFalse((boolean)resultSet.absolute(0));
        ScrollCursors2Test.assertTrue((boolean)resultSet.isBeforeFirst());
        ScrollCursors2Test.assertTrue((boolean)resultSet.first());
        ScrollCursors2Test.assertEquals((int)resultSet.getInt(1), (int)2);
        ScrollCursors2Test.assertTrue((boolean)resultSet.isFirst());
        resultSet.beforeFirst();
        ScrollCursors2Test.assertTrue((boolean)resultSet.isBeforeFirst());
        ScrollCursors2Test.assertTrue((boolean)resultSet.last());
        ScrollCursors2Test.assertTrue((boolean)resultSet.isLast());
        ScrollCursors2Test.assertFalse((boolean)resultSet.isAfterLast());
        ScrollCursors2Test.assertEquals((int)6, (int)resultSet.getInt(1));
        ScrollCursors2Test.assertFalse((String)"not expecting to find another row", (boolean)resultSet.next());
        ScrollCursors2Test.assertTrue((boolean)resultSet.isAfterLast());
        ScrollCursors2Test.assertFalse((boolean)resultSet.isLast());
        ScrollCursors2Test.assertFalse((boolean)resultSet.isFirst());
        ScrollCursors2Test.assertFalse((boolean)resultSet.isBeforeFirst());
        ScrollCursors2Test.assertEquals((int)1000, (int)resultSet.getFetchDirection());
        resultSet.setFetchDirection(1002);
        ScrollCursors2Test.assertEquals((int)1002, (int)resultSet.getFetchDirection());
        if (isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((int)64, (int)resultSet.getFetchSize());
        } else {
            ScrollCursors2Test.assertEquals((int)1, (int)resultSet.getFetchSize());
        }
        resultSet.setFetchSize(5);
        ScrollCursors2Test.assertEquals((int)5, (int)resultSet.getFetchSize());
        resultSet.setFetchSize(0);
        if (isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((int)64, (int)resultSet.getFetchSize());
        } else {
            ScrollCursors2Test.assertEquals((int)5, (int)resultSet.getFetchSize());
        }
        resultSet.close();
        resultSet = statement.executeQuery("select * from t where 1=0");
        resultSet.afterLast();
        ScrollCursors2Test.assertFalse((String)"afterLast() on empty RS should be no-op", (boolean)resultSet.isAfterLast());
        resultSet.beforeFirst();
        ScrollCursors2Test.assertFalse((String)"beforeFirst() on empty RS should be no-op", (boolean)resultSet.isBeforeFirst());
        resultSet.close();
        PreparedStatement preparedStatement = this.prepareStatement("select * from t", 1004, 1007);
        JDBC.assertNoWarnings(connection.getWarnings());
        resultSet = preparedStatement.executeQuery();
        resultSet.last();
        resultSet.close();
        preparedStatement.close();
        ScrollCursors2Test.assertEquals((int)0, (int)statement.getMaxRows());
        statement.setMaxRows(5);
        ScrollCursors2Test.assertEquals((int)5, (int)statement.getMaxRows());
        resultSet = statement.executeQuery("values 1, 2, 3, 4, 5, 6");
        ScrollCursors2Test.assertNotNull((Object)resultSet);
        for (n = 1; n < 6; ++n) {
            ScrollCursors2Test.assertTrue((boolean)resultSet.next());
        }
        ScrollCursors2Test.assertFalse((boolean)resultSet.next());
        resultSet.close();
        resultSet = statement.executeQuery("values 1, 2, 3, 4, 5, 6");
        ScrollCursors2Test.assertNotNull((Object)resultSet);
        ScrollCursors2Test.assertTrue((boolean)resultSet.last());
        for (n = 1; n < 5; ++n) {
            ScrollCursors2Test.assertTrue((boolean)resultSet.previous());
        }
        ScrollCursors2Test.assertFalse((boolean)resultSet.previous());
        resultSet.close();
        resultSet = statement.executeQuery("values 1, 2, 3, 4, 5, 6");
        ScrollCursors2Test.assertNotNull((Object)resultSet);
        resultSet.afterLast();
        for (n = 1; n < 6; ++n) {
            ScrollCursors2Test.assertTrue((boolean)resultSet.previous());
        }
        ScrollCursors2Test.assertFalse((boolean)resultSet.previous());
        resultSet.close();
        statement.setMaxRows(0);
        resultSet = statement.executeQuery("values 1, 2, 3, 4, 5, 6");
        ScrollCursors2Test.assertNotNull((Object)resultSet);
        for (n = 1; n < 7; ++n) {
            ScrollCursors2Test.assertTrue((boolean)resultSet.next());
        }
        ScrollCursors2Test.assertFalse((boolean)resultSet.next());
        resultSet.close();
    }

    public void testScrollInsensitiveNegative() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = this.createStatement(1004, 1007);
        JDBC.assertNoWarnings(connection.getWarnings());
        connection.clearWarnings();
        try {
            statement.setMaxRows(-1);
            ScrollCursors2Test.fail((String)"setMaxRows(-1) expected to fail");
        }
        catch (SQLException sQLException) {
            ScrollCursors2Test.assertEquals((String)"XJ063", (String)sQLException.getSQLState());
        }
        ScrollCursors2Test.assertEquals((int)0, (int)statement.getMaxRows());
        ResultSet resultSet = statement.executeQuery("select * from t where 1=0");
        ScrollCursors2Test.assertFalse((boolean)resultSet.isBeforeFirst());
        ScrollCursors2Test.assertFalse((boolean)resultSet.next());
        ScrollCursors2Test.assertFalse((boolean)resultSet.previous());
        ScrollCursors2Test.assertFalse((boolean)resultSet.isAfterLast());
        ScrollCursors2Test.assertFalse((boolean)resultSet.isFirst());
        ScrollCursors2Test.assertFalse((boolean)resultSet.isLast());
        ScrollCursors2Test.assertFalse((boolean)resultSet.relative(0));
        ScrollCursors2Test.assertFalse((boolean)resultSet.relative(1));
        ScrollCursors2Test.assertFalse((boolean)resultSet.relative(-1));
        ScrollCursors2Test.assertFalse((boolean)resultSet.absolute(0));
        ScrollCursors2Test.assertFalse((boolean)resultSet.absolute(1));
        ScrollCursors2Test.assertFalse((boolean)resultSet.absolute(-1));
        resultSet.close();
        resultSet = statement.executeQuery("select * from t");
        try {
            resultSet.setFetchSize(-5);
            ScrollCursors2Test.fail((String)"setFetchSize(-5) expected to fail");
        }
        catch (SQLException sQLException) {
            ScrollCursors2Test.assertEquals((String)"XJ062", (String)sQLException.getSQLState());
        }
        resultSet.close();
        statement.close();
    }

    public void testCallableStatements() throws SQLException {
        Connection connection = this.getConnection();
        CallableStatement callableStatement = null;
        CallableStatement callableStatement2 = null;
        CallableStatement callableStatement3 = null;
        CallableStatement callableStatement4 = null;
        callableStatement = this.prepareCall("values cast (? as Integer)", 1005, 1007);
        SQLWarning sQLWarning = connection.getWarnings();
        ScrollCursors2Test.assertNotNull((Object)sQLWarning);
        if (!isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((String)"01J02", (String)sQLWarning.getSQLState());
        } else {
            ScrollCursors2Test.assertEquals((String)"01J10", (String)sQLWarning.getSQLState());
        }
        JDBC.assertNoWarnings(sQLWarning.getNextWarning());
        connection.clearWarnings();
        callableStatement.close();
        callableStatement2 = this.prepareCall("values cast (? as Integer)", 1005, 1008);
        sQLWarning = connection.getWarnings();
        ScrollCursors2Test.assertNotNull((Object)sQLWarning);
        if (!isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((String)"01J02", (String)sQLWarning.getSQLState());
        } else {
            ScrollCursors2Test.assertEquals((String)"01J10", (String)sQLWarning.getSQLState());
        }
        JDBC.assertNoWarnings(sQLWarning.getNextWarning());
        connection.clearWarnings();
        callableStatement2.close();
        callableStatement3 = this.prepareCall("values cast (? as Integer)", 1004, 1007);
        JDBC.assertNoWarnings(connection.getWarnings());
        connection.clearWarnings();
        callableStatement3.close();
        callableStatement4 = this.prepareCall("values cast (? as Integer)", 1003, 1007);
        JDBC.assertNoWarnings(connection.getWarnings());
        connection.clearWarnings();
        callableStatement4.close();
    }

    public void testGetMetaData() throws SQLException {
        PreparedStatement preparedStatement = null;
        preparedStatement = this.prepareStatement("select c50, i, 43 from t", 1003, 1007);
        ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
        ScrollCursors2Test.assertNotNull((Object)resultSetMetaData);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData2 = resultSet.getMetaData();
        ScrollCursors2Test.assertNotNull((Object)resultSetMetaData2);
        ScrollCursors2Test.assertEquals((int)resultSetMetaData.getColumnCount(), (int)resultSetMetaData2.getColumnCount());
        ScrollCursors2Test.assertEquals((String)resultSetMetaData.getColumnName(2), (String)resultSetMetaData2.getColumnName(2));
        ScrollCursors2Test.assertEquals((boolean)resultSetMetaData.isReadOnly(2), (boolean)resultSetMetaData2.isReadOnly(2));
        resultSet.close();
        preparedStatement.close();
    }

    public void testScrollVerifyMaxRowWithFetchSize() throws SQLException {
        this.scrollVerifyMaxRowWithFetchSize(10, 10);
        this.scrollVerifyMaxRowWithFetchSize(10, 5);
        this.scrollVerifyMaxRowWithFetchSize(10, 0);
        this.scrollVerifyMaxRowWithFetchSize(0, 0);
        this.scrollVerifyMaxRowWithFetchSize(0, 5);
        this.scrollVerifyMaxRowWithFetchSize(0, 10);
        this.scrollVerifyMaxRowWithFetchSize(0, 15);
    }

    private void scrollVerifyMaxRowWithFetchSize(int n, int n2) throws SQLException {
        int n3;
        Statement statement = this.createStatement(1004, 1007);
        statement.setMaxRows(n);
        ResultSet resultSet = statement.executeQuery("values 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15");
        resultSet.setFetchSize(n2);
        statement.setMaxRows(2);
        if (n == 0) {
            n = 15;
        }
        ScrollCursors2Test.assertNotNull((Object)resultSet);
        for (n3 = 1; n3 < n + 1; ++n3) {
            ScrollCursors2Test.assertTrue((String)("rs.next() failed, index = " + n3), (boolean)resultSet.next());
            ScrollCursors2Test.assertEquals((int)n3, (int)resultSet.getInt(1));
        }
        ScrollCursors2Test.assertFalse((boolean)resultSet.next());
        ScrollCursors2Test.assertTrue((boolean)resultSet.first());
        for (n3 = 1; n3 < n; ++n3) {
            ScrollCursors2Test.assertTrue((boolean)resultSet.next());
            ScrollCursors2Test.assertEquals((int)(n3 + 1), (int)resultSet.getInt(1));
        }
        ScrollCursors2Test.assertFalse((boolean)resultSet.next());
        resultSet.afterLast();
        for (n3 = 1; n3 < n + 1; ++n3) {
            ScrollCursors2Test.assertTrue((boolean)resultSet.previous());
            ScrollCursors2Test.assertEquals((int)(n - n3 + 1), (int)resultSet.getInt(1));
        }
        ScrollCursors2Test.assertFalse((boolean)resultSet.previous());
        ScrollCursors2Test.assertTrue((boolean)resultSet.last());
        for (n3 = 1; n3 < n; ++n3) {
            ScrollCursors2Test.assertTrue((boolean)resultSet.previous());
            ScrollCursors2Test.assertEquals((int)(n - n3), (int)resultSet.getInt(1));
        }
        ScrollCursors2Test.assertFalse((boolean)resultSet.previous());
        resultSet.last();
        n3 = resultSet.getRow();
        resultSet.absolute(n3 / 2);
        ScrollCursors2Test.assertFalse((boolean)resultSet.relative(-1 * n3));
        ScrollCursors2Test.assertTrue((boolean)resultSet.isBeforeFirst());
        resultSet.absolute(n3 / 2);
        ScrollCursors2Test.assertFalse((boolean)resultSet.relative(n3));
        ScrollCursors2Test.assertTrue((boolean)resultSet.isAfterLast());
        resultSet.absolute(n3 / 2);
        ScrollCursors2Test.assertFalse((String)("absolute(" + (n3 + 1) + ") should return false, position outside of the resultSet"), (boolean)resultSet.absolute(n3 + 1));
        resultSet.absolute(n3 / 2);
        ScrollCursors2Test.assertFalse((boolean)resultSet.absolute(-1 * (n3 + 1)));
        ScrollCursors2Test.assertTrue((boolean)resultSet.isBeforeFirst());
        resultSet.close();
    }

    private void assertOnlyOnScrollableException(SQLException sQLException) {
        if (!isDerbyNetClient) {
            ScrollCursors2Test.assertEquals((String)"XJ061", (String)sQLException.getSQLState());
        } else {
            ScrollCursors2Test.assertEquals((String)"XJ125", (String)sQLException.getSQLState());
        }
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ScrollCursors2Test.class);
    }
}

