/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LazyDefaultSchemaCreationTest
extends BaseJDBCTestCase {
    private static final String LOCK_TIMEOUT = "40XL1";

    public LazyDefaultSchemaCreationTest(String string) {
        super(string);
    }

    public void testDerby48testNewSchemaHang() throws SQLException {
        Connection connection = this.openUserConnection("newuser");
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table t1(i int)");
        statement.close();
        Connection connection2 = null;
        try {
            connection2 = this.openUserConnection("newuser");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals(LOCK_TIMEOUT)) {
                connection.rollback();
                connection.close();
                LazyDefaultSchemaCreationTest.fail("DERBY-48 still seen", sQLException);
            }
            throw sQLException;
        }
        connection.rollback();
        JDBC.assertSingleValueResultSet(connection.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='NEWUSER'"), "NEWUSER");
        connection.rollback();
        connection.close();
        connection2.close();
    }

    public void testDerby48SelfLockingRecovery() throws SQLException {
        Connection connection = this.openUserConnection("newuser");
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(8);
        Statement statement = connection.createStatement();
        statement.executeQuery("select count(*) from sys.sysschemas");
        statement.executeUpdate("create table t1(i int)");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select schemaname from sys.sysschemas where schemaname='NEWUSER'"), "NEWUSER");
        connection.rollback();
        JDBC.assertEmpty(statement.executeQuery("select * from sys.sysschemas where schemaname='NEWUSER'"));
        connection.rollback();
    }

    public void testDerby48SelfLockingRecoveryDeadlockDetectionOn() throws SQLException {
        Connection connection = this.openUserConnection("newuser");
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(8);
        Statement statement = connection.createStatement();
        statement.executeQuery("select count(*) from sys.sysschemas");
        try {
            statement.executeUpdate("create table t1(i int)");
            LazyDefaultSchemaCreationTest.fail((String)"Expected exception 40XL1");
        }
        catch (SQLException sQLException) {
            LazyDefaultSchemaCreationTest.assertSQLState("Expected state: ", LOCK_TIMEOUT, sQLException);
        }
        JDBC.assertEmpty(statement.executeQuery("select * from sys.sysschemas where schemaname='NEWUSER'"));
        connection.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby3678() throws SQLException {
        Connection connection = this.openUserConnection("newuser");
        Connection connection2 = null;
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.executeUpdate("create schema newuser");
        statement.executeUpdate("create table t(i int)");
        try {
            connection2 = this.openUserConnection("newuser");
            LazyDefaultSchemaCreationTest.fail((String)"Expected exception 40XL1");
        }
        catch (SQLException sQLException) {
            LazyDefaultSchemaCreationTest.assertSQLState("Expected state: ", LOCK_TIMEOUT, sQLException);
        }
        finally {
            connection.rollback();
        }
    }

    public void testOtherImplicitSchemaCreation() throws SQLException {
        Connection connection = this.openUserConnection("newuser");
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table otherschema.t1(i int)");
        statement.close();
        JDBC.assertSingleValueResultSet(connection.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='OTHERSCHEMA'"), "OTHERSCHEMA");
        connection.rollback();
        JDBC.assertEmpty(connection.createStatement().executeQuery("select schemaname from sys.sysschemas where schemaname='OTHERSCHEMA'"));
        connection.rollback();
        connection.close();
    }

    public void testDerby3043CheckConstraint() throws SQLException {
        Connection connection = this.openUserConnection("frogs");
        Statement statement = connection.createStatement();
        JDBC.assertEmpty(statement.executeQuery("select * from sys.sysschemas where schemaname='FROGS'"));
        JDBC.assertEmpty(statement.executeQuery("select * from sys.sysschemas where schemaname='NOSUCH'"));
        statement.executeUpdate("create table frogs.users2(username varchar(16) CHECK(LENGTH(username)>7))");
        statement.executeUpdate("create table nosuch.users(username varchar(16) CHECK(LENGTH(username)>7))");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select schemaname from sys.sysschemas where schemaname='FROGS'"), "FROGS");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select schemaname from sys.sysschemas where schemaname='NOSUCH'"), "NOSUCH");
        connection.close();
        Connection connection2 = this.openUserConnection("blogs");
        Statement statement2 = connection2.createStatement();
        JDBC.assertEmpty(statement2.executeQuery("select * from sys.sysschemas where schemaname='BLOGS'"));
        statement2.executeUpdate("create table users(username varchar(16) CHECK(LENGTH(username)>7))");
        statement2.executeUpdate("CREATE TABLE BLOGSCOM__BLOGS__USERS(PK INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY,username VARCHAR(16) NOT NULL   CONSTRAINT BLOGSCOM__BLOGS__USERS_UNIQUE_username UNIQUE   CONSTRAINT BLOGSCOM__BLOGS__USERS_PASSWORD_username     CHECK(LENGTH(username)>7),password VARCHAR (32672) NOT NULL , PRIMARY KEY(PK))");
        JDBC.assertSingleValueResultSet(statement2.executeQuery("select schemaname from sys.sysschemas where schemaname='BLOGS'"), "BLOGS");
        connection2.close();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.createStatement().executeUpdate("drop schema newuser restrict");
        }
        catch (SQLException sQLException) {
            LazyDefaultSchemaCreationTest.assertSQLState("Expected state: ", "42Y07", sQLException);
        }
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("LazyDefaultSchemaCreationTest");
        BaseTestSuite[] baseTestSuiteArray = new BaseTestSuite[]{new BaseTestSuite("LazyDefaultSchemaCreationTest:embedded"), new BaseTestSuite("LazyDefaultSchemaCreationTest:clientServer")};
        for (int i = 0; i < 2; ++i) {
            baseTestSuiteArray[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new LazyDefaultSchemaCreationTest("testDerby48testNewSchemaHang"), 2, 1));
            baseTestSuiteArray[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new LazyDefaultSchemaCreationTest("testDerby48SelfLockingRecovery"), 2, 1));
            Properties properties = new Properties();
            properties.setProperty("derby.locks.deadlockTrace", "true");
            baseTestSuiteArray[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new DatabasePropertyTestSetup((Test)new LazyDefaultSchemaCreationTest("testDerby48SelfLockingRecoveryDeadlockDetectionOn"), properties, false), 2, 1));
            baseTestSuiteArray[i].addTest(DatabasePropertyTestSetup.setLockTimeouts((Test)new DatabasePropertyTestSetup((Test)new LazyDefaultSchemaCreationTest("testDerby3678"), properties, false), 2, 1));
            baseTestSuiteArray[i].addTest((Test)new CleanDatabaseTestSetup((Test)new LazyDefaultSchemaCreationTest("testDerby3043CheckConstraint")));
            if (i == 0) {
                baseTestSuite.addTest((Test)baseTestSuiteArray[i]);
                continue;
            }
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)baseTestSuiteArray[i]));
        }
        return baseTestSuite;
    }
}

