/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBC4FromJDBC3DataSourceTest
extends BaseJDBCTestCase {
    public JDBC4FromJDBC3DataSourceTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC4() && JDBC.vmSupportsJNDI()) {
            return TestConfiguration.forceJDBC3Suite(JDBC4FromJDBC3DataSourceTest.class);
        }
        return new BaseTestSuite("JDBC 4 from JDBC 3 Data Sources");
    }

    public void testPooledConnection() throws Exception {
        ConnectionPoolDataSource connectionPoolDataSource = J2EEDataSource.getConnectionPoolDataSource();
        this.checkJDBC4Interface(connectionPoolDataSource.getPooledConnection());
    }

    public void testXAConnection() throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        this.checkJDBC4Interface(xADataSource.getXAConnection());
    }

    private void checkJDBC4Interface(PooledConnection pooledConnection) throws Exception {
        StatementEventListener statementEventListener = new StatementEventListener(this){

            @Override
            public void statementClosed(StatementEvent statementEvent) {
            }

            @Override
            public void statementErrorOccurred(StatementEvent statementEvent) {
            }
        };
        Connection connection = pooledConnection.getConnection();
        JDBC4FromJDBC3DataSourceTest.assertEquals((int)4, (int)connection.getMetaData().getJDBCMajorVersion());
        connection.close();
        connection = null;
        pooledConnection.addStatementEventListener(statementEventListener);
        pooledConnection.removeStatementEventListener(statementEventListener);
        pooledConnection.close();
    }
}

