/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;

public class CallableStatementTestSetup
extends BaseJDBCTestSetup {
    private static final String SOURCECLASS = "org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup.";
    private static final String[] TABLE_DROPS = new String[]{"CSDATA"};
    private static final String[] FUNCTION_DROPS = new String[]{"INT_TO_STRING", "GET_BINARY_DB", "GET_VARCHAR_DB"};
    private static final String[] PROCEDURE_DROPS = new String[]{"GET_BINARY_DIRECT"};
    public static final int STRING_BYTES_ID = 1;
    public static final String STRING_BYTES = "This is a string, converted to bytes and inserted into the database";
    public static final int SQL_NULL_ID = 2;

    public CallableStatementTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("CREATE TABLE CSDATA (ID INT PRIMARY KEY,BINARYDATA VARCHAR(256) FOR BIT DATA, CHARDATA VARCHAR(256))");
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO CSDATA VALUES (?,?,?)");
        preparedStatement.setInt(1, 1);
        try {
            preparedStatement.setBytes(2, STRING_BYTES.getBytes("UTF-16BE"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException(unsupportedEncodingException.getMessage());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
        preparedStatement.setString(3, STRING_BYTES);
        preparedStatement.execute();
        preparedStatement.setInt(1, 2);
        preparedStatement.setNull(2, -3);
        preparedStatement.setNull(3, 12);
        preparedStatement.execute();
        preparedStatement.close();
        statement.execute("CREATE FUNCTION INT_TO_STRING(INTNUM INT) RETURNS VARCHAR(10) PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'java.lang.Integer.toString'");
        statement.execute("CREATE PROCEDURE GET_BINARY_DIRECT(IN INSTRING VARCHAR(40), OUT OUTBYTES VARCHAR(160) FOR BIT DATA) DYNAMIC RESULT SETS 0 PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup.getBinaryDirect'");
        statement.execute("CREATE FUNCTION GET_BINARY_DB(ID INT) RETURNS VARCHAR(256) FOR BIT DATA PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup.getBinaryFromDb'");
        statement.execute("CREATE FUNCTION GET_VARCHAR_DB(ID INT) RETURNS VARCHAR(256) PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup.getVarcharFromDb'");
        statement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        for (String string : FUNCTION_DROPS) {
            statement.execute("DROP FUNCTION " + string);
        }
        for (String string : PROCEDURE_DROPS) {
            statement.execute("DROP PROCEDURE " + string);
        }
        for (String string : TABLE_DROPS) {
            statement.execute("DROP TABLE " + string);
        }
        statement.close();
        super.tearDown();
    }

    public static CallableStatement getIntToStringFunction(Connection connection) throws SQLException {
        Assert.assertNotNull((String)"Connection cannot be null", (Object)connection);
        CallableStatement callableStatement = connection.prepareCall("?= CALL INT_TO_STRING(?)");
        callableStatement.registerOutParameter(1, 12);
        return callableStatement;
    }

    public static CallableStatement getBinaryDirectProcedure(Connection connection) throws SQLException {
        Assert.assertNotNull((String)"Connection cannot be null", (Object)connection);
        CallableStatement callableStatement = connection.prepareCall("CALL GET_BINARY_DIRECT(?,?)");
        callableStatement.registerOutParameter(2, -3);
        return callableStatement;
    }

    public static CallableStatement getBinaryFromDbFunction(Connection connection) throws SQLException {
        Assert.assertNotNull((String)"Connection cannot be null", (Object)connection);
        CallableStatement callableStatement = connection.prepareCall("?= CALL GET_BINARY_DB(?)");
        callableStatement.registerOutParameter(1, -3);
        return callableStatement;
    }

    public static CallableStatement getVarcharFromDbFunction(Connection connection) throws SQLException {
        Assert.assertNotNull((String)"Connection cannot be null", (Object)connection);
        CallableStatement callableStatement = connection.prepareCall("?= CALL GET_VARCHAR_DB(?)");
        callableStatement.registerOutParameter(1, 12);
        return callableStatement;
    }

    public static void getBinaryDirect(String string, byte[][] byArray) {
        try {
            byArray[0] = string.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray[0] = new byte[0];
        }
    }

    public static byte[] getBinaryFromDb(int n) throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT BINARYDATA FROM CSDATA WHERE ID = " + n);
        resultSet.next();
        byte[] byArray = resultSet.getBytes(1);
        resultSet.close();
        statement.close();
        connection.close();
        return byArray;
    }

    public static String getVarcharFromDb(int n) throws Exception {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT CHARDATA FROM CSDATA WHERE ID = " + n);
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        statement.close();
        connection.close();
        return string;
    }
}

