/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.compatibility;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.regex.Pattern;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.compatibility.AbstractCompatibilityTest;
import org.apache.derbyTesting.functionTests.tests.compatibility.helpers.DummyBlob;
import org.apache.derbyTesting.functionTests.tests.compatibility.helpers.DummyClob;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DerbyVersion;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBCDriverTest
extends AbstractCompatibilityTest {
    private static final String ALL_TYPES_TABLE = "allTypesTable";
    private static final String KEY_COLUMN = "keyCol";
    private static final byte[] SAMPLE_BYTES = new byte[]{1, 2, 3, 4, 5};
    private static final String SAMPLE_STRING = "hello";
    private static final boolean Y = true;
    private static final boolean n = false;
    private static final TypeDescriptor[] ALL_TYPES = new TypeDescriptor[]{new TypeDescriptor(-5, "bigint", DerbyVersion._10_0), new TypeDescriptor(2004, "blob", DerbyVersion._10_0), new TypeDescriptor(1, "char(5)", DerbyVersion._10_0), new TypeDescriptor(-2, "char(5) for bit data", DerbyVersion._10_0), new TypeDescriptor(2005, "clob", DerbyVersion._10_0), new TypeDescriptor(91, "date", DerbyVersion._10_0), new TypeDescriptor(3, "decimal", DerbyVersion._10_0), new TypeDescriptor(8, "double", DerbyVersion._10_0), new TypeDescriptor(8, "double precision", DerbyVersion._10_0), new TypeDescriptor(7, "float(23)", DerbyVersion._10_0), new TypeDescriptor(8, "float", DerbyVersion._10_0), new TypeDescriptor(4, "integer", DerbyVersion._10_0), new TypeDescriptor(-1, "long varchar", DerbyVersion._10_0), new TypeDescriptor(-4, "long varchar for bit data", DerbyVersion._10_0), new TypeDescriptor(2, "numeric", DerbyVersion._10_0), new TypeDescriptor(7, "real", DerbyVersion._10_0), new TypeDescriptor(5, "smallint", DerbyVersion._10_0), new TypeDescriptor(92, "time", DerbyVersion._10_0), new TypeDescriptor(93, "timestamp", DerbyVersion._10_0), new TypeDescriptor(12, "varchar(5)", DerbyVersion._10_0), new TypeDescriptor(-3, "varchar(5) for bit data", DerbyVersion._10_0)};
    private static final Object[] ROW_1 = new Object[]{1L, new DummyBlob(SAMPLE_BYTES), "hello", SAMPLE_BYTES, new DummyClob("hello"), new Date(1L), new BigDecimal(1.0), 1.0, 1.0, Float.valueOf(1.0f), 1.0, 1, "hello", SAMPLE_BYTES, new BigDecimal(1.0), Float.valueOf(1.0f), (short)1, new Time(1L), new Timestamp(1L), "hello", SAMPLE_BYTES};
    private static final T_CN[] COERCIONS = new T_CN[]{new T_CN(-5, new boolean[]{true, false, true, false, false, false, false, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(2004, new boolean[]{false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(1, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-2, new boolean[]{false, false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true}), new T_CN(2005, new boolean[]{false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(91, new boolean[]{false, false, false, false, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false}), new T_CN(3, new boolean[]{true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(8, new boolean[]{true, false, false, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(7, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(4, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(-1, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-4, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true}), new T_CN(2, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(7, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(5, new boolean[]{true, false, true, false, false, false, true, true, true, true, true, false, true, true, true, false, false, true, false}), new T_CN(92, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}), new T_CN(93, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false}), new T_CN(12, new boolean[]{false, false, true, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true, false}), new T_CN(-3, new boolean[]{false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, true})};
    private static HashMap<String, TypeDescriptor> _types = new HashMap();
    private static HashMap<Integer, Integer> _coercionIndex = new HashMap();
    private static Pattern DERBY_5449_PATTERN = Pattern.compile("^10\\.8\\.([01]\\.|2\\.[012] ).*");

    public JDBCDriverTest(String string) {
        super(string);
    }

    public void testSanity() {
        JDBCDriverTest.assertEquals((String)"ALL_TYPES.length == ROW_1.length", (int)ALL_TYPES.length, (int)ROW_1.length);
        int n = COERCIONS.length;
        for (int i = 0; i < n; ++i) {
            JDBCDriverTest.assertEquals((String)("Coercion " + i), (int)n, (int)COERCIONS[i].getCoercions().length);
        }
    }

    public void testVerifyVersions() throws SQLException {
        DerbyVersion derbyVersion = this.getServerVersion();
        DerbyVersion derbyVersion2 = this.getDriverVersion();
        JDBCDriverTest.println("server=" + derbyVersion.toString() + " <-> client=" + derbyVersion2.toString());
        String string = JDBCDriverTest.getSystemProperty("derby.tests.compat.expectedServer");
        String string2 = JDBCDriverTest.getSystemProperty("derby.tests.compat.expectedClient");
        JDBCDriverTest.assertNotNull((String)"expected server property missing", (Object)string);
        JDBCDriverTest.assertNotNull((String)"expected client property missing", (Object)string2);
        DerbyVersion derbyVersion3 = DerbyVersion.parseVersionString(string);
        DerbyVersion derbyVersion4 = DerbyVersion.parseVersionString(string2);
        JDBCDriverTest.assertEquals((String)"server version mismatch", (Object)derbyVersion3, (Object)derbyVersion);
        JDBCDriverTest.assertEquals((String)"client version mismatch", (Object)derbyVersion4, (Object)derbyVersion2);
    }

    public void testDataTypesCompatibility() throws SQLException {
        this.datatypesTest();
    }

    public void testDerby4613(Connection connection) throws Exception {
        boolean bl = this.getServerVersion().atLeast(DerbyVersion._10_7) && this.getDriverVersion().atLeast(DerbyVersion._10_7);
        JDBCDriverTest.println("derby_4613_test correctBehavior = " + bl);
        this.vet_isindex_column(bl, "SYSTABLES_HEAP", false);
        this.vet_isindex_column(bl, "SYSTABLES_INDEX1", true);
    }

    private void vet_isindex_column(boolean bl, String string, boolean bl2) throws Exception {
        String string2;
        PreparedStatement preparedStatement = this.prepareStatement("select isindex from sys.sysconglomerates where conglomeratename = ?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = bl ? 16 : 5;
        String string3 = bl ? "BOOLEAN" : "SMALLINT";
        int n2 = bl ? 1 : 5;
        int n3 = 0;
        int n4 = bl ? 5 : 6;
        String string4 = string2 = bl ? "java.lang.Boolean" : "java.lang.Integer";
        Comparable<Boolean> comparable = bl ? (Comparable<Boolean>)Boolean.valueOf(bl2) : (Comparable<Boolean>)Integer.valueOf(bl2 ? 1 : 0);
        String string5 = ((Object)comparable).toString();
        JDBCDriverTest.assertEquals((int)n, (int)resultSetMetaData.getColumnType(1));
        JDBCDriverTest.assertEquals((String)string3, (String)resultSetMetaData.getColumnTypeName(1));
        JDBCDriverTest.assertEquals((int)n2, (int)resultSetMetaData.getPrecision(1));
        JDBCDriverTest.assertEquals((int)n3, (int)resultSetMetaData.getScale(1));
        JDBCDriverTest.assertEquals((int)n4, (int)resultSetMetaData.getColumnDisplaySize(1));
        JDBCDriverTest.assertEquals((String)string2, (String)resultSetMetaData.getColumnClassName(1));
        JDBCDriverTest.assertEquals((boolean)true, (boolean)resultSet.next());
        JDBCDriverTest.assertEquals((boolean)bl2, (boolean)resultSet.getBoolean(1));
        JDBCDriverTest.assertEquals((Object)comparable, (Object)resultSet.getObject(1));
        JDBCDriverTest.assertEquals((String)string5, (String)resultSet.getString(1));
        resultSet.close();
        preparedStatement.close();
    }

    public void testDerby2602() throws SQLException {
        boolean bl = this.getServerVersion().atLeast(DerbyVersion._10_6) && this.getDriverVersion().atLeast(DerbyVersion._10_6);
        Timestamp timestamp = Timestamp.valueOf("2004-02-14 17:14:24.976255123");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t_2602( a ) values ( ? )");
        preparedStatement.setTimestamp(1, timestamp);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.prepareStatement("select a from t_2602");
        ResultSet resultSet = preparedStatement2.executeQuery();
        resultSet.next();
        Timestamp timestamp2 = resultSet.getTimestamp(1);
        int n = timestamp2.getNanos();
        int n2 = bl ? 976255123 : 976255000;
        JDBCDriverTest.assertEquals((int)n2, (int)n);
    }

    public void testDerby4888() throws SQLException {
        JDBCDriverTest.assertFalse((boolean)this.getConnection().getMetaData().storesLowerCaseIdentifiers());
    }

    public void testDerby5449() throws SQLException {
        Object object;
        if (this.getServerVersion().compareTo(DerbyVersion._10_7) <= 0 && DERBY_5449_PATTERN.matcher((CharSequence)(object = this.getConnection().getMetaData().getDriverVersion())).matches()) {
            return;
        }
        object = this.prepareStatement("VALUES CAST(? AS INTEGER)");
        object.setBoolean(1, true);
        JDBC.assertSingleValueResultSet(object.executeQuery(), "1");
        object.setBoolean(1, false);
        JDBC.assertSingleValueResultSet(object.executeQuery(), "0");
    }

    public void testUDT() throws Exception {
        Object object;
        boolean bl = this.getServerVersion().atLeast(DerbyVersion._10_6) && this.getDriverVersion().atLeast(DerbyVersion._10_6);
        String string = "select aliasinfo from sys.sysaliases";
        if (bl) {
            object = "org.apache.derby.catalog.AliasInfo";
            this.checkRSMD(string, (String)object, 15, 2000, (String)object, 0, 0);
        } else {
            this.checkRSMD(string, "byte[]", 65400, -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
        }
        if (this.serverSupportsUDTs()) {
            ByteArrayInputStream byteArrayInputStream;
            Object object2;
            block16: {
                string = "select a from t_price";
                object = this.prepareStatement(string);
                ResultSet resultSet = object.executeQuery();
                resultSet.next();
                Object object3 = resultSet.getObject(1);
                String string2 = object3.getClass().getName();
                resultSet.close();
                object.close();
                if (bl) {
                    object2 = "org.apache.derbyTesting.functionTests.tests.lang.Price";
                    this.checkRSMD(string, (String)object2, 15, 2000, "\"APP\".\"PRICE\"", 0, 0);
                    JDBCDriverTest.assertEquals((String)object2, (String)string2);
                } else {
                    this.checkRSMD(string, "byte[]", 65400, -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
                    JDBCDriverTest.assertEquals((String)"java.lang.String", (String)string2);
                }
                string = "insert into t_price( a ) values ( ? )";
                if (bl) {
                    this.checkPMD(string, "org.apache.derbyTesting.functionTests.tests.lang.Price", 2000, "\"APP\".\"PRICE\"", 0, 0);
                } else {
                    this.checkPMD(string, "byte[]", -4, "LONG VARCHAR FOR BIT DATA", 32700, 0);
                }
                object = this.prepareStatement(string);
                object2 = new byte[]{1, 2, 3};
                byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                try {
                    object.setObject(1, Price.makePrice());
                    object.executeUpdate();
                    if (!bl) {
                        JDBCDriverTest.fail((String)"setObject( Price ) unexpectedly worked.");
                    }
                }
                catch (SQLException sQLException) {
                    if (!bl) break block16;
                    JDBCDriverTest.fail((String)"setObject( Price ) unexpectedly failed.");
                }
            }
            try {
                object.setObject(1, object2);
                object.executeUpdate();
                JDBCDriverTest.fail((String)"setObject( byte[] ) unexpectedly worked.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                object.setBytes(1, (byte[])object2);
                object.executeUpdate();
                JDBCDriverTest.fail((String)"setBytes( byte[] ) unexpectedly worked.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            try {
                object.setBinaryStream(1, (InputStream)byteArrayInputStream, 3);
                object.executeUpdate();
                JDBCDriverTest.fail((String)"setBinaryStream( InputStream ) unexpectedly worked.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            object.close();
        }
    }

    private void checkRSMD(String string, String string2, int n, int n2, String string3, int n3, int n4) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        JDBCDriverTest.assertEquals((String)string2, (String)resultSetMetaData.getColumnClassName(1));
        JDBCDriverTest.assertEquals((int)n, (int)resultSetMetaData.getColumnDisplaySize(1));
        JDBCDriverTest.assertEquals((int)n2, (int)resultSetMetaData.getColumnType(1));
        JDBCDriverTest.assertEquals((String)string3, (String)resultSetMetaData.getColumnTypeName(1));
        JDBCDriverTest.assertEquals((int)n3, (int)resultSetMetaData.getPrecision(1));
        JDBCDriverTest.assertEquals((int)n4, (int)resultSetMetaData.getScale(1));
        resultSet.close();
        preparedStatement.close();
    }

    private void checkPMD(String string, String string2, int n, String string3, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
        JDBCDriverTest.assertEquals((String)parameterMetaData.getParameterClassName(1), (String)string2);
        JDBCDriverTest.assertEquals((int)parameterMetaData.getParameterType(1), (int)n);
        JDBCDriverTest.assertEquals((String)parameterMetaData.getParameterTypeName(1), (String)string3);
        JDBCDriverTest.assertEquals((int)parameterMetaData.getPrecision(1), (int)n2);
        JDBCDriverTest.assertEquals((int)parameterMetaData.getScale(1), (int)n3);
        preparedStatement.close();
    }

    private void datatypesTest() throws SQLException {
        TypeDescriptor[] typeDescriptorArray = ALL_TYPES;
        String string = ALL_TYPES_TABLE;
        Object[][] objectArray = new Object[][]{this.makeNullRow(typeDescriptorArray.length), ROW_1};
        this.checkDBMetadata(string);
        this.stuffTable(string, typeDescriptorArray, objectArray);
        this.readTable(string, typeDescriptorArray, objectArray);
    }

    private void checkDBMetadata(String string) throws SQLException {
        String string2 = TestConfiguration.getCurrent().getUserName();
        String string3 = string2.toUpperCase();
        String string4 = string.toUpperCase();
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, string3, string4, "%");
        JDBCDriverTest.println("Pawing through database metadata for " + string3 + "." + string4);
        while (resultSet.next()) {
            String string5 = resultSet.getString("COLUMN_NAME");
            int n = resultSet.getInt("DATA_TYPE");
            TypeDescriptor typeDescriptor = this.getType(string5);
            if (string5.equals(KEY_COLUMN)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[ ").append(resultSet.getString("COLUMN_NAME")).append(",\t").append("type( ").append(resultSet.getInt("DATA_TYPE")).append(" ),\t").append(resultSet.getString("TYPE_NAME")).append(" ]");
            JDBCDriverTest.println(stringBuilder.toString());
            JDBCDriverTest.assertEquals((String)string5, (int)typeDescriptor.getJdbcType(), (int)n);
        }
        resultSet.close();
    }

    private void stuffTable(String string, TypeDescriptor[] typeDescriptorArray, Object[][] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.makeInsert(string, typeDescriptorArray);
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.setRow(preparedStatement, i + 1, typeDescriptorArray, objectArray[i]);
        }
        preparedStatement.close();
    }

    private PreparedStatement makeInsert(String string, TypeDescriptor[] typeDescriptorArray) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        int n = 0;
        int n2 = 0;
        int n3 = typeDescriptorArray.length;
        JDBCDriverTest.beginColumnList(stringBuilder2);
        JDBCDriverTest.beginColumnList(stringBuilder3);
        JDBCDriverTest.addColumn(stringBuilder2, n++, JDBCDriverTest.doubleQuote(KEY_COLUMN));
        JDBCDriverTest.addColumn(stringBuilder3, n2++, "?");
        for (int i = 0; i < n3; ++i) {
            TypeDescriptor typeDescriptor = typeDescriptorArray[i];
            if (!this.getServerVersion().atLeast(typeDescriptor.getDerbyVersion())) continue;
            String string2 = typeDescriptor.getDerbyTypeName();
            String string3 = JDBCDriverTest.doubleQuote(string2);
            JDBCDriverTest.addColumn(stringBuilder2, n++, string3);
            JDBCDriverTest.addColumn(stringBuilder3, n2++, "?");
        }
        JDBCDriverTest.endColumnList(stringBuilder2);
        JDBCDriverTest.endColumnList(stringBuilder3);
        stringBuilder.append("insert into ").append(string).append("\n").append(stringBuilder2.toString()).append("values\n").append(stringBuilder3.toString());
        return this.prepareStatement(stringBuilder.toString());
    }

    private void readTable(String string, TypeDescriptor[] typeDescriptorArray, Object[][] objectArray) throws SQLException {
        PreparedStatement preparedStatement = this.readTableQuery(string, typeDescriptorArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        this.checkRSMD(resultSet);
        resultSet.close();
        this.checkRows(preparedStatement, typeDescriptorArray, objectArray);
        preparedStatement.close();
    }

    private PreparedStatement readTableQuery(String string, TypeDescriptor[] typeDescriptorArray) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = typeDescriptorArray.length;
        stringBuilder.append("select \n");
        JDBCDriverTest.addColumn(stringBuilder, n++, JDBCDriverTest.doubleQuote(KEY_COLUMN));
        for (int i = 0; i < n2; ++i) {
            TypeDescriptor typeDescriptor = typeDescriptorArray[i];
            if (!this.getServerVersion().atLeast(typeDescriptor.getDerbyVersion())) continue;
            String string2 = typeDescriptor.getDerbyTypeName();
            String string3 = JDBCDriverTest.doubleQuote(string2);
            JDBCDriverTest.addColumn(stringBuilder, n++, string3);
        }
        stringBuilder.append("\nfrom ").append(string).append("\n").append("order by ").append(JDBCDriverTest.doubleQuote(KEY_COLUMN));
        return this.prepareStatement(stringBuilder.toString());
    }

    private void checkRSMD(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        int n2 = 0;
        JDBCDriverTest.println("ResultSetMetaData:\n");
        for (int i = ++n2; i < n; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = i + 1;
            String string = resultSetMetaData.getColumnName(n3);
            TypeDescriptor typeDescriptor = this.getType(string);
            int n4 = this.rsmdTypeKludge(typeDescriptor.getJdbcType());
            int n5 = resultSetMetaData.getColumnType(n3);
            stringBuilder.append("[ ");
            stringBuilder.append(string);
            stringBuilder.append(", type( ");
            stringBuilder.append(n5);
            stringBuilder.append(" ), ");
            stringBuilder.append(resultSetMetaData.getColumnTypeName(n3));
            stringBuilder.append(" ]\n");
            JDBCDriverTest.println(stringBuilder.toString());
            JDBCDriverTest.assertEquals((String)string, (int)n4, (int)n5);
        }
    }

    private void checkRows(PreparedStatement preparedStatement, TypeDescriptor[] typeDescriptorArray, Object[][] objectArray) throws SQLException {
        int n = typeDescriptorArray.length;
        for (int i = 0; i < n; ++i) {
            TypeDescriptor typeDescriptor = typeDescriptorArray[i];
            if (!this.getServerVersion().atLeast(typeDescriptor.getDerbyVersion())) continue;
            JDBCDriverTest.assertEquals((Object)typeDescriptorArray[i], (Object)typeDescriptor);
            this.checkPlainGet(preparedStatement, i, typeDescriptor, objectArray);
            this.checkCoercions(preparedStatement, typeDescriptor);
        }
    }

    private void checkPlainGet(PreparedStatement preparedStatement, int n, TypeDescriptor typeDescriptor, Object[][] objectArray) throws SQLException {
        String string = typeDescriptor.getDerbyTypeName();
        ResultSet resultSet = preparedStatement.executeQuery();
        for (int i = 0; i < objectArray.length; ++i) {
            JDBCDriverTest.assertTrue((String)"Not enough rows in the result", (boolean)resultSet.next());
            Object object = objectArray[i][n];
            Object object2 = this.getColumn(resultSet, string, typeDescriptor);
            JDBCDriverTest.println("Comparing column " + string + ": " + String.valueOf(object) + " to " + String.valueOf(object2));
            this.compareObjects(string, object, object2);
        }
        JDBCDriverTest.assertFalse((String)"Remaining rows in result", (boolean)resultSet.next());
        resultSet.close();
    }

    private void checkCoercions(PreparedStatement preparedStatement, TypeDescriptor typeDescriptor) throws SQLException {
        Object object;
        String string = typeDescriptor.getDerbyTypeName();
        T_CN t_CN = COERCIONS[this.getCoercionIndex(typeDescriptor.getJdbcType())];
        boolean[] blArray = t_CN.getCoercions();
        int n = blArray.length;
        int n2 = 0;
        JDBCDriverTest.println("Checking coercions for " + string);
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            ++n2;
            object = preparedStatement.executeQuery();
            while (object.next()) {
                int n3 = COERCIONS[i].getJdbcType();
                Object object2 = this.getColumn((ResultSet)object, string, n3);
                JDBCDriverTest.println("\t" + n3 + ":\t" + String.valueOf(object2));
            }
            object.close();
        }
        JDBCDriverTest.println(n2 + " legal coercions for " + string + " (type=" + typeDescriptor.getDerbyTypeName() + ")");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            object = resultSet.getObject(string);
            if (object == null) {
                JDBCDriverTest.println("\tgetObject() = null");
                continue;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\tgetObject() = ");
            stringBuilder.append(object.getClass().getName());
            stringBuilder.append("( ");
            stringBuilder.append(object);
            stringBuilder.append(" )");
            JDBCDriverTest.println(stringBuilder.toString());
        }
        resultSet.close();
    }

    private int rsmdTypeKludge(int n) {
        if (JDBCDriverTest.usingEmbedded()) {
            return n;
        }
        switch (n) {
            case 2: {
                return 3;
            }
        }
        return n;
    }

    private void setRow(PreparedStatement preparedStatement, int n, TypeDescriptor[] typeDescriptorArray, Object[] objectArray) throws SQLException {
        int n2 = 1;
        int n3 = typeDescriptorArray.length;
        preparedStatement.setInt(n2++, n);
        for (int i = 0; i < n3; ++i) {
            TypeDescriptor typeDescriptor = typeDescriptorArray[i];
            Object object = objectArray[i];
            if (!this.getServerVersion().atLeast(typeDescriptor.getDerbyVersion())) continue;
            this.setParameter(preparedStatement, n2++, typeDescriptor, object);
        }
        preparedStatement.execute();
    }

    private Object[] makeNullRow(int n) {
        return new Object[n];
    }

    private void buildTypeMap() {
        int n = ALL_TYPES.length;
        for (int i = 0; i < n; ++i) {
            this.putType(ALL_TYPES[i]);
        }
    }

    private void putType(TypeDescriptor typeDescriptor) {
        _types.put(typeDescriptor.getDerbyTypeName(), typeDescriptor);
    }

    private TypeDescriptor getType(String string) {
        if (_types.isEmpty()) {
            this.buildTypeMap();
        }
        return _types.get(string);
    }

    private void buildCoercionMap() {
        int n = COERCIONS.length;
        for (int i = 0; i < n; ++i) {
            this.putCoercionIndex(i);
        }
    }

    private void putCoercionIndex(int n) {
        _coercionIndex.put(COERCIONS[n].getJdbcType(), n);
    }

    private int getCoercionIndex(int n) {
        if (_coercionIndex.isEmpty()) {
            this.buildCoercionMap();
        }
        return _coercionIndex.get(n);
    }

    private static void createTable(Connection connection, String string, TypeDescriptor[] typeDescriptorArray) throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = typeDescriptorArray.length;
        stringBuilder.append("create table ").append(string).append('\n');
        JDBCDriverTest.beginColumnList(stringBuilder);
        JDBCDriverTest.addColumn(stringBuilder, n++, JDBCDriverTest.doubleQuote(KEY_COLUMN) + "\tint");
        for (int i = 0; i < n2; ++i) {
            TypeDescriptor typeDescriptor = typeDescriptorArray[i];
            if (!JDBCDriverTest.getServerVersion(connection).atLeast(typeDescriptor.getDerbyVersion())) continue;
            String string2 = typeDescriptor.getDerbyTypeName();
            String string3 = JDBCDriverTest.doubleQuote(string2) + "\t" + string2;
            JDBCDriverTest.addColumn(stringBuilder, n++, string3);
        }
        JDBCDriverTest.endColumnList(stringBuilder);
        PreparedStatement preparedStatement = connection.prepareStatement(stringBuilder.toString());
        preparedStatement.execute();
        preparedStatement.close();
    }

    private static void createUDTObjects(Connection connection) throws SQLException {
        if (!JDBCDriverTest.serverSupportsUDTs(connection)) {
            return;
        }
        PreparedStatement preparedStatement = connection.prepareStatement("create type price external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("create function makePrice( ) returns price language java parameter style java no sql external name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("create table t_price( a price )\n");
        preparedStatement.execute();
        preparedStatement.close();
        preparedStatement = connection.prepareStatement("insert into t_price( a ) values ( makePrice() )\n");
        preparedStatement.execute();
        preparedStatement.close();
    }

    private static void create_derby_2602_objects(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("create table t_2602( a timestamp )\n");
        preparedStatement.execute();
        preparedStatement.close();
    }

    private static void beginColumnList(StringBuilder stringBuilder) {
        stringBuilder.append("(\n");
    }

    private static void endColumnList(StringBuilder stringBuilder) {
        stringBuilder.append("\n)\n");
    }

    private static void addColumn(StringBuilder stringBuilder, int n, String string) {
        if (n > 0) {
            stringBuilder.append(",");
        }
        stringBuilder.append("\n\t");
        stringBuilder.append(string);
    }

    private void dropSchema() throws SQLException {
        this.dropTable(ALL_TYPES_TABLE);
        this.dropUDTObjects();
        this.drop_derby_2602_objects();
    }

    private void dropUDTObjects() throws SQLException {
        if (this.serverSupportsUDTs()) {
            this.dropFunction("MAKEPRICE");
            this.dropTable("T_PRICE");
            this.dropUDT("PRICE");
        }
    }

    private void drop_derby_2602_objects() throws SQLException {
        this.dropTable("T_2602");
    }

    private void setParameter(PreparedStatement preparedStatement, int n, TypeDescriptor typeDescriptor, Object object) throws SQLException {
        int n2 = typeDescriptor.getJdbcType();
        if (object != null) {
            this.setParameter(preparedStatement, n, n2, object);
            return;
        }
        if (this.clientSupports(typeDescriptor)) {
            preparedStatement.setNull(n, n2);
            return;
        }
        JDBCDriverTest.fail((String)("Unsupported Derby type: " + typeDescriptor.getDerbyTypeName()));
    }

    private boolean clientSupports(TypeDescriptor typeDescriptor) throws SQLException {
        DerbyVersion derbyVersion = typeDescriptor.getDerbyVersion();
        if (derbyVersion == null) {
            return false;
        }
        return this.getDriverVersion().atLeast(derbyVersion);
    }

    private Object getColumn(ResultSet resultSet, String string, TypeDescriptor typeDescriptor) throws SQLException {
        int n = typeDescriptor.getJdbcType();
        return this.getColumn(resultSet, string, n);
    }

    private static String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("JDBCDriverTest suite");
        baseTestSuite.addTestSuite(JDBCDriverTest.class);
        return TestConfiguration.defaultExistingServerDecorator((Test)new BaseJDBCTestSetup((Test)baseTestSuite){

            protected void setUp() throws Exception {
                super.setUp();
                Connection connection = this.getConnection();
                Statement statement = connection.createStatement();
                ResultSet resultSet = statement.executeQuery("values CURRENT SCHEMA");
                resultSet.next();
                String string = resultSet.getString(1);
                resultSet.close();
                statement.close();
                connection.setAutoCommit(false);
                JDBC.dropSchema(connection.getMetaData(), string);
                connection.commit();
                connection.setAutoCommit(true);
                JDBCDriverTest.createTable(connection, JDBCDriverTest.ALL_TYPES_TABLE, ALL_TYPES);
                JDBCDriverTest.createUDTObjects(connection);
                JDBCDriverTest.create_derby_2602_objects(connection);
            }
        });
    }

    public static final class TypeDescriptor {
        private int _jdbcType;
        private String _derbyTypeName;
        private DerbyVersion _derbyVersion;

        public TypeDescriptor(int n, String string, DerbyVersion derbyVersion) {
            this._jdbcType = n;
            this._derbyTypeName = string;
            this._derbyVersion = derbyVersion;
        }

        public int getJdbcType() {
            return this._jdbcType;
        }

        public String getDerbyTypeName() {
            return this._derbyTypeName;
        }

        public DerbyVersion getDerbyVersion() {
            return this._derbyVersion;
        }
    }

    public static final class T_CN {
        private int _jdbcType;
        private boolean[] _coercions;

        public T_CN(int n, boolean[] blArray) {
            this._jdbcType = n;
            this._coercions = blArray;
        }

        public int getJdbcType() {
            return this._jdbcType;
        }

        public boolean[] getCoercions() {
            return this._coercions;
        }
    }
}

