/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UserTypeConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class CastNode
extends ValueNode {
    ValueNode castOperand;
    private int targetCharType;
    TypeId sourceCTI = null;
    private boolean forDataTypeFunction = false;
    private DataTypeDescriptor targetUDT;
    private boolean externallyGeneratedCastNode = false;
    private boolean assignmentSemantics = false;
    private TableName udtTargetName;

    CastNode(ValueNode castOperand, DataTypeDescriptor castTarget, ContextManager cm) throws StandardException {
        super(cm);
        this.castOperand = castOperand;
        if (castTarget.getTypeId().isUserDefinedTypeId()) {
            this.targetUDT = castTarget;
        } else {
            this.setType(castTarget);
        }
    }

    CastNode(ValueNode castOperand, int charType, int charLength, ContextManager cm) throws StandardException {
        super(cm);
        this.castOperand = castOperand;
        int charLen = charLength;
        this.targetCharType = charType;
        if (charLen < 0) {
            return;
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, charLen));
    }

    @Override
    public String toString() {
        return "castTarget: " + this.getTypeServices() + "\n" + super.toString();
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.castOperand != null) {
            this.printLabel(depth, "castOperand: ");
            this.castOperand.treePrint(depth + 1);
        }
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.castOperand.getOrderableVariantType();
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.castOperand = this.castOperand.bindExpression(fromList, subqueryList, aggregates);
        if (this.targetUDT != null) {
            this.setType(this.targetUDT);
        }
        if (this.getTypeServices() == null) {
            DataTypeDescriptor opndType = this.castOperand.getTypeServices();
            int length = -1;
            TypeId srcTypeId = opndType.getTypeId();
            if (srcTypeId.isNumericTypeId()) {
                length = opndType.getPrecision() + 1;
                if (opndType.getScale() > 0) {
                    ++length;
                }
            } else if (srcTypeId.isStringTypeId()) {
                length = opndType.getMaximumWidth();
                if (this.targetCharType == 1) {
                    length = Math.min(length, 254);
                } else if (this.targetCharType == 12) {
                    length = Math.min(length, 32672);
                }
            } else {
                TypeId typeid = opndType.getTypeId();
                if (length < 0) {
                    length = DataTypeUtilities.getColumnDisplaySize(typeid.getJDBCTypeId(), -1);
                }
            }
            if (length < 0) {
                length = 1;
            }
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, length));
        }
        if (this.castOperand instanceof UntypedNullConstantNode) {
            this.castOperand.setType(this.getTypeServices());
        }
        this.bindCastNodeOnly();
        if (this.castOperand instanceof ConstantNode && !(this.castOperand instanceof UntypedNullConstantNode)) {
            ValueNode retNode = this;
            int sourceJDBCTypeId = this.sourceCTI.getJDBCTypeId();
            int destJDBCTypeId = this.getTypeId().getJDBCTypeId();
            switch (sourceJDBCTypeId) {
                case -7: 
                case 16: {
                    if (destJDBCTypeId == -7 || destJDBCTypeId == 16) {
                        retNode = this.castOperand;
                        break;
                    }
                    if (destJDBCTypeId != 1) break;
                    BooleanConstantNode bcn = (BooleanConstantNode)this.castOperand;
                    String booleanString = bcn.getValueAsString();
                    retNode = new CharConstantNode(booleanString, this.getTypeServices().getMaximumWidth(), this.getContextManager());
                    break;
                }
                case 1: {
                    retNode = this.getCastFromCharConstant(destJDBCTypeId);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (destJDBCTypeId != 1) break;
                    String castValue = ((UserTypeConstantNode)this.castOperand).getObjectValue().toString();
                    retNode = new CharConstantNode(castValue, this.getTypeServices().getMaximumWidth(), this.getContextManager());
                    break;
                }
                case 3: {
                    if (destJDBCTypeId == 3 || destJDBCTypeId == 2) break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    retNode = this.getCastFromNumericType(((ConstantNode)this.castOperand).getValue(), destJDBCTypeId);
                }
            }
            return retNode;
        }
        return this;
    }

    void bindCastNodeOnly() throws StandardException {
        TypeCompiler tc;
        if (this.targetUDT != null) {
            this.setType(this.targetUDT);
        }
        this.sourceCTI = this.castOperand.getTypeId();
        if (this.externallyGeneratedCastNode && this.getTypeId().isStringTypeId()) {
            this.setCollationUsingCompilationSchema();
        }
        if (this.getTypeId().userType()) {
            this.setType(this.bindUserType(this.getTypeServices()));
            String className = this.getTypeId().getCorrespondingJavaTypeName();
            this.verifyClassExist(className);
        }
        if (this.udtTargetName != null) {
            this.udtTargetName.setSchemaName(this.getTypeId().getBaseTypeId().getSchemaName());
        }
        if (this.castOperand.requiresTypeFromContext()) {
            this.castOperand.setType(this.getTypeServices());
        } else if (!(this.castOperand instanceof UntypedNullConstantNode) && !(tc = this.castOperand.getTypeCompiler()).convertible(this.getTypeId(), this.forDataTypeFunction)) {
            throw StandardException.newException("42846", this.sourceCTI.getSQLTypeName(), this.getTypeId().getSQLTypeName());
        }
        if (this.castOperand.getTypeServices().getTypeId().isStringTypeId() && this.getTypeId().isBooleanTypeId()) {
            this.setNullability(true);
        } else {
            this.setNullability(this.castOperand.getTypeServices().isNullable());
        }
        if (this.targetUDT != null) {
            this.addUDTUsagePriv(this);
        }
    }

    private ValueNode getCastFromCharConstant(int destJDBCTypeId) throws StandardException {
        String charValue = ((CharConstantNode)this.castOperand).getString();
        String cleanCharValue = StringUtil.SQLToUpperCase(charValue.trim());
        CastNode retNode = this;
        switch (destJDBCTypeId) {
            case -7: 
            case 16: {
                if (cleanCharValue.equals("TRUE")) {
                    return new BooleanConstantNode(true, this.getContextManager());
                }
                if (cleanCharValue.equals("FALSE")) {
                    return new BooleanConstantNode(false, this.getContextManager());
                }
                if (cleanCharValue.equals("UNKNOWN")) {
                    return new BooleanConstantNode(this.getContextManager());
                }
                throw StandardException.newException("22018", "boolean");
            }
            case 91: {
                return new UserTypeConstantNode(this.getDataValueFactory().getDateValue(cleanCharValue, false), this.getContextManager());
            }
            case 93: {
                return new UserTypeConstantNode(this.getDataValueFactory().getTimestampValue(cleanCharValue, false), this.getContextManager());
            }
            case 92: {
                return new UserTypeConstantNode(this.getDataValueFactory().getTimeValue(cleanCharValue, false), this.getContextManager());
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                try {
                    return this.getCastFromIntegralType((long)Double.parseDouble(cleanCharValue), destJDBCTypeId);
                }
                catch (NumberFormatException nfe) {
                    String sqlName = TypeId.getBuiltInTypeId(destJDBCTypeId).getSQLTypeName();
                    throw StandardException.newException("22018", sqlName);
                }
            }
            case 7: {
                Float floatValue;
                try {
                    floatValue = Float.valueOf(cleanCharValue);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", "float");
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(7), floatValue, this.getContextManager());
            }
            case 8: {
                Double doubleValue;
                try {
                    doubleValue = Double.parseDouble(cleanCharValue);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", "double");
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(8), doubleValue, this.getContextManager());
            }
        }
        return retNode;
    }

    private ValueNode getCastFromIntegralType(long longValue, int destJDBCTypeId) throws StandardException {
        CastNode retNode = this;
        switch (destJDBCTypeId) {
            case 1: {
                return new CharConstantNode(Long.toString(longValue), this.getTypeServices().getMaximumWidth(), this.getContextManager());
            }
            case -6: {
                if (longValue < -128L || longValue > 127L) {
                    throw StandardException.newException("22003", "TINYINT");
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(-6), (byte)longValue, this.getContextManager());
            }
            case 5: {
                if (longValue < -32768L || longValue > 32767L) {
                    throw StandardException.newException("22003", "SHORT");
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), (short)longValue, this.getContextManager());
            }
            case 4: {
                if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                    throw StandardException.newException("22003", "INTEGER");
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), (int)longValue, this.getContextManager());
            }
            case -5: {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), longValue, this.getContextManager());
            }
            case 7: {
                if ((float)Math.abs(longValue) > Float.MAX_VALUE) {
                    throw StandardException.newException("22003", "REAL");
                }
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), Float.valueOf(longValue), this.getContextManager());
            }
            case 8: {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), longValue, this.getContextManager());
            }
        }
        return retNode;
    }

    private ValueNode getCastFromNumericType(DataValueDescriptor constantValue, int destJDBCTypeId) throws StandardException {
        switch (destJDBCTypeId) {
            case 1: {
                return new CharConstantNode(constantValue.getString(), this.getTypeServices().getMaximumWidth(), this.getContextManager());
            }
            case -6: {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), constantValue.getByte(), this.getContextManager());
            }
            case 5: {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), constantValue.getShort(), this.getContextManager());
            }
            case 4: {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), constantValue.getInt(), this.getContextManager());
            }
            case -5: {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), constantValue.getLong(), this.getContextManager());
            }
            case 7: {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), Float.valueOf(NumberDataType.normalizeREAL(constantValue.getDouble())), this.getContextManager());
            }
            case 8: {
                return new NumericConstantNode(TypeId.getBuiltInTypeId(destJDBCTypeId), constantValue.getDouble(), this.getContextManager());
            }
        }
        return this;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.castOperand = this.castOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.castOperand.categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.castOperand = this.castOperand.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    boolean isConstantExpression() {
        return this.castOperand.isConstantExpression();
    }

    @Override
    boolean constantExpression(PredicateList whereClause) {
        return this.castOperand.constantExpression(whereClause);
    }

    @Override
    Object getConstantValueAsObject() throws StandardException {
        Object sourceObject = this.castOperand.getConstantValueAsObject();
        if (sourceObject == null) {
            return null;
        }
        if (this.sourceCTI.getCorrespondingJavaTypeName().equals(this.getTypeId().getCorrespondingJavaTypeName())) {
            return sourceObject;
        }
        return null;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.castOperand.generateExpression(acb, mb);
        if (this.castOperand instanceof UntypedNullConstantNode) {
            return;
        }
        if (this.castOperand.requiresTypeFromContext()) {
            this.sourceCTI = this.getTypeId();
        }
        this.genDataValueConversion(acb, mb);
    }

    private void genDataValueConversion(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        MethodBuilder acbConstructor = acb.getConstructor();
        String resultTypeName = this.getTypeCompiler().interfaceName();
        LocalField field = acb.newFieldDeclaration(2, resultTypeName);
        acb.generateNull(acbConstructor, this.getTypeCompiler(this.getTypeId()), this.getTypeServices().getCollationType());
        acbConstructor.setField(field);
        if (!this.sourceCTI.userType() && !this.getTypeId().userType()) {
            mb.getField(field);
            mb.swap();
            mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
            mb.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "setValue", "void", 1);
        } else {
            mb.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "getObject", "java.lang.Object", 0);
            mb.getField(field);
            mb.swap();
            String destinationType = this.getTypeId().getCorrespondingJavaTypeName();
            mb.dup();
            mb.isInstanceOf(destinationType);
            mb.push(destinationType);
            mb.callMethod((short)185, "org.apache.derby.iapi.types.DataValueDescriptor", "setObjectForCast", "void", 3);
        }
        mb.getField(field);
        if (this.getTypeId().variableLength()) {
            boolean isNumber = this.getTypeId().isNumericTypeId();
            mb.dup();
            mb.push(isNumber ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            mb.push(this.getTypeServices().getScale());
            mb.push(!this.sourceCTI.variableLength() || isNumber || this.assignmentSemantics);
            mb.callMethod((short)185, "org.apache.derby.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this.castOperand != null) {
            this.castOperand = (ValueNode)this.castOperand.accept(v);
        }
        if (this.udtTargetName != null) {
            this.udtTargetName = (TableName)this.udtTargetName.accept(v);
        }
    }

    void setForExternallyGeneratedCASTnode() {
        this.externallyGeneratedCastNode = true;
    }

    void setForDataTypeFunction(boolean b) {
        this.forDataTypeFunction = b;
    }

    void setAssignmentSemantics() {
        this.assignmentSemantics = true;
    }

    @Override
    boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeKind(o)) {
            CastNode other = (CastNode)o;
            return this.getTypeServices().equals(other.getTypeServices()) && this.castOperand.isEquivalent(other.castOperand);
        }
        return false;
    }

    void setTargetUDTName(TableName name) {
        this.udtTargetName = name;
    }
}

