/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.derbyTesting.system.oe.client.Load;
import org.apache.derbyTesting.system.oe.util.OERandom;

public class SimpleInsert
implements Load {
    Connection conn = null;
    short scale = 1;
    long seed = System.currentTimeMillis();
    OERandom random;

    @Override
    public void setupLoad(Connection connection, short s) throws SQLException {
        this.setupConnection(connection, s);
        Statement statement = connection.createStatement();
        try {
            statement.execute("DROP TABLE C");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        connection.commit();
        statement.execute("CREATE TABLE C(CLOAD INT)");
        connection.commit();
        this.random = new OERandom(-1, this.seed);
        int n = this.random.randomInt(0, 255);
        statement.execute("INSERT INTO C VALUES(" + n + ")");
        statement.close();
        connection.commit();
        this.setRandomGenerator();
    }

    void setupConnection(Connection connection, short s) throws SQLException {
        this.conn = connection;
        connection.setAutoCommit(false);
        connection.setTransactionIsolation(8);
        this.scale = s;
    }

    void setRandomGenerator() throws SQLException {
        Statement statement = this.conn.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT CLOAD FROM C");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        this.random = new OERandom(n, this.seed);
        statement.close();
        this.conn.commit();
    }

    @Override
    public void populateAllTables() throws Exception {
        this.itemTable(1, 100000);
        for (short s = 1; s <= this.scale; s = (short)(s + 1)) {
            this.populateForOneWarehouse(s);
        }
    }

    void populateForOneWarehouse(short s) throws SQLException {
        this.warehouseTable(s);
        this.stockTable(1, 100000, s);
        for (short s2 = 1; s2 <= 10; s2 = (short)(s2 + 1)) {
            this.districtTable(s, s2);
            this.customerTable(s, s2);
            this.orderTable(s, s2);
        }
    }

    public void itemTable(int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO ITEM(I_ID,I_IM_ID,I_NAME,I_PRICE,I_DATA) VALUES (?, ?, ?, ?, ?)");
        for (int i = n; i <= n2; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, this.random.randomInt(1, 10000));
            preparedStatement.setString(3, this.random.randomAString14_24());
            String string = this.random.randomDecimalString(100, 9999, 2);
            preparedStatement.setString(4, string);
            preparedStatement.setString(5, this.random.randomData());
            preparedStatement.executeUpdate();
            if (i % 1000 != 0) continue;
            this.conn.commit();
        }
        this.conn.commit();
        preparedStatement.close();
    }

    public void warehouseTable(short s) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO WAREHOUSE VALUES (?, ?, ?, ?, ?, ?, ?, ?, 300000.00)");
        preparedStatement.setShort(1, s);
        preparedStatement.setString(2, this.random.randomAString(6, 10));
        preparedStatement.setString(3, this.random.randomAString10_20());
        preparedStatement.setString(4, this.random.randomAString10_20());
        preparedStatement.setString(5, this.random.randomAString10_20());
        preparedStatement.setString(6, this.random.randomState());
        preparedStatement.setString(7, this.random.randomZIP());
        preparedStatement.setString(8, this.random.randomDecimalString(0, 2000, 4));
        preparedStatement.executeUpdate();
        this.conn.commit();
        preparedStatement.close();
    }

    public void stockTable(int n, int n2, short s) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO STOCK (S_I_ID, S_W_ID, S_QUANTITY,S_DIST_01, S_DIST_02, S_DIST_03,S_DIST_04,S_DIST_05,S_DIST_06,S_DIST_07,S_DIST_08,S_DIST_09,S_DIST_10,S_ORDER_CNT, S_REMOTE_CNT, S_YTD, S_DATA ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 0, 0, 0, ?)");
        preparedStatement.setShort(2, s);
        for (int i = n; i <= n2; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(3, this.random.randomInt(10, 100));
            preparedStatement.setString(4, this.random.randomAString24());
            preparedStatement.setString(5, this.random.randomAString24());
            preparedStatement.setString(6, this.random.randomAString24());
            preparedStatement.setString(7, this.random.randomAString24());
            preparedStatement.setString(8, this.random.randomAString24());
            preparedStatement.setString(9, this.random.randomAString24());
            preparedStatement.setString(10, this.random.randomAString24());
            preparedStatement.setString(11, this.random.randomAString24());
            preparedStatement.setString(12, this.random.randomAString24());
            preparedStatement.setString(13, this.random.randomAString24());
            preparedStatement.setString(14, this.random.randomData());
            preparedStatement.executeUpdate();
            if (i % 1000 != 0) continue;
            this.conn.commit();
        }
        this.conn.commit();
        preparedStatement.close();
    }

    public void districtTable(short s, short s2) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO DISTRICT (D_ID, D_W_ID, D_NAME, D_STREET_1, D_STREET_2, D_CITY, D_STATE, D_ZIP, D_TAX, D_YTD, D_NEXT_O_ID)  VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, 30000.00, 3001)");
        preparedStatement.setShort(1, s2);
        preparedStatement.setShort(2, s);
        preparedStatement.setString(3, this.random.randomAString(6, 10));
        preparedStatement.setString(4, this.random.randomAString10_20());
        preparedStatement.setString(5, this.random.randomAString10_20());
        preparedStatement.setString(6, this.random.randomAString10_20());
        preparedStatement.setString(7, this.random.randomState());
        preparedStatement.setString(8, this.random.randomZIP());
        preparedStatement.setString(9, this.random.randomDecimalString(0, 2000, 4));
        preparedStatement.executeUpdate();
        this.conn.commit();
        preparedStatement.close();
    }

    public void customerTable(short s, short s2) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO CUSTOMER (C_ID, C_D_ID, C_W_ID, C_FIRST, C_MIDDLE, C_LAST, C_STREET_1, C_STREET_2,  C_CITY, C_STATE, C_ZIP, C_PHONE, C_SINCE, C_CREDIT, C_CREDIT_LIM, C_DISCOUNT, C_BALANCE, C_YTD_PAYMENT, C_PAYMENT_CNT, C_DELIVERY_CNT, C_DATA)  VALUES (?, ?, ?, ?, 'OE', ?, ?, ?, ?, ?, ?, ?,  CURRENT TIMESTAMP ,?, 50000.00, ?, -10.0, 10.0, 1, 0, ?)");
        PreparedStatement preparedStatement2 = this.conn.prepareStatement("INSERT INTO HISTORY (H_C_ID, H_C_D_ID, H_C_W_ID, H_D_ID, H_W_ID, H_DATE, H_AMOUNT, H_DATA) VALUES (?, ?, ?, ?, ?, CURRENT TIMESTAMP, 10.00, ?)");
        preparedStatement.setShort(2, s2);
        preparedStatement.setShort(3, s);
        preparedStatement2.setShort(2, s2);
        preparedStatement2.setShort(3, s);
        preparedStatement2.setShort(4, s2);
        preparedStatement2.setShort(5, s);
        for (int i = 1; i <= 3000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(4, this.random.randomAString8_16());
            preparedStatement.setString(5, this.random.randomCLastPopulate(i));
            preparedStatement.setString(6, this.random.randomAString10_20());
            preparedStatement.setString(7, this.random.randomAString10_20());
            preparedStatement.setString(8, this.random.randomAString10_20());
            preparedStatement.setString(9, this.random.randomState());
            preparedStatement.setString(10, this.random.randomZIP());
            preparedStatement.setString(11, this.random.randomNString(16, 16));
            preparedStatement.setString(12, Math.random() < 0.1 ? "BC" : "GC");
            preparedStatement.setString(13, this.random.randomDecimalString(0, 5000, 4));
            String string = this.random.randomAString300_500();
            if (string.length() > 255) {
                string = string.substring(255);
            }
            preparedStatement.setString(14, string);
            preparedStatement.executeUpdate();
            preparedStatement2.setInt(1, i);
            preparedStatement2.setString(6, this.random.randomAString(12, 24));
            preparedStatement2.executeUpdate();
            if (i % 1000 != 0) continue;
            this.conn.commit();
        }
        this.conn.commit();
        preparedStatement.close();
        preparedStatement2.close();
    }

    public void orderTable(short s, short s2) throws SQLException {
        PreparedStatement preparedStatement = this.conn.prepareStatement("INSERT INTO ORDERS (O_ID, O_D_ID, O_W_ID, O_C_ID, O_ENTRY_D, O_CARRIER_ID, O_OL_CNT, O_ALL_LOCAL) VALUES (?, ?, ?, ?, ?, ?, ?, 1)");
        PreparedStatement preparedStatement2 = this.conn.prepareStatement("INSERT INTO ORDERLINE (OL_O_ID, OL_D_ID, OL_W_ID, OL_NUMBER, OL_I_ID, OL_SUPPLY_W_ID, OL_DELIVERY_D, OL_QUANTITY, OL_AMOUNT, OL_DIST_INFO)  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        PreparedStatement preparedStatement3 = this.conn.prepareStatement("INSERT INTO NEWORDERS (NO_O_ID, NO_D_ID, NO_W_ID) VALUES (?, ?, ?)");
        preparedStatement.setShort(2, s2);
        preparedStatement.setShort(3, s);
        int[] nArray = this.random.randomIntPerm(3000);
        for (int i = 1; i <= nArray.length; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(4, nArray[i - 1]);
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            preparedStatement.setTimestamp(5, timestamp);
            if (i <= 2100) {
                preparedStatement.setShort(6, (short)this.random.randomInt(1, 10));
            } else {
                preparedStatement.setNull(6, 5);
            }
            int n = this.random.randomInt(5, 15);
            preparedStatement.setInt(7, n);
            preparedStatement.executeUpdate();
            preparedStatement2.setShort(2, s2);
            preparedStatement2.setShort(3, s);
            preparedStatement3.setShort(2, s2);
            preparedStatement3.setShort(3, s);
            for (int j = 1; j <= n; ++j) {
                preparedStatement2.setInt(1, i);
                preparedStatement2.setInt(4, j);
                preparedStatement2.setInt(5, this.random.randomInt(1, 100000));
                preparedStatement2.setShort(6, s);
                if (i <= 2100) {
                    preparedStatement2.setTimestamp(7, timestamp);
                    preparedStatement2.setString(9, "0.00");
                } else {
                    preparedStatement2.setNull(7, 93);
                    preparedStatement2.setString(9, this.random.randomDecimalString(1, 999999, 2));
                }
                preparedStatement2.setInt(8, 5);
                preparedStatement2.setString(10, this.random.randomAString24());
                preparedStatement2.executeUpdate();
            }
            if (i > 2100) {
                preparedStatement3.setInt(1, i);
                preparedStatement3.executeUpdate();
            }
            if (i % 1000 != 0) continue;
            this.conn.commit();
        }
        this.conn.commit();
        preparedStatement2.close();
        preparedStatement.close();
        preparedStatement3.close();
    }

    @Override
    public void setSeed(long l) {
        this.seed = l;
    }

    @Override
    public void setThreadCount(int n) {
    }
}

