/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.utilXid;

public class XATestUtil {
    public static Xid getXid(int n, int n2, int n3) {
        int n4;
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        for (n4 = 0; n4 < byArray.length; ++n4) {
            byArray[n4] = (byte)(n2 + n4);
        }
        for (n4 = 0; n4 < byArray2.length; ++n4) {
            byArray2[n4] = (byte)(n3 + n4);
        }
        return XATestUtil.getXid(n, byArray, byArray2);
    }

    public static Xid getXid(int n, byte[] byArray, byte[] byArray2) {
        return new utilXid(n, byArray, byArray2);
    }

    public static void dumpXAException(String string, XAException xAException) {
        System.out.println(string + " : XAException - " + xAException.getMessage() + " errorCode " + XATestUtil.errorCode(xAException));
        xAException.printStackTrace(System.out);
    }

    public static void createXATransactionView(Statement statement) throws SQLException {
        statement.execute("create view XATESTUTIL.global_xactTable as select  cast(global_xid as char(2)) as gxid, status,  CAST (case when first_instant is NULL then 'NULL' else 'false' end AS VARCHAR(8)) as readOnly,  cast (username as char(10)) as username, type  from syscs_diag.transaction_table");
    }

    public static void checkXATransactionView(Connection connection, String[][] stringArray) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from XATESTUTIL.global_xactTable where gxid is not null order by gxid");
        if (stringArray == null) {
            JDBC.assertEmpty(resultSet);
        } else {
            JDBC.assertUnorderedResultSet(resultSet, stringArray);
        }
        resultSet.close();
    }

    public static String errorCode(XAException xAException) {
        String string;
        switch (xAException.errorCode) {
            case 7: {
                string = "XA_HEURCOM ";
                break;
            }
            case 8: {
                string = "XA_HEURHAZ";
                break;
            }
            case 5: {
                string = "XA_HEURMIX";
                break;
            }
            case 6: {
                string = "XA_HEURRB ";
                break;
            }
            case 9: {
                string = "XA_NOMIGRATE ";
                break;
            }
            case 101: {
                string = "XA_RBCOMMFAIL ";
                break;
            }
            case 102: {
                string = "XA_RBDEADLOCK ";
                break;
            }
            case 103: {
                string = "XA_RBINTEGRITY ";
                break;
            }
            case 104: {
                string = "XA_RBOTHER ";
                break;
            }
            case 105: {
                string = "XA_RBPROTO ";
                break;
            }
            case 100: {
                string = "XA_RBROLLBACK ";
                break;
            }
            case 106: {
                string = "XA_RBTIMEOUT ";
                break;
            }
            case 107: {
                string = "XA_RBTRANSIENT ";
                break;
            }
            case 3: {
                string = "XA_RDONLY ";
                break;
            }
            case 4: {
                string = "XA_RETRY ";
                break;
            }
            case -2: {
                string = "XAER_ASYNC ";
                break;
            }
            case -8: {
                string = "XAER_DUPID ";
                break;
            }
            case -5: {
                string = "XAER_INVAL ";
                break;
            }
            case -4: {
                string = "XAER_NOTA ";
                break;
            }
            case -9: {
                string = "XAER_OUTSIDE ";
                break;
            }
            case -6: {
                string = "XAER_PROTO ";
                break;
            }
            case -3: {
                string = "XAER_RMERR ";
                break;
            }
            case -7: {
                string = "XAER_RMFAIL ";
                break;
            }
            default: {
                string = Integer.toString(xAException.errorCode);
            }
        }
        return string;
    }
}

