/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class st_derby1939
extends BaseJDBCTestCase {
    private final int VC_SIZE = 1024;

    public st_derby1939(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.language.maxMemoryPerTable", "140");
        properties.setProperty("derby.optimizer.noTimeout", "true");
        return new SystemPropertyTestSetup((Test)new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(st_derby1939.class)), properties, true);
    }

    public void testDerby1939() throws SQLException {
        this.setAutoCommit(false);
        this.doLoad();
        this.doQuery();
    }

    private void doLoad() throws SQLException {
        Statement statement = this.createStatement();
        st_derby1939.println("Creating tables and index...");
        statement.execute("create table d1939_t1 (i smallint, vc varchar(1024))");
        statement.execute("create table d1939_t2 (j smallint, val double, vc varchar(1024))");
        statement.execute("create index ix_d1939_t1 on d1939_t1 (i)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into d1939_t1(i, vc) values (?, ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into d1939_t2 values (?, ?, ?)");
        st_derby1939.println("Doing inserts...");
        for (int i = 0; i < 69; ++i) {
            for (int j = 0; j < 10; ++j) {
                String string = this.buildString(i + ":" + j);
                preparedStatement.setInt(1, i % 10);
                preparedStatement.setString(2, string);
                preparedStatement.execute();
                preparedStatement2.setInt(1, i % 10);
                preparedStatement2.setDouble(2, (double)j * 2.0);
                if (j % 2 == 1) {
                    preparedStatement2.setString(3, "shorty-string");
                } else {
                    preparedStatement2.setString(3, string);
                }
                preparedStatement2.execute();
            }
            preparedStatement2.setInt(1, i);
            preparedStatement2.setDouble(2, (double)i * 2.0);
            preparedStatement2.setNull(3, 12);
            preparedStatement2.execute();
        }
        preparedStatement2.setNull(1, 4);
        preparedStatement2.setDouble(2, 48.0);
        preparedStatement.close();
        this.commit();
    }

    private void doQuery() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select * from d1939_t2   left outer join     (select distinct d1939_t1.i, d1939_t2.j, d1939_t1.vc from d1939_t2       left outer join d1939_t1         on d1939_t2.j = d1939_t1.i         and d1939_t1.i = ?     ) x1   on d1939_t2.j = x1.i");
        st_derby1939.println("Done preparing, about to execute...");
        preparedStatement.setShort(1, (short)8);
        int n = 0;
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            for (n = 0; resultSet.next() && n < 10; ++n) {
            }
            resultSet.close();
            st_derby1939.println("Ran without error, retrieved first " + n + " rows.");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("XSDA7")) {
                st_derby1939.fail("Reproduced DERBY-1939", sQLException);
            }
            throw sQLException;
        }
        preparedStatement.close();
        this.rollback();
    }

    private String buildString(String string) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (int i = 0; i < 1024; ++i) {
            stringBuilder.append(string.charAt(i % string.length()));
        }
        return stringBuilder.toString();
    }
}

