/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RowLockBasicTest
extends BaseJDBCTestCase {
    public RowLockBasicTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(RowLockBasicTest.class);
    }

    protected void setUp() throws SQLException {
        this.getConnection().setTransactionIsolation(8);
        Statement statement = this.createStatement();
        statement.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.createLockTableQueryEntries(statement);
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.rowLocking', 'true')");
        statement.close();
        this.getConnection().setAutoCommit(false);
        this.dropTable("a");
    }

    private void createLockTableQueryEntries(Statement statement) throws SQLException {
        statement.execute("create view lock_table as select cast(username as char(8)) as username,cast(t.type as char(8)) as trantype,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode,cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state,status from syscs_diag.lock_table l  right outer join syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' and t.type='UserTransaction'");
        statement.execute("create view full_lock_table as select cast(username as char(8)) as username, cast(t.type as char(8)) as trantype,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode, cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state,status from syscs_diag.lock_table l right outer join syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' ");
        statement.execute("create view lock_table2 as select cast(l.xid as char(8)) as xid,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode,cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state from syscs_diag.lock_table l where l.tableType <> 'S' ");
        statement.execute("create view tran_table as select * from syscs_diag.transaction_table");
    }

    @Override
    public void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("DROP FUNCTION PADSTRING");
        statement.execute("drop view lock_table");
        statement.execute("drop view full_lock_table");
        statement.execute("drop view lock_table2");
        statement.execute("drop view tran_table");
        statement.close();
        this.dropTable("a");
        this.commit();
        super.tearDown();
    }

    public void testInsertIntoHeap() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table a (a int)");
        this.commit();
        statement.execute("insert into a values (1)");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,7)", "GRANT", "ACTIVE"}});
        this.commit();
        statement.execute("insert into a values (2)");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,8)", "GRANT", "ACTIVE"}});
        this.commit();
        this.dropTable("a");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "3", "X", "*** TRANSIEN", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
    }

    public void testInsertIntoBtree() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table a (a int, b varchar(1000))");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.execute("create index a_idx on a (a, b)");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "4", "S", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.execute("insert into a values (1, PADSTRING('a',1000))");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "2", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,7)", "GRANT", "ACTIVE"}});
        this.commit();
        statement.execute("insert into a values (2, PADSTRING('b',1000))");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "2", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,8)", "GRANT", "ACTIVE"}});
        this.commit();
        statement.execute("insert into a values (3, PADSTRING('c',1000))");
        this.commit();
        statement.execute("insert into a values (4, PADSTRING('d',1000))");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "2", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,10)", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(2,6)", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
    }

    public void testInsertOnNewPage() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table a (a int, b varchar(1000))");
        statement.execute("create unique index a_idx on a (a, b)");
        statement.execute("insert into a values (1, PADSTRING('a',1000))");
        statement.execute("insert into a values (2, PADSTRING('b',1000))");
        statement.execute("insert into a values (3, PADSTRING('c',1000))");
        statement.execute("insert into a values (4, PADSTRING('d',1000))");
        ResultSet resultSet = statement.executeQuery("select a from a");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}});
        statement.execute("delete from a where a = 3");
        resultSet = statement.executeQuery("select a from a");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"4"}});
        this.commit();
        statement.execute("insert into a values (3, PADSTRING('c',1000))");
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "2", "IX", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(1,9)", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "X", "A", "(2,7)", "GRANT", "ACTIVE"}});
        statement.close();
    }

    public void testFullCoveredIndexScan() throws SQLException {
        Statement statement = this.createStatement();
        this.createTableAandUniqueIndex(statement);
        ResultSet resultSet = statement.executeQuery("select a from a");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}});
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "S", "A", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
    }

    private void createTableAandUniqueIndex(Statement statement) throws SQLException {
        statement.execute("create table a (a int, b char(200))");
        statement.execute("create unique index a_idx on a (a)");
        statement.execute("insert into a values (1, 'a')");
        statement.execute("insert into a values (2, 'b')");
        statement.execute("insert into a values (3, 'c')");
        statement.execute("insert into a values (4, 'd')");
        this.commit();
    }

    public void testSingleProbeIntoFirstKey() throws SQLException {
        Statement statement = this.createStatement();
        this.createTableAandUniqueIndex(statement);
        ResultSet resultSet = statement.executeQuery("select a from a where a = 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,7)", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
    }

    public void testSingleProbeIntoLastKey() throws SQLException {
        Statement statement = this.createStatement();
        this.createTableAandUniqueIndex(statement);
        ResultSet resultSet = statement.executeQuery("select a from a where a = 4");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"4"}});
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,10)", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
    }

    public void testSetOfRangeScanFor1RowReturn() throws SQLException {
        Statement statement = this.createStatement();
        this.createTableAandUniqueIndex(statement);
        ResultSet resultSet = statement.executeQuery("select a from a where a <= 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,3)", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,7)", "GRANT", "ACTIVE"}});
        this.commit();
        resultSet = statement.executeQuery("select a from a where a >= 2 and a < 3");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2"}});
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,8)", "GRANT", "ACTIVE"}});
        this.commit();
        resultSet = statement.executeQuery("select a from a where a > 3");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"4"}});
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,10)", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,9)", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
    }

    public void testSetOfRangeScanFor0RowReturn() throws SQLException {
        Statement statement = this.createStatement();
        this.createTableAandUniqueIndex(statement);
        ResultSet resultSet = statement.executeQuery("select a from a where a < 1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,3)", "GRANT", "ACTIVE"}});
        this.commit();
        resultSet = statement.executeQuery("select a from a where a > 4");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,10)", "GRANT", "ACTIVE"}});
        this.commit();
        resultSet = statement.executeQuery("select a from a where a > 2 and a < 3");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "IS", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "ROW", "1", "S", "A", "(1,8)", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
    }

    public void testCreateIndexDoesTableLevelLocking() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table a (a int, b char(200))");
        statement.execute("create table b (a int, b char(200))");
        statement.execute("insert into a values (1, 'a')");
        statement.execute("insert into a values (2, 'b')");
        statement.execute("insert into a values (3, 'c')");
        statement.execute("insert into a values (4, 'd')");
        this.commit();
        statement.execute("create unique index a_idx on a (a)");
        ResultSet resultSet = statement.executeQuery("select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "4", "S", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "A", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        resultSet = statement.executeQuery("select a from a");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}, {"2"}, {"3"}, {"4"}});
        resultSet = statement.executeQuery("select a from b");
        JDBC.assertDrainResults(resultSet, 0);
        this.commit();
        statement.execute("drop index a_idx");
        this.dropTable("a");
        this.dropTable("b");
        statement.close();
    }
}

