/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class EncryptDatabaseTest
extends BaseJDBCTestCase {
    private static final String ENCRYPTION_NOCHANGE_ALGORITHM = "XBCXD";
    private static final String ENCRYPTION_NOCHANGE_PROVIDER = "XBCXE";
    private static final String ILLEGAL_BP_LENGTH = "XBCX2";
    private static final String NULL_BOOT_PASSWORD = "XBCX5";
    private static final String WRONG_BOOT_PASSWORD = "XBCXA";
    private static final String WRONG_PASSWORD_CHANGE_FORMAT = "XBCX7";

    public EncryptDatabaseTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("EncryptDatabase");
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest());
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest("DESede/CBC/NoPadding"));
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest("DESede/CFB/NoPadding"));
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest("DES/OFB/NoPadding"));
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest("DES/ECB/NoPadding"));
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest("DES/CBC/NoPadding"));
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest("Blowfish/CBC/NoPadding"));
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest("AES/CBC/NoPadding"));
        baseTestSuite.addTest(EncryptDatabaseTest.wrapTest("AES/OFB/NoPadding"));
        return baseTestSuite;
    }

    private static Test wrapTest() {
        return Decorator.encryptedDatabaseBpw(TestConfiguration.embeddedSuite(EncryptDatabaseTest.class), "Thursday");
    }

    private static Test wrapTest(String string) {
        return Decorator.encryptedDatabaseBpw(TestConfiguration.embeddedSuite(EncryptDatabaseTest.class), string, "Thursday");
    }

    public void testEncryption() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday, Wednesday')");
        TestConfiguration.getCurrent().shutdownEngine();
        this.assertFailedBoot("Thursday");
        EncryptDatabaseTest.assertSuccessfulBoot("Wednesday");
        statement = this.createStatement();
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Wednesday, Thursday')");
        statement.executeUpdate("create table t1 ( a char(20))");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('bootPassword')"), null);
        JDBC.assertSingleValueResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('encryptedBootPassword')"), null);
        statement.executeUpdate("insert into t1 values ('hello world')");
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', null)", NULL_BOOT_PASSWORD);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'wrongkey, ')", ILLEGAL_BP_LENGTH);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday')", WRONG_PASSWORD_CHANGE_FORMAT);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday , ')", ILLEGAL_BP_LENGTH);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday , short')", ILLEGAL_BP_LENGTH);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursdya , derbypwd')", WRONG_BOOT_PASSWORD);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursdayx , derbypwd')", WRONG_BOOT_PASSWORD);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'xThursday , derbypwd')", WRONG_BOOT_PASSWORD);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'thursday , derbypwd')", WRONG_BOOT_PASSWORD);
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', ' Thursday , Saturday')");
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Thursday , derbypwd')", WRONG_BOOT_PASSWORD);
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'Saturday,derbypwd')");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('bootPassword')"), null);
        JDBC.assertSingleValueResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('encryptedBootPassword')"), null);
        TestConfiguration.getCurrent().shutdownEngine();
        this.assertFailedBoot(null);
        this.assertFailedBoot("Thursday");
        this.assertFailedBoot("Saturday");
        EncryptDatabaseTest.assertSuccessfulBoot("derbypwd");
        statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('bootPassword')"), null);
        JDBC.assertSingleValueResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('encryptedBootPassword')"), null);
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', '   derbypwd   ,  bbderbypwdx  ')");
        statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('bootPassword', 'bbderbypwdx, derbypwdxx ')");
        JDBC.assertSingleValueResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('bootPassword')"), null);
        JDBC.assertSingleValueResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('encryptedBootPassword')"), null);
        TestConfiguration.getCurrent().shutdownEngine();
        this.assertFailedBoot("derbypwd");
        EncryptDatabaseTest.assertSuccessfulBoot("derbypwdxx");
        statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select * from t1"), "hello world");
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('encryptionAlgorithm', 'DES/blabla/NoPadding')", ENCRYPTION_NOCHANGE_ALGORITHM);
        EncryptDatabaseTest.assertFailedStatement(statement, "call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('encryptionProvider', 'com.pom.aplomb')", ENCRYPTION_NOCHANGE_PROVIDER);
    }

    private void assertFailedBoot(String string) throws SQLException {
        block2: {
            DataSource dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", string != null ? "bootPassword=" + string : "");
            try {
                dataSource.getConnection();
                EncryptDatabaseTest.fail((String)"boot worked: unexpected");
            }
            catch (SQLException sQLException) {
                String[] stringArray = new String[]{"XBM06", "XJ040"};
                boolean bl = Arrays.asList(stringArray).contains(sQLException.getSQLState());
                if (bl) break block2;
                throw sQLException;
            }
        }
    }

    private static void assertSuccessfulBoot(String string) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "bootPassword=" + string);
        dataSource.getConnection().close();
    }

    private static void assertFailedStatement(Statement statement, String string, String string2) {
        EncryptDatabaseTest.assertStatementError(string2, statement, string);
    }
}

