/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class ShutdownSlave
extends BaseJDBCTestCase {
    private static ReplicationRun repRun = new ReplicationRun("ShutdownSlave");
    static String jvmVersion = null;
    static String derbyVersion = null;
    static String slaveServerHost = null;
    static int slaveServerPort = -1;
    static String slaveDatabasePath = null;
    static String masterServerHost = null;
    static int masterServerPort = -1;
    static String masterDatabasePath = null;

    public ShutdownSlave(String string) {
        super(string);
    }

    static void setEnv() throws Exception {
        repRun.initEnvironment();
        masterServerHost = ReplicationRun.masterServerHost;
        masterServerPort = ReplicationRun.masterServerPort;
        slaveServerHost = ReplicationRun.slaveServerHost;
        slaveServerPort = ReplicationRun.slaveServerPort;
        jvmVersion = ReplicationRun.masterJvmVersion;
        derbyVersion = ReplicationRun.derbyMasterVersion;
        masterDatabasePath = ReplicationRun.masterDatabasePath;
        slaveDatabasePath = ReplicationRun.slaveDatabasePath;
    }

    void shutdown(String string, boolean bl, boolean bl2) throws SQLException, IOException, InterruptedException {
        System.out.println("**** ShutdownSlave.shutdown() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName() + " " + string + " dbOnly: " + bl + " killServer: " + bl2);
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.executeUpdate("create table t (i integer primary key, vc varchar(20))");
        PreparedStatement preparedStatement = this.prepareStatement("insert into t values (?,?)");
        for (int i = 0; i < 1000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setString(2, "i" + i);
            preparedStatement.execute();
            System.out.println("i: " + i);
            if (i != 500) continue;
            if (bl2) {
                repRun.killMaster(slaveServerHost, slaveServerPort);
                continue;
            }
            if (string == null) {
                repRun.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
                continue;
            }
            System.out.println("**** DriverManager.getConnection(\"" + string + ";shutdown=true\");");
            try {
                DriverManager.getConnection(string + ";shutdown=true");
                continue;
            }
            catch (SQLException sQLException) {
                int n = sQLException.getErrorCode();
                String string2 = sQLException.getMessage();
                String string3 = sQLException.getSQLState();
                String string4 = bl ? "08004" : "XJ015";
                int n2 = bl ? 45000 : 50000;
                System.out.println("shutdown Got SQLException: " + n + " " + string3 + " " + string2);
                if (n == n2 && string3.equalsIgnoreCase(string4)) {
                    System.out.println("As expected.");
                    continue;
                }
                throw sQLException;
            }
        }
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n = resultSet.getInt(1);
        System.out.println("count: " + n);
    }
}

