/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XML;

public final class XMLMissingClassesTest
extends BaseJDBCTestCase {
    private static String[] SQLXML_STMTS = new String[]{"insert into xt values (1, xmlparse(document '<hi/>' preserve whitespace))", "select xmlserialize(x as char(80)) from xt", "select xmlexists('//*' passing by ref x) from xt", "select i from xt where xmlquery('//*' passing by ref x empty on empty) is not null"};

    public XMLMissingClassesTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("XML Missing Classes Suite");
        if (!XML.classpathMeetsXMLReqs()) {
            baseTestSuite.addTest(TestConfiguration.defaultSuite(XMLMissingClassesTest.class));
        }
        return baseTestSuite;
    }

    public void testMissingClasses() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table xt (i int, x xml)");
        statement.execute("create table xt1 (i int, x xml default null)");
        this.assertCompileError("XML00", "create table fail1 (i int, x xml check (xmlexists('//should' passing by ref x)))");
        this.assertCompileError("XML00", "create table fail2 (i int, x xml default xmlparse(document '<my>default col</my>' preserve whitespace))");
        this.assertCompileError("42894", "create table fail3 (i int, x xml default 'oops')");
        this.assertCompileError("42894", "create table fail4 (i int, x xml default 8)");
        this.assertCompileError("42818", "create table fail5 (i int, x xml check (x != 0))");
        for (int i = 0; i < SQLXML_STMTS.length; ++i) {
            this.assertCompileError("XML00", SQLXML_STMTS[i]);
        }
        statement.execute("drop table xt");
        statement.execute("drop table xt1");
        statement.close();
        statement = null;
    }
}

