/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;

public class SynonymTest
extends BaseJDBCTestCase {
    public SynonymTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite(SynonymTest.class, "SynonymTest");
        return new CleanDatabaseTestSetup((Test)baseTestSuite);
    }

    public void testViewDependency() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create synonym mySyn for sys.systables");
        statement.executeUpdate("create view v1 as select * from mySyn");
        statement.executeUpdate("create view v2 as select * from v1");
        SynonymTest.assertStatementError("X0Y23", statement, "drop synonym mySyn");
        statement.executeUpdate("drop view v2");
        SynonymTest.assertStatementError("X0Y23", statement, "drop synonym mySyn");
        statement.executeUpdate("drop view v1");
        statement.executeUpdate("drop synonym mySyn");
        statement.close();
    }

    public void testMetaDataCallOnSynonymsDERBY5244() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1Derby5422 ( c11 int not null, c12 char(2) )");
        statement.executeUpdate("create synonym s1Derby5422 for t1Derby5422");
        statement.executeUpdate("create view v1Derby5422 as select * from t1Derby5422");
        ResultSet resultSet = statement.executeQuery("select * from S1DERBY5422");
        JDBC.assertEmpty(resultSet);
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        resultSet = databaseMetaData.getColumns(null, null, "T1DERBY5422", null);
        JDBC.assertDrainResultsHasData(resultSet);
        resultSet = databaseMetaData.getColumns(null, null, "V1DERBY5422", null);
        JDBC.assertDrainResultsHasData(resultSet);
        resultSet = databaseMetaData.getColumns(null, null, "S1DERBY5422", null);
        JDBC.assertEmpty(resultSet);
    }

    public void testSynonymsInSearchedDeleteDERBY4110() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create schema test1");
        statement.executeUpdate("create schema test2");
        statement.executeUpdate("create table test1.t1 ( id bigint not null )");
        statement.executeUpdate("insert into test1.t1 values (1),(2)");
        statement.executeUpdate("create synonym test2.t1 for test1.t1");
        statement.executeUpdate("create unique index idx4110 on test1.t1 (id)");
        statement.executeUpdate("set schema test2");
        statement.executeUpdate("delete from t1 where id = 2");
        statement.executeUpdate("drop synonym test2.t1");
        statement.executeUpdate("drop table test1.t1");
        statement.executeUpdate("drop schema test2 restrict");
        statement.executeUpdate("drop schema test1 restrict");
    }

    public void testSynonymsForTablesWithDoubleQuotes() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create schema \"\"\"\"");
        statement.execute("create table \"\"\"\".\"\"\"\" (x int)");
        statement.execute("create synonym derby_5168_synonym for \"\"\"\".\"\"\"\"");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select aliasinfo from sys.sysaliases where alias = 'DERBY_5168_SYNONYM'"), "\"\"\"\".\"\"\"\"");
    }
}

