/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SequencePermsTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String IRMA = "IRMA";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK", "IRMA"};

    public SequencePermsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(SequencePermsTest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        Test test = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanDatabaseTestSetup, LEGAL_USERS, "sequencePermissions");
        Test test2 = TestConfiguration.sqlAuthorizationDecorator(test);
        return test2;
    }

    public void test_001_basicGrant() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        Connection connection3 = this.openUserConnection(ALICE);
        Connection connection4 = this.openUserConnection(FRANK);
        this.goodStatement(connection2, "create sequence seq_01\n");
        this.goodStatement(connection2, "create table t_01( c int )\n");
        this.goodStatement(connection2, "insert into t_01( c ) values ( 1 )\n");
        this.goodStatement(connection2, "create view v_01( a, b ) as select c, next value for seq_01 from t_01\n");
        this.goodStatement(connection2, "grant select on v_01 to alice\n");
        this.expectExecutionError(connection3, "42504", "values ( next value for ruth.seq_01 )\n");
        this.expectExecutionError(connection3, "42502", "select * from ruth.t_01\n");
        this.goodStatement(connection2, "select * from ruth.v_01\n");
        this.goodStatement(connection2, "values ( next value for ruth.seq_01 )\n");
        this.goodStatement(connection2, "grant usage on sequence seq_01 to alice\n");
        this.goodStatement(connection3, "values( next value for ruth.seq_01 )\n");
    }

    public void test_002_basicRevoke() throws Exception {
        Connection connection = this.openUserConnection(RUTH);
        Connection connection2 = this.openUserConnection(FRANK);
        this.goodStatement(connection, "create sequence seq_02\n");
        this.goodStatement(connection2, "create table t_01( c int )\n");
        this.expectExecutionError(connection2, "42504", "values ( next value for ruth.seq_02 )\n");
        this.goodStatement(connection, "grant usage on sequence seq_02 to public\n");
        this.expectCompilationError(connection, "42X01", "revoke usage on sequence seq_02 from public\n");
        this.goodStatement(connection, "revoke usage on sequence seq_02 from public restrict\n");
        String string = "grant usage on sequence seq_02 to frank\n";
        String string2 = "revoke usage on sequence seq_02 from frank restrict\n";
        String string3 = "create view v_01( a, b ) as select c, next value for ruth.seq_02 from t_01\n";
        String string4 = "drop view v_01\n";
        String string5 = "X0Y23";
        this.verifyRevokePrivilege(connection, connection2, string, string2, string3, string4, string5);
        string3 = "create trigger trig_01 after update on t_01 for each statement insert into t_01( c ) values ( next value for ruth.seq_02 )\n";
        string4 = "drop trigger trig_01\n";
        string5 = "X0Y25";
        this.verifyRevokePrivilege(connection, connection2, string, string2, string3, string4, string5);
    }

    public void test_003_dropSchema() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(IRMA);
        this.goodStatement(connection2, "create sequence seq_01\n");
        this.expectExecutionError(connection, "X0Y54", "drop schema irma restrict\n");
        this.goodStatement(connection2, "drop sequence seq_01 restrict\n");
        this.goodStatement(connection, "drop schema irma restrict\n");
    }
}

