/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RenameIndexTest
extends BaseJDBCTestCase {
    public RenameIndexTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(RenameIndexTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRenameNonExistingIndex() throws SQLException {
        Statement statement = this.createStatement();
        RenameIndexTest.assertStatementError("42X65", statement, "rename index i1t1 to i1rt1");
    }

    public void testExistingIndexName() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(c11 int, c12 int)");
        statement.executeUpdate("create index i1t1 on t1(c11)");
        statement.executeUpdate("create index i2t1 on t1(c12)");
        RenameIndexTest.assertStatementError("X0Y32", statement, "rename index i1t1 to i2t1");
        statement.executeUpdate("drop table t1");
    }

    public void testRenameSystemTableIndex() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("set schema sys");
        RenameIndexTest.assertStatementError("X0Y56", statement, "rename index syscolumns_index1 to newName");
        statement.executeUpdate("set schema app");
    }

    public void testRenameIndexOfView() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(c11 int, c12 int)");
        statement.executeUpdate("create index t1i1 on t1(c11)");
        statement.executeUpdate("create view v1 as select * from t1");
        ResultSet resultSet = statement.executeQuery("select count(*) from v1");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        RenameIndexTest.assertUpdateCount(statement, 0, "rename index t1i1 to t1i1r");
        resultSet = statement.executeQuery("select count(*) from v1");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        statement.executeUpdate("drop view v1");
        statement.executeUpdate("drop table t1");
    }

    public void testDuplicateIndexWithViews() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(c11 int not null primary key, c12 int)");
        statement.executeUpdate("create index i1t1 on t1(c11)");
        statement.executeUpdate("create view v1 as select * from t1");
        RenameIndexTest.assertStatementError("42X65", statement, "rename index i1t1 to i1rt1");
        RenameIndexTest.assertUpdateCount(statement, 0, "drop view v1");
        RenameIndexTest.assertUpdateCount(statement, 0, "create view v1 as select * from t1");
        ResultSet resultSet = statement.executeQuery("select count(*) from v1");
        JDBC.assertSingleValueResultSet(resultSet, "0");
        RenameIndexTest.assertStatementError("42X65", statement, "rename index i1rt1 to i1t1");
        statement.executeUpdate("drop view v1");
        statement.executeUpdate("drop table t1");
    }

    public void testRenameIndexWithOpenCursor() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        statement.executeUpdate("create table t1(c11 int , c12 int)");
        statement.executeUpdate("create index i1 on t1(c11)");
        statement.executeUpdate("insert into t1 values(2 , 3)");
        statement.executeUpdate("insert into t1 values(3 , 4)");
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        RenameIndexTest.assertStatementError("X0X95", this.createStatement(), "rename index i1 to i1r");
        resultSet.close();
        RenameIndexTest.assertUpdateCount(statement, 0, "rename index i1 to i1r");
        statement.executeUpdate("drop table t1");
    }

    public void testWithPreparedStatement() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(c11 int not null primary key, c12 int)");
        statement.executeUpdate("create index i1 on t1(c11)");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t1 where c11 > ?");
        preparedStatement.setInt(1, 1);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        resultSet.close();
        RenameIndexTest.assertStatementError("42X65", statement, "rename index i1 to i1r");
        preparedStatement.setInt(1, 1);
        resultSet = preparedStatement.executeQuery();
        resultSet.next();
        resultSet.close();
        preparedStatement.close();
        statement.executeUpdate("drop table t1");
    }

    public void testRenameColumnWithIndex() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t3(c31 int not null primary key, c32 int)");
        statement.executeUpdate("create index i1_t3 on t3(c32)");
        statement.executeUpdate("rename index i1_t3 to i1_3r");
        RenameIndexTest.assertStatementError("42X65", statement, "rename index i1_t3 to i1_3r");
        statement.executeUpdate("drop table t3");
    }

    public void testDuplicateIndexWithPreparedStatement() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t3(c31 int not null primary key, c32 int)");
        statement.executeUpdate("create index i1_t3 on t3(c32)");
        PreparedStatement preparedStatement = this.prepareStatement("select * from t3 where c31 > ?");
        preparedStatement.setInt(1, 1);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.close();
        RenameIndexTest.assertUpdateCount(statement, 0, "rename index i1_t3 to i1_t3r");
        preparedStatement.setInt(1, 1);
        resultSet = preparedStatement.executeQuery();
        resultSet.close();
        RenameIndexTest.assertUpdateCount(statement, 0, "rename index i1_t3r to i1_t3");
        preparedStatement.close();
        statement.executeUpdate("drop table t3");
    }
}

