/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class PredicatePushdownTest
extends BaseJDBCTestCase {
    public PredicatePushdownTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.optimizer.noTimeout", "true");
        BaseTestSuite baseTestSuite = new BaseTestSuite("predicatePushdown Test");
        baseTestSuite.addTest((Test)new SystemPropertyTestSetup((Test)new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(PredicatePushdownTest.class)), properties));
        return baseTestSuite;
    }

    /*
     * Opcode count of 19654 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public void test_predicatePushdown() throws Exception {
        ResultSet resultSet = null;
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE \"APP\".\"T1\" (\"I\" INTEGER, \"J\" INTEGER)");
        statement.executeUpdate(" insert into t1 values (1, 2), (2, 4), (3, 6), (4, 8), (5, 10)");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T2\" (\"I\" INTEGER, \"J\" INTEGER)");
        statement.executeUpdate(" insert into t2 values (1, 2), (2, -4), (3, 6), (4, -8), (5, 10)");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T3\" (\"A\" INTEGER, \"B\" INTEGER)");
        statement.executeUpdate(" insert into T3 values (1,1), (2,2), (3,3), (4,4), (6, 24), (7, 28), (8, 32), (9, 36), (10, 40)");
        statement.executeUpdate(" insert into t3 (a) values 11, 12, 13, 14, 15, 16, 17, 18, 19, 20");
        PredicatePushdownTest.assertUpdateCount(statement, 10, " update t3 set b = 2 * a where a > 10");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T4\" (\"A\" INTEGER, \"B\" INTEGER)");
        statement.executeUpdate(" insert into t4 values (3, 12), (4, 16)");
        statement.executeUpdate(" insert into t4 (a) values 11, 12, 13, 14, 15, 16, 17, 18, 19, 20");
        PredicatePushdownTest.assertUpdateCount(statement, 10, " update t4 set b = 2 * a where a > 10");
        statement.executeUpdate(" create view V1 as select i, j from T1 union select i,j from T2");
        statement.executeUpdate(" create view V2 as select a,b from T3 union select a,b from T4");
        PredicatePushdownTest.assertUpdateCount(this.prepareCall("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T1', 1)"), 0);
        PredicatePushdownTest.assertUpdateCount(this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T2', 1)"), 0);
        PredicatePushdownTest.assertUpdateCount(this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T3', 1)"), 0);
        PredicatePushdownTest.assertUpdateCount(this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T4', 1)"), 0);
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        resultSet = statement.executeQuery("select * from V1, V2 where V1.j = V2.b");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "2", "2"}, {"2", "4", "4", "4"}}, true);
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan", (boolean)runtimeStatisticsParser.usedTableScan());
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("select * from V2, V1 where V1.j = V2.b");
        JDBC.assertColumnNames(resultSet, "A", "B", "I", "J");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "2", "1", "2"}, {"4", "4", "2", "4"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan", (boolean)runtimeStatisticsParser.usedTableScan());
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2 union select * from t1 union select * from t2 ) x1, (select * from t3 union select * from t4 union select * from t4 ) x2 where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan", (boolean)runtimeStatisticsParser.usedTableScan());
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("select * from (select * from t1 union all select * from t2) x1, (select * from t3 union select * from t4) x2 where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}, {"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan", (boolean)runtimeStatisticsParser.usedTableScan());
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2) x1, (select * from t3 union all select * from t4) x2 where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan", (boolean)runtimeStatisticsParser.usedTableScan());
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("select * from (select * from t1 union all select * from t2) x1, (select * from t3 union all select * from t4) x2 where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}, {"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan", (boolean)runtimeStatisticsParser.usedTableScan());
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        statement.executeUpdate("create table tc (c1 char, c2 char, c3 char, c int)");
        statement.executeUpdate(" create view vz (z1, z2, z3, z4) as select distinct xx1.c1, xx1.c2, 'bokibob' bb, xx1.c from (select c1, c, c2, c3 from tc) xx1 union select 'i','j','j',i from t2");
        statement.executeUpdate(" create view vz2 (z1, z2, z3, z4) as select distinct xx1.c1, xx1.c2, 'bokibob' bb, xx1.c from (select c1, c, c2, c3 from tc) xx1");
        statement.executeUpdate(" create view vz3 (z1, z2, z3, z4) as select distinct xx1.c1, xx1.c2, 'bokibob' bb, xx1.c from (select c1, c, c2, 28 from tc) xx1 union select 'i','j','j',i from t2");
        statement.executeUpdate(" create view vz4 (z1, z2, z3, z4) as select distinct xx1.c1, xx1.c2, 'bokibob' bb, xx1.c from (select c1, c, c2, 28 from tc) xx1 union select 'i','j','j',i from t2 union select c1, c2, c3, c from tc");
        statement.executeUpdate("create view vz5a (z1, z2, z3, z4) as select distinct xx1.c1, xx1.c2, 'bokibob' bb, xx1.c from (select c1, c2, c3, c from --DERBY-PROPERTIES joinOrder=FIXED \nt2, tc where tc.c = t2.i) xx1 union select 'i','j','j',i from t2");
        statement.executeUpdate("create view vz5b (z1, z2, z3, z4) as select distinct xx1.c1, xx1.c2, 'bokibob' bb, xx1.c from (select c1, c2, c3, c from --DERBY-PROPERTIES joinOrder=FIXED \n t2, (select distinct * from tc) tc where tc.c = t2.i) xx1 union select 'i','j','j',i from t2");
        statement.executeUpdate("create view vz5c (z1, z2, z3, z4) as select distinct xx1.c1, xx1.c2, 'bokibob' bb, xx1.c from (select c1, c2, c3, c from --DERBY-PROPERTIES joinOrder=FIXED \n t2, (select * from tc union select * from tc) tc where tc.c = t2.i) xx1 union select 'i','j','j',i from t2");
        statement.executeUpdate("create view vz5d (z1, z2, z3, z4) as select distinct xx1.c1, xx1.c2, 'bokibob' bb, xx1.c from (select c1, c2, c3, c from --DERBY-PROPERTIES joinOrder=FIXED \n t2, (select * from tc union select z1 c1, z2 c2, z3 c3, z4 c from vz5b) tc where tc.c = t2.i) xx1 union select 'i','j','j',i from t2");
        resultSet = statement.executeQuery("select x1.c1 from (select count(*) from t1 union select count(*) from t2) x1 (c1), (select count(*) from t3 union select count(*) from t4) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select x1.c1 from (select count(*) from (select distinct j from t1) xx1 union select count(*) from t2 ) x1 (c1), (select count(*) from t3 union select count(*) from t4) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select x1.c1 from (select count(*) from (select distinct j from t1 union select distinct j from t2) xx1 union select count(*) from t2 ) x1 (c1), (select count(*) from t3 union select count(*) from t4) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select x1.c1 from (select xx1.c from (select distinct c, c1 from tc) xx1 union select count(*) from t2 ) x1 (c1), (select count(*) from t3 union select count(*) from t4) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select x1.c1 from (select xx1.c from (select c, c1 from tc) xx1 union select count(*) from t2 ) x1 (c1), (select count(*) from t3 union select count(*) from t4) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select x1.z1 from (select xx1.c1, xx1.c2, xx1.c, xx1.c3 from (select c1, c2, c3, c from tc) xx1 union select 'i','j',j,'i' from t2 ) x1 (z1, z2, z3, z4), (select count(*) from t3 union select count (*) from t4) x2 (c2) where x1.z3 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select x1.z1 from (select xx1.c1, xx1.c2, xx1.c, xx1.c3 from (select c1, c2, c3, c from tc) xx1 union select 'i','j',j,'i' from t2 ) x1 (z1, z2, z3, z4), (select a from t3 union select count (*) from t4) x2 (c2) where x1.z3 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"i"}, {"i"}, {"i"}}, true);
        resultSet = statement.executeQuery("select x1.z1 from (select xx1.c1, xx1.c2, xx1.c, xx1.c3 from (select c1, c2, c3, c from tc) xx1 union select 'i','j',j,'i' from t2 ) x1 (z1, z2, z3, z4), (select count(*) from t3 union select a from t4) x2 (c2) where x1.z3 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select x1.c1 from (select count(*) from (select distinct j from t1) xx1 union select count(*) from t2 ) x1 (c1), (select a from t3 union select a from t4) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select x1.c1 from (select count(*) from (select distinct j from t1) xx1 union select i from t2 ) x1 (c1), (select a from t3 union select a from t4) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1"}, {"2"}, {"3"}, {"4"}}, true);
        resultSet = statement.executeQuery("select x1.c1 from (select count(*) from (select distinct j from t1) xx1 union select count(*) from t2 ) x1 (c1), (select i from t2 union select i from t1) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"5"}}, true);
        resultSet = statement.executeQuery("select x1.c1 from (select count(*) from (select distinct j from t1) xx1 union select count(*) from t2 ) x1 (c1), (select 1 from t2 union select i from t1) x2 (c2) where x1.c1 = x2.c2");
        JDBC.assertColumnNames(resultSet, "C1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"5"}}, true);
        resultSet = statement.executeQuery("select x1.z4 from (select z1, z4, z3 from vz union select '1', 4, '3' from t1 ) x1 (z1, z4, z3), (select distinct j from t2 union select j from t1) x2 (c2) where x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"4"}, {"2"}, {"4"}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select z1, z4, z3 from vz union select '1', i+1, '3' from t1 ) x1 (z1, z4, z3), (select distinct j from t2 union select j from t1) x2 (c2) where x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "2"}, {"4", "4"}, {"6", "6"}, {"2", "2"}, {"4", "4"}}, true);
        resultSet = statement.executeQuery("select x1.z4 from (select z1, z4, z3 from vz2 union select '1', 4, '3' from t1 ) x1 (z1, z4, z3), (select distinct j from t2 union select j from t1) x2 (c2) where x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"4"}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select z1, z4, z3 from vz4 union select '1', i+1, '3' from t1 ) x1 (z1, z4, z3), (select distinct j from t2 union select j from t1) x2 (c2) where x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "2"}, {"4", "4"}, {"6", "6"}, {"2", "2"}, {"4", "4"}}, true);
        resultSet = statement.executeQuery("select t1.i, vz5a.* from t1 left outer join vz5a --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on t1.i = vz5a.z4");
        JDBC.assertColumnNames(resultSet, "I", "Z1", "Z2", "Z3", "Z4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "i", "j", "j", "1"}, {"2", "i", "j", "j", "2"}, {"3", "i", "j", "j", "3"}, {"4", "i", "j", "j", "4"}, {"5", "i", "j", "j", "5"}}, true);
        resultSet = statement.executeQuery("select t1.i, vz5a.* from t1 left outer join vz5a on t1.i = vz5a.z4");
        JDBC.assertColumnNames(resultSet, "I", "Z1", "Z2", "Z3", "Z4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "i", "j", "j", "1"}, {"2", "i", "j", "j", "2"}, {"3", "i", "j", "j", "3"}, {"4", "i", "j", "j", "4"}, {"5", "i", "j", "j", "5"}}, true);
        resultSet = statement.executeQuery("select t1.i, vz5b.* from t1 left outer join vz5b --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on t1.i = vz5b.z4");
        JDBC.assertColumnNames(resultSet, "I", "Z1", "Z2", "Z3", "Z4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "i", "j", "j", "1"}, {"2", "i", "j", "j", "2"}, {"3", "i", "j", "j", "3"}, {"4", "i", "j", "j", "4"}, {"5", "i", "j", "j", "5"}}, true);
        resultSet = statement.executeQuery(" select t1.i, vz5c.* from t1 left outer join vz5c --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on t1.i = vz5c.z4");
        JDBC.assertColumnNames(resultSet, "I", "Z1", "Z2", "Z3", "Z4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "i", "j", "j", "1"}, {"2", "i", "j", "j", "2"}, {"3", "i", "j", "j", "3"}, {"4", "i", "j", "j", "4"}, {"5", "i", "j", "j", "5"}}, true);
        resultSet = statement.executeQuery(" select t1.i, vz5d.* from t1 left outer join vz5d --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on t1.i = vz5d.z4");
        JDBC.assertColumnNames(resultSet, "I", "Z1", "Z2", "Z3", "Z4");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "i", "j", "bokibob", "1"}, {"1", "i", "j", "j", "1"}, {"2", "i", "j", "bokibob", "2"}, {"2", "i", "j", "j", "2"}, {"3", "i", "j", "bokibob", "3"}, {"3", "i", "j", "j", "3"}, {"4", "i", "j", "bokibob", "4"}, {"4", "i", "j", "j", "4"}, {"5", "i", "j", "bokibob", "5"}, {"5", "i", "j", "j", "5"}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select z1, z4, z3 from vz union select '1', i+1, '3' from t1 ) x1 (z1, z4, z3) left join (select distinct i,j from (select distinct i,j from t2) x3 union select i, j from t1 ) x2 (c1, c2) --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "2"}, {"3", null}, {"4", "4"}, {"5", null}, {"6", "6"}, {"1", null}, {"2", "2"}, {"3", null}, {"4", "4"}, {"5", null}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select z1, z4, z3 from vz union select '1', i+1, '3' from t1 ) x1 (z1, z4, z3) left join (select distinct i,j from (select distinct j,i from t2) x3 union select i, j from t1 ) x2 (c1, c2) --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "2"}, {"3", null}, {"4", "4"}, {"5", null}, {"6", "6"}, {"1", null}, {"2", "2"}, {"3", null}, {"4", "4"}, {"5", null}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select distinct i,j from (select distinct j,i from t2) x3 union select i, j from t1) x2 (c1, c2) left join (select z1, z4, z3 from vz union select '1', i+1, '3' from t1 ) x1 (z1, z4, z3) --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "2"}, {"2", "2"}, {null, "-4"}, {"4", "4"}, {"4", "4"}, {"6", "6"}, {null, "-8"}, {null, "8"}, {null, "10"}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select distinct i,j from (select distinct j,i from t2) x3 union select i, j from t1) x2 (c1, c2) left join (select z1, z4, z3 from vz union select '1', sin(i), '3' from t1 ) x1 (z1, z4, z3) --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2.0", "2"}, {null, "-4"}, {"4.0", "4"}, {null, "6"}, {null, "-8"}, {null, "8"}, {null, "10"}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select distinct i,j from (select distinct j,i from t2) x3 union select i, j from t1) x2 (c1, c2) left join (select z1, z4, z3 from vz union select '1', i, '3' from t1 ) x1 (z1, z4, z3) --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \non x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "2"}, {"2", "2"}, {null, "-4"}, {"4", "4"}, {"4", "4"}, {null, "6"}, {null, "-8"}, {null, "8"}, {null, "10"}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select distinct i,j from (select distinct j,i from t2) x3 union select i, j from t1) x2 (c1, c2) left join (select z1, z4, z3 from vz3 union select '1', sin(i), '3' from t1 ) x1 (z1, z4, z3) --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2.0", "2"}, {null, "-4"}, {"4.0", "4"}, {null, "6"}, {null, "-8"}, {null, "8"}, {null, "10"}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select distinct i,j from (select distinct j,i from t2) x3 union select i, j from t1) x2 (c1, c2) left join (select z1, z4, z3 from vz union select '1', sin(i), '3' from t1 union select '1', 14, '3' from t1 ) x1 (z1, z4, z3) --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2.0", "2"}, {null, "-4"}, {"4.0", "4"}, {null, "6"}, {null, "-8"}, {null, "8"}, {null, "10"}}, true);
        resultSet = statement.executeQuery("select x1.z4, x2.c2 from (select distinct i,j from (select distinct j,i from t2) x3 union select i, j from t1) x2 (c1, c2) left join (select '1', sin(i), '3' from t1 union select '1', 14, '3' from t1 union select z1, z4, z3 from vz ) x1 (z1, z4, z3) --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on x1.z4 = x2.c2");
        JDBC.assertColumnNames(resultSet, "Z4", "C2");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2.0", "2"}, {null, "-4"}, {"4.0", "4"}, {null, "6"}, {null, "-8"}, {null, "8"}, {null, "10"}}, true);
        statement.executeUpdate("drop view vz");
        statement.executeUpdate(" drop view vz2");
        statement.executeUpdate(" drop view vz3");
        statement.executeUpdate(" drop view vz4");
        statement.executeUpdate(" drop view vz5a");
        statement.executeUpdate(" drop view vz5d");
        statement.executeUpdate(" drop view vz5b");
        statement.executeUpdate(" drop view vz5c");
        statement.executeUpdate(" drop table tc");
        this.getConnection().setAutoCommit(false);
        statement.executeUpdate(" insert into t3 (a) values 21, 22, 23, 24, 25, 26, 27, 28, 29, 30");
        statement.executeUpdate(" insert into t3 (a) values 31, 32, 33, 34, 35, 36, 37, 38, 39, 40");
        statement.executeUpdate(" insert into t3 (a) values 41, 42, 43, 44, 45, 46, 47, 48, 49, 50");
        statement.executeUpdate(" insert into t3 (a) values 51, 52, 53, 54, 55, 56, 57, 58, 59, 60");
        statement.executeUpdate(" insert into t3 (a) values 61, 62, 63, 64, 65, 66, 67, 68, 69, 70");
        statement.executeUpdate(" insert into t3 (a) values 71, 72, 73, 74, 75, 76, 77, 78, 79, 80");
        statement.executeUpdate(" insert into t3 (a) values 81, 82, 83, 84, 85, 86, 87, 88, 89, 90");
        statement.executeUpdate(" insert into t3 (a) values 91, 92, 93, 94, 95, 96, 97, 98, 99, 100");
        PredicatePushdownTest.assertUpdateCount(statement, 80, " update t3 set b = 2 * a where a > 20");
        statement.executeUpdate(" insert into t4 (a, b) (select a,b from t3 where a > 20)");
        statement.executeUpdate(" insert into t4 (a, b) (select a,b from t3 where a > 20)");
        statement.executeUpdate(" insert into t3 (a, b) (select a,b from t4 where a > 20)");
        statement.executeUpdate(" insert into t4 (a, b) (select a,b from t3 where a > 20)");
        statement.executeUpdate(" insert into t3 (a, b) (select a,b from t4 where a > 20)");
        statement.executeUpdate(" insert into t4 (a, b) (select a,b from t3 where a > 20)");
        statement.executeUpdate(" insert into t3 (a, b) (select a,b from t4 where a > 20)");
        statement.executeUpdate(" insert into t4 (a, b) (select a,b from t3 where a > 20)");
        statement.executeUpdate(" insert into t3 (a, b) (select a,b from t4 where a > 20)");
        statement.executeUpdate(" insert into t4 (a, b) (select a,b from t3 where a > 20)");
        statement.executeUpdate(" insert into t3 (a, b) (select a,b from t4 where a > 20)");
        statement.executeUpdate(" insert into t4 (a, b) (select a,b from t3 where a > 20)");
        statement.executeUpdate(" insert into t3 (a, b) (select a,b from t4 where a > 20)");
        statement.executeUpdate(" insert into t4 (a, b) (select a,b from t3 where a > 20)");
        statement.executeUpdate(" insert into t3 (a, b) (select a,b from t4 where a > 60)");
        this.commit();
        this.getConnection().setAutoCommit(true);
        resultSet = statement.executeQuery("select count(*) from t3");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"54579"}}, true);
        resultSet = statement.executeQuery(" select count(*) from t4");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"48812"}}, true);
        statement.executeUpdate("CREATE INDEX \"APP\".\"T3_IX1\" ON \"APP\".\"T3\" (\"A\")");
        statement.executeUpdate(" CREATE INDEX \"APP\".\"T3_IX2\" ON \"APP\".\"T3\" (\"B\")");
        statement.executeUpdate(" CREATE INDEX \"APP\".\"T4_IX1\" ON \"APP\".\"T4\" (\"A\")");
        statement.executeUpdate(" CREATE INDEX \"APP\".\"T4_IX2\" ON \"APP\".\"T4\" (\"B\")");
        statement.executeUpdate("CREATE TABLE \"APP\".\"T5\" (\"I\" INTEGER, \"J\" INTEGER)");
        statement.executeUpdate(" insert into t5 values (5, 10)");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T6\" (\"P\" INTEGER, \"Q\" INTEGER)");
        statement.executeUpdate(" insert into t5 values (2, 4), (4, 8)");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"XX1\" (\"II\" INTEGER NOT NULL, \"JJ\" CHAR(10), \"MM\" INTEGER, \"OO\" DOUBLE, \"KK\" BIGINT)");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"YY1\" (\"II\" INTEGER NOT NULL, \"JJ\" CHAR(10), \"AA\" INTEGER, \"OO\" DOUBLE, \"KK\" BIGINT)");
        statement.executeUpdate(" ALTER TABLE \"APP\".\"YY1\" ADD CONSTRAINT \"PK_YY1\" PRIMARY KEY (\"II\")");
        statement.executeUpdate(" ALTER TABLE \"APP\".\"XX1\" ADD CONSTRAINT \"PK_XX1\" PRIMARY KEY (\"II\")");
        statement.executeUpdate(" create view xxunion as select all ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1 union all select ii, jj, kk, mm from xx1");
        statement.executeUpdate(" create view yyunion as select all ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1 union all select ii, jj, kk, aa from yy1");
        PredicatePushdownTest.assertUpdateCount(this.prepareCall("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T1', 1)"), 0);
        PredicatePushdownTest.assertUpdateCount(this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T2', 1)"), 0);
        PredicatePushdownTest.assertUpdateCount(this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T3', 1)"), 0);
        PredicatePushdownTest.assertUpdateCount(this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T4', 1)"), 0);
        PredicatePushdownTest.assertUpdateCount(this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T5', 1)"), 0);
        CallableStatement callableStatement = this.prepareCall(" call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'T6', 1)");
        PredicatePushdownTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery("select * from V1, V2 where V1.j = V2.b");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "2", "2"}, {"2", "4", "4", "4"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from V2, V1 where V1.j = V2.b");
        JDBC.assertColumnNames(resultSet, "A", "B", "I", "J");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "2", "1", "2"}, {"4", "4", "2", "4"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select count(*) from V1, V2 where V1.i in (2,4)");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"404"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T3", (boolean)runtimeStatisticsParser.usedTableScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T4", (boolean)runtimeStatisticsParser.usedTableScan("T4"));
        resultSet = statement.executeQuery("select count(*) from V1, V2 where V1.j > 0");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"505"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T3", (boolean)runtimeStatisticsParser.usedTableScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T4", (boolean)runtimeStatisticsParser.usedTableScan("T4"));
        resultSet = statement.executeQuery("select * from V1, V2 where V1.j = V2.b and V1.i in (2,4)");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "4", "4", "4"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2) x1, (select * from t3 union select * from t4) x2 where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2) x1, t3 where x1.i = t3.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"4", "-8", "4", "4"}, {"4", "8", "4", "4"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T1", (boolean)runtimeStatisticsParser.usedTableScan("T1"));
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T2", (boolean)runtimeStatisticsParser.usedTableScan("T2"));
        resultSet = statement.executeQuery("select * from (select * from t1 union all select * from t2) x1, (select * from t3 union select * from t4) x2 where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}, {"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from (select * from t1 union all select * from t2) x1, (select * from t3 union all select * from t4) x2 where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}, {"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from v1, v2 where V1.i = V1.j");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertEmpty(resultSet);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T1", (boolean)runtimeStatisticsParser.usedTableScan("T1"));
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T2", (boolean)runtimeStatisticsParser.usedTableScan("T2"));
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T3", (boolean)runtimeStatisticsParser.usedTableScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T4", (boolean)runtimeStatisticsParser.usedTableScan("T4"));
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2) x1 (c, d), (select * from t3 union select * from t4) x2 (e, f) where x1.c = x2.e");
        JDBC.assertColumnNames(resultSet, "C", "D", "E", "F");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2) x1 (a, b), (select * from t3 union select * from t4) x2 (i, j) where x1.a = x2.i");
        JDBC.assertColumnNames(resultSet, "A", "B", "I", "J");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select count(*) from (select * from t1 union select * from t3) x1 (c, d), (select * from t2 union select * from t4) x2 (e, f) where x1.c = x2.e");
        String[] stringArray = new String[]{"1"};
        JDBC.assertColumnNames(resultSet, stringArray);
        Object[][] objectArray = new String[][]{{"103"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        if (!PredicatePushdownTest.is64BitJVM()) {
            PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T3", (boolean)runtimeStatisticsParser.usedTableScan("T3"));
            PredicatePushdownTest.assertTrue((String)"Expected Hash Join", (boolean)runtimeStatisticsParser.usedHashJoin());
        }
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2 union select * from t1 union select * from t2 ) x1, (select * from t3 union select * from t4 union select * from t4 ) x2 where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2 union select * from t1 union select * from t2 ) x1 where x1.i > 0");
        JDBC.assertColumnNames(resultSet, "I", "J");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2"}, {"2", "-4"}, {"2", "4"}, {"3", "6"}, {"4", "-8"}, {"4", "8"}, {"5", "10"}}, true);
        SQLUtilities.getRuntimeStatisticsParser(statement).findString("Operator: <=", 4);
        resultSet = statement.executeQuery("select count(*) from (select * from t1 union select * from t2 union select * from t3 union select * from t4 ) x1 (i, b) where x1.i > 0");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"108"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T1", (boolean)runtimeStatisticsParser.usedTableScan("T1"));
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T2", (boolean)runtimeStatisticsParser.usedTableScan("T2"));
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T3", (boolean)runtimeStatisticsParser.usedTableScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected Table Scan ResultSet for T4", (boolean)runtimeStatisticsParser.usedTableScan("T4"));
        resultSet = statement.executeQuery("select * from (select * from t1 union select * from t2) x1 inner join (select * from t3 union select * from t4) x2 on x1.j = x2.b");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "2", "2"}, {"2", "4", "4", "4"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from ( select i,j from t2 union values (1,1),(2,2),(3,3),(4,4) union select i,j from t1 ) x0 (i,j), v2 where x0.i = v2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "1", "1", "1"}, {"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "2", "2", "2"}, {"2", "4", "2", "2"}, {"3", "3", "3", "3"}, {"3", "3", "3", "12"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "16"}, {"4", "4", "4", "4"}, {"4", "4", "4", "16"}, {"4", "8", "4", "4"}, {"4", "8", "4", "16"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from t2, (select * from t1 union values (3,3), (4,4), (5,5), (6,6)) X1 (a,b) where X1.a = t2.i");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "2"}, {"2", "-4", "2", "4"}, {"3", "6", "3", "3"}, {"3", "6", "3", "6"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "8"}, {"5", "10", "5", "5"}, {"5", "10", "5", "10"}}, true);
        PredicatePushdownTest.assertTrue((String)"Expected Hash Join", (boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedHashJoin());
        resultSet = statement.executeQuery("select * from (select i,j from t2 union values (1,1),(2,2),(3,3),(4,4) union select i,j from t1 ) x0 (i,j), (select a, b from t3 union values (4, 5), (5, 6), (6, 7) union select a, b from t4 ) x1 (a,b) where x0.i = x1.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "1", "1", "1"}, {"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "2", "2", "2"}, {"2", "4", "2", "2"}, {"3", "3", "3", "3"}, {"3", "3", "3", "12"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "-8", "4", "5"}, {"4", "-8", "4", "16"}, {"4", "4", "4", "4"}, {"4", "4", "4", "5"}, {"4", "4", "4", "16"}, {"4", "8", "4", "4"}, {"4", "8", "4", "5"}, {"4", "8", "4", "16"}, {"5", "10", "5", "6"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T3", (boolean)runtimeStatisticsParser.usedTableScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from t5, (values (2,2), (4,4) union values (1,1),(2,2),(3,3),(4,4) union select i,j from t1 ) x0 (i,j) where x0.i = t5.i");
        JDBC.assertColumnNames(resultSet, "I", "J", "I", "J");
        objectArray = new String[][]{{"2", "4", "2", "2"}, {"2", "4", "2", "4"}, {"4", "8", "4", "4"}, {"4", "8", "4", "8"}, {"5", "10", "5", "10"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        resultSet = statement.executeQuery("select distinct xx0.kk, xx0.ii, xx0.jj from xxunion xx0, yyunion yy0 where xx0.mm = yy0.ii");
        stringArray = new String[]{"KK", "II", "JJ"};
        JDBC.assertColumnNames(resultSet, stringArray);
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("values (1)");
        resultSet.next();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        PreparedStatement preparedStatement = this.prepareStatement("select distinct xx0.kk, xx0.ii, xx0.jj from xxunion xx0, yyunion yy0 where xx0.mm = yy0.ii and yy0.aa in (?) for fetch only");
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            preparedStatement.setObject(i, resultSet.getObject(i));
        }
        resultSet = preparedStatement.executeQuery();
        JDBC.assertColumnNames(resultSet, "KK", "II", "JJ");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery("select count(*) from (select * from t1 union select * from t2) x1, (select * from t3 union select * from t4) x2, (select * from t4 union select * from t3) x3 where x1.i = x3.a");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"909"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T1", (boolean)runtimeStatisticsParser.usedTableScan("T1"));
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T2", (boolean)runtimeStatisticsParser.usedTableScan("T2"));
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T3", (boolean)runtimeStatisticsParser.usedTableScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T4", (boolean)runtimeStatisticsParser.usedTableScan("T4"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select count(*) from (select * from t1 union select * from t2) x1, (select * from t3 union select * from t4) x2, (select * from t4 union select * from t3) x3 where x1.i = x3.a and x3.b = x2.b");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"9"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select * from (select i, b j from t1, t4 where i = j union select * from t2) x1, t3 where x1.j = t3.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "2", "2"}, {"3", "6", "6", "24"}, {"5", "10", "10", "40"}}, true);
        resultSet = statement.executeQuery("select * from (select i, b j from t1, t4 where i = j union select * from t2) x1, v2 where x1.j = v2.a");
        stringArray = new String[]{"I", "J", "A", "B"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "2", "2"}, {"3", "6", "6", "24"}, {"5", "10", "10", "40"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        if (!PredicatePushdownTest.is64BitJVM()) {
            PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        }
        resultSet = statement.executeQuery("select * from (select i, j from t1, t3 where i = a union select * from t2) x1, v2 where x1.i = v2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "2", "1", "1"}, {"2", "-4", "2", "2"}, {"2", "4", "2", "2"}, {"3", "6", "3", "3"}, {"3", "6", "3", "12"}, {"4", "-8", "4", "4"}, {"4", "8", "4", "4"}, {"4", "-8", "4", "16"}, {"4", "8", "4", "16"}}, true);
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)SQLUtilities.getRuntimeStatisticsParser(statement).usedHashJoin());
        resultSet = statement.executeQuery("select * from (select i, b j from t1, t4 where i = j union select * from t2) x1, (select i, b j from t2, t3 where i = j union select * from t1) x2 where x1.j = x2.i");
        stringArray = new String[]{"I", "J", "I", "J"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "2", "2", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        if (!PredicatePushdownTest.is64BitJVM()) {
            PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        }
        resultSet = statement.executeQuery("select count(*) from (select i,a,j,b from V1, V2 where V1.j = V2.b ) X3");
        JDBC.assertColumnNames(resultSet, "1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select t2.i,p from (select distinct i,p from (select distinct i,a from t1, t3 where t1.j = t3.b) X1, t6 where X1.a = t6.p) X2, t2 where t2.i = X2.i");
        JDBC.assertColumnNames(resultSet, "I", "P");
        JDBC.assertDrainResults(resultSet, 0);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T1", (boolean)runtimeStatisticsParser.usedTableScan("T1"));
        PredicatePushdownTest.assertTrue((String)"Expected index row to base row for T3", (boolean)runtimeStatisticsParser.usedIndexRowToBaseRow("T3"));
        resultSet = statement.executeQuery("select x1.j, x2.b from (select distinct i,j from t1) x1, (select distinct a,b from t3) x2 where x1.i = x2.a order by x1.j, x2.b");
        JDBC.assertColumnNames(resultSet, "J", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "1"}, {"4", "2"}, {"6", "3"}, {"8", "4"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected distinct scan on T1", (boolean)runtimeStatisticsParser.usedDistinctScan("T1"));
        PredicatePushdownTest.assertTrue((String)"Expected distinct scan  T3", (boolean)runtimeStatisticsParser.usedDistinctScan("T3"));
        resultSet = statement.executeQuery("select x1.j, x2.b from (select distinct i,j from t1) x1, (select distinct a,b from t3) x2, (select distinct i,j from t2) x3, (select distinct a,b from t4) x4 where x1.i = x2.a and x3.i = x4.a order by x1.j, x2.b");
        JDBC.assertColumnNames(resultSet, "J", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "1"}, {"2", "1"}, {"4", "2"}, {"4", "2"}, {"6", "3"}, {"6", "3"}, {"8", "4"}, {"8", "4"}}, true);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected distinct scan on T1", (boolean)runtimeStatisticsParser.usedDistinctScan("T1"));
        PredicatePushdownTest.assertTrue((String)"Expected distinct scan  T2", (boolean)runtimeStatisticsParser.usedDistinctScan("T2"));
        PredicatePushdownTest.assertTrue((String)"Expected distinct scan on T3", (boolean)runtimeStatisticsParser.usedDistinctScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected distinct scan  T4", (boolean)runtimeStatisticsParser.usedDistinctScan("T4"));
        resultSet = statement.executeQuery("select X0.a, X2.i from (select a,b from t4 union select a,b from t3) X0, (select i,j from (select i,j from t1 union select i,j from t2) X1, T6 where T6.p = X1.i) X2 where X0.b = X2.j ");
        JDBC.assertColumnNames(resultSet, "A", "I");
        JDBC.assertDrainResults(resultSet, 0);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected hash join", (boolean)runtimeStatisticsParser.usedHashJoin());
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select X0.a, X2.i from (select a,b from t4 union select a,b from t3) X0, (select i,j from (select i,j from t1 union select i,j from t2) X1, T6 ) X2 where X0.b = X2.j ");
        JDBC.assertColumnNames(resultSet, "A", "I");
        JDBC.assertEmpty(resultSet);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T3", (boolean)runtimeStatisticsParser.usedIndexScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected index scan on T4", (boolean)runtimeStatisticsParser.usedIndexScan("T4"));
        resultSet = statement.executeQuery("select X0.a, X2.i from (select a,b from t4 union select a,b from t3) X0, (select i,j from (select i,j from t1 union select i,j from t2) X1, T6 where T6.p = X1.i) X2 ");
        JDBC.assertColumnNames(resultSet, "A", "I");
        JDBC.assertDrainResults(resultSet, 0);
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T3", (boolean)runtimeStatisticsParser.usedTableScan("T3"));
        PredicatePushdownTest.assertTrue((String)"Expected table scan on T4", (boolean)runtimeStatisticsParser.usedTableScan("T4"));
        callableStatement = this.prepareCall("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        PredicatePushdownTest.assertUpdateCount(callableStatement, 0);
        resultSet = statement.executeQuery(" select * from (select * from t1 union select * from t2) x1, (values (2, 4), (3, 6), (4, 8)) x2 (a, b) where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "-4", "2", "4"}, {"2", "4", "2", "4"}, {"3", "6", "3", "6"}, {"4", "-8", "4", "8"}, {"4", "8", "4", "8"}}, true);
        resultSet = statement.executeQuery("select * from(select * from t1 union (values (1, -1), (2, -2), (5, -5))) x1 (i, j),(values (2, 4), (3, 6), (4, 8)) x2 (a, b)where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"2", "-2", "2", "4"}, {"2", "4", "2", "4"}, {"3", "6", "3", "6"}, {"4", "8", "4", "8"}});
        resultSet = statement.executeQuery(" select * from (select * from t1 union all (values (1, -1), (2, -2), (5, -5))) x1 (i, j), (values (2, 4), (3, 6), (4, 8)) x2 (a, b) where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "4", "2", "4"}, {"3", "6", "3", "6"}, {"4", "8", "4", "8"}, {"2", "-2", "2", "4"}}, true);
        resultSet = statement.executeQuery(" select * from (select * from t1 union (values (1, -1), (2, -2), (5, -5))) x1 (i, j), (values (2, 4), (3, 6), (4, 8)) x2 (a, b) where x1.i = x2.a and x2.b = x1.j");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "4", "2", "4"}, {"3", "6", "3", "6"}, {"4", "8", "4", "8"}}, true);
        resultSet = statement.executeQuery(" select * from (values (2, -4), (3, -6), (4, -8) union values (1, -1), (2, -2), (5, -5) ) x1 (i, j), (values (2, 4), (3, 6), (4, 8)) x2 (a, b) where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "-4", "2", "4"}, {"2", "-2", "2", "4"}, {"3", "-6", "3", "6"}, {"4", "-8", "4", "8"}}, true);
        resultSet = statement.executeQuery(" select * from (values (2, -4), (3, -6), (4, -8) union values (1, -1), (2, -2), (5, -5) ) x1 (i, j), (values (2, 4), (3, 6), (4, 8)) x2 (a, b) where x1.i = x2.a and x2.b = x1.j");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertDrainResults(resultSet, 0);
        resultSet = statement.executeQuery(" select * from (values (1, -1), (2, -2), (5, -5) union select * from t1) x1 (i,j), (values (2, 4), (3, 6), (4, 8)) x2 (a, b) where x1.i = x2.a");
        JDBC.assertColumnNames(resultSet, "I", "J", "A", "B");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"2", "-2", "2", "4"}, {"2", "4", "2", "4"}, {"3", "6", "3", "6"}, {"4", "8", "4", "8"}}, true);
        statement.executeUpdate("drop view v1");
        statement.executeUpdate(" drop view v2");
        statement.executeUpdate(" drop table t1");
        statement.executeUpdate(" drop table t2");
        statement.executeUpdate(" drop table t3");
        statement.executeUpdate(" drop table t4");
        statement.executeUpdate(" drop table t5");
        statement.executeUpdate(" drop table t6");
        statement.executeUpdate(" drop view xxunion");
        statement.executeUpdate(" drop view yyunion");
        statement.executeUpdate(" drop table xx1");
        statement.executeUpdate(" drop table yy1");
        statement.executeUpdate("CREATE TABLE \"APP\".\"T1\" (\"I\" INTEGER, \"D\" DOUBLE, \"C\" CHAR(10))");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T2\" (\"I2\" INTEGER, \"D2\" DOUBLE, \"C2\" CHAR(10))");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T3\" (\"I3\" INTEGER, \"D3\" DOUBLE, \"C3\" CHAR(10))");
        statement.executeUpdate(" insert into t1 values (1, -1, '1'), (2, -2, '2')");
        statement.executeUpdate(" insert into t2 values (2, -2, '2'), (4, -4, '4'), (8, -8, '8')");
        statement.executeUpdate(" insert into t3 values (3, -3, '3'), (6, -6, '6'), (9, -9, '9')");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T4\" (\"C4\" CHAR(10))");
        statement.executeUpdate(" insert into t4 values '1', '2', '3', '4', '5', '6', '7', '8', '9'");
        statement.executeUpdate(" insert into t4 select rtrim(c4) || rtrim(c4) from t4");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T5\" (\"I5\" INTEGER, \"D5\" DOUBLE, \"C5\" CHAR(10))");
        statement.executeUpdate(" CREATE TABLE \"APP\".\"T6\" (\"I6\" INTEGER, \"D6\" DOUBLE, \"C6\" CHAR(10))");
        statement.executeUpdate(" insert into t5 values (100, 100.0, '100'), (200, 200.0, '200'), (300, 300.0, '300')");
        statement.executeUpdate(" insert into t6 values (400, 400.0, '400'), (200, 200.0, '200'), (300, 300.0, '300')");
        statement.executeUpdate(" create view v_keycol_at_pos_3 as select distinct i col1, d col2, c col3 from t1");
        statement.executeUpdate(" create view v1_keycol_at_pos_2 as select distinct i2 col1, c2 col3, d2 col2 from t2");
        statement.executeUpdate(" create view v2_keycol_at_pos_2 as select distinct i3 col1, c3 col3, d3 col2 from t3");
        statement.executeUpdate(" create view v1_intersect as select distinct i5 col1, c5 col3, d5 col2 from t5");
        statement.executeUpdate(" create view v2_intersect as select distinct i6 col1, c6 col3, d6 col2 from t6");
        statement.executeUpdate(" create view v1_values as select distinct vals1 col1, vals2 col2, vals3 col3 from (values (321, 321.0, '321'), (432, 432.0, '432'), (654, 654.0, '654') ) VT(vals1, vals2, vals3)");
        statement.executeUpdate(" create view v_union as select distinct i col1, d col2, c col3 from t1 union select distinct i3 col1, d3 col2, c3 col3 from t3");
        statement.executeUpdate("create view topview as (select distinct 'other:' col0, vpos3.col3, vpos3.col1 from v_keycol_at_pos_3 vpos3 union select distinct 't2stuff:' col0, vpos2_1.col3, vpos2_1.col1 from v1_keycol_at_pos_2 vpos2_1 union select distinct 't3stuff:' col0, vpos2_2.col3, vpos2_2.col1 from v2_keycol_at_pos_2 vpos2_2 )");
        statement.executeUpdate("create view topview2 as (select distinct 'other:' col0, vpos3.col3, vpos3.col1 from v_keycol_at_pos_3 vpos3 union select distinct 't2stuff:' col0, vpos2_1.col3, vpos2_1.col1 from v1_keycol_at_pos_2 vpos2_1 union select distinct 't3stuff:' col0, vpos2_2.col3, vpos2_2.col1 from v2_keycol_at_pos_2 vpos2_2 union select distinct 'morestuff:' col0, vu.col3, vu.col1 from v_union vu )");
        statement.executeUpdate("create view topview3 (col0, col3, col1) as (select distinct 'other:' col0, vpos3.col3, vpos3.col1 from v_keycol_at_pos_3 vpos3 intersect select distinct 't2stuff:' col0, vpos2_1.col3, vpos2_1.col1 from v1_keycol_at_pos_2 vpos2_1 union select distinct 't3stuff:' col0, vpos2_2.col3, vpos2_2.col1 from v2_keycol_at_pos_2 vpos2_2 union select distinct 'morestuff:' col0, vu.col3, vu.col1 from v_union vu )");
        statement.executeUpdate("create view topview4 (col0, col3, col1) as (select distinct 'intersect:' col0, vi1.col3, vi1.col1 from v1_intersect vi1 intersect select distinct 'intersect:' col0, vi2.col3, vi2.col1 from v2_intersect vi2 union select distinct 't3stuff:' col0, vpos2_2.col3, vpos2_2.col1 from v2_keycol_at_pos_2 vpos2_2 union select distinct 'morestuff:' col0, vu.col3, vu.col1 from v_union vu )");
        statement.executeUpdate("create view topview5 (col0, col3, col1) as (select distinct 'values:' col0, vv1.col3, vv1.col1 from v1_values vv1 union select distinct 'intersect:' col0, vi2.col3, vi2.col1 from v2_intersect vi2 union select distinct 't3stuff:' col0, vpos2_2.col3, vpos2_2.col1 from v2_keycol_at_pos_2 vpos2_2 union select distinct 'morestuff:' col0, vu.col3, vu.col1 from v_union vu )");
        resultSet = statement.executeQuery("select * from t4, topview where t4.c4 = topview.col3");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "other:", "1", "1"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"4", "t2stuff:", "4", "4"}, {"8", "t2stuff:", "8", "8"}, {"3", "t3stuff:", "3", "3"}, {"6", "t3stuff:", "6", "6"}, {"9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from t4, topview where topview.col3 = t4.c4");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "other:", "1", "1"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"4", "t2stuff:", "4", "4"}, {"8", "t2stuff:", "8", "8"}, {"3", "t3stuff:", "3", "3"}, {"6", "t3stuff:", "6", "6"}, {"9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1, topview where topview.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "other:", "1", "1"}, {"other:", "2", "2", "other:", "2", "2"}, {"other:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "2", "2", "other:", "2", "2"}, {"t2stuff:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "4", "4", "t2stuff:", "4", "4"}, {"t2stuff:", "8", "8", "t2stuff:", "8", "8"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from t4, topview2 where t4.c4 = topview2.col3");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "morestuff:", "1", "1"}, {"2", "morestuff:", "2", "2"}, {"3", "morestuff:", "3", "3"}, {"6", "morestuff:", "6", "6"}, {"9", "morestuff:", "9", "9"}, {"1", "other:", "1", "1"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"4", "t2stuff:", "4", "4"}, {"8", "t2stuff:", "8", "8"}, {"3", "t3stuff:", "3", "3"}, {"6", "t3stuff:", "6", "6"}, {"9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview2 x1, topview where topview.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"morestuff:", "1", "1", "other:", "1", "1"}, {"morestuff:", "2", "2", "other:", "2", "2"}, {"morestuff:", "2", "2", "t2stuff:", "2", "2"}, {"morestuff:", "3", "3", "t3stuff:", "3", "3"}, {"morestuff:", "6", "6", "t3stuff:", "6", "6"}, {"morestuff:", "9", "9", "t3stuff:", "9", "9"}, {"other:", "1", "1", "other:", "1", "1"}, {"other:", "2", "2", "other:", "2", "2"}, {"other:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "2", "2", "other:", "2", "2"}, {"t2stuff:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "4", "4", "t2stuff:", "4", "4"}, {"t2stuff:", "8", "8", "t2stuff:", "8", "8"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from t4 left join topview on t4.c4 = topview.col3");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "other:", "1", "1"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"3", "t3stuff:", "3", "3"}, {"4", "t2stuff:", "4", "4"}, {"5", null, null, null}, {"6", "t3stuff:", "6", "6"}, {"7", null, null, null}, {"8", "t2stuff:", "8", "8"}, {"9", "t3stuff:", "9", "9"}, {"11", null, null, null}, {"22", null, null, null}, {"33", null, null, null}, {"44", null, null, null}, {"55", null, null, null}, {"66", null, null, null}, {"77", null, null, null}, {"88", null, null, null}, {"99", null, null, null}}, true);
        resultSet = statement.executeQuery(" select * from t4 left join topview --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on t4.c4 = topview.col3");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "other:", "1", "1"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"3", "t3stuff:", "3", "3"}, {"4", "t2stuff:", "4", "4"}, {"5", null, null, null}, {"6", "t3stuff:", "6", "6"}, {"7", null, null, null}, {"8", "t2stuff:", "8", "8"}, {"9", "t3stuff:", "9", "9"}, {"11", null, null, null}, {"22", null, null, null}, {"33", null, null, null}, {"44", null, null, null}, {"55", null, null, null}, {"66", null, null, null}, {"77", null, null, null}, {"88", null, null, null}, {"99", null, null, null}}, true);
        resultSet = statement.executeQuery(" select * from t4 left join topview on topview.col3 = t4.c4");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "other:", "1", "1"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"3", "t3stuff:", "3", "3"}, {"4", "t2stuff:", "4", "4"}, {"5", null, null, null}, {"6", "t3stuff:", "6", "6"}, {"7", null, null, null}, {"8", "t2stuff:", "8", "8"}, {"9", "t3stuff:", "9", "9"}, {"11", null, null, null}, {"22", null, null, null}, {"33", null, null, null}, {"44", null, null, null}, {"55", null, null, null}, {"66", null, null, null}, {"77", null, null, null}, {"88", null, null, null}, {"99", null, null, null}}, true);
        resultSet = statement.executeQuery(" select * from t4 left join topview --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on topview.col3 = t4.c4");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "other:", "1", "1"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"3", "t3stuff:", "3", "3"}, {"4", "t2stuff:", "4", "4"}, {"5", null, null, null}, {"6", "t3stuff:", "6", "6"}, {"7", null, null, null}, {"8", "t2stuff:", "8", "8"}, {"9", "t3stuff:", "9", "9"}, {"11", null, null, null}, {"22", null, null, null}, {"33", null, null, null}, {"44", null, null, null}, {"55", null, null, null}, {"66", null, null, null}, {"77", null, null, null}, {"88", null, null, null}, {"99", null, null, null}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview on topview.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "other:", "1", "1"}, {"other:", "2", "2", "other:", "2", "2"}, {"other:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "2", "2", "other:", "2", "2"}, {"t2stuff:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "4", "4", "t2stuff:", "4", "4"}, {"t2stuff:", "8", "8", "t2stuff:", "8", "8"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on topview.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "other:", "1", "1"}, {"other:", "2", "2", "other:", "2", "2"}, {"other:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "2", "2", "other:", "2", "2"}, {"t2stuff:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "4", "4", "t2stuff:", "4", "4"}, {"t2stuff:", "8", "8", "t2stuff:", "8", "8"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from t4 left join topview2 on t4.c4 = topview2.col3");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "morestuff:", "1", "1"}, {"1", "other:", "1", "1"}, {"2", "morestuff:", "2", "2"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"3", "morestuff:", "3", "3"}, {"3", "t3stuff:", "3", "3"}, {"4", "t2stuff:", "4", "4"}, {"5", null, null, null}, {"6", "morestuff:", "6", "6"}, {"6", "t3stuff:", "6", "6"}, {"7", null, null, null}, {"8", "t2stuff:", "8", "8"}, {"9", "morestuff:", "9", "9"}, {"9", "t3stuff:", "9", "9"}, {"11", null, null, null}, {"22", null, null, null}, {"33", null, null, null}, {"44", null, null, null}, {"55", null, null, null}, {"66", null, null, null}, {"77", null, null, null}, {"88", null, null, null}, {"99", null, null, null}}, true);
        resultSet = statement.executeQuery(" select * from t4 left join topview2 --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on t4.c4 = topview2.col3");
        JDBC.assertColumnNames(resultSet, "C4", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"1", "morestuff:", "1", "1"}, {"1", "other:", "1", "1"}, {"2", "morestuff:", "2", "2"}, {"2", "other:", "2", "2"}, {"2", "t2stuff:", "2", "2"}, {"3", "morestuff:", "3", "3"}, {"3", "t3stuff:", "3", "3"}, {"4", "t2stuff:", "4", "4"}, {"5", null, null, null}, {"6", "morestuff:", "6", "6"}, {"6", "t3stuff:", "6", "6"}, {"7", null, null, null}, {"8", "t2stuff:", "8", "8"}, {"9", "morestuff:", "9", "9"}, {"9", "t3stuff:", "9", "9"}, {"11", null, null, null}, {"22", null, null, null}, {"33", null, null, null}, {"44", null, null, null}, {"55", null, null, null}, {"66", null, null, null}, {"77", null, null, null}, {"88", null, null, null}, {"99", null, null, null}}, true);
        resultSet = statement.executeQuery(" select * from topview2 x1 left join topview on topview.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"morestuff:", "1", "1", "other:", "1", "1"}, {"morestuff:", "2", "2", "other:", "2", "2"}, {"morestuff:", "2", "2", "t2stuff:", "2", "2"}, {"morestuff:", "3", "3", "t3stuff:", "3", "3"}, {"morestuff:", "6", "6", "t3stuff:", "6", "6"}, {"morestuff:", "9", "9", "t3stuff:", "9", "9"}, {"other:", "1", "1", "other:", "1", "1"}, {"other:", "2", "2", "other:", "2", "2"}, {"other:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "2", "2", "other:", "2", "2"}, {"t2stuff:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "4", "4", "t2stuff:", "4", "4"}, {"t2stuff:", "8", "8", "t2stuff:", "8", "8"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview2 x1 left join topview --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on topview.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"morestuff:", "1", "1", "other:", "1", "1"}, {"morestuff:", "2", "2", "other:", "2", "2"}, {"morestuff:", "2", "2", "t2stuff:", "2", "2"}, {"morestuff:", "3", "3", "t3stuff:", "3", "3"}, {"morestuff:", "6", "6", "t3stuff:", "6", "6"}, {"morestuff:", "9", "9", "t3stuff:", "9", "9"}, {"other:", "1", "1", "other:", "1", "1"}, {"other:", "2", "2", "other:", "2", "2"}, {"other:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "2", "2", "other:", "2", "2"}, {"t2stuff:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "4", "4", "t2stuff:", "4", "4"}, {"t2stuff:", "8", "8", "t2stuff:", "8", "8"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview2 on topview2.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "morestuff:", "1", "1"}, {"other:", "1", "1", "other:", "1", "1"}, {"other:", "2", "2", "morestuff:", "2", "2"}, {"other:", "2", "2", "other:", "2", "2"}, {"other:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "2", "2", "other:", "2", "2"}, {"t2stuff:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "4", "4", "t2stuff:", "4", "4"}, {"t2stuff:", "8", "8", "t2stuff:", "8", "8"}, {"t3stuff:", "3", "3", "morestuff:", "3", "3"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "morestuff:", "6", "6"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "morestuff:", "9", "9"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview2 --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on topview2.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "morestuff:", "1", "1"}, {"other:", "1", "1", "other:", "1", "1"}, {"other:", "2", "2", "morestuff:", "2", "2"}, {"other:", "2", "2", "other:", "2", "2"}, {"other:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "2", "2", "other:", "2", "2"}, {"t2stuff:", "2", "2", "t2stuff:", "2", "2"}, {"t2stuff:", "4", "4", "t2stuff:", "4", "4"}, {"t2stuff:", "8", "8", "t2stuff:", "8", "8"}, {"t3stuff:", "3", "3", "morestuff:", "3", "3"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "morestuff:", "6", "6"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "morestuff:", "9", "9"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview3 on topview3.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "morestuff:", "1", "1"}, {"other:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "4", "4", null, null, null}, {"t2stuff:", "8", "8", null, null, null}, {"t3stuff:", "3", "3", "morestuff:", "3", "3"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "morestuff:", "6", "6"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "morestuff:", "9", "9"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview3 --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on topview3.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "morestuff:", "1", "1"}, {"other:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "4", "4", null, null, null}, {"t2stuff:", "8", "8", null, null, null}, {"t3stuff:", "3", "3", "morestuff:", "3", "3"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "morestuff:", "6", "6"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "morestuff:", "9", "9"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview4 on topview4.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "morestuff:", "1", "1"}, {"other:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "4", "4", null, null, null}, {"t2stuff:", "8", "8", null, null, null}, {"t3stuff:", "3", "3", "morestuff:", "3", "3"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "morestuff:", "6", "6"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "morestuff:", "9", "9"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview4 --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on topview4.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "morestuff:", "1", "1"}, {"other:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "4", "4", null, null, null}, {"t2stuff:", "8", "8", null, null, null}, {"t3stuff:", "3", "3", "morestuff:", "3", "3"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "morestuff:", "6", "6"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "morestuff:", "9", "9"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview5 on topview5.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "morestuff:", "1", "1"}, {"other:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "4", "4", null, null, null}, {"t2stuff:", "8", "8", null, null, null}, {"t3stuff:", "3", "3", "morestuff:", "3", "3"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "morestuff:", "6", "6"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "morestuff:", "9", "9"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        resultSet = statement.executeQuery(" select * from topview x1 left join topview5 --DERBY-PROPERTIES joinStrategy=NESTEDLOOP \n on topview5.col3 = x1.col3");
        JDBC.assertColumnNames(resultSet, "COL0", "COL3", "COL1", "COL0", "COL3", "COL1");
        JDBC.assertFullResultSet(resultSet, (Object[][])new String[][]{{"other:", "1", "1", "morestuff:", "1", "1"}, {"other:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "2", "2", "morestuff:", "2", "2"}, {"t2stuff:", "4", "4", null, null, null}, {"t2stuff:", "8", "8", null, null, null}, {"t3stuff:", "3", "3", "morestuff:", "3", "3"}, {"t3stuff:", "3", "3", "t3stuff:", "3", "3"}, {"t3stuff:", "6", "6", "morestuff:", "6", "6"}, {"t3stuff:", "6", "6", "t3stuff:", "6", "6"}, {"t3stuff:", "9", "9", "morestuff:", "9", "9"}, {"t3stuff:", "9", "9", "t3stuff:", "9", "9"}}, true);
        statement.executeUpdate("insert into t1 select * from t2");
        statement.executeUpdate(" insert into t2 select * from t3");
        statement.executeUpdate(" insert into t3 select * from t1");
        statement.executeUpdate(" insert into t1 select * from t2");
        statement.executeUpdate(" insert into t2 select * from t3");
        statement.executeUpdate(" insert into t3 select * from t1");
        statement.executeUpdate(" insert into t1 select * from t2");
        statement.executeUpdate(" insert into t2 select * from t3");
        statement.executeUpdate(" insert into t3 select * from t1");
        statement.executeUpdate(" insert into t1 select * from t2");
        statement.executeUpdate(" insert into t2 select * from t3");
        statement.executeUpdate(" insert into t3 select * from t1");
        resultSet = statement.executeQuery("select topview4.col3, x1.col3 from topview x1 left join topview4 on topview4.col3 = x1.col3");
        stringArray = new String[]{"COL3", "COL3"};
        JDBC.assertColumnNames(resultSet, stringArray);
        objectArray = new String[][]{{"1", "1"}, {"1", "1"}, {"2", "2"}, {"2", "2"}, {"3", "3"}, {"3", "3"}, {"4", "4"}, {"4", "4"}, {"6", "6"}, {"6", "6"}, {"8", "8"}, {"8", "8"}, {"9", "9"}, {"9", "9"}, {"1", "1"}, {"1", "1"}, {"2", "2"}, {"2", "2"}, {"3", "3"}, {"3", "3"}, {"4", "4"}, {"4", "4"}, {"6", "6"}, {"6", "6"}, {"8", "8"}, {"8", "8"}, {"9", "9"}, {"9", "9"}, {"1", "1"}, {"1", "1"}, {"2", "2"}, {"2", "2"}, {"3", "3"}, {"3", "3"}, {"4", "4"}, {"4", "4"}, {"6", "6"}, {"6", "6"}, {"8", "8"}, {"8", "8"}, {"9", "9"}, {"9", "9"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop view topview");
        statement.executeUpdate(" drop view topview2");
        statement.executeUpdate(" drop view topview3");
        statement.executeUpdate(" drop view topview4");
        statement.executeUpdate(" drop view topview5");
        statement.executeUpdate(" drop view v_keycol_at_pos_3");
        statement.executeUpdate(" drop view v1_keycol_at_pos_2");
        statement.executeUpdate(" drop view v2_keycol_at_pos_2");
        statement.executeUpdate(" drop view v1_intersect");
        statement.executeUpdate(" drop view v2_intersect");
        statement.executeUpdate(" drop view v1_values");
        statement.executeUpdate(" drop view v_union");
        statement.executeUpdate(" drop table t1");
        statement.executeUpdate(" drop table t2");
        statement.executeUpdate(" drop table t3");
        statement.executeUpdate(" drop table t4");
        statement.executeUpdate(" drop table t5");
        statement.executeUpdate(" drop table t6");
        this.getConnection().rollback();
        statement.close();
    }

    private static boolean is64BitJVM() {
        String string = PredicatePushdownTest.getSystemProperty("sun.arch.data.model");
        try {
            return Integer.parseInt(string) == 64;
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = PredicatePushdownTest.getSystemProperty("os.arch");
            if (string2 != null) {
                String[] stringArray = new String[]{"i386", "x86", "sparc"};
                if (Arrays.asList(stringArray).contains(string2)) {
                    return false;
                }
                String[] stringArray2 = new String[]{"amd64", "x86_64", "sparcv9"};
                if (Arrays.asList(stringArray2).contains(string2)) {
                    return true;
                }
            }
            BaseTestCase.traceit("Bitness undetermined, sun.arch.data.model='" + string + "', os.arch='" + string2 + "', assuming we're 32 bit");
            return false;
        }
    }
}

