/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.security.AccessControlException;
import java.sql.Connection;
import junit.framework.Test;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.services.jce.JCECipherFactoryBuilder;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class NoDBInternalsPermissionTest
extends GeneratedColumnsHelper {
    private static final String POLICY_FILE = "org/apache/derbyTesting/functionTests/tests/lang/no_derby_internals.policy";

    public NoDBInternalsPermissionTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(NoDBInternalsPermissionTest.class);
        SecurityManagerSetup securityManagerSetup = new SecurityManagerSetup((Test)baseTestSuite, POLICY_FILE);
        return securityManagerSetup;
    }

    public void test_001_ContextService() throws Exception {
        try {
            ContextService.stop();
            NoDBInternalsPermissionTest.fail((String)"Should have raised an AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            NoDBInternalsPermissionTest.println("Caught an AccessControlException");
        }
        try {
            ContextService.getFactory();
            NoDBInternalsPermissionTest.fail((String)"Should have raised an AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            NoDBInternalsPermissionTest.println("Caught an AccessControlException");
        }
        try {
            ContextService.getContext((String)"some context id");
            NoDBInternalsPermissionTest.fail((String)"Should have raised an AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            NoDBInternalsPermissionTest.println("Caught an AccessControlException");
        }
        try {
            ContextService.getContextOrNull((String)"some context id");
            NoDBInternalsPermissionTest.fail((String)"Should have raised an AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            NoDBInternalsPermissionTest.println("Caught an AccessControlException");
        }
    }

    public void test_002_EmbedConnection() throws Exception {
        try {
            Connection connection = this.getConnection();
            ((EmbedConnection)connection).getContextManager();
            NoDBInternalsPermissionTest.fail((String)"Should have raised an AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            NoDBInternalsPermissionTest.println("Caught an AccessControlException");
        }
    }

    public void test_003_JCECipherFactory() throws Exception {
        try {
            JCECipherFactoryBuilder jCECipherFactoryBuilder = new JCECipherFactoryBuilder();
            jCECipherFactoryBuilder.createCipherFactory(true, null, true);
            NoDBInternalsPermissionTest.fail((String)"Should have raised an AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            NoDBInternalsPermissionTest.println("Caught an AccessControlException");
        }
    }

    public void test_004_BaseDataFileFactory() throws Exception {
        try {
            BaseDataFileFactory baseDataFileFactory = new BaseDataFileFactory();
            NoDBInternalsPermissionTest.fail((String)"Should have raised an AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            NoDBInternalsPermissionTest.println("Caught an AccessControlException");
        }
    }

    public void test_005_EmbedConnection_getLCC() throws Exception {
        try {
            Connection connection = this.getConnection();
            ((EmbedConnection)connection).getLanguageConnection();
            NoDBInternalsPermissionTest.fail((String)"Should have raised an AccessControlException");
        }
        catch (AccessControlException accessControlException) {
            NoDBInternalsPermissionTest.println("Caught an AccessControlException");
        }
    }
}

