/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class GrantRevokeTest
extends BaseJDBCTestCase {
    public static final String[] users = new String[]{"TEST_DBO", "U1", "U2", "U3", "U4"};

    public GrantRevokeTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest(GrantRevokeTest.basesuite());
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new GrantRevokeTest("testGrantDatabaseMetaDataMethods")));
        return baseTestSuite;
    }

    public static Test basesuite() {
        Object object = new BaseTestSuite(GrantRevokeTest.class);
        object = DatabasePropertyTestSetup.singleProperty((Test)object, "derby.locks.deadlockTrace", "true");
        object = new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create schema s1");
                statement.execute("create schema s2");
                statement.execute("create table s1.t1(c1 int, c2 int, c3 int)");
                statement.execute("create table s2.t1(c1 int, c2 int, c3 int)");
                statement.execute("create table s2.t2(c1 int, c2 int, c3 int)");
                statement.execute("create table s2.t3(c1 int, c2 int, c3 int)");
                statement.execute("create table s2.noPerms(c1 int, c2 int, c3 int)");
                statement.execute("create function s1.f1() returns int  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.GrantRevokeTest.s1F1'  no sql called on null input");
                statement.execute("create procedure s1.f1( )  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.GrantRevokeTest.s1F1P'  no sql called on null input");
                statement.execute("create procedure s1.p1( )  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.GrantRevokeTest.s1P1'  no sql called on null input");
                statement.execute("create schema appl");
                statement.execute("CREATE TABLE appl.\"TBL_Tasks\"(\"TaskID\" integer NOT NULL                     GENERATED ALWAYS AS IDENTITY, \"Task\" varchar(64) NOT NULL, \"AssignedTo\" varchar(64) NOT NULL,CONSTRAINT \"PK_Tasks\" PRIMARY KEY (\"TaskID\"))");
                statement.execute("CREATE TABLE appl.\"TBL_Priorities\"(\"TaskID\" integer NOT NULL, \"Priority\" integer NOT NULL, \"SeqNbr\" integer NOT NULL,CONSTRAINT \"PK_Priorities\" PRIMARY KEY   (\"TaskID\", \"Priority\"))");
                statement.execute("CREATE VIEW appl.\"VW_MyTasks\" AS     SELECT * FROM appl.\"TBL_Tasks\" WHERE \"AssignedTo\" = SESSION_USER");
                statement.execute("CREATE VIEW appl.\"VW_MyPriorityTasks\" AS     SELECT t.\"TaskID\", t.\"Task\", p.\"Priority\"    FROM appl.\"TBL_Tasks\" AS t,         appl.\"TBL_Priorities\" AS p     WHERE p.\"TaskID\" = t.\"TaskID\"           AND t.\"AssignedTo\" = SESSION_USER");
                statement.execute("CREATE VIEW appl.\"VW2_MyPriorityTasks\" AS     SELECT t.\"TaskID\", t.\"Task\", p.\"Priority\"     FROM appl.\"TBL_Tasks\" AS t INNER JOIN          appl.\"TBL_Priorities\" AS p ON          p.\"TaskID\" = t.\"TaskID\"     WHERE t.\"AssignedTo\" = SESSION_USER");
                statement.execute("CREATE VIEW appl.\"VW3_MyPriorityTasks\" AS     SELECT t.\"TaskID\", t.\"Task\"     FROM appl.\"TBL_Tasks\" AS t     WHERE t.\"AssignedTo\" = SESSION_USER     AND EXISTS         (SELECT * FROM appl.\"TBL_Priorities\" AS p          WHERE p.\"TaskID\" = t.\"TaskID\")");
            }
        };
        object = DatabasePropertyTestSetup.builtinAuthentication((Test)object, users, "grantrevoke");
        object = TestConfiguration.sqlAuthorizationDecorator((Test)object);
        return object;
    }

    public void testSimpleGrant() throws Exception {
        this.grant("select", "s1", "t1", users[1]);
        this.assertSelectPrivilege(true, users[1], "s1", "t1", null);
        this.assertSelectPrivilege(false, users[2], "s1", "t1", null);
        this.assertSelectPrivilege(false, users[2], "s2", "t1", null);
        this.assertSelectPrivilege(false, users[2], "s2", "t2", null);
        this.revoke("select", "s1", "t1", users[1]);
    }

    public void testAllPrivileges() throws Exception {
        this.grant("all privileges", "s2", "t1", new String[]{users[2], users[3]});
        this.assertAllPrivileges(false, users[1], "S2", "T1", null);
        this.assertAllPrivileges(true, users[2], "S2", "T1", null);
        this.assertAllPrivileges(true, users[3], "S2", "T1", null);
        this.assertSelectPrivilege(false, users[1], "s1", "t1", null);
        this.assertSelectPrivilege(false, users[1], "s2", "t2", null);
        this.revoke("all privileges", "s2", "t1", new String[]{users[2], users[3]});
    }

    public void testColumnPrivileges() throws Exception {
        this.grant("select(c1),update(c3,c2),references(c3,c1,c2)", "s1", "t1", users[4]);
        this.assertSelectPrivilege(true, users[4], "s1", "t1", new String[]{"c1"});
        this.assertSelectPrivilege(false, users[4], "s1", "t1", new String[]{"c2"});
        this.assertSelectPrivilege(false, users[4], "s1", "t1", new String[]{"c3"});
        this.assertSelectPrivilege(false, users[4], "s1", "t1", null);
        this.assertUpdatePrivilege(false, users[4], "S1", "T1", new String[]{"C1"});
        this.assertUpdatePrivilege(true, users[4], "S1", "T1", new String[]{"C2", "C3"});
        this.assertReferencesPrivilege(true, users[4], "s1", "t1", new String[]{"c1", "c2", "c3"});
        this.revoke("select(c1),update(c3,c2),references(c3,c1,c2)", "s1", "t1", users[4]);
    }

    public void testFunctionWithSameProcedureName() throws Exception {
        this.grant("execute", "function s1", "f1", users[1]);
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertProcedurePrivilege(false, users[1], "S1", "F1");
        this.assertFunctionPrivilege(false, users[2], "S1", "F1", false);
        this.revoke("execute", "function s1", "f1", users[1]);
    }

    public void testGrantOnProcedure() throws Exception {
        this.grant("execute", "procedure s1", "p1", users[1]);
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.assertFunctionPrivilege(false, users[1], "S1", "P1", true);
        this.assertProcedurePrivilege(false, users[2], "S1", "P1");
        this.assertFunctionPrivilege(false, users[2], "S1", "P1", true);
        this.revoke("execute", "procedure s1", "p1", users[1]);
    }

    public void testPublicTablePrivileges() throws Exception {
        this.grant("select, references(c1)", "s2", "t2", "public");
        this.assertSelectPrivilege(true, users[4], "S2", "T2", null);
        this.assertSelectPrivilege(true, users[1], "S2", "T2", null);
        this.assertSelectPrivilege(false, users[4], "S2", "NOPERMS", null);
        this.assertUpdatePrivilege(false, users[4], "S2", "T2", null);
        this.assertReferencesPrivilege(true, users[4], "S2", "T2", new String[]{"C1"});
        this.assertReferencesPrivilege(false, users[4], "S2", "T2", null);
        this.revoke("select, references(c1)", "s2", "t2", "public");
    }

    public void testPublicRoutinePrivileges() throws Exception {
        this.grant("execute", "procedure s1", "p1", "public");
        this.grant("execute", "procedure s1", "p1", users[1]);
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.assertProcedurePrivilege(true, users[4], "S1", "P1");
        this.revoke("execute", "procedure s1", "p1", "public");
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.assertProcedurePrivilege(false, users[4], "S1", "P1");
        this.revoke("execute", "procedure s1", "p1", users[1]);
        this.assertProcedurePrivilege(false, users[1], "S1", "P1");
    }

    public void testGrantRollbackAndCommit() throws SQLException {
        Connection connection = this.openUserConnection(users[0]);
        connection.setAutoCommit(false);
        this.grant(connection, "select", "s2", "t2", "public");
        connection.commit();
        this.assertSelectPrivilege(true, users[3], "S2", "T2", null);
        this.assertUpdatePrivilege(false, users[3], "S2", "T2", null);
        this.assertSelectPrivilege(false, users[1], "S2", "T3", new String[]{"C2"});
        this.assertDeletePrivilege(false, users[1], "S2", "T3");
        this.assertTriggerPrivilege(false, users[2], "S2", "T2");
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.grant(connection, "select(c2),delete", "s2", "t3", users[1]);
        this.grant(connection, "trigger", "s2", "t2", "public");
        this.grant(connection, "execute", "function s1", "f1", users[1]);
        connection.rollback();
        this.assertSelectPrivilege(false, users[1], "S2", "T3", new String[]{"C2"});
        this.assertDeletePrivilege(false, users[1], "S2", "T3");
        this.assertTriggerPrivilege(false, users[2], "S2", "T2");
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.grant(connection, "select(c2),delete", "s2", "t3", users[1]);
        this.grant(connection, "trigger", "s2", "t2", "public");
        this.grant(connection, "execute", "function s1", "f1", users[1]);
        connection.commit();
        this.assertSelectPrivilege(true, users[1], "S2", "T3", new String[]{"C2"});
        this.assertDeletePrivilege(true, users[1], "S2", "T3");
        this.assertTriggerPrivilege(true, users[2], "S2", "T2");
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.revoke(connection, "select", "s2", "t2", "public");
        this.revoke(connection, "select(c2),delete", "s2", "t3", users[1]);
        this.revoke(connection, "trigger", "s2", "t2", "public");
        this.revoke(connection, "execute", "function s1", "f1", users[1]);
        connection.commit();
        connection.setAutoCommit(false);
        this.assertSelectPrivilege(false, users[3], "S2", "T2", null);
        this.assertUpdatePrivilege(false, users[3], "S2", "T2", null);
        this.assertSelectPrivilege(false, users[1], "S2", "T3", new String[]{"C2"});
        this.assertDeletePrivilege(false, users[1], "S2", "T3");
        this.assertTriggerPrivilege(false, users[2], "S2", "T2");
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        connection.close();
    }

    public void testGrantDatabaseMetaDataMethods() throws Exception {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        GrantRevokeTest.assertFalse((String)"GrantRevoke: DatabaseMetaData.supportsCatalogsInPrivilegeDefinitionSupport", (boolean)databaseMetaData.supportsCatalogsInPrivilegeDefinitions());
        GrantRevokeTest.assertTrue((String)"GrantRevoke: DatabaseMetaData.supportsSchemasInPrivilegeDefinitions", (boolean)databaseMetaData.supportsSchemasInPrivilegeDefinitions());
    }

    public void testRevokeWithNoPermissions() throws Exception {
        this.assertSelectPrivilege(false, users[1], "S1", "T1", null);
        this.assertSelectPrivilege(false, users[2], "S1", "T1", new String[]{"C2"});
        this.assertUpdatePrivilege(false, users[2], "S1", "T1", new String[]{"C1", "C3"});
        this.assertProcedurePrivilege(false, users[1], "S1", "P1");
        this.revoke("all privileges", "s1", "t1", users[1]);
        this.assertSelectPrivilege(false, users[1], "S1", "T1", null);
        this.assertSelectPrivilege(false, users[1], "S1", "T1", new String[]{"C2"});
        this.revoke("execute", "procedure s1", "p1", users[1]);
        this.assertProcedurePrivilege(false, users[1], "S1", "P1");
        this.revoke("select(c2), update(c1,c3)", "s1", "t1", users[2]);
        this.assertSelectPrivilege(false, users[2], "S1", "T1", new String[]{"C2"});
        this.assertUpdatePrivilege(false, users[2], "S1", "T1", new String[]{"C1", "C3"});
    }

    public void testRevokeSingleTableSingleUser() throws Exception {
        this.grant("all privileges", "s2", "t1", users[1]);
        this.grant("update(c3)", "s2", "t1", users[1]);
        this.assertSelectPrivilege(true, users[1], "S2", "T1", null);
        this.assertUpdatePrivilege(true, users[1], "S2", "T1", new String[]{"C3"});
        this.revoke("update", "S2", "t1", users[1]);
        this.assertSelectPrivilege(true, users[1], "S2", "T1", null);
        this.assertUpdatePrivilege(false, users[1], "S2", "T1", null);
        this.assertUpdatePrivilege(false, users[1], "S2", "T1", new String[]{"C3"});
        this.assertInsertPrivilege(true, users[1], "S2", "T1", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T1");
        this.assertReferencesPrivilege(true, users[1], "S2", "T1", null);
        this.assertTriggerPrivilege(true, users[1], "S2", "T1");
        this.revoke("all privileges", "s2", "t1", users[1]);
        this.assertAllPrivileges(false, users[1], "S2", "T1", null);
    }

    public void testRevokeMultiplePermissionsMultipleUsers() throws SQLException {
        this.grant("select", "s1", "t1", new String[]{users[1], users[2], users[3]});
        this.grant("update(c1,c2,c3)", "s1", "t1", users[1]);
        this.grant("update(c3)", "s1", "t1", users[2]);
        this.grant("trigger", "s1", "t1", users[1]);
        this.assertSelectPrivilege(true, users[1], "S1", "T1", null);
        this.assertSelectPrivilege(true, users[2], "S1", "T1", null);
        this.assertSelectPrivilege(true, users[3], "S1", "T1", null);
        this.assertUpdatePrivilege(true, users[1], "S1", "T1", new String[]{"C1", "C2", "C3"});
        this.assertUpdatePrivilege(false, users[2], "S1", "T1", new String[]{"C1", "C2"});
        this.assertUpdatePrivilege(true, users[2], "S1", "T1", new String[]{"C3"});
        this.assertTriggerPrivilege(true, users[1], "S1", "T1");
        this.assertTriggerPrivilege(false, users[2], "S1", "T1");
        this.revoke("select, update(c2,c3)", "s1", "t1", new String[]{users[1], users[2], users[3]});
        this.assertSelectPrivilege(false, users[1], "S1", "T1", null);
        this.assertSelectPrivilege(false, users[2], "S1", "T1", null);
        this.assertSelectPrivilege(false, users[3], "S1", "T1", null);
        this.assertUpdatePrivilege(true, users[1], "S1", "T1", new String[]{"C1"});
        this.assertUpdatePrivilege(false, users[1], "S1", "T1", new String[]{"C2", "C3"});
        this.assertUpdatePrivilege(false, users[2], "S1", "T1", null);
        this.assertTriggerPrivilege(true, users[1], "S1", "T1");
        this.assertTriggerPrivilege(false, users[2], "S1", "T1");
        this.revoke("update", "s1", "t1", users[1]);
        this.assertUpdatePrivilege(false, users[1], "S1", "T1", new String[]{"C1"});
        this.assertUpdatePrivilege(false, users[1], "S1", "T1", null);
        this.revoke("all privileges", "s1", "t1", users[1]);
        this.assertAllPrivileges(false, users[1], "S1", "T1", null);
    }

    public void testRevokeExecutePrivileges() throws Exception {
        this.grant("execute", "function s1", "f1", new String[]{users[1], users[2]});
        this.grant("execute", "procedure s1", "f1", users[1]);
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertProcedurePrivilege(true, users[1], "S1", "F1");
        this.revoke("execute", "function s1", "f1", users[1]);
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertProcedurePrivilege(true, users[1], "S1", "F1");
        this.grant("execute", "function s1", "f1", users[1]);
        this.revoke("execute", "procedure s1", "f1", users[1]);
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertProcedurePrivilege(false, users[1], "S1", "F1");
        this.revoke("execute", "function s1", "f1", new String[]{users[1], users[2]});
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(false, users[2], "S1", "F1", false);
        this.assertProcedurePrivilege(false, users[1], "S1", "F1");
    }

    public void testRevokeWithPublicPrivilege() throws Exception {
        this.grant("select, delete", "s2", "t1", "public");
        this.grant("select, delete", "s2", "t1", new String[]{users[1], users[2]});
        this.grant("update(c1,c3)", "s2", "t1", "public");
        this.grant("update(c1,c3)", "s2", "t1", new String[]{users[1], users[2]});
        this.assertSelectPrivilege(true, users[1], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[2], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[4], "S2", "T1", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T1");
        this.assertDeletePrivilege(true, users[2], "S2", "T1");
        this.assertDeletePrivilege(true, users[4], "S2", "T1");
        this.assertUpdatePrivilege(true, users[1], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[2], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[4], "S2", "T1", new String[]{"C1", "C3"});
        this.revoke("select, update(c1,c3), delete", "S2", "T1", users[1]);
        this.assertSelectPrivilege(true, users[1], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[2], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[4], "S2", "T1", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T1");
        this.assertDeletePrivilege(true, users[2], "S2", "T1");
        this.assertDeletePrivilege(true, users[4], "S2", "T1");
        this.assertUpdatePrivilege(true, users[1], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[2], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[4], "S2", "T1", new String[]{"C1", "C3"});
        this.revoke("select, update(c1,c3), delete", "S2", "t1", "public");
        this.assertSelectPrivilege(false, users[1], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[2], "S2", "T1", null);
        this.assertSelectPrivilege(false, users[4], "S2", "T1", null);
        this.assertDeletePrivilege(false, users[1], "S2", "T1");
        this.assertDeletePrivilege(true, users[2], "S2", "T1");
        this.assertDeletePrivilege(false, users[4], "S2", "T1");
        this.assertUpdatePrivilege(false, users[1], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[2], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(false, users[4], "S2", "T1", new String[]{"C1", "C3"});
        this.revoke("all privileges", "S2", "t1", users[2]);
        this.assertAllPrivileges(false, users[2], "S2", "T1", null);
    }

    public void testRevokeExecuteWithPublicPrivilege() throws Exception {
        this.grant("execute", "function s1", "f1", "public");
        this.grant("execute", "function s1", "f1", new String[]{users[1], users[2]});
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[4], "S1", "F1", false);
        this.revoke("execute", "function s1", "f1", users[1]);
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[4], "S1", "F1", false);
        this.revoke("execute", "function s1", "f1", "public");
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertFunctionPrivilege(false, users[4], "S1", "F1", false);
        this.revoke("execute", "function s1", "f1", users[2]);
        this.assertFunctionPrivilege(false, users[2], "s1", "F1", false);
    }

    public void testRevokeRollbackAndCommit() throws Exception {
        Connection connection = this.openUserConnection(users[0]);
        connection.setAutoCommit(false);
        this.grant(connection, "select(c1,c2), update(c1), insert, delete", "s2", "t3", users[1]);
        this.grant(connection, "select, references", "s2", "t3", users[2]);
        this.grant(connection, "select", "s2", "t3", users[3]);
        this.grant(connection, "execute", "procedure s1", "p1", users[1]);
        connection.commit();
        this.assertSelectPrivilege(true, users[1], "S2", "T3", new String[]{"C1", "C2"});
        this.assertUpdatePrivilege(true, users[1], "S2", "T3", new String[]{"C1"});
        this.assertInsertPrivilege(true, users[1], "S2", "T3", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T3");
        this.assertSelectPrivilege(true, users[2], "S2", "T3", null);
        this.assertReferencesPrivilege(true, users[2], "S2", "T3", null);
        this.assertSelectPrivilege(true, users[3], "S2", "T3", null);
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.revoke(connection, "select(c2), update(c1), delete", "s2", "t3", users[1]);
        this.revoke(connection, "select, references", "s2", "t3", users[2]);
        this.revoke(connection, "select", "s2", "t3", users[3]);
        this.revoke(connection, "execute", "procedure s1", "p1", users[1]);
        connection.rollback();
        this.assertSelectPrivilege(true, users[1], "S2", "T3", new String[]{"C1", "C2"});
        this.assertUpdatePrivilege(true, users[1], "S2", "T3", new String[]{"C1"});
        this.assertInsertPrivilege(true, users[1], "S2", "T3", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T3");
        this.assertSelectPrivilege(true, users[2], "S2", "T3", null);
        this.assertReferencesPrivilege(true, users[2], "S2", "T3", null);
        this.assertSelectPrivilege(true, users[3], "S2", "T3", null);
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.revoke(connection, "select(c2), update(c1), delete", "s2", "t3", users[1]);
        this.revoke(connection, "select, references", "s2", "t3", users[2]);
        this.revoke(connection, "select", "s2", "t3", users[3]);
        this.revoke(connection, "execute", "procedure s1", "p1", users[1]);
        connection.commit();
        connection.setAutoCommit(true);
        this.assertSelectPrivilege(false, users[1], "S2", "T3", new String[]{"C1", "C2"});
        this.assertUpdatePrivilege(false, users[1], "S2", "T3", new String[]{"C1"});
        this.assertInsertPrivilege(true, users[1], "S2", "T3", null);
        this.assertDeletePrivilege(false, users[1], "S2", "T3");
        this.assertSelectPrivilege(false, users[2], "S2", "T3", null);
        this.assertReferencesPrivilege(false, users[2], "S2", "T3", null);
        this.assertSelectPrivilege(false, users[3], "S2", "T3", null);
        this.assertProcedurePrivilege(false, users[1], "S1", "P1");
    }

    public void testInvalidGrantAction() throws Exception {
        try {
            this.grant("xx", "s1", "t1", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42X01", sQLException);
        }
    }

    public void testInvalidReservedWordAction() throws Exception {
        try {
            this.grant("between", "s1", "t1", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42X01", sQLException);
        }
        this.assertCompileError("42X01", "grant select on schema t1 to " + users[1]);
        this.assertCompileError("42X01", "grant select on decimal t1 to " + users[1]);
    }

    public void testGrantOnNonexistantColumn() throws Exception {
        try {
            this.grant("select(nosuchCol)", "s1", "t1", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42X14", sQLException);
        }
    }

    public void testGrantOnNonexistantSchema() throws Exception {
        try {
            this.grant("select", "nosuch", "t1", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42Y07", sQLException);
        }
    }

    public void testGrantOnNonexistantTable() throws Exception {
        try {
            this.grant("select(nosuchCol)", "s1", "nosuch", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42X05", sQLException);
        }
    }

    public void testGrantOnFunctionWithBadSchema() throws Exception {
        try {
            this.grant("execute", "function nosuch", "f0", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42Y07", sQLException);
        }
    }

    public void testGrantOnNonexistantFunction() throws Exception {
        block2: {
            try {
                this.grant("execute", "function s1", "nosuch", users[1]);
            }
            catch (SQLException sQLException) {
                GrantRevokeTest.assertSQLState("42Y03", sQLException);
                if (!Locale.getDefault().getLanguage().equals("en")) break block2;
                GrantRevokeTest.assertEquals((String)"'S1.NOSUCH' is not recognized as a function.", (String)sQLException.getMessage());
            }
        }
    }

    public void testGrantOnNonexistantFunctionForProcedure() throws Exception {
        block2: {
            try {
                this.grant("execute", "function s1", "p1", users[1]);
            }
            catch (SQLException sQLException) {
                GrantRevokeTest.assertSQLState("42Y03", sQLException);
                if (!Locale.getDefault().getLanguage().equals("en")) break block2;
                GrantRevokeTest.assertEquals((String)"'S1.P1' is not recognized as a function.", (String)sQLException.getMessage());
            }
        }
    }

    public void testGrantOnProcedureWithBadSchema() throws Exception {
        try {
            this.grant("execute", "procedure nosuch", "f0", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42Y07", sQLException);
        }
    }

    public void testGrantOnNonexistantProcedure() throws Exception {
        block2: {
            try {
                this.grant("execute", "procedure s1", "nosuch", users[1]);
            }
            catch (SQLException sQLException) {
                GrantRevokeTest.assertSQLState("42Y03", sQLException);
                if (!Locale.getDefault().getLanguage().equals("en")) break block2;
                GrantRevokeTest.assertEquals((String)"'S1.NOSUCH' is not recognized as a procedure.", (String)sQLException.getMessage());
            }
        }
    }

    public void testGrantOnNonexistantProcedureForFunction() throws Exception {
        block2: {
            try {
                this.grant("execute", "procedure s1", "f2", users[1]);
            }
            catch (SQLException sQLException) {
                GrantRevokeTest.assertSQLState("42Y03", sQLException);
                if (!Locale.getDefault().getLanguage().equals("en")) break block2;
                GrantRevokeTest.assertEquals((String)"'S1.F2' is not recognized as a procedure.", (String)sQLException.getMessage());
            }
        }
    }

    public void testGrantExecuteOnTable() throws Exception {
        this.assertCompileError("42X01", "grant execute on table s1.t1 to " + users[1]);
    }

    public void testGrantSelectOnRoutine() throws Exception {
        this.assertCompileError("42X01", "grant select on function s1.f1 to " + users[1]);
        this.assertCompileError("42X01", "grant select on procedure s1.p1 to " + users[1]);
    }

    public void testGrantExecuteWithRestrict() throws Exception {
        this.assertCompileError("42X01", "grant execute on function s1.f1 to " + users[1] + " restrict");
    }

    public void testGrantRevokeWithoutRestrict() throws Exception {
        this.assertCompileError("42X01", "revoke execute on function s1.f1 from " + users[0]);
    }

    public void testGrantRevokeSelectWithRestrict() throws Exception {
        this.assertCompileError("42X01", "revoke select on s1.t1 from " + users[0] + " restrict");
    }

    public void testGrantDeleteWithColumnList() throws Exception {
        try {
            this.grant("delete(c1)", "s1", "t1", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42X01", sQLException);
        }
    }

    public void testGrantTriggerWithColumnList() throws Exception {
        try {
            this.grant("trigger(c1)", "s1", "t1", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42X01", sQLException);
        }
    }

    public void testOtherUserCannotRevokeOwnerPrivileges() throws SQLException {
        this.grant("select", "s1", "t1", "public");
        this.grant("insert", "s1", "t1", users[1]);
        this.grant("update", "s1", "t1", users[1]);
        this.grant("delete", "s1", "t1", users[1]);
        this.grant("update(c1)", "s1", "t1", users[2]);
        try {
            this.revoke(users[2], "select", "s1", "t1", "public");
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42506", sQLException);
        }
        try {
            this.revoke(users[2], "select", "s1", "t1", users[0]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42509", sQLException);
        }
        try {
            this.revoke(users[2], "insert", "s1", "t1", users[1]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42506", sQLException);
        }
        try {
            this.revoke(users[2], "update(c1)", "s1", "t1", users[2]);
        }
        catch (SQLException sQLException) {
            GrantRevokeTest.assertSQLState("42506", sQLException);
        }
        this.revoke("select", "s1", "t1", "public");
        this.revoke("all privileges", "s1", "t1", users[1]);
        this.revoke("all privileges", "s1", "t1", users[2]);
        this.assertAllPrivileges(false, users[1], "S1", "T1", null);
        this.assertAllPrivileges(false, users[2], "S1", "T1", null);
    }

    public void testViewDefinersRights() throws Exception {
        this.grant("select", "appl", "\"VW_MyTasks\"", users[1]);
        this.grant("select", "appl", "\"VW_MyPriorityTasks\"", users[1]);
        this.grant("select", "appl", "\"VW2_MyPriorityTasks\"", users[1]);
        this.grant("select", "appl", "\"VW3_MyPriorityTasks\"", users[1]);
        this.assertSelectPrivilege(true, users[1], "appl", "\"VW_MyTasks\"", null);
        this.assertSelectPrivilege(true, users[1], "appl", "\"VW_MyPriorityTasks\"", null);
        this.assertSelectPrivilege(true, users[1], "appl", "\"VW2_MyPriorityTasks\"", null);
        this.assertSelectPrivilege(true, users[1], "appl", "\"VW3_MyPriorityTasks\"", null);
    }

    void grant(String string, String string2, String string3, String string4) throws SQLException {
        this.grant(string, string2, string3, new String[]{string4});
    }

    void grant(String string, String string2, String string3, String string4, String string5) throws SQLException {
        Connection connection = this.openUserConnection(string);
        this.grant(connection, string2, string3, string4, string5);
        connection.close();
    }

    void grant(String string, String string2, String string3, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("grant " + string + " on " + string2 + "." + string3 + " to " + stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("," + stringArray[i]);
        }
        Statement statement = this.getConnection().createStatement();
        statement.executeUpdate(stringBuffer.toString());
        statement.close();
    }

    void grant(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        Statement statement = connection.createStatement();
        statement.executeUpdate("grant " + string + " on " + string2 + "." + string3 + " to " + string4);
        statement.close();
    }

    void revoke(String string, String string2, String string3, String string4) throws SQLException {
        this.revoke(string, string2, string3, new String[]{string4});
    }

    void revoke(String string, String string2, String string3, String string4, String string5) throws SQLException {
        Connection connection = this.openUserConnection(string);
        this.revoke(connection, string2, string3, string4, string5);
        connection.close();
    }

    void revoke(String string, String string2, String string3, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("revoke " + string + " on " + string2 + "." + string3 + " from " + stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("," + stringArray[i]);
        }
        if (string.equalsIgnoreCase("execute")) {
            stringBuffer.append(" restrict");
        }
        Statement statement = this.createStatement();
        statement.executeUpdate(stringBuffer.toString());
        statement.close();
    }

    void revoke(Connection connection, String string, String string2, String string3, String string4) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("revoke " + string + " on " + string2 + "." + string3 + " from " + string4 + (string.equalsIgnoreCase("execute") ? " restrict" : ""));
        statement.close();
    }

    public static int s1F1() {
        return 1;
    }

    public static int s2F1a() {
        return 1;
    }

    public static int s2F2() {
        return 1;
    }

    public static void s1F1P() {
    }

    public static void s1P1() {
    }

    public void assertAllPrivileges(boolean bl, String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.assertSelectPrivilege(bl, string, string2, string3, stringArray);
        this.assertDeletePrivilege(bl, string, string2, string3);
        this.assertInsertPrivilege(bl, string, string2, string3, stringArray);
        this.assertUpdatePrivilege(bl, string, string2, string3, stringArray);
        this.assertReferencesPrivilege(bl, string, string2, string3, stringArray);
        this.assertTriggerPrivilege(bl, string, string2, string3);
    }

    public void assertSelectPrivilege(boolean bl, String string, String string2, String string3, String[] stringArray) throws SQLException {
        Connection connection = this.openUserConnection(string);
        Statement statement = connection.createStatement();
        try {
            boolean bl2 = statement.execute("select " + GrantRevokeTest.columnListAsString(stringArray) + " from " + string2 + "." + string3);
            GrantRevokeTest.assertTrue((String)"expected no SELECT permission on table", (boolean)bl);
        }
        catch (SQLException sQLException) {
            if (!bl) {
                GrantRevokeTest.assertSQLState("42502", sQLException);
            }
            GrantRevokeTest.printStackTrace(sQLException);
            GrantRevokeTest.fail("Unexpected lack of select privilege", sQLException);
        }
        statement.close();
        connection.close();
        this.assertPrivilegeMetadata(bl, "SELECT", string, string2, string3, stringArray);
    }

    public void assertDeletePrivilege(boolean bl, String string, String string2, String string3) throws SQLException {
        Connection connection = this.openUserConnection(string);
        Statement statement = connection.createStatement();
        try {
            boolean bl2 = statement.execute("delete from " + string2 + "." + string3);
            GrantRevokeTest.assertTrue((String)"expected no DELETE permission on table", (boolean)bl);
        }
        catch (SQLException sQLException) {
            if (!bl) {
                GrantRevokeTest.assertSQLState("42500", sQLException);
            }
            GrantRevokeTest.printStackTrace(sQLException);
            GrantRevokeTest.fail("Unexpected lack of delete privilege", sQLException);
        }
        statement.close();
        connection.close();
        this.assertPrivilegeMetadata(bl, "DELETE", string, string2, string3, null);
    }

    public void assertInsertPrivilege(boolean bl, String string, String string2, String string3, String[] stringArray) throws SQLException {
        Connection connection = this.openUserConnection(string);
        Statement statement = connection.createStatement();
        try {
            StringBuffer stringBuffer = new StringBuffer("insert into " + string2 + "." + string3 + " values (");
            ResultSet resultSet = connection.getMetaData().getColumns(null, string2, string3, null);
            boolean bl2 = true;
            while (resultSet.next()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(",");
                }
                GrantRevokeTest.appendColumnValue(stringBuffer, resultSet.getInt(5));
            }
            resultSet.close();
            stringBuffer.append(")");
            int n = statement.executeUpdate(stringBuffer.toString());
            GrantRevokeTest.assertTrue((String)"expected no INSERT permission on table", (boolean)bl);
        }
        catch (SQLException sQLException) {
            if (!bl) {
                GrantRevokeTest.assertSQLState("42500", sQLException);
            }
            GrantRevokeTest.fail("Unexpected lack of insert privilege on " + JDBC.escape(string2, string3) + " by " + string, sQLException);
        }
        statement.close();
        connection.close();
        this.assertPrivilegeMetadata(bl, "INSERT", string, string2, string3, stringArray);
    }

    public void assertUpdatePrivilege(boolean bl, String string, String string2, String string3, String[] stringArray) throws SQLException {
        String[] stringArray2 = stringArray == null ? this.getAllColumns(string2, string3) : stringArray;
        Connection connection = this.openUserConnection(string);
        Statement statement = connection.createStatement();
        int n = 0;
        for (int i = 0; i < stringArray2.length; ++i) {
            boolean bl2 = false;
            try {
                Object object;
                try {
                    object = statement.executeQuery("select count(" + stringArray2[i] + ") from " + string2 + "." + string3);
                    if (!object.next()) {
                        GrantRevokeTest.fail((String)("Could not get count on " + stringArray2[i] + " to verify update"));
                    }
                    n = object.getInt(1);
                    bl2 = true;
                }
                catch (SQLException sQLException) {
                    GrantRevokeTest.assertSQLState("42502", sQLException);
                }
                object = new StringBuffer("update " + string2 + "." + string3 + " set " + stringArray2[i] + "=");
                ResultSet resultSet = connection.getMetaData().getColumns(null, string2, string3, stringArray2[i]);
                if (!resultSet.next()) {
                    GrantRevokeTest.fail((String)("Could not get column metadata for " + stringArray2[i]));
                }
                GrantRevokeTest.appendColumnValue((StringBuffer)object, resultSet.getInt(5));
                resultSet.close();
                int n2 = statement.executeUpdate(((StringBuffer)object).toString());
                if (bl && bl2) {
                    GrantRevokeTest.assertEquals((int)n, (int)n2);
                }
                GrantRevokeTest.assertTrue((String)"expected no UPDATE permission on table", (boolean)bl);
                continue;
            }
            catch (SQLException sQLException) {
                if (!bl) {
                    GrantRevokeTest.assertSQLState("42502", sQLException);
                    continue;
                }
                GrantRevokeTest.printStackTrace(sQLException);
                GrantRevokeTest.fail("Unexpected lack of privilege to update on " + JDBC.escape(string2, string3) + " by " + string, sQLException);
            }
        }
        statement.close();
        connection.close();
        this.assertPrivilegeMetadata(bl, "UPDATE", string, string2, string3, stringArray);
    }

    public void assertReferencesPrivilege(boolean bl, String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.assertPrivilegeMetadata(bl, "REFERENCES", string, string2, string3, stringArray);
    }

    public void assertTriggerPrivilege(boolean bl, String string, String string2, String string3) throws SQLException {
        Connection connection = this.openUserConnection(string);
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        try {
            int n = statement.executeUpdate("create trigger \"" + string3 + "Trig\" after insert on " + string2 + "." + string3 + " for each row values 1");
            if (bl) {
                GrantRevokeTest.assertEquals((int)0, (int)n);
            }
            GrantRevokeTest.assertTrue((String)"expected no TRIGGER permission on table", (boolean)bl);
        }
        catch (SQLException sQLException) {
            if (!bl) {
                GrantRevokeTest.assertSQLState("42500", sQLException);
            }
            GrantRevokeTest.printStackTrace(sQLException);
            GrantRevokeTest.fail("Unexpected lack of trigger privilege on " + JDBC.escape(string2, string3) + " by " + string, sQLException);
        }
        connection.rollback();
        statement.close();
        connection.close();
        this.assertPrivilegeMetadata(bl, "TRIGGER", string, string2, string3, null);
    }

    public void assertFunctionPrivilege(boolean bl, String string, String string2, String string3, boolean bl2) throws SQLException {
        Connection connection = this.openUserConnection(string);
        String string4 = "values " + string2 + "." + string3 + "()";
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string4);
            resultSet = preparedStatement.executeQuery();
            GrantRevokeTest.assertTrue((String)"expected no EXECUTE permission on function", (boolean)bl);
        }
        catch (SQLException sQLException) {
            if (!bl) {
                if (bl2) {
                    GrantRevokeTest.assertSQLState("42Y03", sQLException);
                } else {
                    GrantRevokeTest.assertSQLState("42504", sQLException);
                }
            }
            GrantRevokeTest.printStackTrace(sQLException);
            GrantRevokeTest.fail("Unexpected lack of function execute privilege", sQLException);
        }
        if (preparedStatement != null) {
            preparedStatement.close();
        }
        if (resultSet != null) {
            resultSet.close();
        }
        connection.close();
    }

    public void assertProcedurePrivilege(boolean bl, String string, String string2, String string3) throws SQLException {
        Connection connection = this.openUserConnection(string);
        String string4 = "call " + string2 + "." + string3 + "()";
        CallableStatement callableStatement = connection.prepareCall(string4);
        ResultSet resultSet = null;
        try {
            callableStatement.execute();
            resultSet = callableStatement.getResultSet();
            GrantRevokeTest.assertTrue((String)"expected no EXECUTE permission on procedure", (boolean)bl);
        }
        catch (SQLException sQLException) {
            if (!bl) {
                GrantRevokeTest.assertSQLState("42504", sQLException);
            }
            GrantRevokeTest.printStackTrace(sQLException);
            GrantRevokeTest.fail("Unexpected lack of procedure execute privilege", sQLException);
        }
        callableStatement.close();
        if (resultSet != null) {
            resultSet.close();
        }
        connection.close();
    }

    public void assertPrivilegeMetadata(boolean bl, String string, String string2, String string3, String string4, String[] stringArray) throws SQLException {
        Object object;
        Connection connection = this.openUserConnection(string2);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        string3 = JDBC.identifierToCNF(string3);
        string4 = JDBC.identifierToCNF(string4);
        ResultSet resultSet = databaseMetaData.getTablePrivileges(null, string3, string4);
        boolean bl2 = false;
        if (stringArray == null) {
            while (resultSet.next()) {
                GrantRevokeTest.assertEquals((String)resultSet.getString(4), (String)"TEST_DBO");
                GrantRevokeTest.assertEquals((String)resultSet.getString(7), (String)"NO");
                if (!resultSet.getString(6).equals(string) || !((String)(object = resultSet.getString(5))).equals(string2) && !((String)object).equals("PUBLIC")) continue;
                bl2 = true;
            }
            GrantRevokeTest.assertEquals((boolean)bl, (boolean)bl2);
            resultSet.close();
        }
        object = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                object = databaseMetaData.getColumnPrivileges(null, string3.toUpperCase(), string4.toUpperCase(), stringArray[i].toUpperCase());
                bl2 = false;
                while (object.next()) {
                    String string5;
                    GrantRevokeTest.assertEquals((String)"TEST_DBO", (String)object.getString(5));
                    GrantRevokeTest.assertEquals((String)"NO", (String)object.getString(8));
                    if (!object.getString(7).equals(string) || !(string5 = object.getString(6)).equals(string2) && !string5.equals("PUBLIC")) continue;
                    bl2 = true;
                }
                if (!bl) continue;
                GrantRevokeTest.assertTrue((boolean)bl2);
            }
        }
        if (object != null) {
            object.close();
        }
        connection.close();
    }

    static void appendColumnValue(StringBuffer stringBuffer, int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                stringBuffer.append("0");
                break;
            }
            case 1: 
            case 12: {
                stringBuffer.append("' '");
                break;
            }
            case 91: {
                stringBuffer.append("CURRENT_DATE");
                break;
            }
            case 92: {
                stringBuffer.append("CURRENT_TIME");
                break;
            }
            case 93: {
                stringBuffer.append("CURRENT_TIMESTAMP");
                break;
            }
            default: {
                stringBuffer.append("null");
            }
        }
    }

    static String columnListAsString(String[] stringArray) {
        if (stringArray == null) {
            return "*";
        }
        StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("," + stringArray[i]);
        }
        return stringBuffer.toString();
    }

    String[] getAllColumns(String string, String string2) throws SQLException {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = databaseMetaData.getColumns(null, string, string2, null);
        while (resultSet.next()) {
            arrayList.add(resultSet.getString(4));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    String getColumnDataType(String string, String string2, String string3) throws SQLException {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, string, string2, string3);
        int n = 0;
        while (resultSet.next()) {
            n = resultSet.getInt(5);
        }
        resultSet.close();
        return JDBC.sqlNameFromJdbc(n);
    }
}

