/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ForeignKeysNonSpsTest
extends BaseJDBCTestCase {
    private static final int WAIT_TIMEOUT_DURATION = 4;

    public ForeignKeysNonSpsTest(String string) {
        super(string);
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(ForeignKeysNonSpsTest.class);
    }

    public void testForeignKeys() throws Exception {
        Statement statement = this.createStatement();
        int n = this.numberOfRowsInSysdepends(statement);
        statement.executeUpdate("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() DYNAMIC RESULT SETS 0 LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
        statement.executeUpdate(" create table p (c1 char(1), y int not null, c2 char(1), x int not null, constraint pk primary key (x,y))");
        statement.executeUpdate(" create table f (x int not null, s smallint, y int not null, constraint fk foreign key (x,y) references p)");
        statement.executeUpdate("insert into p values ('1',1,'1',1)");
        statement.executeUpdate("insert into f values \t(1,1,1),\t(1,1,1),\t(1,1,1),\t\t(1,1,1),\t(1, 0, 1),\t(1,1,1),\t(1,0,1),\t(1, 0, 1)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 8, "delete from f");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, " insert into f values \t(1,1,1),\t(1,1,1),\t(1,1,1),\t\t(1,1,1),\t(1, 1, 1),\t(2,1,666),\t(1,1,0),\t(0, 1, 0)");
        statement.executeUpdate("drop table f");
        this.waitForPostCommit();
        statement.executeUpdate("create table f (c1 char(1), y int, c2 char(1), x int, constraint fk foreign key (x,y) references p)");
        statement.executeUpdate("insert into f select * from p where 1 = 2");
        statement.executeUpdate("drop table f");
        statement.executeUpdate("drop table p");
        this.waitForPostCommit();
        statement.executeUpdate("create table s (x int not null primary key, y int references s, z int references s)");
        statement.executeUpdate("insert into s values \t(1,1,1),\t(2,1,1),\t(10,2,1),\t\t(11,1,2),\t(12,4,4),\t(4,1,1),\t(13,null,null),\t(14,1,2),\t(15,null, 1)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 9, "delete from s");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "insert into s values \t(1,1,1),\t(2,1,1),\t(10,2,1),\t\t(11,1,2),\t(12,4,4),\t(4,1,1),\t(13,null,null),\t(14,1,2),\t(15,666, 1)");
        statement.executeUpdate("create table x (x int not null, y int, constraint pk primary key (x))");
        statement.executeUpdate(" create table y (x int , y int, constraint fk foreign key (x) references x)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into x\tvalues(0,0),(1,1),(2,2)");
        PreparedStatement preparedStatement2 = this.prepareStatement("insert into x values(3,3),(4,4)");
        PreparedStatement preparedStatement3 = this.prepareStatement("insert into y values(0,0),(1,1),(2,2)");
        PreparedStatement preparedStatement4 = this.prepareStatement("delete from y where x = 1");
        PreparedStatement preparedStatement5 = this.prepareStatement("delete from x where x = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement, 3);
        this.setAutoCommit(false);
        this.commit();
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement4, 0);
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement5, 1);
        ForeignKeysNonSpsTest.assertStatementError("23503", preparedStatement3);
        this.rollback();
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement3, 3);
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement4, 1);
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement5, 1);
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
        preparedStatement4.close();
        preparedStatement5.close();
        statement.executeUpdate("drop table y");
        statement.executeUpdate("drop table x");
        statement.executeUpdate("drop table s");
        this.setAutoCommit(true);
        this.waitForPostCommit();
        statement.executeUpdate("create table p1 (x int not null, constraint pk1 primary key(x))");
        statement.executeUpdate(" create table u1 (x int not null unique)");
        statement.executeUpdate("create table p2 (x int not null, y dec(5,2) not null, constraint pk2 primary key (x,y))");
        statement.executeUpdate(" create table u2 (x int not null, y dec(5,2) not null, constraint uk2 unique (x,y))");
        statement.executeUpdate(" create table p3 (x char(10) not null, constraint pk3 primary key (x))");
        statement.executeUpdate("create schema otherschema");
        statement.executeUpdate(" create table otherschema.p1 (x int not null primary key)");
        ForeignKeysNonSpsTest.assertStatementError("X0Y46", statement, "create table f (x int, constraint fk foreign key (x) references notthere)");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (x int, constraint fk foreign key (x) references p1(notthere))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (x int, constraint fk foreign key (x) references p2(y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (x smallint, constraint fk foreign key (x) references p1(x))");
        ForeignKeysNonSpsTest.assertStatementError("42Y08", statement, "create table f (x char(36), constraint fk foreign key (x) references sys.sysforeignkeys(constraintid))");
        ForeignKeysNonSpsTest.assertStatementError("42Y07", statement, "create table f (x char(36), constraint fk foreign key (x) references badschema.x)");
        ForeignKeysNonSpsTest.assertStatementError("42X93", statement, "create table f (x dec(5,2), y int, constraint fk foreign key (x,z) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (x dec(5,2), y int, constraint fk foreign key (x) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, " create table f (x dec(5,2), y int, constraint fk foreign key (x,y) references p2(x))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y46", statement, "create table f (x int references notthere)");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (x int references p1(notthere))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (x int references p2(y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (x smallint references p1(x))");
        ForeignKeysNonSpsTest.assertStatementError("42Y08", statement, "create table f (x char(36) references sys.sysforeignkeys(constraintid))");
        ForeignKeysNonSpsTest.assertStatementError("42Y07", statement, "create table f (x char(36) references badschema.x)");
        statement.executeUpdate("create table f (d dec(5,2), i int, constraint fk foreign key (i,d) references p2(x,y))");
        statement.executeUpdate(" drop table f");
        this.waitForPostCommit();
        statement.executeUpdate(" create table f (i int, d dec(5,2), constraint fk foreign key (i,d) references p2(x,y))");
        statement.executeUpdate("drop table f");
        this.waitForPostCommit();
        statement.executeUpdate(" create table f (d dec(5,2), i int, constraint fk foreign key (i,d) references u2(x,y))");
        statement.executeUpdate("drop table f");
        this.waitForPostCommit();
        statement.executeUpdate(" create table f (i int, d dec(5,2), constraint fk foreign key (i,d) references u2(x,y))");
        statement.executeUpdate("drop table f");
        this.waitForPostCommit();
        statement.executeUpdate(" create table f (c char(10) references p3(x))");
        statement.executeUpdate("drop table f");
        this.waitForPostCommit();
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (i int, d dec(5,1), constraint fk foreign key (i,d) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, " create table f (i int, d dec(4,2), constraint fk foreign key (i,d) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, " create table f (i int, d dec(4,2), constraint fk foreign key (i,d) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, " create table f (i int, d numeric(5,2), constraint fk foreign key (i,d) references p2(x,y))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, " create table f (c char(11) references p3(x))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, " create table f (c varchar(10) references p3(x))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y44", statement, "create table f (d dec(5,2), i int, constraint fk foreign key (d,i) references p2(x,y))");
        statement.executeUpdate("create table f (x int, constraint fk foreign key (x) references p1)");
        ResultSet resultSet = statement.executeQuery(" select constraintname, referencecount \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.keyconstraintid = c.constraintid order by constraintname");
        Object[][] objectArray = new String[][]{{"PK1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" create table f2 (x int, constraint fk2 foreign key (x) references p1(x))");
        statement.executeUpdate(" create table f3 (x int, constraint fk3 foreign key (x) references p1(x))");
        statement.executeUpdate(" create table f4 (x int, constraint fk4 foreign key (x) references p1(x))");
        resultSet = statement.executeQuery(" select distinct constraintname, referencecount \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.keyconstraintid = c.constraintid order by constraintname");
        objectArray = new String[][]{{"PK1", "4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery(" select constraintname \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.constraintid = c.constraintid\torder by 1");
        objectArray = new String[][]{{"FK"}, {"FK2"}, {"FK3"}, {"FK4"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ForeignKeysNonSpsTest.assertStatementError("X0Y25", statement, "alter table p1 drop constraint pk1");
        ForeignKeysNonSpsTest.assertStatementError("X0Y25", statement, "drop table p1");
        this.waitForPostCommit();
        statement.executeUpdate("drop table f2");
        statement.executeUpdate("drop table f3");
        statement.executeUpdate("drop table f4");
        this.waitForPostCommit();
        resultSet = statement.executeQuery(" select constraintname, referencecount \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.keyconstraintid = c.constraintid order by constraintname");
        objectArray = new String[][]{{"PK1", "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate(" alter table f drop constraint fk");
        this.waitForPostCommit();
        statement.executeUpdate("alter table p1 drop constraint pk1");
        this.waitForPostCommit();
        ForeignKeysNonSpsTest.assertStatementError("X0Y41", statement, "alter table f add constraint fk foreign key (x) references p1");
        statement.executeUpdate("alter table p1 add constraint pk1 primary key (x)");
        statement.executeUpdate(" create table f2 (x int, constraint fk2 foreign key (x) references p1(x))");
        statement.executeUpdate(" create table f3 (x int, constraint fk3 foreign key (x) references p1(x))");
        statement.executeUpdate(" create table f4 (x int, constraint fk4 foreign key (x) references p1(x))");
        statement.executeUpdate("alter table f4 drop constraint fk4");
        statement.executeUpdate("alter table f3 drop constraint fk3");
        statement.executeUpdate("alter table f2 drop constraint fk2");
        statement.executeUpdate("alter table p1 drop constraint pk1");
        this.waitForPostCommit();
        resultSet = statement.executeQuery("select constraintname \tfrom sys.sysconstraints c, sys.sysforeignkeys fk\twhere fk.constraintid = c.constraintid order by constraintname");
        JDBC.assertDrainResults(resultSet, 0);
        statement.executeUpdate("drop table p1");
        statement.executeUpdate("drop table p2");
        statement.executeUpdate("drop table u1");
        statement.executeUpdate("drop table u2");
        statement.executeUpdate("drop table otherschema.p1");
        statement.executeUpdate("drop schema otherschema restrict");
        this.waitForPostCommit();
        statement.executeUpdate("create table default_sysdepends_count(a int)");
        statement.executeUpdate(" insert into default_sysdepends_count select count(*) from sys.sysdepends");
        resultSet = statement.executeQuery(" select * from default_sysdepends_count");
        objectArray = new String[][]{{Integer.toString(n)}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table selfref (p char(10) not null primary key, \t\tf char(10) references selfref)");
        statement.executeUpdate("drop table selfref");
        this.waitForPostCommit();
        statement.executeUpdate("create table selfref (p char(10) not null, \t\tf char(10) references selfref, \t\tconstraint pk primary key (p))");
        statement.executeUpdate("drop table selfref");
        this.waitForPostCommit();
        statement.executeUpdate("create table selfref (p char(10) not null, f char(10), \t\tconstraint f foreign key (f) references selfref(p), \t\tconstraint pk primary key (p))");
        ForeignKeysNonSpsTest.assertStatementError("X0Y25", statement, "alter table selfref drop constraint pk");
        this.waitForPostCommit();
        statement.executeUpdate("alter table selfref drop constraint f");
        statement.executeUpdate(" alter table selfref drop constraint pk");
        statement.executeUpdate("drop table selfref");
        this.waitForPostCommit();
        statement.executeUpdate("create table pr1(x int not null, \t\tconstraint pkr1 primary key (x))");
        statement.executeUpdate(" create table pr2(x int not null, \t\tconstraint pkr2 primary key(x), \t\tconstraint fpkr2 foreign key (x) references pr1)");
        statement.executeUpdate(" create table pr3(x int not null, \t\tconstraint pkr3 primary key(x), \t\tconstraint fpkr3 foreign key (x) references pr2)");
        resultSet = statement.executeQuery(" select constraintname, referencecount from sys.sysconstraints order by constraintname");
        objectArray = new String[][]{{"FPKR2", "0"}, {"FPKR3", "0"}, {"PK3", "0"}, {"PKR1", "1"}, {"PKR2", "1"}, {"PKR3", "0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("alter table pr2 drop constraint fpkr2");
        statement.executeUpdate(" alter table pr1 drop constraint pkr1");
        this.waitForPostCommit();
        resultSet = statement.executeQuery("select constraintname, referencecount from sys.sysconstraints order by constraintname");
        objectArray = new String[][]{{"FPKR3", "0"}, {"PK3", "0"}, {"PKR2", "1"}, {"PKR3", "0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("drop table pr3");
        statement.executeUpdate("drop table pr2");
        statement.executeUpdate("drop table pr1");
        this.waitForPostCommit();
        statement.executeUpdate("create table default_sysdepends_count2(a int)");
        statement.executeUpdate(" insert into default_sysdepends_count2 select count(*) from sys.sysdepends");
        resultSet = statement.executeQuery(" select default_sysdepends_count2.a - default_sysdepends_count.a    from default_sysdepends_count2, default_sysdepends_count");
        objectArray = new String[][]{{"0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        statement.executeUpdate("create table x (x int not null primary key, y int, constraint xfk foreign key (y) references x)");
        statement.executeUpdate(" create table y (x int, constraint yfk foreign key (x) references x)");
        PreparedStatement preparedStatement6 = this.prepareStatement("select * from x");
        PreparedStatement preparedStatement7 = this.prepareStatement("insert into x values (1,1)");
        PreparedStatement preparedStatement8 = this.prepareStatement("update x set x = x+1, y=y+1");
        statement.executeUpdate(" alter table x drop constraint xfk");
        this.waitForPostCommit();
        this.setAutoCommit(false);
        statement.executeUpdate("alter table y drop constraint yfk");
        this.commit();
        this.waitForPostCommit();
        statement.executeUpdate("drop table y");
        this.commit();
        this.waitForPostCommit();
        statement.executeUpdate("drop table x");
        preparedStatement6.close();
        preparedStatement7.close();
        preparedStatement8.close();
        statement.executeUpdate("drop table f3");
        statement.executeUpdate("drop table f2");
        statement.executeUpdate("drop table f");
        this.commit();
        this.waitForPostCommit();
        statement.executeUpdate("create table default_sysdepends_count3(a int)");
        statement.executeUpdate(" insert into default_sysdepends_count3 select count(*) from sys.sysdepends");
        resultSet = statement.executeQuery(" select default_sysdepends_count3.a - default_sysdepends_count.a    from default_sysdepends_count3, default_sysdepends_count");
        objectArray = new String[][]{{"0"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        this.setAutoCommit(true);
        ForeignKeysNonSpsTest.assertStatementError("42Y55", statement, "drop table s");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", statement, "drop table f3");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", statement, "drop table f2");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", statement, "drop table f");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", statement, "drop table p");
        this.waitForPostCommit();
        statement.executeUpdate(" create table p (x int not null, y int not null, constraint pk primary key (x,y))");
        statement.executeUpdate(" create table f (x int, y int, constraint fk foreign key (x,y) references p)");
        statement.executeUpdate(" insert into p values (1,1)");
        statement.executeUpdate("insert into f values (1,1)");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "insert into f values (2,1)");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, " insert into f values (1,2)");
        statement.executeUpdate("insert into f values (1,null)");
        statement.executeUpdate("insert into f values (null,null)");
        statement.executeUpdate("insert into f values (1,null)");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set x = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set y = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set x = 1, y = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set x = 2, y = 1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set x = 2, y = 2");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update p set x = 1, y = 1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "delete from p");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 4, "delete from f");
        statement.executeUpdate("insert into f values (1,1)");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update f set x = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update f set y = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update f set x = 1, y = 2");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update f set x = 2, y = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update f set x = 1, y = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update f set x = null, y = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update f set x = 1, y = null");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update f set x = null, y = null");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "delete from f");
        statement.executeUpdate("insert into f values (1,1)");
        statement.executeUpdate("insert into p values (2,2)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update f set x = x+1, y = y+1");
        resultSet = statement.executeQuery("select * from f");
        objectArray = new String[][]{{"2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        resultSet = statement.executeQuery("select * from p");
        objectArray = new String[][]{{"1", "1"}, {"2", "2"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 2, "update p set x = x+1, y = y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set x = x+1, y = y+1");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "delete from f");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 2, "delete from p");
        statement.executeUpdate("insert into f select * from f");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 0, "delete from p where x = 9999");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 0, "update p set x = x+1, y=y+1 where x = 999");
        statement.executeUpdate("insert into p values (1,1)");
        statement.executeUpdate("insert into f values (1,1)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 0, "update p set x = x+1, y=y+1 where x = 999");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 0, "delete from p where x = 9999");
        statement.executeUpdate("insert into f select * from f");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 2, "delete from f");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "delete from p");
        statement.executeUpdate("insert into p values (1,1)");
        statement.executeUpdate("insert into f values (1,1)");
        this.setAutoCommit(false);
        Statement statement2 = this.createStatement(1003, 1008);
        ResultSet resultSet2 = statement2.executeQuery("select * from p for update of x");
        resultSet2.next();
        ForeignKeysNonSpsTest.assertEquals((String)resultSet2.getString(1), (String)"1");
        ForeignKeysNonSpsTest.assertEquals((String)resultSet2.getString(2), (String)"1");
        try {
            resultSet2.updateInt("X", 666);
        }
        catch (SQLException sQLException) {
            ForeignKeysNonSpsTest.assertSQLState("23503", sQLException);
        }
        resultSet2.close();
        resultSet2 = statement2.executeQuery("select * from f for update of x");
        resultSet2.next();
        ForeignKeysNonSpsTest.assertEquals((String)resultSet2.getString(1), (String)"1");
        ForeignKeysNonSpsTest.assertEquals((String)resultSet2.getString(2), (String)"1");
        try {
            resultSet2.updateInt("X", 666);
        }
        catch (SQLException sQLException) {
            ForeignKeysNonSpsTest.assertSQLState("23503", sQLException);
        }
        resultSet2.close();
        this.commit();
        this.setAutoCommit(true);
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "delete from f");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "delete from p");
        statement.executeUpdate("insert into p values (0,0), (1,1), (2,2), (3,3), (4,4)");
        statement.executeUpdate("insert into f values (1,1)");
        statement.executeUpdate("create table f2 (x int, y int, constraint fk2 foreign key (x,y) references p)");
        statement.executeUpdate("insert into f2 values (2,2)");
        statement.executeUpdate(" create table f3 (x int, y int, constraint fk3 foreign key (x,y) references p)");
        statement.executeUpdate("insert into f3 values (3,3)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 5, "update p set x = x+1, y = y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set x = x+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set y = y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set x = x+1, y = y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set y = 666 where y = 3");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update p set x = 666 where x = 2");
        statement.executeUpdate("drop table f");
        statement.executeUpdate("drop table f2");
        statement.executeUpdate("drop table f3");
        statement.executeUpdate("drop table p");
        this.waitForPostCommit();
        statement.executeUpdate("create table s (x int not null primary key, y int references s, z int references s)");
        statement.executeUpdate("insert into s values (1,null,null)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update s set y = 1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update s set z = 2");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update s set z = 1");
        statement.executeUpdate("insert into s values (2, 1, 1)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update s set x = 666 where x = 2");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 2, "update s set x = x+1, y = y+1, z = z+1");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 2, "delete from s");
        statement.executeUpdate("insert into s values (1,null,null)");
        statement.executeUpdate("insert into s values (2,null,null)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update s set y = 2 where x = 1");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "update s set z = 1 where x = 2");
        resultSet = statement.executeQuery("select * from s");
        objectArray = new String[][]{{"1", "2", null}, {"2", null, "1"}};
        JDBC.assertFullResultSet(resultSet, objectArray, true);
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "update s set x = 0 where x = 1");
        statement.executeUpdate("create table p (c1 char(1), y int not null, c2 char(1), x int not null, constraint pk primary key (x,y))");
        statement.executeUpdate(" create table f (x int, s smallint, y int, constraint fk foreign key (x,y) references p)");
        statement.executeUpdate(" insert into p values ('1',1,'1',1)");
        statement.executeUpdate("insert into f values (1,1,1)");
        statement.executeUpdate("insert into p values ('0',0,'0',0)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 2, "update p set x = x+1, y=y+1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "delete from p where y = 1");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "insert into f values (1,1,4)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 1, "delete from f");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 2, "delete from p");
        statement.executeUpdate("insert into p values ('1',1,'1',1)");
        statement.executeUpdate("insert into f values (1,1,1)");
        statement.executeUpdate("insert into p values ('0',0,'0',0)");
        ForeignKeysNonSpsTest.assertUpdateCount(statement, 2, "update p set x = x+1, y=y+1 where x < (select max(x)+10000 from p)");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "delete from p where y = 1 and y in (select y from p)");
        statement.executeUpdate("create table f2 (x int, t smallint, y int)");
        statement.executeUpdate("insert into f2 values (1,1,4)");
        ForeignKeysNonSpsTest.assertStatementError("23503", statement, "insert into f select * from f2");
        statement.executeUpdate("insert into f2 values (1,1,1)");
        statement.executeUpdate("insert into f select * from f2 where y = 1");
        statement.executeUpdate("drop table f2");
        statement.executeUpdate("drop table f");
        statement.executeUpdate("drop table p");
        this.waitForPostCommit();
        ForeignKeysNonSpsTest.assertStatementError("42Y55", statement, "drop table f");
        ForeignKeysNonSpsTest.assertStatementError("42Y55", statement, "drop table p");
        this.waitForPostCommit();
        PreparedStatement preparedStatement9 = this.prepareStatement("create table p (w int not null primary key, x int references p, y int not null, z int not null, constraint uyz unique (y,z))");
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement9, 0);
        preparedStatement9 = this.prepareStatement("create table f (w int references p, x int, y int, z int, constraint fk foreign key (y,z) references p (y,z))");
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement9, 0);
        preparedStatement9 = this.prepareStatement("alter table f drop constraint fk");
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement9, 0);
        this.waitForPostCommit();
        preparedStatement9 = this.prepareStatement("alter table f add constraint fk foreign key (y,z) references p (y,z)");
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement9, 0);
        PreparedStatement preparedStatement10 = this.prepareStatement("insert into f values (1,1,1,1)");
        PreparedStatement preparedStatement11 = this.prepareStatement("insert into p values (1,1,1,1)");
        ForeignKeysNonSpsTest.assertStatementError("23503", preparedStatement10);
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement11, 1);
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement10, 1);
        statement.executeUpdate(" insert into p values (2,2,2,2)");
        preparedStatement9 = this.prepareStatement("update f set w=w+1, x = x+1, y=y+1, z=z+1");
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement9, 1);
        preparedStatement9 = this.prepareStatement("update p set w=w+1, x = x+1, y=y+1, z=z+1");
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement9, 2);
        preparedStatement9 = this.prepareStatement("delete from p where x =1");
        ForeignKeysNonSpsTest.assertUpdateCount(preparedStatement9, 0);
        statement.executeUpdate("drop table f");
        statement.executeUpdate("drop table p");
        this.waitForPostCommit();
        statement.executeUpdate("drop procedure WAIT_FOR_POST_COMMIT");
        this.rollback();
        statement.close();
    }

    private int numberOfRowsInSysdepends(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM SYS.SYSDEPENDS");
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        return n;
    }

    private void waitForPostCommit() throws SQLException {
        CallableStatement callableStatement = this.prepareCall("CALL WAIT_FOR_POST_COMMIT()");
        ForeignKeysNonSpsTest.assertUpdateCount(callableStatement, 0);
        callableStatement.close();
    }
}

