/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.shared.common.error.DerbySQLIntegrityConstraintViolationException;
import org.apache.derbyTesting.functionTests.tests.lang.DBOperations;
import org.apache.derbyTesting.functionTests.tests.lang.LockTableTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XATestUtil;

public class ConstraintCharacteristicsTest
extends BaseJDBCTestCase {
    private static final String LANG_DUPLICATE_KEY_CONSTRAINT = "23505";
    private static final String LANG_DEFERRED_DUP_VIOLATION_T = "23506";
    private static final String LANG_DEFERRED_DUP_VIOLATION_S = "23507";
    private static final String LANG_CHECK_CONSTRAINT_VIOLATED = "23513";
    private static final String LANG_DEFERRED_CHECK_VIOLATION_T = "23514";
    private static final String LANG_DEFERRED_CHECK_VIOLATION_S = "23515";
    private static final String LANG_DEFERRED_FK_VIOLATION_T = "23516";
    private static final String LANG_DEFERRED_FK_VIOLATION_S = "23517";
    private static final String LOCK_TIMEOUT = "40XL1";
    private static final String LANG_INCONSISTENT_C_CHARACTERISTICS = "42X97";
    private static final String LANG_DROP_OR_ALTER_NON_EXISTING_C = "42X86";
    private static final String LANG_SYNTAX_ERROR = "42X01";
    private static final String NOT_IMPLEMENTED = "0A000";
    private static final String LANG_NOT_NULL_CHARACTERISTICS = "42XAN";
    private static final String LANG_OBJECT_NOT_FOUND = "42X94";
    private static final String LANG_DB2_DUPLICATE_NAMES = "42734";
    private static final String LANG_ADD_CHECK_CONSTRAINT_FAILED = "X0Y59";
    private static String expImpDataFile;
    private static String expImpDataWithNullsFile;
    private static boolean exportFilesCreatedEmbedded;
    private static boolean exportFilesCreatedClient;
    private static final int WAIT_TIMEOUT_DURATION = 1;
    static final String[] uniqueForms;
    static final String[] uniqueSpec;
    static final String[] checkForms;
    static final String[] fkForms;
    static final String[] checkSpec;
    static final String[][] initialContents;
    static final String[][] negatedInitialContents;
    static final String[] setConstraintsForms;
    static final long NO_OF_INSERTED_ROWS = 4096L;
    static final String DID = "deferrable initially deferred";
    private static final String[] tableConstraintTypes;
    private static final String[] columnConstraintTypes;
    private static final String[][] defaultCharacteristics;
    private static final String[][] nonDefaultCharacteristics;
    private static final String[] illegalCharacteristics;
    private static final String[] illegalAlterCharacteristics;
    private static final Map<String, String[]> inverseState;

    public ConstraintCharacteristicsTest(String string) {
        super(string);
    }

    public static Test suite() {
        String string = ConstraintCharacteristicsTest.class.getName();
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTest(ConstraintCharacteristicsTest.baseSuite1(string + ":embedded 1"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ConstraintCharacteristicsTest.baseSuite1(string + ":client 1")));
        baseTestSuite.addTest(ConstraintCharacteristicsTest.baseSuite2(string + ":embedded 2"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ConstraintCharacteristicsTest.baseSuite2(string + ":client 2")));
        baseTestSuite.addTest(ConstraintCharacteristicsTest.baseSuite3(string + ":embedded 3"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ConstraintCharacteristicsTest.baseSuite3(string + ":client 3")));
        return baseTestSuite;
    }

    private static Test baseSuite3(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testDeferredRowsInvalidation"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testLockingForUniquePK"));
        Properties properties = new Properties();
        properties.setProperty("derby.locks.waitTimeout", Integer.toString(1));
        return new SupportFilesSetup((Test)new SystemPropertyTestSetup((Test)baseTestSuite, properties, true));
    }

    private static Test baseSuite2(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        Properties properties = new Properties();
        properties.setProperty("derby.language.logQueryPlan", "true");
        baseTestSuite.addTest((Test)new SupportFilesSetup((Test)new SystemPropertyTestSetup((Test)new ConstraintCharacteristicsTest("testDerby6666"), properties, true)));
        return baseTestSuite;
    }

    private static Test baseSuite1(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testSyntaxAndBinding"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testDropNotNullOnUniqueColumn"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testCompressTableOKUnique"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testLockingForUniquePKWithCommit"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testLockingForUniquePKWithRollback"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testDatabaseMetaData"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testCreateConstraintDictionaryEncodings"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testAlterConstraintDictionaryEncodings"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testAlterConstraintInvalidation"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testBasicDeferral"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testRoutines"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testImport"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testDerby6374"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testXA"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testAlmostRemovedAllDups"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testCheckConstraintsWithDeferredRows"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testSeveralCheckConstraints"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testDerby6670_a"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testDerby6670_b"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testManySimilarDuplicates"));
        baseTestSuite.addTest((Test)new ConstraintCharacteristicsTest("testDerby6773"));
        Properties properties = new Properties();
        properties.setProperty("derby.locks.waitTimeout", Integer.toString(500));
        return new SupportFilesSetup((Test)new SystemPropertyTestSetup((Test)baseTestSuite, properties, true));
    }

    protected void setUp() throws Exception {
        super.setUp();
        Statement statement = this.createStatement();
        statement.executeUpdate("create table referenced(    i int primary key, j int default 0)");
        if (ConstraintCharacteristicsTest.usingEmbedded() && !exportFilesCreatedEmbedded || ConstraintCharacteristicsTest.usingDerbyNetClient() && !exportFilesCreatedClient) {
            if (ConstraintCharacteristicsTest.usingEmbedded()) {
                exportFilesCreatedEmbedded = true;
            } else {
                exportFilesCreatedClient = true;
            }
            expImpDataFile = SupportFilesSetup.getReadWrite("t.data").getPath();
            expImpDataWithNullsFile = SupportFilesSetup.getReadWrite("t_with_nulls.data").getPath();
            statement.executeUpdate("create table t(i int)");
            statement.executeUpdate("insert into t values 1,-2,-2, 3");
            statement.executeUpdate("create table t_with_nulls(i int)");
            statement.executeUpdate("insert into t_with_nulls values 1,null, null, 3");
            statement.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null)");
            statement.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (    'APP' , 'T_WITH_NULLS' , '" + expImpDataWithNullsFile + "', null, null , null)");
            statement.executeUpdate("drop table t");
            statement.executeUpdate("drop table t_with_nulls");
        }
        statement.close();
        this.setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.setAutoCommit(true);
        this.getConnection().createStatement().executeUpdate("drop table referenced");
        super.tearDown();
    }

    public void testSyntaxAndBinding() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        ConstraintCharacteristicsTest.assertTableLevelDefaultBehaviorAccepted(connection, statement);
        ConstraintCharacteristicsTest.assertTableLevelNonDefaultAccepted(statement);
        statement.executeUpdate("create table t(i int, constraint app.c primary key(i))");
        statement.executeUpdate("alter table t alter constraint c enforced");
        ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, statement, "alter table t alter constraint c not enforced");
        for (String string : illegalAlterCharacteristics) {
            ConstraintCharacteristicsTest.assertStatementError(LANG_SYNTAX_ERROR, statement, "alter table t alter constraint c " + string);
        }
        ConstraintCharacteristicsTest.assertStatementError(LANG_DROP_OR_ALTER_NON_EXISTING_C, statement, "alter table t alter constraint cuckoo not enforced");
        statement.executeUpdate("alter table t drop constraint c");
        statement.executeUpdate("alter table t add constraint c     primary key(i) deferrable");
        statement.executeUpdate("set constraints c deferred");
        statement.executeUpdate("set constraints all deferred");
        ConstraintCharacteristicsTest.assertStatementError(LANG_OBJECT_NOT_FOUND, statement, "set constraints cuckoo deferred");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DB2_DUPLICATE_NAMES, statement, "set constraints c,c deferred");
        connection.rollback();
        ConstraintCharacteristicsTest.assertColumnLevelDefaultBehaviorAccepted(connection, statement);
        ConstraintCharacteristicsTest.assertColumnLevelNonDefaultAccepted(statement);
        ConstraintCharacteristicsTest.assertStatementError(LANG_NOT_NULL_CHARACTERISTICS, statement, "create table t(i int not null deferrable initially immediate)");
    }

    public void testCreateConstraintDictionaryEncodings() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        for (String[] stringArray : defaultCharacteristics) {
            this.assertDictState(statement, stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : nonDefaultCharacteristics) {
            this.assertDictState(statement, stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : illegalCharacteristics) {
            this.assertCreateInconsistentCharacteristics(statement, (String)stringArray);
        }
        this.rollback();
    }

    public void testAlterConstraintDictionaryEncodings() throws SQLException {
        Statement statement = this.getConnection().createStatement();
        for (String[] stringArray : defaultCharacteristics) {
            statement.executeUpdate("create table t(i int, constraint c primary key(i) " + stringArray[0] + ")");
            this.assertAlterDictState(statement, "enforced");
            this.assertAlterDictState(statement, "not enforced");
            this.rollback();
        }
        for (String[] stringArray : nonDefaultCharacteristics) {
            if (stringArray[0].contains("not enforced")) {
                ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, statement, "create table t(i int, constraint c primary key(i) " + stringArray[0] + ")");
                continue;
            }
            statement.executeUpdate("create table t(i int, constraint c primary key(i) " + stringArray[0] + ")");
            this.assertAlterDictState(statement, "enforced");
            this.assertAlterDictState(statement, "not enforced");
            this.rollback();
        }
        for (String[] stringArray : illegalAlterCharacteristics) {
            this.assertAlterInconsistentCharacteristics(statement, (String)stringArray);
        }
    }

    public void testAlterConstraintInvalidation() throws SQLException {
        if (ConstraintCharacteristicsTest.usingDerbyNetClient()) {
            return;
        }
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t(i int, constraint c primary key(i))");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into t values 3");
        preparedStatement.execute();
        statement.executeUpdate("alter table t alter constraint c enforced ");
        LanguageConnectionContext languageConnectionContext = ConstraintCharacteristicsTest.getLCC(connection);
        GenericPreparedStatement genericPreparedStatement = (GenericPreparedStatement)languageConnectionContext.getLastActivation().getPreparedStatement();
        ConstraintCharacteristicsTest.assertFalse((boolean)genericPreparedStatement.isValid());
        this.rollback();
    }

    public void testDatabaseMetaData() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t(i int not null     constraint c primary key deferrable initially immediate)");
        DatabaseMetaData databaseMetaData = statement.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getIndexInfo(null, null, "T", false, false);
        resultSet.next();
        ConstraintCharacteristicsTest.assertEquals((String)"false", (String)resultSet.getString("NON_UNIQUE"));
        String[] stringArray = new String[]{"deferrable initially immediate", DID, "not deferrable"};
        int[] nArray = new int[]{6, 5, 7};
        for (int i = 0; i < stringArray.length; ++i) {
            statement.executeUpdate("create table child(i int, constraint c2 foreign key(i)     references t(i) " + stringArray[i] + ")");
            resultSet = databaseMetaData.getImportedKeys(null, null, "CHILD");
            resultSet.next();
            ConstraintCharacteristicsTest.assertEquals((String)Integer.toString(nArray[i]), (String)resultSet.getString("DEFERRABILITY"));
            resultSet.close();
            resultSet = databaseMetaData.getExportedKeys(null, null, "T");
            resultSet.next();
            ConstraintCharacteristicsTest.assertEquals((String)Integer.toString(nArray[i]), (String)resultSet.getString("DEFERRABILITY"));
            resultSet.close();
            resultSet = databaseMetaData.getCrossReference(null, null, "T", null, null, "CHILD");
            resultSet.next();
            ConstraintCharacteristicsTest.assertEquals((String)Integer.toString(nArray[i]), (String)resultSet.getString("DEFERRABILITY"));
            resultSet.close();
            statement.executeUpdate("drop table child");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockingForUniquePK() throws SQLException {
        Statement statement;
        Statement statement2 = this.createStatement();
        statement2.executeUpdate("create table t1(i int, constraint c1 primary key(i) not deferrable)");
        statement2.executeUpdate("create table t2(i int, constraint c2 primary key(i) deferrable initially deferred)");
        statement2.executeUpdate("insert into t1 values 1,2,3");
        statement2.executeUpdate("insert into t2 values 1,2,3");
        this.commit();
        statement2.executeUpdate("insert into t1 values 4");
        ResultSet resultSet = statement2.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTransaction", "TABLE", "2", "IX", "T1", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "ROW", "1", "X", "T1", "(1,10)", "GRANT", "ACTIVE"}});
        Connection connection = null;
        try {
            connection = this.openDefaultConnection();
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            ConstraintCharacteristicsTest.assertStatementError(LOCK_TIMEOUT, statement, "insert into t1 values 4");
        }
        finally {
            if (connection != null) {
                connection.rollback();
                connection.close();
            }
        }
        this.commit();
        statement2.executeUpdate("insert into t2 values 4");
        resultSet = statement2.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTransaction", "TABLE", "1", "IS", "T2", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "TABLE", "2", "IX", "T2", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "ROW", "1", "X", "T2", "(1,10)", "GRANT", "ACTIVE"}});
        this.commit();
        statement2.executeUpdate("insert into t2 values 4");
        resultSet = statement2.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTransaction", "TABLE", "1", "IS", "T2", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "TABLE", "2", "IX", "T2", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "ROW", "1", "X", "T2", "(1,11)", "GRANT", "ACTIVE"}});
        try {
            connection = this.openDefaultConnection();
            connection.setAutoCommit(false);
            statement = connection.createStatement();
            statement.executeUpdate("insert into t2 values 4");
            ConstraintCharacteristicsTest.assertCommitError(LOCK_TIMEOUT, connection);
        }
        finally {
            try {
                if (connection != null) {
                    connection.rollback();
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        this.rollback();
        statement2.executeUpdate("insert into t2 values 5");
        connection = this.openDefaultConnection();
        connection.setAutoCommit(false);
        statement = connection.createStatement();
        statement.executeUpdate("insert into t2 values 5");
        this.commit();
        connection.rollback();
        statement.executeUpdate("insert into t2 values 10,12");
        statement2.executeUpdate("insert into t2 values 11,11");
        Statement statement3 = this.createStatement(1003, 1008);
        resultSet = statement3.executeQuery("select * from t2 where i=11");
        resultSet.next();
        resultSet.deleteRow();
        resultSet.close();
        this.commit();
        connection.rollback();
        connection.close();
        statement2.executeUpdate("drop table t1");
        statement2.executeUpdate("drop table t2");
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicDeferral() throws SQLException {
        Statement statement = this.createStatement();
        for (String string : setConstraintsForms) {
            int n = 0;
            for (String string2 : uniqueForms) {
                try {
                    statement.executeUpdate(string2 + " deferrable initially immediate)");
                    statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    this.commit();
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "insert into t values (2,30)");
                    statement.executeUpdate(string + " deferred");
                    statement.executeUpdate("insert into t values (2,19),(2,21),(3,31)");
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t"), new String[][]{{"1", "10"}, {"2", "20"}, {"3", "30"}, {"2", "19"}, {"2", "21"}, {"3", "31"}});
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t --DERBY-PROPERTIES constraint=c\n     order by i"), new String[][]{{"1", "10"}, {"2", "20"}, {"2", "19"}, {"2", "21"}, {"3", "30"}, {"3", "31"}});
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, statement, string + " immediate");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, statement, string + " immediate");
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_DUP_VIOLATION_T, this.getConnection());
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t"), initialContents);
                    statement.executeUpdate(string + " immediate");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "insert into t values (2,30)");
                    statement.executeUpdate(string + " deferred");
                    statement.executeUpdate("insert into t values (2,19),(2,21),(3,31)");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, statement, string + " immediate");
                    this.rollback();
                    statement.executeUpdate(string + " deferred");
                    statement.executeUpdate("insert into t values (20,19),(200,21),(30,31)");
                    statement.executeUpdate("update t set i=2 where i=20");
                    statement.executeUpdate("update t set i=2 where i=200");
                    statement.executeUpdate("update t set i=3 where i=30");
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t --DERBY-PROPERTIES constraint=c\n     order by i"), new String[][]{{"1", "10"}, {"2", "20"}, {"2", "19"}, {"2", "21"}, {"3", "30"}, {"3", "31"}});
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_DUP_VIOLATION_T, this.getConnection());
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t"), initialContents);
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t --DERBY-PROPERTIES constraint=c\n     order by i"), initialContents);
                    ConstraintCharacteristicsTest.checkConsistencyOfBaseTableAndIndex(statement);
                    statement.execute("alter table t drop constraint c");
                    statement.executeUpdate("insert into t values (2,19),(2,21),(3,31)");
                    this.commit();
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "alter table t add constraint c " + uniqueSpec[n]);
                    statement.executeUpdate("alter table t add constraint c " + uniqueSpec[n] + " deferrable initially deferred");
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t --DERBY-PROPERTIES constraint=c\n     order by i"), new String[][]{{"1", "10"}, {"2", "20"}, {"2", "19"}, {"2", "21"}, {"3", "30"}, {"3", "31"}});
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_DUP_VIOLATION_T, this.getConnection());
                    ConstraintCharacteristicsTest.checkConsistencyOfBaseTableAndIndex(statement);
                }
                finally {
                    ++n;
                    this.dropTable("t");
                    this.commit();
                }
            }
            n = 0;
            for (String string2 : checkForms) {
                try {
                    statement.executeUpdate(string2 + " deferrable initially immediate)");
                    statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    this.commit();
                    ConstraintCharacteristicsTest.assertStatementError(LANG_CHECK_CONSTRAINT_VIOLATED, statement, "insert into t values (-2,30)");
                    try {
                        statement.execute("insert into t values (-2,30)");
                        ConstraintCharacteristicsTest.fail();
                    }
                    catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
                        ConstraintCharacteristicsTest.assertSQLState(LANG_CHECK_CONSTRAINT_VIOLATED, (SQLException)((Object)derbySQLIntegrityConstraintViolationException));
                        ConstraintCharacteristicsTest.assertEquals((String)"\"APP\".\"T\"", (String)derbySQLIntegrityConstraintViolationException.getTableName());
                        ConstraintCharacteristicsTest.assertEquals((String)"C", (String)derbySQLIntegrityConstraintViolationException.getConstraintName());
                    }
                    statement.executeUpdate(string + " deferred");
                    statement.executeUpdate("insert into t values (-2,30),(1,31),(-3,32)");
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t"), new String[][]{{"1", "10"}, {"2", "20"}, {"3", "30"}, {"-2", "30"}, {"1", "31"}, {"-3", "32"}});
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, statement, string + " immediate");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, statement, string + " immediate");
                    try {
                        statement.execute(string + " immediate");
                        ConstraintCharacteristicsTest.fail();
                    }
                    catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
                        ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_S, (SQLException)((Object)derbySQLIntegrityConstraintViolationException));
                        ConstraintCharacteristicsTest.assertEquals((String)"\"APP\".\"T\"", (String)derbySQLIntegrityConstraintViolationException.getTableName());
                        ConstraintCharacteristicsTest.assertEquals((String)"C", (String)derbySQLIntegrityConstraintViolationException.getConstraintName());
                    }
                    try {
                        this.getConnection().commit();
                        ConstraintCharacteristicsTest.fail();
                    }
                    catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
                        ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_T, (SQLException)((Object)derbySQLIntegrityConstraintViolationException));
                        ConstraintCharacteristicsTest.assertEquals((String)"\"APP\".\"T\"", (String)derbySQLIntegrityConstraintViolationException.getTableName());
                        ConstraintCharacteristicsTest.assertEquals((String)"C", (String)derbySQLIntegrityConstraintViolationException.getConstraintName());
                    }
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t"), initialContents);
                    statement.executeUpdate(string + " immediate");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_CHECK_CONSTRAINT_VIOLATED, statement, "insert into t values (-2,30)");
                    statement.executeUpdate(string + " deferred");
                    statement.executeUpdate("insert into t values (-2,19),(2,21),(-3,31)");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, statement, string + " immediate");
                    this.rollback();
                    statement.executeUpdate(string + " deferred");
                    statement.executeUpdate("insert into t values (20,19),(200,21),(30,31)");
                    statement.executeUpdate("update t set i=-2 where i=20");
                    statement.executeUpdate("update t set i=-3 where i=200");
                    statement.executeUpdate("update t set i=-4 where i=30");
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t order by j"), new String[][]{{"1", "10"}, {"-2", "19"}, {"2", "20"}, {"-3", "21"}, {"3", "30"}, {"-4", "31"}});
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t"), initialContents);
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t order by i"), initialContents);
                    ConstraintCharacteristicsTest.checkConsistencyOfBaseTableAndIndex(statement);
                    statement.execute("alter table t drop constraint c");
                    statement.executeUpdate("insert into t values (-2,19),(2,21),(-3,31)");
                    this.commit();
                    ConstraintCharacteristicsTest.assertStatementError(LANG_ADD_CHECK_CONSTRAINT_FAILED, statement, "alter table t add constraint c " + checkSpec[n]);
                    statement.executeUpdate("alter table t add constraint c " + checkSpec[n] + " deferrable initially deferred");
                    JDBC.assertFullResultSet(statement.executeQuery("select * from t order by i,j"), new String[][]{{"-3", "31"}, {"-2", "19"}, {"1", "10"}, {"2", "20"}, {"2", "21"}, {"3", "30"}});
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
                    ConstraintCharacteristicsTest.checkConsistencyOfBaseTableAndIndex(statement);
                }
                finally {
                    ++n;
                    this.dropTable("t");
                    this.commit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRoutines() throws SQLException {
        Statement statement = this.createStatement();
        for (String string : uniqueForms) {
            try {
                statement.executeUpdate(string + " deferrable initially immediate)");
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.commit();
                this.declareCalledNested(statement);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, statement, "call calledNested(false)");
            }
            finally {
                this.dropTable("t");
            }
        }
        for (String string : setConstraintsForms) {
            for (String string2 : uniqueForms) {
                try {
                    statement.executeUpdate(string2 + " deferrable initially deferred)");
                    statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    this.commit();
                    statement.executeUpdate(string + " immediate");
                    this.declareCalledNested(statement);
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, statement, "call calledNested(false)");
                }
                finally {
                    this.dropTable("t");
                    this.commit();
                }
            }
        }
        for (String string : uniqueForms) {
            try {
                statement.executeUpdate(string + " deferrable initially deferred)");
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.declareCalledNested(statement);
                statement.executeUpdate("call calledNested(false)");
            }
            finally {
                this.rollback();
            }
        }
        for (String string : checkForms) {
            try {
                statement.executeUpdate(string + " deferrable initially immediate)");
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.commit();
                this.declareCalledNested(statement);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_T, statement, "call calledNested(true)");
            }
            finally {
                this.dropTable("t");
                this.commit();
            }
        }
        for (String string : setConstraintsForms) {
            for (String string2 : checkForms) {
                try {
                    statement.executeUpdate(string2 + " deferrable initially deferred)");
                    statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    this.commit();
                    statement.executeUpdate(string + " immediate");
                    this.declareCalledNested(statement);
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_T, statement, "call calledNested(true)");
                }
                finally {
                    this.dropTable("t");
                    this.commit();
                }
            }
        }
        for (String string : checkForms) {
            try {
                statement.executeUpdate(string + " deferrable initially deferred)");
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(negatedInitialContents));
                this.declareCalledNested(statement);
                statement.executeUpdate("call calledNested(true)");
            }
            finally {
                this.rollback();
            }
        }
        for (String string : checkForms) {
            try {
                statement.executeUpdate(string + " deferrable initially deferred)");
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(negatedInitialContents));
                this.declareCalledNestedSetImmediate(statement);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, statement, "call calledNestedSetImmediate()");
            }
            finally {
                this.rollback();
            }
        }
        for (String string : fkForms) {
            try {
                statement.executeUpdate(string + " deferrable initially immediate)");
                statement.executeUpdate("insert into referenced values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.commit();
                this.declareCalledNestedFk(statement);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_T, statement, "call calledNestedFk()");
            }
            finally {
                this.dropTable("t");
                this.dontThrow(statement, "delete from referenced");
                this.commit();
            }
        }
        for (String string : setConstraintsForms) {
            for (String string2 : fkForms) {
                try {
                    statement.executeUpdate(string2 + " deferrable initially deferred)");
                    statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    statement.executeUpdate("insert into referenced(i) select i from t");
                    this.commit();
                    statement.executeUpdate(string + " immediate");
                    this.declareCalledNestedFk(statement);
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_T, statement, "call calledNestedFk()");
                }
                finally {
                    this.dropTable("t");
                    this.dontThrow(statement, "delete from referenced");
                    this.commit();
                }
            }
        }
        for (String string : fkForms) {
            try {
                statement.executeUpdate(string + " deferrable initially deferred)");
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.declareCalledNestedFk(statement);
                statement.executeUpdate("call calledNestedFk()");
                ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_FK_VIOLATION_T, this.getConnection());
            }
            finally {
                this.rollback();
            }
        }
        for (String string : fkForms) {
            try {
                statement.executeUpdate(string + " deferrable initially deferred)");
                statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.declareCalledNestedSetImmediate(statement);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, statement, "call calledNestedSetImmediate()");
            }
            finally {
                this.rollback();
            }
        }
    }

    public void testDeferredRowsInvalidation() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        statement.executeUpdate("insert into t values 1,2,2,3");
        statement.executeUpdate("alter table t drop constraint c");
        this.commit();
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        statement.executeUpdate("insert into t values 1,2,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        statement.executeUpdate("insert into t values 1,2,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("truncate table t");
        statement.executeUpdate("set constraints c immediate");
        statement.executeUpdate("set constraints c deferred");
        statement.executeUpdate("insert into t values 1,2,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        statement.executeUpdate("insert into t values 1,2,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("delete from t where i=1");
        statement.executeUpdate("call syscs_util.syscs_compress_table('APP', 'T', 0)");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, statement, "set constraints c immediate");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_DUP_VIOLATION_T, this.getConnection());
        statement.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        this.commit();
        statement.executeUpdate("insert into t values 1,2,3");
        statement.executeUpdate("delete from t where i=1");
        ConstraintCharacteristicsTest.assertStatementError(LOCK_TIMEOUT, statement, "call syscs_util.syscs_inplace_compress_table('APP', 'T', 1, 1, 1)");
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        statement.executeUpdate("insert into t values -1,-2, -2, -3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("alter table t drop constraint c");
        this.commit();
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        statement.executeUpdate("insert into t values -1, -2, -2, -3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        statement.executeUpdate("insert into t values -1, -2, -2, -3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("truncate table t");
        this.commit();
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        statement.executeUpdate("insert into t values -1, -2, -2, -3");
        statement.executeUpdate("delete from t where i=-2");
        statement.executeUpdate("call syscs_util.syscs_compress_table('APP', 'T', 0)");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
        statement.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        this.commit();
        statement.executeUpdate("insert into t values -1, -2, -2, -3");
        statement.executeUpdate("delete from t where i=-2");
        statement.executeUpdate("call syscs_util.syscs_inplace_compress_table('APP', 'T', 1, 1, 1)");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) initially deferred)");
        statement.executeUpdate("insert into t values 1,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("alter table t drop constraint c");
        this.commit();
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) initially deferred)");
        statement.executeUpdate("insert into t values 1,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("truncate table t");
        this.commit();
        statement.executeUpdate("insert into t values 1,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("drop table t");
        this.commit();
        statement.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) initially deferred)");
        statement.executeUpdate("insert into referenced(i) values 4,5,6");
        statement.executeUpdate("insert into t values 4,5,6,7");
        statement.executeUpdate("delete from t where i=5");
        statement.executeUpdate("call syscs_util.syscs_compress_table('APP', 'T', 0)");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_FK_VIOLATION_T, this.getConnection());
        statement.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) initially deferred)");
        statement.executeUpdate("insert into referenced(i) values 4,5,6");
        statement.executeUpdate("insert into t values 4,5,6,7");
        statement.executeUpdate("delete from t where i=5");
        ConstraintCharacteristicsTest.assertStatementError(LOCK_TIMEOUT, statement, "call syscs_util.syscs_inplace_compress_table('APP', 'T', 1,1,1)");
        statement.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) ON DELETE NO ACTION initially deferred)");
        statement.executeUpdate("insert into referenced(i) values 4,5,6");
        statement.executeUpdate("insert into t values 4,5,6");
        statement.executeUpdate("delete from referenced where i=5");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, statement, "set constraints c immediate");
        statement.executeUpdate("call syscs_util.syscs_compress_table('APP', 'T', 0)");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_FK_VIOLATION_T, this.getConnection());
        statement.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) ON DELETE NO ACTION initially deferred)");
        statement.executeUpdate("insert into referenced(i) values 4,5,6");
        statement.executeUpdate("insert into t values 4,5,6");
        statement.executeUpdate("delete from referenced where i=5");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, statement, "set constraints c immediate");
        ConstraintCharacteristicsTest.assertStatementError(LOCK_TIMEOUT, statement, "call syscs_util.syscs_inplace_compress_table('APP', 'T', 1, 1, 1)");
    }

    public void testImport() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t(i int)");
        try {
            for (int i = 0; i < 2; ++i) {
                statement.executeUpdate("alter table t alter column i not null");
                statement.executeUpdate("alter table t add constraint c primary key(i)     deferrable initially immediate");
                this.commit();
                statement.executeUpdate("set constraints c deferred");
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, statement, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + i + ")");
                statement.executeUpdate("alter table t alter column i not null");
                statement.executeUpdate("alter table t drop constraint c");
                statement.executeUpdate("alter table t add constraint c unique(i)     deferrable initially immediate");
                this.commit();
                statement.executeUpdate("set constraints c deferred");
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, statement, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + i + ")");
                statement.executeUpdate("alter table t alter column i null");
                statement.executeUpdate("alter table t drop constraint c");
                statement.executeUpdate("alter table t add constraint c unique(i) initially deferred");
                this.commit();
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, statement, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + i + ")");
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataWithNullsFile + "',    null, null , null, " + i + ")");
                statement.executeUpdate("alter table t drop constraint c");
                statement.executeUpdate("truncate table t");
                this.commit();
                statement.executeUpdate("alter table t add constraint c check (i > 0) initially deferred");
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_T, statement, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + i + ")");
                statement.executeUpdate("truncate table t");
                this.commit();
            }
        }
        finally {
            this.dropTable("t");
            this.commit();
        }
    }

    public void testDropNotNullOnUniqueColumn() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table constraintest (val1 varchar (20) not null, val2 varchar (20))");
        statement.executeUpdate("alter table constraintest add constraint u_con unique (val1) deferrable initially immediate");
        statement.executeUpdate("alter table constraintest alter column val1 null");
        statement.executeUpdate("insert into constraintest(val1) values 'name1'");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "insert into constraintest(val1) values 'name1'");
        PreparedStatement preparedStatement = this.prepareStatement("insert into constraintest(val1) values (?)");
        preparedStatement.setString(1, null);
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, null);
        preparedStatement.executeUpdate();
    }

    public void testDerby6374() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t(i int)");
        try {
            for (int i = 0; i < 2; ++i) {
                statement.executeUpdate("alter table t add constraint c unique(i)");
                this.commit();
                ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + i + ")");
                statement.executeUpdate("alter table t drop constraint c");
            }
        }
        finally {
            this.dropTable("t");
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXA() throws SQLException, XAException {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xADataSource, "databaseName", "wombat");
        String[] stringArray = new String[]{LANG_DEFERRED_DUP_VIOLATION_T, LANG_DEFERRED_CHECK_VIOLATION_T};
        for (int i = 0; i <= 1; ++i) {
            XAConnection xAConnection = xADataSource.getXAConnection();
            try {
                Throwable throwable;
                XAResource xAResource = xAConnection.getXAResource();
                Connection connection = xAConnection.getConnection();
                connection.setAutoCommit(false);
                Statement statement = connection.createStatement();
                Xid xid = i == 0 ? this.doXAWorkUniquePK(statement, xAResource) : this.doXAWorkCheck(statement, xAResource);
                xAResource.rollback(xid);
                this.assertXidRolledBack(xAResource, xid);
                xid = i == 0 ? this.doXAWorkUniquePK(statement, xAResource) : this.doXAWorkCheck(statement, xAResource);
                try {
                    xAResource.prepare(xid);
                    ConstraintCharacteristicsTest.fail((String)"Expected XA prepare to fail due to constraint violation");
                }
                catch (XAException xAException) {
                    ConstraintCharacteristicsTest.assertEquals((int)103, (int)xAException.errorCode);
                    if (!ConstraintCharacteristicsTest.usingDerbyNetClient()) {
                        throwable = xAException.getCause();
                        ConstraintCharacteristicsTest.assertTrue((throwable != null && throwable instanceof SQLException ? 1 : 0) != 0);
                        ConstraintCharacteristicsTest.assertSQLState(stringArray[i], (SQLException)throwable);
                    }
                    this.assertXidRolledBack(xAResource, xid);
                }
                xid = i == 0 ? this.doXAWorkUniquePK(statement, xAResource) : this.doXAWorkCheck(statement, xAResource);
                try {
                    xAResource.commit(xid, true);
                    ConstraintCharacteristicsTest.fail((String)"Expected XA commit to fail due to constraint violation");
                }
                catch (XAException xAException) {
                    if (xAException.errorCode == -3) {
                        System.err.println("huff");
                    } else {
                        ConstraintCharacteristicsTest.assertEquals((int)103, (int)xAException.errorCode);
                        if (!ConstraintCharacteristicsTest.usingDerbyNetClient()) {
                            throwable = xAException.getCause();
                            ConstraintCharacteristicsTest.assertTrue((throwable != null && throwable instanceof SQLException ? 1 : 0) != 0);
                            ConstraintCharacteristicsTest.assertSQLState(stringArray[i], (SQLException)throwable);
                        }
                    }
                    this.assertXidRolledBack(xAResource, xid);
                }
                continue;
            }
            finally {
                if (ConstraintCharacteristicsTest.usingDerbyNetClient()) {
                    xAConnection.getConnection().rollback();
                }
                xAConnection.close();
            }
        }
    }

    public void testCompressTableOKUnique() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table table1(name1 int unique deferrable initially immediate, name2 int unique not null, name3 int primary key)");
        try {
            statement.execute("call syscs_util.syscs_compress_table('APP','TABLE1',1)");
            statement.executeUpdate("insert into table1 values(1,11,111)");
            ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "insert into table1 values(1,22,222)");
            ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "insert into table1 values(3,11,333)");
            ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, statement, "insert into table1 values(4,44,111)");
            try {
                statement.execute("insert into table1 values(1,22,222)");
                ConstraintCharacteristicsTest.fail();
            }
            catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
                ConstraintCharacteristicsTest.assertSQLState(LANG_DUPLICATE_KEY_CONSTRAINT, (SQLException)((Object)derbySQLIntegrityConstraintViolationException));
                ConstraintCharacteristicsTest.assertEquals((String)"TABLE1", (String)derbySQLIntegrityConstraintViolationException.getTableName());
                ConstraintCharacteristicsTest.assertTrue((boolean)derbySQLIntegrityConstraintViolationException.getConstraintName().startsWith("SQL"));
            }
        }
        finally {
            statement.executeUpdate("drop table table1");
        }
    }

    public void testManySimilarDuplicates() throws SQLException {
        if (ConstraintCharacteristicsTest.usingDerbyNetClient()) {
            return;
        }
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("create table t (i varchar(256),     constraint c primary key(i) initially deferred)");
            PreparedStatement preparedStatement = connection.prepareStatement("insert into t values ?");
            char[] cArray = new char[256];
            Arrays.fill(cArray, 'a');
            preparedStatement.setString(1, String.valueOf(cArray));
            for (long i = 0L; i < 4096L; ++i) {
                preparedStatement.executeUpdate();
            }
            connection.commit();
            ConstraintCharacteristicsTest.fail();
        }
        catch (SQLException sQLException) {
            ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_DUP_VIOLATION_T, sQLException);
            statement.executeUpdate("call syscs_util.syscs_checkpoint_database()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlmostRemovedAllDups() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t(i int, j int,     constraint c primary key (i) initially deferred)");
        try {
            int n;
            PreparedStatement preparedStatement = this.prepareStatement("insert into t values (?,?)");
            for (n = 0; n < 10; ++n) {
                preparedStatement.setInt(1, 1);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
            }
            statement.executeUpdate("delete from t where j > 0");
            this.commit();
            statement.executeUpdate("truncate table t");
            for (n = 0; n < 10; ++n) {
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
                preparedStatement.setInt(1, n);
                preparedStatement.setInt(2, n);
                preparedStatement.executeUpdate();
            }
            statement.execute("delete from t where i < 9");
            JDBC.assertFullResultSet(statement.executeQuery("select * from t"), new String[][]{{"9", "9"}, {"9", "9"}});
            this.commit();
        }
        catch (SQLException sQLException) {
            ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_DUP_VIOLATION_T, sQLException);
        }
        finally {
            this.dropTable("t");
            this.commit();
        }
    }

    private static void setupTab1(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        statement.execute("create table tab1 (i integer)");
        statement.executeUpdate("alter table tab1 add constraint con1 unique (i) deferrable");
        PreparedStatement preparedStatement = connection.prepareStatement("insert into tab1 values (?)");
        for (int i = 0; i < 10; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
        statement.close();
        connection.commit();
    }

    private static void dropTab1(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute("drop table tab1");
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testLockingForUniquePKWithCommit() throws Exception {
        ConstraintCharacteristicsTest.setupTab1(this.getConnection());
        try {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    ConstraintCharacteristicsTest.executeThreads(this, (int)Math.pow(2.0, i), (int)Math.pow(2.0, j), true);
                }
            }
        }
        finally {
            ConstraintCharacteristicsTest.dropTab1(this.getConnection());
        }
    }

    public void testLockingForUniquePKWithRollback() throws Exception {
        ConstraintCharacteristicsTest.setupTab1(this.getConnection());
        try {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    ConstraintCharacteristicsTest.executeThreads(this, (int)Math.pow(2.0, i), (int)Math.pow(2.0, j), false);
                }
            }
        }
        finally {
            ConstraintCharacteristicsTest.dropTab1(this.getConnection());
        }
    }

    public void testCheckConstraintsWithDeferredRows() throws SQLException {
        Statement statement = this.createStatement();
        try {
            statement.executeUpdate("create table tab1 (c1 int, constraint c check (c1 > 0) deferrable initially deferred)");
            this.commit();
            statement.executeUpdate("insert into tab1 values (4)");
            statement.executeUpdate("insert into tab1 values (3)");
            statement.executeUpdate("insert into tab1 select c1-3 from tab1");
            ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
            statement.executeUpdate("insert into tab1 values (2)");
            statement.executeUpdate("update tab1 as grr set c1=-1 where c1 = 2 and ((select max(c1) from tab1 where grr.c1 > 0) > 0)");
            ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
            statement.executeUpdate("insert into tab1 values (2)");
            statement.executeUpdate("create table trigtab(i int)");
            statement.executeUpdate("create trigger mytrigger after update on tab1 insert into trigtab values 1");
            statement.executeUpdate("update tab1 as grr set c1=-1 where c1 = 2 and ((select max(c1) from tab1 where grr.c1 > 0) > 0)");
            ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
        }
        finally {
            this.dropTable("tab1");
            this.dropTable("trigtab");
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralCheckConstraints() throws SQLException {
        Statement statement = this.createStatement();
        try {
            int n;
            statement.executeUpdate("create table t(i int, constraint ci check (i > 0) deferrable initially deferred, j int, constraint cj check (j > 0) deferrable initially deferred, k int, constraint ck check (k > 0) deferrable initially deferred)");
            this.commit();
            String[] stringArray = new String[]{"j = -j, k = -k", "i = -i, k = -k", "i = -i, j = -j"};
            String[] stringArray2 = new String[]{"ci", "cj", "ck"};
            for (n = 0; n < 3; ++n) {
                statement.executeUpdate("insert into t values (-1, -2, -3)");
                statement.executeUpdate("update t set " + stringArray[n]);
                try {
                    statement.executeUpdate("set constraints " + stringArray2[n] + " immediate");
                    ConstraintCharacteristicsTest.fail((String)("expected violation: " + n));
                }
                catch (SQLException sQLException) {
                    ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_S, sQLException);
                    ConstraintCharacteristicsTest.assertTrue((boolean)sQLException.getMessage().contains(stringArray2[n].toUpperCase()));
                }
                this.rollback();
            }
            statement.executeUpdate("insert into t values (-1,  2,  3)");
            statement.executeUpdate("insert into t values ( 1, -2,  3)");
            statement.executeUpdate("insert into t values ( 1,  2, -3)");
            for (n = 0; n < 3; ++n) {
                try {
                    statement.executeUpdate("set constraints " + stringArray2[n] + " immediate");
                    ConstraintCharacteristicsTest.fail((String)("expected violation: " + n));
                    continue;
                }
                catch (SQLException sQLException) {
                    ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_S, sQLException);
                    ConstraintCharacteristicsTest.assertTrue((boolean)sQLException.getMessage().contains(stringArray2[n].toUpperCase()));
                }
            }
            this.rollback();
            statement.executeUpdate("insert into t values (-1,  2,  3)");
            statement.executeUpdate("update t set i=-1");
            statement.executeUpdate("update t set i=-1");
            ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
        }
        finally {
            this.dropTable("t");
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeThreads(ConstraintCharacteristicsTest constraintCharacteristicsTest, int n, int n2, boolean bl) throws Exception {
        Connection connection = constraintCharacteristicsTest.openDefaultConnection();
        connection.setTransactionIsolation(n);
        Connection connection2 = constraintCharacteristicsTest.openDefaultConnection();
        try {
            connection2.setTransactionIsolation(n2);
            DBOperations dBOperations = new DBOperations(connection, 5);
            DBOperations dBOperations2 = new DBOperations(connection2, 5);
            dBOperations.delete();
            Thread thread = new Thread(dBOperations2);
            thread.start();
            Thread.sleep(500L);
            if (bl) {
                dBOperations.rollback();
                thread.join();
                ConstraintCharacteristicsTest.assertSQLState("isolation levels: " + n + " " + n2, LANG_DUPLICATE_KEY_CONSTRAINT, dBOperations2.getException());
            } else {
                dBOperations.commit();
                thread.join();
                ConstraintCharacteristicsTest.assertNull((String)("isolation levels: " + n + " " + n2 + ": exception " + dBOperations2.getException()), (Object)dBOperations2.getException());
            }
            ConstraintCharacteristicsTest.assertNull((String)("unexpected failure: " + n + " " + n2 + ": exception " + dBOperations2.getUnexpectedException()), (Object)dBOperations2.getUnexpectedException());
        }
        finally {
            connection.commit();
            connection2.commit();
            connection.close();
            connection2.close();
        }
    }

    private Xid doXAWorkUniquePK(Statement statement, XAResource xAResource) throws SQLException, XAException {
        Xid xid = XATestUtil.getXid(1, 5, 32);
        xAResource.start(xid, 0);
        statement.executeUpdate("create table derby532xa(i int,     constraint derby532xa_c primary key(i) initially deferred)");
        statement.executeUpdate("insert into derby532xa values 1,1,2");
        xAResource.end(xid, 0x4000000);
        return xid;
    }

    private Xid doXAWorkCheck(Statement statement, XAResource xAResource) throws SQLException, XAException {
        Xid xid = XATestUtil.getXid(1, 5, 32);
        xAResource.start(xid, 0);
        statement.executeUpdate("create table derby532xa(i int,     constraint derby532xa_c check(i > 0) initially deferred)");
        statement.executeUpdate("insert into derby532xa values -1, 1,-2");
        xAResource.end(xid, 0x4000000);
        return xid;
    }

    private void assertXidRolledBack(XAResource xAResource, Xid xid) {
        try {
            xAResource.rollback(xid);
            ConstraintCharacteristicsTest.fail((String)"expected the transaction to be unknown");
        }
        catch (XAException xAException) {
            ConstraintCharacteristicsTest.assertEquals((int)xAException.errorCode, (int)-4);
        }
    }

    private static String rs2Values(String[][] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String[] stringArray2 : stringArray) {
            stringBuilder.append('(');
            for (String string : stringArray2) {
                stringBuilder.append(string);
                stringBuilder.append(',');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append("),");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    private static void checkConsistencyOfBaseTableAndIndex(Statement statement) throws SQLException {
        JDBC.assertFullResultSet(statement.executeQuery("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T')"), new String[][]{{"1"}});
    }

    private static void assertTableLevelNonDefaultAccepted(Statement statement) throws SQLException {
        for (String string : tableConstraintTypes) {
            for (String[] stringArray : nonDefaultCharacteristics) {
                if (stringArray[0].contains("not enforced")) {
                    ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, statement, "create table t(i int, constraint c " + string + stringArray[0] + ")");
                    continue;
                }
                statement.executeUpdate("create table t(i int, constraint c " + string + stringArray[0] + ")");
                statement.executeUpdate("drop table t");
            }
        }
    }

    private static void assertColumnLevelNonDefaultAccepted(Statement statement) throws SQLException {
        for (String string : columnConstraintTypes) {
            for (String[] stringArray : nonDefaultCharacteristics) {
                if (stringArray[0].contains("not enforced")) {
                    ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, statement, "create table t(i int " + string + stringArray[0] + ")");
                    continue;
                }
                statement.executeUpdate("create table t(i int " + string + stringArray[0] + ")");
                statement.executeUpdate("drop table t");
            }
        }
    }

    private static void assertTableLevelDefaultBehaviorAccepted(Connection connection, Statement statement) throws SQLException {
        for (String string : tableConstraintTypes) {
            for (String[] stringArray : defaultCharacteristics) {
                ConstraintCharacteristicsTest.assertUpdateCount(statement, 0, "create table t(i int, constraint c " + string + stringArray[0] + ")");
                connection.rollback();
            }
        }
    }

    private static void assertColumnLevelDefaultBehaviorAccepted(Connection connection, Statement statement) throws SQLException {
        for (String string : columnConstraintTypes) {
            for (String[] stringArray : defaultCharacteristics) {
                ConstraintCharacteristicsTest.assertUpdateCount(statement, 0, "create table t(i int " + string + stringArray[0] + ")");
                connection.rollback();
            }
        }
    }

    private void assertDictState(Statement statement, String string, String string2) throws SQLException {
        for (String string3 : tableConstraintTypes) {
            try {
                statement.executeUpdate("create table t(i int, constraint c " + string3 + " " + string + ")");
                if (string.contains("not enforced")) {
                    ConstraintCharacteristicsTest.fail();
                    continue;
                }
                JDBC.assertFullResultSet(statement.executeQuery("select state from sys.sysconstraints     where constraintname = 'C'"), new String[][]{{string2}});
                this.rollback();
            }
            catch (SQLException sQLException) {
                if (string.contains("not enforced")) {
                    ConstraintCharacteristicsTest.assertSQLState(NOT_IMPLEMENTED, sQLException);
                    continue;
                }
                throw sQLException;
            }
        }
    }

    private void assertAlterDictState(Statement statement, String string) throws SQLException {
        String string2 = this.getOldState(statement);
        String string3 = this.computeNewState(string2, string);
        if (!string.contains("not enforced")) {
            statement.executeUpdate("alter table t alter constraint c " + string);
            JDBC.assertFullResultSet(statement.executeQuery("select state from sys.sysconstraints     where constraintname = 'C'"), new String[][]{{string3}});
        } else {
            ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, statement, "alter table t alter constraint c " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOldState(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery("select state from sys.sysconstraints     where constraintname = 'C'");){
            resultSet.next();
            String string = resultSet.getString(1);
            return string;
        }
    }

    private String computeNewState(String string, String string2) {
        return inverseState.get(string)[string2.equals("enforced") ? 0 : 1];
    }

    private void assertCreateInconsistentCharacteristics(Statement statement, String string) throws SQLException {
        for (String string2 : tableConstraintTypes) {
            try {
                statement.executeUpdate("create table t(i int, constraint c " + string2 + " " + string + ")");
                ConstraintCharacteristicsTest.fail((String)"wrong characteristics unexpectedly passed muster");
                this.rollback();
            }
            catch (SQLException sQLException) {
                ConstraintCharacteristicsTest.assertSQLState(LANG_INCONSISTENT_C_CHARACTERISTICS, sQLException);
            }
        }
    }

    private void assertAlterInconsistentCharacteristics(Statement statement, String string) throws SQLException {
        try {
            statement.executeUpdate("alter table t alter constraint c " + string);
            ConstraintCharacteristicsTest.fail((String)"wrong characteristics unexpectedly passed muster");
            this.rollback();
        }
        catch (SQLException sQLException) {
            ConstraintCharacteristicsTest.assertSQLState(LANG_SYNTAX_ERROR, sQLException);
        }
    }

    private void declareCalledNested(Statement statement) throws SQLException {
        statement.executeUpdate("create procedure calledNested(isCheckConstraint boolean)  language java parameter style java  external name '" + ((Object)((Object)this)).getClass().getName() + ".calledNested' modifies sql data");
    }

    private void declareCalledNestedFk(Statement statement) throws SQLException {
        statement.executeUpdate("create procedure calledNestedFk()  language java parameter style java  external name '" + ((Object)((Object)this)).getClass().getName() + ".calledNestedFk' modifies sql data");
    }

    private void declareCalledNestedSetImmediate(Statement statement) throws SQLException {
        statement.executeUpdate("create procedure calledNestedSetImmediate()  language java parameter style java  external name '" + ((Object)((Object)this)).getClass().getName() + ".calledNestedSetImmediate' modifies sql data");
    }

    public static void calledNested(boolean bl) throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.executeUpdate("set constraints c deferred");
        statement.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(bl ? negatedInitialContents : initialContents));
        connection.close();
    }

    public static void calledNestedFk() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        statement.executeUpdate("set constraints c deferred");
        statement.executeUpdate("insert into t select i*2, j*2 from t");
        connection.close();
    }

    public static void calledNestedSetImmediate() throws SQLException {
        Connection connection = DriverManager.getConnection("jdbc:default:connection");
        Statement statement = connection.createStatement();
        try {
            statement.executeUpdate("set constraints c immediate");
        }
        finally {
            connection.close();
        }
    }

    private void dontThrow(Statement statement, String string) {
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            ConstraintCharacteristicsTest.println("\"" + string + "\"failed: " + sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby6670_a() throws SQLException {
        String[] stringArray;
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        for (String string : stringArray = new String[]{"pk", "fk", "check"}) {
            String string2 = null;
            try {
                if (string.equals("pk")) {
                    statement.execute("create table derby6670_1(x int primary key     initially deferred)");
                    statement.execute("insert into derby6670_1 values 1,1,1,1");
                    string2 = LANG_DEFERRED_DUP_VIOLATION_T;
                } else if (string.equals("fk")) {
                    statement.execute("create table derby6670_11(x int primary key)");
                    statement.execute("create table derby6670_1(x int   references derby6670_11 initially deferred)");
                    statement.execute("insert into derby6670_1 values 1");
                    string2 = LANG_DEFERRED_FK_VIOLATION_T;
                } else if (string.equals("check")) {
                    statement.execute("create table derby6670_1(x int check (x < 0)     initially deferred)");
                    statement.execute("insert into derby6670_1 values 1");
                    string2 = LANG_DEFERRED_CHECK_VIOLATION_T;
                }
                Savepoint savepoint = connection.setSavepoint();
                statement.execute("drop table derby6670_1");
                connection.rollback(savepoint);
                try {
                    this.commit();
                    ConstraintCharacteristicsTest.fail();
                }
                catch (SQLException sQLException) {
                    ConstraintCharacteristicsTest.assertSQLState(string2, sQLException);
                }
                savepoint = connection.setSavepoint();
                if (string.equals("pk")) {
                    statement.execute("create table derby6670_2(x int primary key     initially deferred)");
                    statement.execute("insert into derby6670_2 values 1,1,1,1");
                } else if (string.equals("fk")) {
                    statement.execute("create table derby6670_22(x int primary key)");
                    statement.execute("create table derby6670_2(x int   references derby6670_22 initially deferred)");
                    statement.execute("insert into derby6670_2 values 1");
                } else if (string.equals("check")) {
                    statement.execute("create table derby6670_2(x int)");
                    statement.execute("alter table derby6670_2 add constraint c   check(x > 0) deferrable initially deferred");
                    statement.execute("insert into derby6670_2 values -1");
                }
                connection.rollback(savepoint);
                this.commit();
                statement.execute("create table derby6670_3(x int not null)");
                this.commit();
                savepoint = connection.setSavepoint();
                if (string.equals("pk")) {
                    statement.execute("alter table derby6670_3 add constraint c   primary key(x) deferrable   initially deferred");
                    statement.execute("insert into derby6670_3 values 1,1");
                } else if (string.equals("fk")) {
                    statement.execute("create table derby6670_33(x int primary key)");
                    statement.execute("alter table derby6670_3 add constraint c    foreign key(x) references derby6670_33    deferrable initially deferred");
                    statement.execute("insert into derby6670_3 values -1");
                } else if (string.equals("check")) {
                    statement.execute("alter table derby6670_3 add constraint c    check(x > 0) deferrable initially deferred");
                    statement.execute("insert into derby6670_3 values -1");
                }
                connection.rollback(savepoint);
                this.commit();
                statement.execute("create table derby6670_4(x int not null)");
                connection.commit();
                if (string.equals("pk")) {
                    statement.execute("alter table derby6670_4 add constraint c   primary key(x) deferrable   initially deferred");
                    statement.execute("insert into derby6670_4 values 1,1");
                } else if (string.equals("fk")) {
                    statement.execute("create table derby6670_44(x int primary key)");
                    statement.execute("alter table derby6670_4 add constraint c    foreign key(x) references derby6670_44    deferrable initially deferred");
                    statement.execute("insert into derby6670_4 values -1");
                } else if (string.equals("check")) {
                    statement.execute("alter table derby6670_4 add constraint c    check(x > 0) deferrable initially deferred");
                    statement.execute("insert into derby6670_4 values -1");
                }
                savepoint = connection.setSavepoint();
                statement.execute("alter table derby6670_4 drop constraint c");
                connection.rollback(savepoint);
                try {
                    connection.commit();
                    ConstraintCharacteristicsTest.fail();
                }
                catch (SQLException sQLException) {
                    ConstraintCharacteristicsTest.assertSQLState(string2, sQLException);
                }
            }
            finally {
                for (int i = 1; i <= 4; ++i) {
                    this.dropTable("derby6670_" + i);
                }
                connection.commit();
            }
        }
    }

    public void testDerby6670_b() throws SQLException {
        String[] stringArray;
        Connection connection = this.getConnection();
        Statement statement = this.createStatement();
        for (String string : stringArray = new String[]{"c", "all"}) {
            statement.execute("create table t1(x int primary key,     constraint c check(x > 0) initially deferred)");
            statement.execute("insert into t1 values -1");
            Savepoint savepoint = connection.setSavepoint();
            statement.execute("delete from t1");
            statement.execute("set constraints " + string + " immediate");
            connection.rollback(savepoint);
            try {
                connection.commit();
                ConstraintCharacteristicsTest.fail();
            }
            catch (SQLException sQLException) {
                ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_T, sQLException);
            }
        }
    }

    public void testDerby6666() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table t1(x int primary key)");
        statement.executeUpdate("create table t2(y int, constraint c check(y > 0)    initially deferred, constraint fk    foreign key(y) references t1 initially deferred)");
        this.setAutoCommit(false);
        statement.executeUpdate("insert into t1 values -1, 1");
        statement.executeUpdate("insert into t2 values 1");
        statement.executeUpdate("update t2 set y = -1");
        try {
            this.commit();
            ConstraintCharacteristicsTest.fail();
        }
        catch (SQLException sQLException) {
            ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_T, sQLException);
        }
    }

    public void testDerby6773() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("create table Application    (id bigint generated by default as identity,    name varchar(255),    shortName varchar(32),    userId varchar(32),    primary key (id))");
        statement.executeUpdate("create unique index UK_APPLICATION_SHORTNAME     on Application (shortName)");
        statement.executeUpdate("create unique index UK_APPLICATION_NAME     on Application (name)");
        statement.executeUpdate("insert into Application (name, shortName, userId)     VALUES ('fooApp', 'Foo Application 0', 'me')");
        try {
            statement.executeUpdate("insert into Application (name, shortName, userId)     VALUES ('fooApp', 'Foo Application 1', 'me')");
            ConstraintCharacteristicsTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
            ConstraintCharacteristicsTest.assertEquals((String)"APPLICATION", (String)derbySQLIntegrityConstraintViolationException.getTableName());
            ConstraintCharacteristicsTest.assertEquals((String)"UK_APPLICATION_NAME", (String)derbySQLIntegrityConstraintViolationException.getConstraintName());
        }
        try {
            statement.executeUpdate("insert into Application (name, shortName, userId)     VALUES ('BarApp', 'Foo Application 0', 'me')");
            ConstraintCharacteristicsTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException derbySQLIntegrityConstraintViolationException) {
            ConstraintCharacteristicsTest.assertEquals((String)"APPLICATION", (String)derbySQLIntegrityConstraintViolationException.getTableName());
            ConstraintCharacteristicsTest.assertEquals((String)"UK_APPLICATION_SHORTNAME", (String)derbySQLIntegrityConstraintViolationException.getConstraintName());
        }
    }

    public static LanguageConnectionContext getLCC(final Connection connection) {
        return AccessController.doPrivileged(new PrivilegedAction<LanguageConnectionContext>(){

            @Override
            public LanguageConnectionContext run() {
                ContextManager contextManager = ((EmbedConnection)connection).getContextManager();
                return (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
            }
        });
    }

    static {
        exportFilesCreatedEmbedded = false;
        exportFilesCreatedClient = false;
        uniqueForms = new String[]{"create table t(i int, j int, constraint c primary key(i)", "create table t(i int, j int, constraint c unique(i)", "create table t(i int not null, j int, constraint c unique(i)"};
        uniqueSpec = new String[]{"primary key(i)", "unique(i)", "unique(i)"};
        checkForms = new String[]{"create table t(i int, j int, constraint c check (i > 0)"};
        fkForms = new String[]{"create table t(i int, j int,     constraint c foreign key(i) references referenced(i)"};
        checkSpec = new String[]{"check (i > 0)"};
        initialContents = new String[][]{{"1", "10"}, {"2", "20"}, {"3", "30"}};
        negatedInitialContents = new String[][]{{"-1", "10"}, {"-2", "20"}, {"-3", "30"}};
        setConstraintsForms = new String[]{"set constraints all", "set constraints c"};
        tableConstraintTypes = new String[]{" foreign key (i) references referenced(i)", " primary key(i)", " unique(i)", " check(i<3)"};
        columnConstraintTypes = new String[]{" references referenced(i)", " primary key", " unique", " check(i<3)"};
        defaultCharacteristics = new String[][]{{" not deferrable initially immediate enforced", "E"}, {" not deferrable initially immediate", "E"}, {" not deferrable enforced", "E"}, {" not deferrable", "E"}, {" initially immediate enforced", "E"}, {" initially immediate", "E"}, {" enforced", "E"}, {"", "E"}};
        nonDefaultCharacteristics = new String[][]{{" deferrable", "i"}, {" deferrable initially immediate", "i"}, {" deferrable enforced", "i"}, {" deferrable initially immediate enforced", "i"}, {" deferrable initially deferred", "e"}, {" deferrable initially deferred enforced", "e"}, {" initially deferred enforced", "e"}, {" initially deferred", "e"}, {" deferrable not enforced", "j"}, {" deferrable initially immediate not enforced", "j"}, {" deferrable initially deferred not enforced", "d"}, {" initially deferred not enforced", "d"}, {" not enforced", "D"}, {" initially immediate not enforced", "D"}, {" not deferrable not enforced", "D"}, {" not deferrable initially immediate not enforced", "D"}};
        illegalCharacteristics = new String[]{" not deferrable initially deferred", " not deferrable initially deferred enforced", " not deferrable initially deferred not enforced"};
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(defaultCharacteristics[0]));
        arrayList.addAll(Arrays.asList(nonDefaultCharacteristics[0]));
        arrayList.addAll(Arrays.asList(illegalCharacteristics));
        arrayList.remove(" not enforced");
        arrayList.remove(" enforced");
        arrayList.remove("");
        illegalAlterCharacteristics = arrayList.toArray(new String[0]);
        inverseState = new HashMap<String, String[]>();
        inverseState.put("E", new String[]{"E", "D"});
        inverseState.put("D", new String[]{"E", "D"});
        inverseState.put("i", new String[]{"i", "j"});
        inverseState.put("j", new String[]{"i", "j"});
        inverseState.put("i", new String[]{"i", "j"});
        inverseState.put("e", new String[]{"e", "d"});
        inverseState.put("d", new String[]{"e", "d"});
    }
}

