/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class XAJNDITest
extends BaseJDBCTestCase {
    private static String ldapServer;
    private static String ldapPort;
    private static String dnString;
    private InitialDirContext ic = this.getInitialDirContext();

    public XAJNDITest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3()) {
            ldapServer = XAJNDITest.getSystemProperty("derbyTesting.ldapServer");
            if (ldapServer == null || ldapServer.length() < 1) {
                return new BaseTestSuite("XAJNDITest requires property derbyTesting.ldapServer set, eg: -DderbyTesting.ldapServer=myldapserver.myorg.org");
            }
            ldapPort = XAJNDITest.getSystemProperty("derbyTesting.ldapPort");
            if (ldapPort == null || ldapPort.length() < 1) {
                return new BaseTestSuite("XAJNDITest requires property derbyTesting.ldapPort set, eg: -DderbyTesting.ldapPort=333");
            }
            dnString = XAJNDITest.getSystemProperty("derbyTesting.dnString");
            if (dnString == null || dnString.length() < 1) {
                return new BaseTestSuite("XAJNDITest requires property derbyTesting.dnString for setting o=, eg: -DderbyTesting.dnString=myJNDIstring");
            }
            return TestConfiguration.defaultSuite(XAJNDITest.class);
        }
        return new BaseTestSuite("XAJNDITest cannot run without XA support");
    }

    @Override
    public void tearDown() throws Exception {
        ldapServer = null;
        ldapPort = null;
        super.tearDown();
    }

    private InitialDirContext getInitialDirContext() {
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string = XAJNDITest.getSystemProperty("derbyTesting.ldapContextFactory");
            if (string == null || string.length() < 1) {
                hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            } else {
                hashtable.put("java.naming.factory.initial", string);
            }
            hashtable.put("java.naming.provider.url", "ldap://" + ldapServer + ":" + ldapPort);
            hashtable.put("java.naming.security.authentication", "simple");
            return new InitialDirContext(hashtable);
        }
        catch (NamingException namingException) {
            XAJNDITest.fail((String)"naming exception ");
            return null;
        }
    }

    public void testCompareXADataSourcewithJNDIDataSource() throws Exception {
        XADataSource xADataSource = J2EEDataSource.getXADataSource();
        String string = TestConfiguration.getCurrent().getDefaultDatabaseName();
        JDBCDataSource.setBeanProperty(xADataSource, "databaseName", string);
        JDBCDataSource.setBeanProperty(xADataSource, "createDatabase", "create");
        JDBCDataSource.setBeanProperty(xADataSource, "description", "XA DataSource");
        this.ic.rebind("cn=compareDS, o=" + dnString, (Object)xADataSource);
        XADataSource xADataSource2 = (XADataSource)this.ic.lookup("cn=compareDS, o=" + dnString);
        if (XAJNDITest.usingEmbedded()) {
            XAJNDITest.assertEquals((Object)xADataSource, (Object)xADataSource2);
        }
        String[] stringArray = XAJNDITest.getPropertyBeanList(xADataSource);
        String[] stringArray2 = XAJNDITest.getPropertyBeanList(xADataSource2);
        XAJNDITest.assertEquals((int)stringArray.length, (int)stringArray2.length);
        for (int i = 0; i < stringArray.length; ++i) {
            XAJNDITest.assertEquals((String)stringArray[i], (String)stringArray2[i]);
            XAJNDITest.assertEquals((Object)JDBCDataSource.getBeanProperty(xADataSource, stringArray[i]), (Object)JDBCDataSource.getBeanProperty(xADataSource2, stringArray2[i]));
        }
        JDBCDataSource.clearStringBeanProperty(xADataSource, "createDatabase");
        XAJNDITest.assertFalse((boolean)xADataSource.equals(xADataSource2));
    }

    private static String[] getPropertyBeanList(Object object) {
        Method[] methodArray = object.getClass().getMethods();
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            String string = method.getName();
            if (string.length() < 5 || !string.startsWith("get") || method.getParameterTypes().length != 0) continue;
            Class<?> clazz = method.getReturnType();
            if (clazz.equals(Integer.TYPE) || clazz.equals(String.class) || clazz.equals(Boolean.TYPE) || clazz.equals(Short.TYPE) || clazz.equals(Long.TYPE)) {
                String string2 = string.substring(3, 4).toLowerCase() + string.substring(4);
                arrayList.add((CallSite)((Object)string2));
                continue;
            }
            XAJNDITest.assertFalse((String)("Method '" + string + "' with primitive return type not supported - update test!!"), (boolean)clazz.isPrimitive());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

