/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ScrollResultSetTest
extends BaseJDBCTestCase {
    public ScrollResultSetTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJDBC3() || JDBC.vmSupportsJSR169()) {
            return TestConfiguration.defaultSuite(ScrollResultSetTest.class);
        }
        return new BaseTestSuite("Empty ScrollResultSetTest suite, no support for holdability");
    }

    public void setUp() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        String string = "CREATE TABLE tableWithPK (c1 int primary key,c2 int)";
        String string2 = "INSERT INTO tableWithPK values (1, 1), (2, 2), (3, 3), (4, 4), (5, 5)";
        Statement statement = connection.createStatement();
        statement.execute(string);
        statement.execute(string2);
        statement.close();
    }

    @Override
    public void tearDown() throws Exception {
        ScrollResultSetTest.println("TearDown");
        Statement statement = this.getConnection().createStatement();
        try {
            statement.executeUpdate("DROP TABLE tableWithPK");
        }
        catch (SQLException sQLException) {
            ScrollResultSetTest.printStackTrace(sQLException);
        }
        statement.close();
        super.tearDown();
    }

    public void testNextOnLastRowForwardOnly() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        connection.setHoldability(2);
        Statement statement = connection.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery("SELECT c1 FROM tableWithPK");
        while (resultSet.next()) {
        }
        try {
            resultSet.next();
            ScrollResultSetTest.assertTrue((String)"Excepted exception to be thrown - result set is closed", (boolean)false);
        }
        catch (SQLException sQLException) {
            ScrollResultSetTest.assertSQLState("Unexpected SQL State", "XCL16", sQLException);
        }
    }

    public void testNextOnLastRowScrollable() throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        connection.setHoldability(2);
        Statement statement = connection.createStatement(1004, 1007);
        ResultSet resultSet = statement.executeQuery("SELECT c1 FROM tableWithPK");
        resultSet.last();
        resultSet.next();
        ScrollResultSetTest.assertFalse((String)"Calling next while positioned after last returns false", (boolean)resultSet.next());
        ScrollResultSetTest.assertTrue((String)"Moving to absolute(2) returns true", (boolean)resultSet.absolute(2));
        resultSet.close();
    }

    public void testDerby6737() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table d6737(c clob)");
        statement.execute("insert into d6737 values 'abc'");
        PreparedStatement preparedStatement = this.prepareStatement("select * from d6737", 1004, 1007);
        ResultSet resultSet = preparedStatement.executeQuery();
        ScrollResultSetTest.assertTrue((boolean)resultSet.last());
        ScrollResultSetTest.assertTrue((boolean)resultSet.first());
        ScrollResultSetTest.assertEquals((long)3L, (long)resultSet.getClob(1).length());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        ScrollResultSetTest.assertTrue((boolean)resultSet.next());
        ScrollResultSetTest.assertTrue((boolean)resultSet.first());
        ScrollResultSetTest.assertEquals((long)3L, (long)resultSet.getClob(1).length());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        ScrollResultSetTest.assertTrue((boolean)resultSet.first());
        ScrollResultSetTest.assertTrue((boolean)resultSet.last());
        ScrollResultSetTest.assertEquals((long)3L, (long)resultSet.getClob(1).length());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        ScrollResultSetTest.assertTrue((boolean)resultSet.last());
        ScrollResultSetTest.assertTrue((boolean)resultSet.absolute(1));
        ScrollResultSetTest.assertEquals((long)3L, (long)resultSet.getClob(1).length());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        ScrollResultSetTest.assertTrue((boolean)resultSet.last());
        ScrollResultSetTest.assertEquals((long)3L, (long)resultSet.getClob(1).length());
        ScrollResultSetTest.assertTrue((boolean)resultSet.first());
        ScrollResultSetTest.assertEquals((long)3L, (long)resultSet.getClob(1).length());
        resultSet.close();
        resultSet = preparedStatement.executeQuery();
        ScrollResultSetTest.assertTrue((boolean)resultSet.last());
        resultSet.getClob(1).free();
        ScrollResultSetTest.assertTrue((boolean)resultSet.first());
        ScrollResultSetTest.assertEquals((long)3L, (long)resultSet.getClob(1).length());
        resultSet.close();
    }
}

