/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class LargeDataLocksTest
extends BaseJDBCTestCase {
    public LargeDataLocksTest(String string) {
        super(string);
    }

    public void testGetCharacterStream() throws SQLException, IOException {
        int n = 0;
        Statement statement = this.createStatement();
        String string = "SELECT bc from t1";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        Reader reader = resultSet.getCharacterStream(1);
        int n2 = reader.read();
        while (n2 != -1) {
            n2 = reader.read();
            ++n;
        }
        LargeDataLocksTest.assertEquals((int)38000, (int)n);
        resultSet.close();
        this.assertLockCount(0);
        this.commit();
    }

    public void testGetBytes() throws SQLException {
        Statement statement = this.createStatement();
        String string = "SELECT bincol from t1";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        byte[] byArray = resultSet.getBytes(1);
        LargeDataLocksTest.assertEquals((int)38000, (int)byArray.length);
        resultSet.close();
        this.assertLockCount(0);
        this.commit();
    }

    public void testGetBinaryStream() throws SQLException, IOException {
        int n = 0;
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        String string = "SELECT bincol from t1";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        InputStream inputStream = resultSet.getBinaryStream(1);
        int n2 = inputStream.read();
        while (n2 != -1) {
            n2 = inputStream.read();
            ++n;
        }
        LargeDataLocksTest.assertEquals((int)38000, (int)n);
        resultSet.close();
        this.assertLockCount(0);
        this.commit();
    }

    public void testGetString() throws SQLException, IOException {
        Statement statement = this.createStatement();
        String string = "SELECT bc from t1";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        String string2 = resultSet.getString(1);
        LargeDataLocksTest.assertEquals((int)38000, (int)string2.length());
        resultSet.close();
        this.assertLockCount(0);
        this.commit();
    }

    private void assertLockCount(int n) throws SQLException {
        Connection connection = this.openDefaultConnection();
        Statement statement = connection.createStatement();
        statement.execute("call wait_for_post_commit()");
        ResultSet resultSet = statement.executeQuery("select * from syscs_diag.lock_table");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        StringBuffer stringBuffer = new StringBuffer("Unexpected lock count. Contents of lock table:\n");
        int n2 = 0;
        while (resultSet.next()) {
            stringBuffer.append(n2 + 1).append(": ");
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String string = resultSetMetaData.getColumnName(i);
                Object object = resultSet.getObject(i);
                stringBuffer.append(string).append('=').append(object).append(' ');
            }
            stringBuffer.append('\n');
            ++n2;
        }
        resultSet.close();
        statement.close();
        connection.close();
        LargeDataLocksTest.assertEquals((String)stringBuffer.toString(), (int)n, (int)n2);
    }

    public static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTestSuite(LargeDataLocksTest.class);
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = this.getConnection();
                connection.setAutoCommit(false);
                PreparedStatement preparedStatement = null;
                String string = "CREATE TABLE t1 (bc CLOB(1M), bincol BLOB(1M), datalen int)";
                statement.executeUpdate(string);
                string = "INSERT into t1 values(?,?,?)";
                preparedStatement = connection.prepareStatement(string);
                preparedStatement.setCharacterStream(1, (Reader)new StringReader(Utilities.repeatChar("a", 38000)), 38000);
                try {
                    preparedStatement.setBytes(2, Utilities.repeatChar("a", 38000).getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    BaseTestCase.fail(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
                preparedStatement.setInt(3, 38000);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                statement.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
                connection.commit();
            }
        };
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("LargeDataLocksTest");
        baseTestSuite.addTest(LargeDataLocksTest.baseSuite("LargeDataLocksTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(LargeDataLocksTest.baseSuite("LargeDataLocksTest:client")));
        return baseTestSuite;
    }
}

