/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derby.jdbc.BasicEmbeddedDataSource40;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.SecurityCheck;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DataSourceTest
extends BaseJDBCTestCase {
    private static final String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
    protected static Hashtable<String, Connection> conns = new Hashtable();
    private static final String CONNSTRING_FORMAT = "\\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) ";
    private final Object nogc = SecurityCheck.class;

    public DataSourceTest(String string) {
        super(string);
    }

    private static Test baseSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ClientAndEmbedded" + string);
        baseTestSuite.addTest((Test)new DataSourceTest("testBadConnectionAttributeSyntax"));
        baseTestSuite.addTest((Test)new DataSourceTest("testDescriptionProperty"));
        baseTestSuite.addTest((Test)new DataSourceTest("testAllDataSources"));
        baseTestSuite.addTest((Test)new DataSourceTest("testJira95ds"));
        return baseTestSuite;
    }

    private static Test getClientSuite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Client/Server");
        baseTestSuite.addTest((Test)new DataSourceTest("testClientDSConnectionAttributes"));
        baseTestSuite.addTest((Test)new DataSourceTest("testClientTraceFileDSConnectionAttribute"));
        baseTestSuite.addTest((Test)new DataSourceTest("testClientMessageTextConnectionAttribute"));
        return baseTestSuite;
    }

    private static Test getEmbeddedSuite(String string) {
        BaseTestSuite baseTestSuite = new BaseTestSuite("Embedded" + string);
        baseTestSuite.addTest((Test)new DataSourceTest("testDSRequestAuthentication"));
        return baseTestSuite;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DataSourceTest suite");
        baseTestSuite.addTest(DataSourceTest.getEmbeddedSuite("embedded"));
        baseTestSuite.addTest(DataSourceTest.baseSuite(":embedded"));
        if (!JDBC.vmSupportsJSR169()) {
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DataSourceTest.baseSuite(":client")));
            baseTestSuite.addTest(TestConfiguration.clientServerDecorator(DataSourceTest.getClientSuite()));
        }
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.executeUpdate("create table intTable(i int)");
            }
        };
    }

    @Override
    public void tearDown() throws Exception {
        for (int i = 0; i < 6; ++i) {
            String string = "trace" + (i + 1) + ".out";
            File file = new File(string);
            if (!PrivilegedFileOpsForTests.exists(file)) continue;
            PrivilegedFileOpsForTests.delete(file);
        }
        super.tearDown();
    }

    public void testAllDataSources() throws SQLException, Exception {
        Object[] objectArray = new Object[]{1, "XJ010", 2, true, false};
        if (DataSourceTest.usingEmbedded()) {
            this.assertTenConnectionsUnique();
        }
        DataSource dataSource = JDBCDataSource.getDataSource();
        if (DataSourceTest.usingEmbedded()) {
            DataSourceTest.assertToString(dataSource);
        }
        DataSource dataSource2 = dataSource;
        this.assertConnectionOK(objectArray, "DataSource", dataSource2.getConnection());
        if (JDBC.vmSupportsJDBC4()) {
            BasicEmbeddedDataSource40 basicEmbeddedDataSource40 = new BasicEmbeddedDataSource40();
            basicEmbeddedDataSource40.setDatabaseName(dbName);
            this.assertConnectionOK(objectArray, "BasicDataSource", basicEmbeddedDataSource40.getConnection());
        }
    }

    public void testJira95ds() throws SQLException {
        try {
            DataSource dataSource = JDBCDataSource.getDataSource();
            JDBCDataSource.setBeanProperty(dataSource, "databaseName", "jdbc:derby:wombat");
            dataSource.getConnection();
            DataSourceTest.fail((String)"expected an SQLException!");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("XCY00", sQLException);
        }
        catch (Exception exception) {
            DataSourceTest.fail((String)("unexpected exception: " + exception.toString()));
        }
    }

    public void testBadConnectionAttributeSyntax() throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(dataSource, "ConnectionAttributes", "bad");
        try {
            dataSource.getConnection();
            DataSourceTest.fail((String)"should have seen an error");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("XJ028", sQLException);
        }
    }

    public void testClientDSConnectionAttributes() throws Exception {
        if (DataSourceTest.usingEmbedded()) {
            return;
        }
        ClientDataSourceInterface clientDataSourceInterface = null;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientDataSourceInterface.setPortNumber(TestConfiguration.getCurrent().getPort());
        DataSourceTest.dsConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (DataSource)clientDataSourceInterface);
        clientDataSourceInterface.setConnectionAttributes("databaseName=" + dbName);
        DataSourceTest.dsConnectionRequests(new String[]{"08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001", "08001"}, (DataSource)clientDataSourceInterface);
        clientDataSourceInterface.setConnectionAttributes(null);
        clientDataSourceInterface.setConnectionAttributes("databaseName=kangaroo");
        clientDataSourceInterface.setDatabaseName(dbName);
        DataSourceTest.dsConnectionRequests(new String[]{"OK", "08001", "OK", "OK", "08001", "08001", "OK", "OK", "OK"}, (DataSource)clientDataSourceInterface);
        clientDataSourceInterface.setConnectionAttributes(null);
        clientDataSourceInterface.setDatabaseName(null);
    }

    public void testDSRequestAuthentication() throws SQLException {
        JDBCClient jDBCClient = this.getTestConfiguration().getJDBCClient();
        String string = jDBCClient.getDataSourceClassName();
        DataSource dataSource = null;
        try {
            Class<?> clazz = Class.forName(string);
            dataSource = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            DataSourceTest.fail((String)"unable to complete test because unable to create new instance of datasource");
        }
        DataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004"}, dataSource);
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "databaseName=" + dbName);
        DataSourceTest.dsConnectionRequests(new String[]{"XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004", "XJ004"}, dataSource);
        JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        dataSource = null;
        TestConfiguration.getCurrent().shutdownDatabase();
    }

    public void testClientTraceFileDSConnectionAttribute() throws SQLException {
        if (DataSourceTest.usingEmbedded()) {
            return;
        }
        DataSource dataSource = JDBCDataSource.getDataSource();
        String string = "trace1.out";
        JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", "traceFile=" + string);
        DataSourceTest.dsGetBadConnection(dataSource);
        JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        string = "trace2.out";
        JDBCDataSource.setBeanProperty(dataSource, "traceFile", string);
        dataSource.getConnection();
        dataSource = null;
        DataSourceTest.assertTraceFilesExist();
    }

    private static void dsGetBadConnection(DataSource dataSource) {
        try {
            dataSource.getConnection();
            dataSource.getConnection(null, null);
            DataSourceTest.fail((String)"expected an sqlException");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08001", sQLException);
        }
    }

    private static void assertTraceFilesExist() {
        for (int i = 0; i < 2; ++i) {
            String string = "trace" + (i + 1) + ".out";
            File file = new File(string);
            DataSourceTest.assertTrue((boolean)PrivilegedFileOpsForTests.exists(file));
        }
    }

    public void testClientMessageTextConnectionAttribute() throws Exception {
        if (DataSourceTest.usingEmbedded()) {
            return;
        }
        String string = "retrieveMessageText";
        ClientDataSourceInterface clientDataSourceInterface = null;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.BasicClientDataSource40");
            clientDataSourceInterface = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        clientDataSourceInterface.setPortNumber(TestConfiguration.getCurrent().getPort());
        clientDataSourceInterface.setDatabaseName(dbName);
        clientDataSourceInterface.setConnectionAttributes(string + "=false");
        Connection connection = clientDataSourceInterface.getConnection();
        DataSourceTest.assertMessageText(connection, "false");
        connection.close();
        clientDataSourceInterface.setConnectionAttributes(string + "=true");
        connection = clientDataSourceInterface.getConnection();
        DataSourceTest.assertMessageText(connection, "true");
        clientDataSourceInterface.setConnectionAttributes(null);
        connection.close();
    }

    private static void assertMessageText(Connection connection, String string) throws SQLException {
        try {
            connection.createStatement().executeQuery("SELECT * FROM APP.NOTTHERE");
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("42X05", sQLException);
            if (string.equals("true")) {
                DataSourceTest.assertTrue((sQLException.getMessage().indexOf("does not exist") >= 0 ? 1 : 0) != 0);
            }
            DataSourceTest.assertTrue((sQLException.getMessage().indexOf("does not exist") == -1 ? 1 : 0) != 0);
        }
    }

    public void testDescriptionProperty() throws SQLException, Exception {
        this.subTestDataSourceDescription(JDBCDataSource.getDataSource());
    }

    private void subTestDataSourceDescription(DataSource dataSource) throws Exception {
        String string = "Everything you ever wanted to know about this datasource";
        JDBCDataSource.setBeanProperty(dataSource, "description", string);
        dataSource.getConnection();
        DataSourceTest.assertEquals((Object)string, (Object)JDBCDataSource.getBeanProperty(dataSource, "description"));
        JDBCDataSource.clearStringBeanProperty(dataSource, "description");
        DataSourceTest.assertNull((Object)JDBCDataSource.getBeanProperty(dataSource, "description"));
    }

    private static void setDatabaseProperty(String string, String string2) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        Connection connection = dataSource.getConnection();
        CallableStatement callableStatement = connection.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        callableStatement.setString(1, string);
        callableStatement.setString(2, string2);
        callableStatement.execute();
        callableStatement.close();
        connection.close();
    }

    private static void dsConnectionRequests(String[] stringArray, DataSource dataSource) {
        if (DataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(dataSource, "javax.sql.DataSource");
        }
        try {
            dataSource.getConnection();
            if (!stringArray[0].equals("OK")) {
                DataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState(stringArray[0], sQLException);
        }
        DataSourceTest.dsConnectionRequest(stringArray[1], dataSource, null, null);
        DataSourceTest.dsConnectionRequest(stringArray[2], dataSource, "fred", null);
        DataSourceTest.dsConnectionRequest(stringArray[3], dataSource, "fred", "wilma");
        DataSourceTest.dsConnectionRequest(stringArray[4], dataSource, null, "wilma");
        DataSourceTest.dsConnectionRequest(stringArray[5], dataSource, null, "databaseName=wombat");
        DataSourceTest.dsConnectionRequest(stringArray[6], dataSource, "fred", "databaseName=wombat");
        DataSourceTest.dsConnectionRequest(stringArray[7], dataSource, "fred", "databaseName=wombat;password=wilma");
        DataSourceTest.dsConnectionRequest(stringArray[8], dataSource, "fred", "databaseName=wombat;password=betty");
    }

    private static void dsConnectionRequest(String string, DataSource dataSource, String string2, String string3) {
        try {
            dataSource.getConnection(string2, string3);
            if (!string.equals("OK")) {
                DataSourceTest.fail((String)" expected connection to fail, but was OK");
            }
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState(string, sQLException);
        }
    }

    private void assertConnectionOK(Object[] objectArray, String string, Connection connection) throws SQLException {
        DataSourceTest.assertEquals((int)((Integer)objectArray[0]), (int)connection.getHoldability());
        try {
            connection.releaseSavepoint(connection.setSavepoint());
            if (connection.getAutoCommit()) {
                DataSourceTest.fail((String)"expected a SQLExpection (savepoint with autocommit on");
            }
            if (!((String)objectArray[1]).equals("OK")) {
                DataSourceTest.fail((String)"expected a SQLExpection (savepoint with autocommit on");
            }
        }
        catch (SQLException sQLException) {
            if (connection.getAutoCommit()) {
                DataSourceTest.assertSQLState("XJ010", sQLException);
            }
            if (((String)objectArray[1]).equals("OK")) {
                DataSourceTest.fail((String)"unexpected JDBC 3.0 savepoint SQL Exception");
            }
            DataSourceTest.assertSQLState((String)objectArray[1], sQLException);
        }
        if (DataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(connection, "java.sql.Connection");
            SecurityCheck.assertSourceSecurity(connection.getMetaData(), "java.sql.DatabaseMetaData");
        }
        DataSourceTest.assertEquals((int)((Integer)objectArray[2]), (int)connection.getTransactionIsolation());
        DataSourceTest.assertEquals((boolean)((Boolean)objectArray[3]), (boolean)connection.getAutoCommit());
        DataSourceTest.assertEquals((boolean)((Boolean)objectArray[4]), (boolean)connection.isReadOnly());
        if (connection.getWarnings() != null) {
            DataSourceTest.assertSQLState("01J01", connection.getWarnings());
        }
        Statement statement = connection.createStatement();
        this.assertStatementOK(string, connection, statement);
        this.assertStatementOK(string, connection, connection.createStatement(1004, 1007));
        Connection connection2 = connection.getMetaData().getConnection();
        if (!DataSourceTest.usingDerbyNetClient() && string.indexOf("DataSource") >= 0) {
            DataSourceTest.assertEquals((Object)connection2, (Object)connection);
        }
        this.assertConnectionPreClose(string, connection);
        connection.close();
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            DataSourceTest.fail((String)" unexpected exception on <closedconn>.close() ");
        }
        try {
            connection.createStatement();
            DataSourceTest.fail((String)(string + " <closedconn>.createStatement(), expected 08003 - No current connection"));
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
        try {
            statement.execute("values 1");
            DataSourceTest.fail((String)(string + " <closedstmt>.execute(), expected 08003 - No current connection"));
        }
        catch (SQLException sQLException) {
            DataSourceTest.assertSQLState("08003", sQLException);
        }
    }

    private void assertConnectionPreClose(String string, Connection connection) throws SQLException {
        connection.setHoldability(2);
        if (!string.equals("Nested2")) {
            try {
                connection.setReadOnly(true);
            }
            catch (SQLException sQLException) {
                DataSourceTest.assertSQLState("25501", sQLException);
            }
        }
    }

    private void assertStatementOK(String string, Connection connection, Statement statement) throws SQLException {
        ResultSet resultSet;
        Connection connection2;
        if (DataSourceTest.usingEmbedded()) {
            SecurityCheck.assertSourceSecurity(statement, "java.sql.Statement");
        }
        if ((connection2 = statement.getConnection()) != connection && !DataSourceTest.usingDerbyNetClient() && string.indexOf("DataSource") >= 0) {
            DataSourceTest.fail((String)"incorrect connection object returned for Statement.getConnection()");
        }
        statement.addBatch("insert into intTable values 1");
        statement.addBatch("insert into intTable values 2,3");
        int[] nArray = statement.executeBatch();
        if (nArray[0] != 1) {
            DataSourceTest.fail((String)"invalid update count for first batch statement");
        }
        if (nArray[1] != 2) {
            DataSourceTest.fail((String)"invalid update count for second batch statement");
        }
        if ((resultSet = statement.executeQuery("VALUES 1")).getStatement() != statement) {
            DataSourceTest.fail((String)("incorrect Statement object returned for ResultSet.getStatement for " + string));
        }
        resultSet.close();
        statement.close();
    }

    private static void assertToString(Connection connection) throws Exception {
        DataSourceTest.assertStringFormat(connection);
        String string = connection.toString();
        if (conns.containsKey(string)) {
            throw new Exception("ERROR: Connection toString() is not unique: " + string);
        }
        conns.put(string, connection);
    }

    private static void assertStringFormat(Connection connection) {
        DataSourceTest.assertStringPrefix(connection);
        String string = connection.toString();
        if (!JDBC.vmSupportsJSR169()) {
            DataSourceTest.assertTrue((String)("\nexpected format:\n \\S+@\\-?[0-9]+.* \\(XID = .*\\), \\(SESSIONID = [0-9]+\\), \\(DATABASE = [A-Za-z]+\\), \\(DRDAID = .*\\) \nactual value:\n " + string), (boolean)string.matches(CONNSTRING_FORMAT));
        }
    }

    private static String assertStringPrefix(Object object) {
        String string = object.toString();
        String string2 = object.getClass().getName() + "@" + object.hashCode();
        DataSourceTest.assertTrue((boolean)string.startsWith(string2));
        return string2;
    }

    private static void assertToString(DataSource dataSource) throws Exception {
        DataSourceTest.clearConnections();
        int n = 10;
        for (int i = 0; i < n; ++i) {
            Connection connection = dataSource.getConnection();
            DataSourceTest.assertToString(connection);
        }
        DataSourceTest.clearConnections();
    }

    private static void clearConnections() throws SQLException {
        for (Connection connection : conns.values()) {
            connection.close();
        }
        conns.clear();
    }

    private void assertTenConnectionsUnique() throws Exception {
        DataSourceTest.clearConnections();
        int n = 10;
        for (int i = 0; i < n; ++i) {
            Connection connection = this.openDefaultConnection();
            DataSourceTest.assertToString(connection);
        }
        DataSourceTest.clearConnections();
    }
}

