/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AIjdbcTest
extends BaseJDBCTestCase {
    public AIjdbcTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.defaultSuite(AIjdbcTest.class, false)){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("create table tab1 (x int, y int generated always as identity,z char(2))");
                statement.execute("create view tab1_view (a,b) as select y,y+1 from tab1");
            }
        };
    }

    @Override
    protected void initializeConnection(Connection connection) throws SQLException {
        connection.setAutoCommit(false);
    }

    public void testSelect() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select x,z from tab1");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        AIjdbcTest.assertFalse((String)"Column count doesn't match.", (resultSetMetaData.getColumnCount() != 2 ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 1 is NOT ai.", (boolean)resultSetMetaData.isAutoIncrement(1));
        AIjdbcTest.assertFalse((String)"Column 2 is NOT ai.", (boolean)resultSetMetaData.isAutoIncrement(2));
        resultSet.close();
        resultSet = statement.executeQuery("select y, x,z from tab1");
        resultSetMetaData = resultSet.getMetaData();
        AIjdbcTest.assertFalse((String)"Column count doesn't match.", (resultSetMetaData.getColumnCount() != 3 ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 1 IS ai.", (!resultSetMetaData.isAutoIncrement(1) ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 2 is NOT ai.", (boolean)resultSetMetaData.isAutoIncrement(2));
        AIjdbcTest.assertFalse((String)"Column 3 is NOT ai.", (boolean)resultSetMetaData.isAutoIncrement(3));
        resultSet.close();
        statement.close();
    }

    public void testSelectView() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from tab1_view");
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        AIjdbcTest.assertFalse((String)"Column count doesn't match.", (resultSetMetaData.getColumnCount() != 2 ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 1 IS ai.", (!resultSetMetaData.isAutoIncrement(1) ? 1 : 0) != 0);
        AIjdbcTest.assertFalse((String)"Column 1 is NOT ai.", (boolean)resultSetMetaData.isAutoIncrement(2));
        resultSet.close();
        statement.close();
    }
}

