/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;

public class StatementTestSetup
extends BaseJDBCTestSetup {
    public StatementTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws SQLException {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        try {
            statement.execute("select count(*) from stmtTable");
            statement.execute("drop table stmtTable");
        }
        catch (SQLException sQLException) {
            StatementTestSetup.assertEquals((String)"Unexpected error when accessing non-existing table.", (String)"42X05", (String)sQLException.getSQLState());
        }
        try {
            statement.execute("drop function delay_st");
        }
        catch (SQLException sQLException) {
            StatementTestSetup.assertEquals((String)"42Y55", (String)sQLException.getSQLState());
        }
        statement.execute("create table stmtTable (id int, val varchar(10))");
        statement.execute("insert into stmtTable values (1, 'one'),(2,'two')");
        ResultSet resultSet = statement.executeQuery("select count(*) from stmtTable");
        resultSet.next();
        StatementTestSetup.assertEquals((String)"Number of rows are not as expected", (int)2, (int)resultSet.getInt(1));
        resultSet.close();
        statement.execute("create function delay_st(seconds integer, value integer) returns integer\nparameter style java no sql language java\nexternal name 'org.apache.derbyTesting.functionTests.tests.jdbcapi.SetQueryTimeoutTest.delay'");
        statement.close();
        connection.commit();
    }

    @Override
    protected void tearDown() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("drop table stmtTable");
        statement.close();
        connection.commit();
        super.tearDown();
    }
}

