/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.BatchUpdateException;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PrepareStatementTest
extends BaseJDBCTestCase {
    public PrepareStatementTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty PrepareStatementTest - client not supported on JSR169");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("PrepareStatementTest");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(PrepareStatementTest.class));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(TestConfiguration.connectionCPDecorator((Test)new CleanDatabaseTestSetup((Test)new BaseTestSuite(PrepareStatementTest.class)))));
        return baseTestSuite;
    }

    public void testBasicPrepare() throws Exception {
        ResultSet resultSet;
        PreparedStatement preparedStatement = this.prepareStatement("create table t1(c1 int, c2 int, c3 int)");
        PrepareStatementTest.assertUpdateCount(preparedStatement, 0);
        preparedStatement.close();
        Object[][] objectArray = new Integer[][]{{99, 5, 9}, {2, 6, 10}, {7, 5, 8}};
        preparedStatement = this.prepareStatement("insert into t1 values (?, " + objectArray[0][1] + ", ?)");
        preparedStatement.setInt(1, objectArray[0][0]);
        preparedStatement.setInt(2, objectArray[0][2]);
        PrepareStatementTest.assertUpdateCount(preparedStatement, 1);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into t1 values (" + objectArray[1][0] + ", " + objectArray[1][1] + ", ?), (?, " + objectArray[2][1] + ", " + objectArray[2][2] + ")");
        preparedStatement.setInt(1, objectArray[1][2]);
        preparedStatement.setInt(2, objectArray[2][0]);
        boolean bl = preparedStatement.execute();
        while (bl) {
            resultSet = preparedStatement.getResultSet();
            PrepareStatementTest.assertFalse((boolean)resultSet.next());
            resultSet.close();
            bl = preparedStatement.getMoreResults();
        }
        PrepareStatementTest.assertEquals((int)2, (int)preparedStatement.getUpdateCount());
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select * from t1");
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, objectArray, false);
        resultSet.close();
        preparedStatement.close();
        Object[][] objectArray2 = new Integer[2][];
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if ((Integer)objectArray[i][1] != 5) continue;
            objectArray2[n++] = objectArray[i];
        }
        preparedStatement = this.prepareStatement("select * from t1 where c2 = ?");
        preparedStatement.setInt(1, 5);
        resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, objectArray2, false);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select * from t1 where c2 = ?");
        preparedStatement.setInt(1, 5);
        PrepareStatementTest.assertTrue((boolean)preparedStatement.execute());
        resultSet = preparedStatement.getResultSet();
        JDBC.assertFullResultSet(resultSet, objectArray2, false);
        resultSet.close();
        PrepareStatementTest.assertFalse((boolean)preparedStatement.getMoreResults());
        PrepareStatementTest.assertEquals((int)-1, (int)preparedStatement.getUpdateCount());
        preparedStatement.close();
    }

    public void testParameterTypes() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("create table t2(si smallint,i int, bi bigint, r real, f float, d double precision, n5_2 numeric(5,2), dec10_3 decimal(10,3), ch20 char(20),vc varchar(20), lvc long varchar, b20 char(23) for bit data, vb varchar(23) for bit data, lvb long varchar for bit data,  dt date, tm time, ts timestamp not null)");
        PrepareStatementTest.assertUpdateCount(preparedStatement, 0);
        preparedStatement.close();
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
        byte[] byArray2 = new byte[23];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        Arrays.fill(byArray2, byArray.length, byArray2.length, (byte)32);
        Object[][] objectArray = new Object[][]{{1, 2, 3L, Float.valueOf(4.0f), 5.0, 6.0, new BigDecimal("77.77"), new BigDecimal("8.100"), "column9string       ", "column10vcstring", "column11lvcstring", byArray2, byArray, byArray, Date.valueOf("2002-04-12"), Time.valueOf("11:44:30"), Timestamp.valueOf("2002-04-12 11:44:30.000000000")}, {1, 2, 3L, Float.valueOf(4.0f), 5.0, 6.0, new BigDecimal("77.77"), new BigDecimal("8.100"), "column11string      ", "column10vcstring", "column11lvcstring", byArray2, byArray, byArray, Date.valueOf("2002-04-12"), Time.valueOf("11:44:30"), Timestamp.valueOf("2002-04-12 11:44:30.000000000")}, {null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, Timestamp.valueOf("2002-04-12 11:44:31.000000000")}};
        preparedStatement = this.prepareStatement("insert into t2 values (?, ?, ?, ?,  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? ,? , ?)");
        preparedStatement.setShort(1, ((Integer)objectArray[0][0]).shortValue());
        preparedStatement.setInt(2, (Integer)objectArray[0][1]);
        preparedStatement.setLong(3, (Long)objectArray[0][2]);
        preparedStatement.setFloat(4, ((Float)objectArray[0][3]).floatValue());
        preparedStatement.setDouble(5, (Double)objectArray[0][4]);
        preparedStatement.setDouble(6, (Double)objectArray[0][5]);
        preparedStatement.setBigDecimal(7, (BigDecimal)objectArray[0][6]);
        preparedStatement.setBigDecimal(8, new BigDecimal("8.1"));
        preparedStatement.setString(9, "column9string");
        byte[] byArray3 = ((String)objectArray[0][9]).getBytes("UTF-8");
        int n = byArray3.length;
        preparedStatement.setAsciiStream(10, (InputStream)new ByteArrayInputStream(byArray3), n);
        byte[] byArray4 = ((String)objectArray[0][10]).getBytes("UTF-8");
        n = byArray4.length;
        preparedStatement.setCharacterStream(11, (Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(byArray4), "UTF-8"), n);
        preparedStatement.setBytes(12, byArray);
        preparedStatement.setBinaryStream(13, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
        preparedStatement.setBytes(14, byArray);
        preparedStatement.setDate(15, (Date)objectArray[0][14]);
        preparedStatement.setTime(16, (Time)objectArray[0][15]);
        preparedStatement.setTimestamp(17, (Timestamp)objectArray[0][16]);
        PrepareStatementTest.assertUpdateCount(preparedStatement, 1);
        for (int i = 0; i < 17; ++i) {
            preparedStatement.setObject(i + 1, objectArray[1][i]);
        }
        PrepareStatementTest.assertUpdateCount(preparedStatement, 1);
        preparedStatement.setNull(1, 5);
        preparedStatement.setNull(2, 4);
        preparedStatement.setNull(3, -5);
        preparedStatement.setNull(4, 7);
        preparedStatement.setNull(5, 6);
        preparedStatement.setNull(6, 8);
        preparedStatement.setNull(7, 2);
        preparedStatement.setNull(8, 3);
        preparedStatement.setNull(9, 1);
        preparedStatement.setNull(10, 12);
        preparedStatement.setNull(11, -1);
        preparedStatement.setNull(12, -2);
        preparedStatement.setNull(13, -3);
        preparedStatement.setNull(14, -4);
        preparedStatement.setNull(15, 91);
        preparedStatement.setNull(16, 92);
        preparedStatement.setTimestamp(17, (Timestamp)objectArray[2][16]);
        PrepareStatementTest.assertFalse((boolean)preparedStatement.execute());
        PrepareStatementTest.assertEquals((int)1, (int)preparedStatement.getUpdateCount());
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select * from t2");
        ResultSet resultSet = preparedStatement.executeQuery();
        JDBC.assertFullResultSet(resultSet, objectArray, false);
        resultSet.close();
        preparedStatement.close();
        try {
            preparedStatement = this.prepareStatement("select * from t2 where i = ?");
            resultSet = preparedStatement.executeQuery();
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("07000", sQLException);
        }
        resultSet.close();
        preparedStatement.close();
        try {
            preparedStatement = this.prepareStatement("insert into t2 values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            preparedStatement.executeUpdate();
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("07000", sQLException);
        }
        preparedStatement.close();
        preparedStatement = this.prepareStatement("create table d2558 (i int)");
        PrepareStatementTest.assertUpdateCount(preparedStatement, 0);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("insert into d2558 values (3), (4)");
        PrepareStatementTest.assertUpdateCount(preparedStatement, 2);
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select * from d2558 where i = ?");
        preparedStatement.setObject(1, (Object)3, 4, 0);
        try {
            preparedStatement.setObject(2, (Object)4, 4, 0);
            resultSet = preparedStatement.executeQuery();
            resultSet.close();
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("XCL13", sQLException);
        }
        preparedStatement.close();
    }

    public void testBigTable() throws Exception {
        int n = 1000;
        StringBuffer stringBuffer = new StringBuffer("create table bigtab (");
        for (int i = 1; i <= n; ++i) {
            stringBuffer.append("c");
            stringBuffer.append(i);
            stringBuffer.append(" int");
            stringBuffer.append(i != n ? ", " : " )");
        }
        PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
        PrepareStatementTest.assertUpdateCount(preparedStatement, 0);
        preparedStatement.close();
        this.insertTab("bigtab", 50);
        this.insertTab("bigtab", 200);
        this.insertTab("bigtab", 300);
        this.insertTab("bigtab", 500);
        this.insertTab("bigtab", 1000);
        this.selectFromBigTab();
        try {
            this.insertTab("bigtab", 1001);
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("42X14", sQLException);
        }
        try {
            this.insertTab("bigtab", 0);
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("42X01", sQLException);
        }
        try {
            this.insertTab("wrongtab", 1000);
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("42X05", sQLException);
        }
    }

    private void insertTab(String string, int n) throws SQLException {
        int n2;
        StringBuffer stringBuffer = new StringBuffer("insert into " + string + "(");
        for (n2 = 1; n2 <= n; ++n2) {
            stringBuffer.append(" c");
            stringBuffer.append(n2);
            stringBuffer.append(n2 != n ? ", " : ")");
        }
        stringBuffer.append("  values (");
        for (n2 = 1; n2 <= n; ++n2) {
            stringBuffer.append("?");
            stringBuffer.append(n2 != n ? ", " : " )");
        }
        PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
        for (int i = 1; i <= n; ++i) {
            preparedStatement.setInt(i, i);
        }
        PrepareStatementTest.assertUpdateCount(preparedStatement, 1);
        preparedStatement.close();
    }

    private void selectFromBigTab() throws SQLException {
        String string = "select * from bigtab";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        block5: while (resultSet.next()) {
            switch (++n) {
                case 1: 
                case 2: 
                case 3: {
                    PrepareStatementTest.assertNull((Object)resultSet.getObject(500));
                    PrepareStatementTest.assertNull((Object)resultSet.getObject(1000));
                    continue block5;
                }
                case 4: {
                    PrepareStatementTest.assertEquals((int)resultSet.getInt(500), (int)500);
                    PrepareStatementTest.assertNull((Object)resultSet.getObject(1000));
                    continue block5;
                }
                case 5: {
                    PrepareStatementTest.assertEquals((int)resultSet.getInt(500), (int)500);
                    PrepareStatementTest.assertEquals((int)resultSet.getInt(1000), (int)1000);
                    continue block5;
                }
            }
            PrepareStatementTest.fail((String)"Too many rows in bigTab");
        }
        PrepareStatementTest.assertEquals((int)n, (int)5);
        resultSet.close();
        preparedStatement.close();
    }

    public void testBigDecimalSetObject() throws SQLException {
        this.getConnection().setAutoCommit(false);
        String string = "CREATE TABLE doubletab (i int, doubleVal DOUBLE)";
        Statement statement = this.createStatement();
        PrepareStatementTest.assertUpdateCount(statement, 0, string);
        statement.close();
        this.commit();
        double[] dArray = new double[]{1.0E-130, 1.0E125, 0.0, -1.0E124};
        BigDecimal[] bigDecimalArray = new BigDecimal[]{new BigDecimal(1.0E-130), new BigDecimal(1.0E125), new BigDecimal(-1.0E124), new BigDecimal("12345678901234567890123456789012"), new BigDecimal("1.2345678901234567890123456789012")};
        String string2 = "INSERT INTO doubletab VALUES (?, ?)";
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        String string3 = "SELECT doubleVal FROM doubletab";
        PreparedStatement preparedStatement2 = this.prepareStatement(string3);
        String string4 = "DELETE FROM doubletab";
        PreparedStatement preparedStatement3 = this.prepareStatement(string4);
        for (int i = 0; i < bigDecimalArray.length; ++i) {
            BigDecimal bigDecimal = bigDecimalArray[i];
            preparedStatement.setInt(1, i);
            preparedStatement.setObject(2, (Object)bigDecimal, 8);
            PrepareStatementTest.assertUpdateCount(preparedStatement, 1);
            ResultSet resultSet = preparedStatement2.executeQuery();
            resultSet.next();
            PrepareStatementTest.assertEquals((double)bigDecimal.doubleValue(), (double)resultSet.getDouble(1), (double)0.0);
            resultSet.close();
            PrepareStatementTest.assertUpdateCount(preparedStatement3, 1);
        }
        preparedStatement.close();
        preparedStatement2.close();
        preparedStatement3.close();
        this.commit();
    }

    public void testBigDecimalSetObjectWithScale() throws Exception {
        this.getConnection().setAutoCommit(false);
        String string = "CREATE TABLE numtab (num NUMERIC(10,6))";
        Statement statement = this.createStatement();
        PrepareStatementTest.assertUpdateCount(statement, 0, string);
        statement.close();
        this.commit();
        BigDecimal bigDecimal = new BigDecimal("2.33333333");
        string = "INSERT INTO  numtab  VALUES(?)";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        int n = 2;
        preparedStatement.setObject(1, (Object)bigDecimal, 3, n);
        PrepareStatementTest.assertUpdateCount(preparedStatement, 1);
        preparedStatement.close();
        string = "SELECT num FROM numtab";
        statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        BigDecimal bigDecimal2 = bigDecimal.setScale(n, RoundingMode.DOWN);
        BigDecimal bigDecimal3 = (BigDecimal)resultSet.getObject(1);
        PrepareStatementTest.assertEquals((String)("Actual value: " + bigDecimal3 + "does not match expected value: " + bigDecimal2), (int)bigDecimal2.compareTo(bigDecimal3), (int)0);
        resultSet.close();
        statement.close();
        this.commit();
    }

    public void testVaryingClientParameterTypeBatch() throws Exception {
        Statement statement = this.createStatement();
        String string = "create table varcharclobtab (c1 varchar(100), c2 clob)";
        PrepareStatementTest.assertUpdateCount(statement, 0, string);
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("insert into varcharclobtab VALUES(?,?)");
        preparedStatement.setNull(1, 12);
        preparedStatement.setString(2, "clob");
        preparedStatement.addBatch();
        preparedStatement.setString(1, "varchar");
        preparedStatement.setNull(2, 2005);
        preparedStatement.addBatch();
        preparedStatement.executeBatch();
        preparedStatement.close();
    }

    public void testSmallBigDecimal() throws Exception {
        Statement statement = this.createStatement();
        String string = "create table Numeric_Tab (MAX_VAL NUMERIC(30,15), MIN_VAL NUMERIC(30,15), NULL_VAL NUMERIC(30,15) DEFAULT NULL)";
        PrepareStatementTest.assertUpdateCount(statement, 0, string);
        String string2 = "insert into Numeric_Tab values(999999999999999, 0.000000000000001, null)";
        PrepareStatementTest.assertUpdateCount(statement, 1, string2);
        String string3 = "0.000000000000001";
        BigDecimal bigDecimal = new BigDecimal(string3);
        String string4 = "update Numeric_Tab set NULL_VAL=?";
        PreparedStatement preparedStatement = this.prepareStatement(string4);
        preparedStatement.setObject(1, bigDecimal);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        String string5 = "Select NULL_VAL from Numeric_Tab";
        ResultSet resultSet = statement.executeQuery(string5);
        resultSet.next();
        BigDecimal bigDecimal2 = (BigDecimal)resultSet.getObject(1);
        PrepareStatementTest.assertEquals((Object)bigDecimal2, (Object)bigDecimal);
        resultSet.close();
        statement.close();
    }

    public void testManyPreparedStatements() throws Exception {
        int n;
        int n2 = 500;
        PreparedStatement[] preparedStatementArray = new PreparedStatement[n2];
        for (n = 0; n < n2; ++n) {
            preparedStatementArray[n] = this.getConnection().prepareStatement("SELECT COUNT(*) from SYS.SYSTABLES", 1004, 1007);
            ResultSet resultSet = preparedStatementArray[n].executeQuery();
            resultSet.close();
        }
        for (n = 0; n < n2; ++n) {
            preparedStatementArray[n].close();
        }
    }

    public void testInvalidTimestamp() throws Exception {
        Statement statement = this.createStatement();
        PrepareStatementTest.assertUpdateCount(statement, 0, "CREATE TABLE TSTAB (I int, STATUS_TS  Timestamp,  PROPERTY_TS Timestamp)");
        PrepareStatementTest.assertUpdateCount(statement, 1, "INSERT INTO TSTAB VALUES(1 , '2003-08-15 21:20:00',       '2003-08-15 21:20:00')");
        PrepareStatementTest.assertUpdateCount(statement, 1, "INSERT INTO TSTAB VALUES(2 ,'1969-12-31 16:00:00.0',       '2003-08-15 21:20:00')");
        statement.close();
        String string = "20";
        String string2 = "select STATUS_TS from TSTAB where  (STATUS_TS >= ? or PROPERTY_TS < ?)";
        PreparedStatement preparedStatement = this.prepareStatement(string2);
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setString(2, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.close();
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("22007", sQLException);
        }
        preparedStatement.close();
    }

    public void testSplitQRYDTABlock() throws Exception {
        PreparedStatement preparedStatement = this.prepareStatement("create table jira614 (c1 varchar(10000))");
        PrepareStatementTest.assertUpdateCount(preparedStatement, 0);
        preparedStatement.close();
        String string = Formatters.repeatChar("a", 150);
        preparedStatement = this.prepareStatement("insert into jira614 values (?)");
        preparedStatement.setString(1, string);
        for (int i = 0; i < 210; ++i) {
            preparedStatement.executeUpdate();
        }
        string = Formatters.repeatChar("b", 10000);
        preparedStatement.setString(1, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        preparedStatement = this.prepareStatement("select * from jira614");
        ResultSet resultSet = preparedStatement.executeQuery();
        int n = 0;
        while (resultSet.next() && ++n != 26) {
        }
        resultSet.close();
        preparedStatement.close();
        Statement statement = this.createStatement();
        statement.execute("create table jira614_a (c1 int)");
        preparedStatement = this.prepareStatement("insert into jira614_a values (?)");
        for (int i = 1; i <= 5; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        resultSet = statement.executeQuery("select * from jira614");
        n = 0;
        while (resultSet.next() && ++n != 26) {
        }
        statement.close();
        statement = this.createStatement();
        resultSet = statement.executeQuery("select * from jira614_a");
        while (resultSet.next()) {
        }
        preparedStatement.close();
        resultSet.close();
        statement.close();
    }

    public void testExcpetionWithBigParameter() throws Exception {
        char[] cArray = new char[1000000];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Character.forDigit(i % 10, 10);
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = this.prepareStatement("insert into jira170 values (?)");
            preparedStatement.setString(1, new String(cArray));
            preparedStatement.execute();
            preparedStatement.close();
            PrepareStatementTest.fail((String)"No exception when executing a failed prepare with an enormous parameter");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("42X05", sQLException);
        }
    }

    public void testLargeReplies() throws Exception {
        this.jira125Test_a();
        this.jira125Test_b();
    }

    private void jira125Test_a() throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 49; ++i) {
            stringBuffer.append("id");
        }
        stringBuffer.append("i");
        StringBuffer stringBuffer2 = new StringBuffer("jira");
        for (int i = 0; i < 31; ++i) {
            stringBuffer2.append("125");
        }
        Statement statement = this.createStatement();
        statement.execute("create table " + stringBuffer2.toString() + " (" + stringBuffer.toString() + " integer)");
        statement.execute("insert into " + stringBuffer2.toString() + " values 1, 2, 3");
        statement.close();
        StringBuffer stringBuffer3 = new StringBuffer();
        stringBuffer3.append("SELECT " + stringBuffer.toString() + " FROM " + stringBuffer2.toString() + " WHERE " + stringBuffer.toString() + " IN ( ");
        int n = 554;
        for (int i = 0; i < n; ++i) {
            stringBuffer3.append("?,");
        }
        stringBuffer3.append("?)");
        PreparedStatement preparedStatement = this.prepareStatement(stringBuffer3.toString());
        for (int i = 0; i <= n; ++i) {
            preparedStatement.setInt(i + 1, 1);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void jira125Test_b() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table jira125 (id integer)");
        statement.execute("insert into jira125 values 1, 2, 3");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT id FROM jira125 WHERE id IN ( ");
        int n = 556;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("?,");
        }
        stringBuffer.append("?)");
        PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
        for (int i = 0; i <= n; ++i) {
            preparedStatement.setInt(i + 1, 1);
        }
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
        }
        resultSet.close();
        preparedStatement.close();
    }

    public void testAlternatingLobValuesAndNull() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table tt1 (CLICOL01 smallint not null)");
        statement.execute("alter table tt1 add clicol02 smallint");
        statement.execute("alter table tt1 add clicol03 int not null default 1");
        statement.execute("alter table tt1 add clicol04 int");
        statement.execute("alter table tt1 add clicol05 decimal(10,0) not null default 1");
        statement.execute("alter table tt1 add clicol51 blob(1G)");
        statement.execute("alter table tt1 add clicol52 blob(50)");
        statement.execute("alter table tt1 add clicol53 clob(2G) not null default ''");
        statement.execute("alter table tt1 add clicol54 clob(60)");
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("insert into tt1 values (?,?,?,?,?,?,?,?,?)");
        preparedStatement.setShort(1, (short)500);
        preparedStatement.setShort(2, (short)501);
        preparedStatement.setInt(3, 496);
        preparedStatement.setInt(4, 497);
        preparedStatement.setDouble(5, 484.0);
        preparedStatement.setBytes(6, "404 bit".getBytes());
        preparedStatement.setBytes(7, "405 bit".getBytes());
        preparedStatement.setString(8, "408 bit");
        preparedStatement.setString(9, "409 bit");
        PrepareStatementTest.assertUpdateCount(preparedStatement, 1);
        preparedStatement.setNull(2, 5);
        preparedStatement.setNull(4, 8);
        preparedStatement.setNull(7, 2004);
        preparedStatement.setNull(9, 2005);
        PrepareStatementTest.assertUpdateCount(preparedStatement, 1);
        ResultSet resultSet = statement.executeQuery("select * from tt1");
        resultSet.next();
        preparedStatement.setShort(1, resultSet.getShort(1));
        preparedStatement.setShort(2, resultSet.getShort(2));
        preparedStatement.setInt(3, resultSet.getInt(3));
        preparedStatement.setInt(4, resultSet.getInt(4));
        preparedStatement.setDouble(5, resultSet.getDouble(5));
        preparedStatement.setBlob(6, resultSet.getBlob(6));
        preparedStatement.setBlob(7, resultSet.getBlob(7));
        preparedStatement.setClob(8, resultSet.getClob(8));
        preparedStatement.setClob(9, resultSet.getClob(9));
        preparedStatement.execute();
        resultSet.next();
        preparedStatement.setNull(2, 5);
        preparedStatement.setNull(4, 8);
        preparedStatement.setBlob(6, resultSet.getBlob(6));
        preparedStatement.setNull(7, 2004);
        preparedStatement.setClob(8, resultSet.getClob(8));
        preparedStatement.setNull(9, 2005);
        preparedStatement.execute();
        resultSet.close();
        preparedStatement.close();
        this.commit();
    }

    public void testLargeBatch() throws Exception {
        int n;
        Statement statement = this.createStatement();
        statement.execute("create table jira428 (i integer)");
        this.getConnection().setAutoCommit(false);
        PreparedStatement preparedStatement = this.prepareStatement("insert into jira428 values (?)");
        for (n = 0; n < 32765; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.addBatch();
        }
        preparedStatement.executeBatch();
        preparedStatement.close();
        this.commit();
        preparedStatement = this.prepareStatement("insert into jira428 values (?)");
        for (n = 0; n < 100000; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.addBatch();
        }
        try {
            preparedStatement.executeBatch();
            PrepareStatementTest.assertFalse((String)"Expected exception when >65534 statements per batch", (boolean)PrepareStatementTest.usingDerbyNetClient());
        }
        catch (BatchUpdateException batchUpdateException) {
            PrepareStatementTest.assertSQLState("XJ116", batchUpdateException);
            PrepareStatementTest.assertFalse((String)"Unexpected exception in embedded framework", (boolean)PrepareStatementTest.usingEmbedded());
        }
        preparedStatement.close();
        this.commit();
    }

    public void testDSSLength() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table jira1454(c1 varchar(20000), c2 varchar(30000))");
        statement.close();
        this.tickleDSSLength(12748);
        this.tickleDSSLength(12750);
        this.tickleDSSLength(12749);
    }

    private void tickleDSSLength(int n) throws Exception {
        char[] cArray = new char[20000];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = Character.forDigit(i % 10, 10);
        }
        char[] cArray2 = new char[30000];
        for (int i = 0; i < n; ++i) {
            cArray2[i] = Character.forDigit(i % 10, 10);
        }
        PreparedStatement preparedStatement = this.prepareStatement("insert into jira1454 values (?,?)");
        preparedStatement.setString(1, new String(cArray));
        preparedStatement.setString(2, new String(cArray2, 0, n));
        preparedStatement.execute();
        preparedStatement.close();
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from jira1454");
        while (resultSet.next()) {
            PrepareStatementTest.assertEquals((int)resultSet.getString("c2").length(), (int)n);
        }
        resultSet.close();
        statement.execute("delete from jira1454");
        statement.close();
    }

    public void testVariationOfSetObject() throws Exception {
        Statement statement = this.createStatement();
        String string = "CREATE TABLE WISH_LIST  (WISH_ID INT NOT NULL GENERATED ALWAYS AS IDENTITY    CONSTRAINT WISH_PK PRIMARY KEY,  ENTRY_DATE TIMESTAMP DEFAULT CURRENT_TIMESTAMP,  WISH_ITEM VARCHAR(32) NOT NULL) ";
        statement.executeUpdate(string);
        PreparedStatement preparedStatement = this.prepareStatement("insert into WISH_LIST(WISH_ITEM) values (?)");
        preparedStatement.setString(1, "aaa");
        preparedStatement.executeUpdate();
        preparedStatement = this.prepareStatement("insert into WISH_LIST(WISH_ITEM) values ('bb')");
        try {
            preparedStatement.setString(1, "aaa");
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            if (PrepareStatementTest.usingDerbyNetClient()) {
                PrepareStatementTest.assertSQLState("XCL14", sQLException);
            }
            PrepareStatementTest.assertSQLState("07009", sQLException);
        }
        try {
            preparedStatement.setObject(1, (Object)"cc", 12);
            PrepareStatementTest.fail((String)"Exception expected above!");
        }
        catch (SQLException sQLException) {
            PrepareStatementTest.assertSQLState("07009", sQLException);
        }
    }

    public void testLargeParameters_a() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table jira1533_a (aa BIGINT NOT NULL, bbbbbb BIGINT DEFAULT 0 NOT NULL,cccc  VARCHAR(40), ddddddddddd BIGINT, eeeeee VARCHAR(128), ffffffffffffffffff VARCHAR(128),ggggggggg  BLOB(2G), hhhhhhhhh VARCHAR(128), iiiiiiii VARCHAR(128), jjjjjjjjjjjjjj BIGINT,kkkkkkkk CHAR(1) DEFAULT 'f', llllllll CHAR(1) DEFAULT 'f', mmmmmmmmmmmmm  CHAR(1) DEFAULT 'f')");
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO jira1533_a (aa, bbbbbb, cccc, ddddddddddd, eeeeee,                      ffffffffffffffffff,                      ggggggggg, hhhhhhhhh, iiiiiiii,                       jjjjjjjjjjjjjj, kkkkkkkk,                      llllllll,mmmmmmmmmmmmm)          VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String string = PrepareStatementTest.makeString(32584);
        preparedStatement.setLong(1, 5L);
        preparedStatement.setLong(2, 1L);
        preparedStatement.setString(3, "AAAAAAAAAAA");
        preparedStatement.setLong(4, 30000L);
        preparedStatement.setString(5, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        preparedStatement.setString(6, "AAAAAAAAAAA");
        preparedStatement.setBytes(7, string.getBytes());
        preparedStatement.setString(8, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        preparedStatement.setString(9, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        preparedStatement.setLong(10, 1L);
        preparedStatement.setString(11, "1");
        preparedStatement.setString(12, "1");
        preparedStatement.setString(13, "1");
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void testLargeParameters_b() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table jira1533_b (aa BIGINT NOT NULL, bbbbbb BIGINT DEFAULT 0 NOT NULL, cccc VARCHAR(40), ddddddddddd BIGINT, eeeeee VARCHAR(128), ffffffffffffffffff VARCHAR(128), g1 BLOB(2G), g2 BLOB(2G), g3 BLOB(2G), g4 BLOB(2G), ggggggggg  BLOB(2G), hhhhhhhhh VARCHAR(128), iiiiiiii VARCHAR(128), jjjjjjjjjjjjjj BIGINT,kkkkkkkk CHAR(1) DEFAULT 'f', llllllll CHAR(1) DEFAULT 'f', mmmmmmmmmmmmm  CHAR(1) DEFAULT 'f')");
        statement.close();
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO jira1533_b (aa, bbbbbb, cccc, ddddddddddd, eeeeee,                      ffffffffffffffffff,                      g1, g2, g3, g4,                      ggggggggg, hhhhhhhhh, iiiiiiii,                      jjjjjjjjjjjjjj, kkkkkkkk,                      llllllll,mmmmmmmmmmmmm)          VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        String string = PrepareStatementTest.makeString(32584);
        preparedStatement.setLong(1, 5L);
        preparedStatement.setLong(2, 1L);
        preparedStatement.setString(3, "AAAAAAAAAAA");
        preparedStatement.setLong(4, 30000L);
        preparedStatement.setString(5, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        preparedStatement.setString(6, "AAAAAAAAAAA");
        preparedStatement.setBytes(7, string.getBytes());
        preparedStatement.setBytes(8, string.getBytes());
        preparedStatement.setBytes(9, string.getBytes());
        preparedStatement.setBytes(10, string.getBytes());
        preparedStatement.setBytes(11, string.getBytes());
        preparedStatement.setString(12, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        preparedStatement.setString(13, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA");
        preparedStatement.setLong(14, 1L);
        preparedStatement.setString(15, "1");
        preparedStatement.setString(16, "1");
        preparedStatement.setString(17, "1");
        preparedStatement.execute();
        preparedStatement.close();
    }

    public void testDerby3230() throws SQLException {
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE TAB (col1 varchar(32672) NOT NULL)");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO TAB VALUES(?)");
        preparedStatement.setString(1, PrepareStatementTest.makeString(15000));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(7500));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(5000));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(2000));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(1600));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(800));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(400));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(200));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(100));
        preparedStatement.executeUpdate();
        preparedStatement.setString(1, PrepareStatementTest.makeString(56));
        preparedStatement.executeUpdate();
        ResultSet resultSet = statement.executeQuery("SELECT * from tab");
        JDBC.assertDrainResults(resultSet);
    }

    private static String makeString(int n) {
        return PrepareStatementTest.makeString(n, 'X');
    }

    private static String makeString(int n, char c) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public void testReadBlobCloseToMaxDssLength() throws Exception {
        DataInputStream dataInputStream = new DataInputStream(new LoopingAlphabetStream(32766L));
        byte[] byArray = new byte[32766];
        dataInputStream.readFully(byArray);
        PreparedStatement preparedStatement = this.prepareStatement("values cast(? as blob)");
        preparedStatement.setBytes(1, byArray);
        ResultSet resultSet = preparedStatement.executeQuery();
        PrepareStatementTest.assertTrue((String)"empty result set", (boolean)resultSet.next());
        InputStream inputStream = resultSet.getBinaryStream(1);
        PrepareStatementTest.assertEquals(new LoopingAlphabetStream(32766L), inputStream);
        PrepareStatementTest.assertFalse((String)"too many rows", (boolean)resultSet.next());
        resultSet.close();
    }

    public void testLongColumn() throws Exception {
        AutoCloseable autoCloseable;
        Object object;
        Object object2;
        Object object3;
        PreparedStatement preparedStatement = this.prepareStatement("values cast(? as varchar(32672))");
        String string = PrepareStatementTest.makeString(20000, '\u4e10');
        preparedStatement.setString(1, string);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string);
        String string2 = string + PrepareStatementTest.makeString(65536 - string.getBytes("UTF-8").length - 1);
        preparedStatement.setString(1, string2);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string2);
        String string3 = string2 + "X";
        preparedStatement.setString(1, string3);
        if (PrepareStatementTest.usingDerbyNetClient()) {
            object3 = string3.substring(0, string3.length() - 1);
            object2 = preparedStatement.executeQuery();
            PrepareStatementTest.assertTrue((String)"Empty result", (boolean)object2.next());
            PrepareStatementTest.assertDataTruncation(new String[]{object3}, new String[]{object2.getString(1)}, 1, false, true, string3.length(), ((String)object3).length(), object2.getWarnings());
            PrepareStatementTest.assertFalse((String)"Too many rows", (boolean)object2.next());
            object2.close();
        } else {
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), string3);
        }
        object3 = string3.substring(0, string3.length() - 2) + "\u4e10";
        preparedStatement.setString(1, (String)object3);
        if (PrepareStatementTest.usingDerbyNetClient()) {
            object2 = ((String)object3).substring(0, ((String)object3).length() - 1);
            object = preparedStatement.executeQuery();
            PrepareStatementTest.assertTrue((String)"Empty result", (boolean)object.next());
            PrepareStatementTest.assertDataTruncation(new String[]{object2}, new String[]{object.getString(1)}, 1, false, true, ((String)object3).length(), ((String)object2).length(), object.getWarnings());
            PrepareStatementTest.assertFalse((String)"Too many rows", (boolean)object.next());
            object.close();
        } else {
            JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), (String)object3);
        }
        object2 = this.prepareStatement("values (cast(? as varchar(32672)), cast(? as varchar(32672)))");
        object2.setString(1, (String)object3);
        object2.setString(2, (String)object3);
        if (PrepareStatementTest.usingDerbyNetClient()) {
            object = ((String)object3).substring(0, ((String)object3).length() - 1);
            autoCloseable = object2.executeQuery();
            PrepareStatementTest.assertTrue((String)"Empty result", (boolean)autoCloseable.next());
            PrepareStatementTest.assertDataTruncation(new String[]{object, object}, new String[]{autoCloseable.getString(1), autoCloseable.getString(2)}, 1, false, true, ((String)object3).length(), ((String)object).length(), autoCloseable.getWarnings());
            PrepareStatementTest.assertFalse((String)"Too many rows", (boolean)autoCloseable.next());
            autoCloseable.close();
        } else {
            object = new String[][]{{object3, object3}};
            JDBC.assertFullResultSet(object2.executeQuery(), (String[][])object);
        }
        object = this.createStatement();
        object.execute("create procedure derby_5236_proc(in x varchar(32672), out y varchar(32672))language java parameter style java external name '" + ((Object)((Object)this)).getClass().getName() + ".copyString'");
        autoCloseable = this.prepareCall("call derby_5236_proc(?,?)");
        autoCloseable.setString(1, string3);
        autoCloseable.registerOutParameter(2, 12);
        autoCloseable.execute();
        if (PrepareStatementTest.usingDerbyNetClient()) {
            PrepareStatementTest.assertDataTruncation(new String[]{string3.substring(0, string3.length() - 1)}, new String[]{autoCloseable.getString(2)}, 2, true, true, string3.length(), string3.length() - 1, autoCloseable.getWarnings());
        } else {
            PrepareStatementTest.assertEquals((String)string3, (String)autoCloseable.getString(2));
        }
    }

    public static void copyString(String string, String[] stringArray) {
        stringArray[0] = string;
    }

    private static void assertDataTruncation(String[] stringArray, String[] stringArray2, int n, boolean bl, boolean bl2, int n2, int n3, SQLWarning sQLWarning) {
        PrepareStatementTest.assertEquals((String)"Wrong number of columns", (int)stringArray.length, (int)stringArray2.length);
        PrepareStatementTest.assertNotNull((String)"Expected data truncation warning", (Object)sQLWarning);
        for (int i = 0; i < stringArray.length; ++i) {
            PrepareStatementTest.assertEquals((String)("column #" + (i + 1)), (String)stringArray[i], (String)stringArray2[i]);
            if (sQLWarning instanceof DataTruncation) {
                DataTruncation dataTruncation = (DataTruncation)sQLWarning;
                PrepareStatementTest.assertEquals((String)"index", (int)n, (int)dataTruncation.getIndex());
                PrepareStatementTest.assertEquals((String)"parameter", (boolean)bl, (boolean)dataTruncation.getParameter());
                PrepareStatementTest.assertEquals((String)"read", (boolean)bl2, (boolean)dataTruncation.getRead());
                PrepareStatementTest.assertEquals((String)"dataSize", (int)n2, (int)dataTruncation.getDataSize());
                PrepareStatementTest.assertEquals((String)"transferSize", (int)n3, (int)dataTruncation.getTransferSize());
            } else {
                PrepareStatementTest.fail("Unexpected warning", sQLWarning);
            }
            PrepareStatementTest.assertNull((String)"Chained warnings not expected on network client", (Object)sQLWarning.getNextWarning());
        }
    }
}

