/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import org.apache.derby.impl.drda.DDMWriter;

final class DRDAString {
    private byte[] buffer = new byte[0];
    private final DDMWriter writer;
    private boolean modified;
    private String cachedString;

    DRDAString(DDMWriter dDMWriter) {
        this.writer = dDMWriter;
        this.cachedString = null;
    }

    private boolean equalTo(byte[] byArray, int n, int n2) {
        int n3 = this.buffer.length;
        if (n3 != n2) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (this.buffer[i] == byArray[i + n]) continue;
            return false;
        }
        return true;
    }

    public void setBytes(byte[] byArray, int n, int n2) {
        if (this.equalTo(byArray, n, n2)) {
            this.modified = false;
            return;
        }
        if (this.buffer.length != n2) {
            this.buffer = new byte[n2];
        }
        System.arraycopy(byArray, n, this.buffer, 0, n2);
        this.modified = true;
        this.cachedString = null;
    }

    public boolean wasModified() {
        return this.modified;
    }

    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.writer.getCurrentCcsidManager().convertToJavaString(this.buffer);
        }
        return this.cachedString;
    }

    public int length() {
        return this.buffer.length;
    }

    public byte[] getBytes() {
        return this.buffer;
    }
}

