/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.pipespec.integration.template.Spec;
import org.apache.camel.v1.pipespec.integration.template.spec.Containers;
import org.apache.camel.v1.pipespec.integration.template.spec.ContainersBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.ContainersFluent;
import org.apache.camel.v1.pipespec.integration.template.spec.EphemeralContainers;
import org.apache.camel.v1.pipespec.integration.template.spec.EphemeralContainersBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.EphemeralContainersFluent;
import org.apache.camel.v1.pipespec.integration.template.spec.InitContainers;
import org.apache.camel.v1.pipespec.integration.template.spec.InitContainersBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.InitContainersFluent;
import org.apache.camel.v1.pipespec.integration.template.spec.SecurityContext;
import org.apache.camel.v1.pipespec.integration.template.spec.SecurityContextBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.SecurityContextFluent;
import org.apache.camel.v1.pipespec.integration.template.spec.TopologySpreadConstraints;
import org.apache.camel.v1.pipespec.integration.template.spec.TopologySpreadConstraintsBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.TopologySpreadConstraintsFluent;
import org.apache.camel.v1.pipespec.integration.template.spec.Volumes;
import org.apache.camel.v1.pipespec.integration.template.spec.VolumesBuilder;
import org.apache.camel.v1.pipespec.integration.template.spec.VolumesFluent;

public class SpecFluent<A extends SpecFluent<A>>
extends BaseFluent<A> {
    private Long activeDeadlineSeconds;
    private ArrayList<ContainersBuilder> containers;
    private String dnsPolicy;
    private ArrayList<EphemeralContainersBuilder> ephemeralContainers;
    private ArrayList<InitContainersBuilder> initContainers;
    private Map<String, String> nodeSelector;
    private String restartPolicy;
    private SecurityContextBuilder securityContext;
    private Long terminationGracePeriodSeconds;
    private ArrayList<TopologySpreadConstraintsBuilder> topologySpreadConstraints;
    private ArrayList<VolumesBuilder> volumes;

    public SpecFluent() {
    }

    public SpecFluent(Spec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Spec instance) {
        Spec spec = instance = instance != null ? instance : new Spec();
        if (instance != null) {
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withContainers(instance.getContainers());
            this.withDnsPolicy(instance.getDnsPolicy());
            this.withEphemeralContainers(instance.getEphemeralContainers());
            this.withInitContainers(instance.getInitContainers());
            this.withNodeSelector(instance.getNodeSelector());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withSecurityContext(instance.getSecurityContext());
            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
            this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
            this.withVolumes(instance.getVolumes());
        }
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)((Object)this);
    }

    public boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public A addToContainers(int index, Containers item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainersBuilder builder = new ContainersBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(index, builder);
            this.containers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContainers(int index, Containers item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainersBuilder builder = new ContainersBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").set(index, builder);
            this.containers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContainers(Containers ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Containers item : items) {
            ContainersBuilder builder = new ContainersBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationContainers(Collection<Containers> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Containers item : items) {
            ContainersBuilder builder = new ContainersBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContainers(Containers ... items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (Containers item : items) {
            ContainersBuilder builder = new ContainersBuilder(item);
            this._visitables.get((Object)"containers").remove((Object)builder);
            this.containers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationContainers(Collection<Containers> items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (Containers item : items) {
            ContainersBuilder builder = new ContainersBuilder(item);
            this._visitables.get((Object)"containers").remove((Object)builder);
            this.containers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationContainers(Predicate<ContainersBuilder> predicate) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        Iterator<ContainersBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Containers> buildContainers() {
        return this.containers != null ? SpecFluent.build(this.containers) : null;
    }

    public Containers buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Containers buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Containers buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public Containers buildMatchingContainer(Predicate<ContainersBuilder> predicate) {
        for (ContainersBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<ContainersBuilder> predicate) {
        for (ContainersBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainers(List<Containers> containers) {
        if (this.containers != null) {
            this._visitables.get((Object)"containers").clear();
        }
        if (containers != null) {
            this.containers = new ArrayList();
            for (Containers item : containers) {
                this.addToContainers(item);
            }
        } else {
            this.containers = null;
        }
        return (A)((Object)this);
    }

    public A withContainers(Containers ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove((Object)"containers");
        }
        if (containers != null) {
            for (Containers item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(Containers item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, Containers item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<ContainersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public String getDnsPolicy() {
        return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy) {
        this.dnsPolicy = dnsPolicy;
        return (A)((Object)this);
    }

    public boolean hasDnsPolicy() {
        return this.dnsPolicy != null;
    }

    public A addToEphemeralContainers(int index, EphemeralContainers item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        EphemeralContainersBuilder builder = new EphemeralContainersBuilder(item);
        if (index < 0 || index >= this.ephemeralContainers.size()) {
            this._visitables.get((Object)"ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        } else {
            this._visitables.get((Object)"ephemeralContainers").add(index, builder);
            this.ephemeralContainers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEphemeralContainers(int index, EphemeralContainers item) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        EphemeralContainersBuilder builder = new EphemeralContainersBuilder(item);
        if (index < 0 || index >= this.ephemeralContainers.size()) {
            this._visitables.get((Object)"ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        } else {
            this._visitables.get((Object)"ephemeralContainers").set(index, builder);
            this.ephemeralContainers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEphemeralContainers(EphemeralContainers ... items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        for (EphemeralContainers item : items) {
            EphemeralContainersBuilder builder = new EphemeralContainersBuilder(item);
            this._visitables.get((Object)"ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationEphemeralContainers(Collection<EphemeralContainers> items) {
        if (this.ephemeralContainers == null) {
            this.ephemeralContainers = new ArrayList();
        }
        for (EphemeralContainers item : items) {
            EphemeralContainersBuilder builder = new EphemeralContainersBuilder(item);
            this._visitables.get((Object)"ephemeralContainers").add(builder);
            this.ephemeralContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEphemeralContainers(EphemeralContainers ... items) {
        if (this.ephemeralContainers == null) {
            return (A)((Object)this);
        }
        for (EphemeralContainers item : items) {
            EphemeralContainersBuilder builder = new EphemeralContainersBuilder(item);
            this._visitables.get((Object)"ephemeralContainers").remove((Object)builder);
            this.ephemeralContainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationEphemeralContainers(Collection<EphemeralContainers> items) {
        if (this.ephemeralContainers == null) {
            return (A)((Object)this);
        }
        for (EphemeralContainers item : items) {
            EphemeralContainersBuilder builder = new EphemeralContainersBuilder(item);
            this._visitables.get((Object)"ephemeralContainers").remove((Object)builder);
            this.ephemeralContainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationEphemeralContainers(Predicate<EphemeralContainersBuilder> predicate) {
        if (this.ephemeralContainers == null) {
            return (A)((Object)this);
        }
        Iterator<EphemeralContainersBuilder> each = this.ephemeralContainers.iterator();
        List visitables = this._visitables.get((Object)"ephemeralContainers");
        while (each.hasNext()) {
            EphemeralContainersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<EphemeralContainers> buildEphemeralContainers() {
        return this.ephemeralContainers != null ? SpecFluent.build(this.ephemeralContainers) : null;
    }

    public EphemeralContainers buildEphemeralContainer(int index) {
        return this.ephemeralContainers.get(index).build();
    }

    public EphemeralContainers buildFirstEphemeralContainer() {
        return this.ephemeralContainers.get(0).build();
    }

    public EphemeralContainers buildLastEphemeralContainer() {
        return this.ephemeralContainers.get(this.ephemeralContainers.size() - 1).build();
    }

    public EphemeralContainers buildMatchingEphemeralContainer(Predicate<EphemeralContainersBuilder> predicate) {
        for (EphemeralContainersBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEphemeralContainer(Predicate<EphemeralContainersBuilder> predicate) {
        for (EphemeralContainersBuilder item : this.ephemeralContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEphemeralContainers(List<EphemeralContainers> ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this._visitables.get((Object)"ephemeralContainers").clear();
        }
        if (ephemeralContainers != null) {
            this.ephemeralContainers = new ArrayList();
            for (EphemeralContainers item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        } else {
            this.ephemeralContainers = null;
        }
        return (A)((Object)this);
    }

    public A withEphemeralContainers(EphemeralContainers ... ephemeralContainers) {
        if (this.ephemeralContainers != null) {
            this.ephemeralContainers.clear();
            this._visitables.remove((Object)"ephemeralContainers");
        }
        if (ephemeralContainers != null) {
            for (EphemeralContainers item : ephemeralContainers) {
                this.addToEphemeralContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEphemeralContainers() {
        return this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty();
    }

    public EphemeralContainersNested<A> addNewEphemeralContainer() {
        return new EphemeralContainersNested(-1, null);
    }

    public EphemeralContainersNested<A> addNewEphemeralContainerLike(EphemeralContainers item) {
        return new EphemeralContainersNested(-1, item);
    }

    public EphemeralContainersNested<A> setNewEphemeralContainerLike(int index, EphemeralContainers item) {
        return new EphemeralContainersNested(index, item);
    }

    public EphemeralContainersNested<A> editEphemeralContainer(int index) {
        if (this.ephemeralContainers.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainers. Index exceeds size.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public EphemeralContainersNested<A> editFirstEphemeralContainer() {
        if (this.ephemeralContainers.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(0, this.buildEphemeralContainer(0));
    }

    public EphemeralContainersNested<A> editLastEphemeralContainer() {
        int index = this.ephemeralContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainers. The list is empty.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public EphemeralContainersNested<A> editMatchingEphemeralContainer(Predicate<EphemeralContainersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainers.size(); ++i) {
            if (!predicate.test(this.ephemeralContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainers. No match found.");
        }
        return this.setNewEphemeralContainerLike(index, this.buildEphemeralContainer(index));
    }

    public A addToInitContainers(int index, InitContainers item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        InitContainersBuilder builder = new InitContainersBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").add(index, builder);
            this.initContainers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToInitContainers(int index, InitContainers item) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        InitContainersBuilder builder = new InitContainersBuilder(item);
        if (index < 0 || index >= this.initContainers.size()) {
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        } else {
            this._visitables.get((Object)"initContainers").set(index, builder);
            this.initContainers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToInitContainers(InitContainers ... items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (InitContainers item : items) {
            InitContainersBuilder builder = new InitContainersBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationInitContainers(Collection<InitContainers> items) {
        if (this.initContainers == null) {
            this.initContainers = new ArrayList();
        }
        for (InitContainers item : items) {
            InitContainersBuilder builder = new InitContainersBuilder(item);
            this._visitables.get((Object)"initContainers").add(builder);
            this.initContainers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromInitContainers(InitContainers ... items) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        for (InitContainers item : items) {
            InitContainersBuilder builder = new InitContainersBuilder(item);
            this._visitables.get((Object)"initContainers").remove((Object)builder);
            this.initContainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationInitContainers(Collection<InitContainers> items) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        for (InitContainers item : items) {
            InitContainersBuilder builder = new InitContainersBuilder(item);
            this._visitables.get((Object)"initContainers").remove((Object)builder);
            this.initContainers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationInitContainers(Predicate<InitContainersBuilder> predicate) {
        if (this.initContainers == null) {
            return (A)((Object)this);
        }
        Iterator<InitContainersBuilder> each = this.initContainers.iterator();
        List visitables = this._visitables.get((Object)"initContainers");
        while (each.hasNext()) {
            InitContainersBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<InitContainers> buildInitContainers() {
        return this.initContainers != null ? SpecFluent.build(this.initContainers) : null;
    }

    public InitContainers buildInitContainer(int index) {
        return this.initContainers.get(index).build();
    }

    public InitContainers buildFirstInitContainer() {
        return this.initContainers.get(0).build();
    }

    public InitContainers buildLastInitContainer() {
        return this.initContainers.get(this.initContainers.size() - 1).build();
    }

    public InitContainers buildMatchingInitContainer(Predicate<InitContainersBuilder> predicate) {
        for (InitContainersBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainer(Predicate<InitContainersBuilder> predicate) {
        for (InitContainersBuilder item : this.initContainers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainers(List<InitContainers> initContainers) {
        if (this.initContainers != null) {
            this._visitables.get((Object)"initContainers").clear();
        }
        if (initContainers != null) {
            this.initContainers = new ArrayList();
            for (InitContainers item : initContainers) {
                this.addToInitContainers(item);
            }
        } else {
            this.initContainers = null;
        }
        return (A)((Object)this);
    }

    public A withInitContainers(InitContainers ... initContainers) {
        if (this.initContainers != null) {
            this.initContainers.clear();
            this._visitables.remove((Object)"initContainers");
        }
        if (initContainers != null) {
            for (InitContainers item : initContainers) {
                this.addToInitContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasInitContainers() {
        return this.initContainers != null && !this.initContainers.isEmpty();
    }

    public InitContainersNested<A> addNewInitContainer() {
        return new InitContainersNested(-1, null);
    }

    public InitContainersNested<A> addNewInitContainerLike(InitContainers item) {
        return new InitContainersNested(-1, item);
    }

    public InitContainersNested<A> setNewInitContainerLike(int index, InitContainers item) {
        return new InitContainersNested(index, item);
    }

    public InitContainersNested<A> editInitContainer(int index) {
        if (this.initContainers.size() <= index) {
            throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editFirstInitContainer() {
        if (this.initContainers.size() == 0) {
            throw new RuntimeException("Can't edit first initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(0, this.buildInitContainer(0));
    }

    public InitContainersNested<A> editLastInitContainer() {
        int index = this.initContainers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainers. The list is empty.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public InitContainersNested<A> editMatchingInitContainer(Predicate<InitContainersBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainers.size(); ++i) {
            if (!predicate.test(this.initContainers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainers. No match found.");
        }
        return this.setNewInitContainerLike(index, this.buildInitContainer(index));
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)((Object)this);
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public SecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    public A withSecurityContext(SecurityContext securityContext) {
        this._visitables.remove((Object)"securityContext");
        if (securityContext != null) {
            this.securityContext = new SecurityContextBuilder(securityContext);
            this._visitables.get((Object)"securityContext").add(this.securityContext);
        } else {
            this.securityContext = null;
            this._visitables.get((Object)"securityContext").remove((Object)this.securityContext);
        }
        return (A)((Object)this);
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNested(null);
    }

    public SecurityContextNested<A> withNewSecurityContextLike(SecurityContext item) {
        return new SecurityContextNested(item);
    }

    public SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(null));
    }

    public SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(new SecurityContextBuilder().build()));
    }

    public SecurityContextNested<A> editOrNewSecurityContextLike(SecurityContext item) {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(item));
    }

    public Long getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
        return (A)((Object)this);
    }

    public boolean hasTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds != null;
    }

    public A addToTopologySpreadConstraints(int index, TopologySpreadConstraints item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        TopologySpreadConstraintsBuilder builder = new TopologySpreadConstraintsBuilder(item);
        if (index < 0 || index >= this.topologySpreadConstraints.size()) {
            this._visitables.get((Object)"topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        } else {
            this._visitables.get((Object)"topologySpreadConstraints").add(index, builder);
            this.topologySpreadConstraints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTopologySpreadConstraints(int index, TopologySpreadConstraints item) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        TopologySpreadConstraintsBuilder builder = new TopologySpreadConstraintsBuilder(item);
        if (index < 0 || index >= this.topologySpreadConstraints.size()) {
            this._visitables.get((Object)"topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        } else {
            this._visitables.get((Object)"topologySpreadConstraints").set(index, builder);
            this.topologySpreadConstraints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTopologySpreadConstraints(TopologySpreadConstraints ... items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        for (TopologySpreadConstraints item : items) {
            TopologySpreadConstraintsBuilder builder = new TopologySpreadConstraintsBuilder(item);
            this._visitables.get((Object)"topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationTopologySpreadConstraints(Collection<TopologySpreadConstraints> items) {
        if (this.topologySpreadConstraints == null) {
            this.topologySpreadConstraints = new ArrayList();
        }
        for (TopologySpreadConstraints item : items) {
            TopologySpreadConstraintsBuilder builder = new TopologySpreadConstraintsBuilder(item);
            this._visitables.get((Object)"topologySpreadConstraints").add(builder);
            this.topologySpreadConstraints.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTopologySpreadConstraints(TopologySpreadConstraints ... items) {
        if (this.topologySpreadConstraints == null) {
            return (A)((Object)this);
        }
        for (TopologySpreadConstraints item : items) {
            TopologySpreadConstraintsBuilder builder = new TopologySpreadConstraintsBuilder(item);
            this._visitables.get((Object)"topologySpreadConstraints").remove((Object)builder);
            this.topologySpreadConstraints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationTopologySpreadConstraints(Collection<TopologySpreadConstraints> items) {
        if (this.topologySpreadConstraints == null) {
            return (A)((Object)this);
        }
        for (TopologySpreadConstraints item : items) {
            TopologySpreadConstraintsBuilder builder = new TopologySpreadConstraintsBuilder(item);
            this._visitables.get((Object)"topologySpreadConstraints").remove((Object)builder);
            this.topologySpreadConstraints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationTopologySpreadConstraints(Predicate<TopologySpreadConstraintsBuilder> predicate) {
        if (this.topologySpreadConstraints == null) {
            return (A)((Object)this);
        }
        Iterator<TopologySpreadConstraintsBuilder> each = this.topologySpreadConstraints.iterator();
        List visitables = this._visitables.get((Object)"topologySpreadConstraints");
        while (each.hasNext()) {
            TopologySpreadConstraintsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TopologySpreadConstraints> buildTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null ? SpecFluent.build(this.topologySpreadConstraints) : null;
    }

    public TopologySpreadConstraints buildTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index).build();
    }

    public TopologySpreadConstraints buildFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0).build();
    }

    public TopologySpreadConstraints buildLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(this.topologySpreadConstraints.size() - 1).build();
    }

    public TopologySpreadConstraints buildMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintsBuilder> predicate) {
        for (TopologySpreadConstraintsBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintsBuilder> predicate) {
        for (TopologySpreadConstraintsBuilder item : this.topologySpreadConstraints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTopologySpreadConstraints(List<TopologySpreadConstraints> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this._visitables.get((Object)"topologySpreadConstraints").clear();
        }
        if (topologySpreadConstraints != null) {
            this.topologySpreadConstraints = new ArrayList();
            for (TopologySpreadConstraints item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        } else {
            this.topologySpreadConstraints = null;
        }
        return (A)((Object)this);
    }

    public A withTopologySpreadConstraints(TopologySpreadConstraints ... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {
            this.topologySpreadConstraints.clear();
            this._visitables.remove((Object)"topologySpreadConstraints");
        }
        if (topologySpreadConstraints != null) {
            for (TopologySpreadConstraints item : topologySpreadConstraints) {
                this.addToTopologySpreadConstraints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTopologySpreadConstraints() {
        return this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty();
    }

    public TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraint() {
        return new TopologySpreadConstraintsNested(-1, null);
    }

    public TopologySpreadConstraintsNested<A> addNewTopologySpreadConstraintLike(TopologySpreadConstraints item) {
        return new TopologySpreadConstraintsNested(-1, item);
    }

    public TopologySpreadConstraintsNested<A> setNewTopologySpreadConstraintLike(int index, TopologySpreadConstraints item) {
        return new TopologySpreadConstraintsNested(index, item);
    }

    public TopologySpreadConstraintsNested<A> editTopologySpreadConstraint(int index) {
        if (this.topologySpreadConstraints.size() <= index) {
            throw new RuntimeException("Can't edit topologySpreadConstraints. Index exceeds size.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public TopologySpreadConstraintsNested<A> editFirstTopologySpreadConstraint() {
        if (this.topologySpreadConstraints.size() == 0) {
            throw new RuntimeException("Can't edit first topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(0, this.buildTopologySpreadConstraint(0));
    }

    public TopologySpreadConstraintsNested<A> editLastTopologySpreadConstraint() {
        int index = this.topologySpreadConstraints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last topologySpreadConstraints. The list is empty.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public TopologySpreadConstraintsNested<A> editMatchingTopologySpreadConstraint(Predicate<TopologySpreadConstraintsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.topologySpreadConstraints.size(); ++i) {
            if (!predicate.test(this.topologySpreadConstraints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching topologySpreadConstraints. No match found.");
        }
        return this.setNewTopologySpreadConstraintLike(index, this.buildTopologySpreadConstraint(index));
    }

    public A addToVolumes(int index, Volumes item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumesBuilder builder = new VolumesBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").add(index, builder);
            this.volumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVolumes(int index, Volumes item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        VolumesBuilder builder = new VolumesBuilder(item);
        if (index < 0 || index >= this.volumes.size()) {
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
            this.volumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVolumes(Volumes ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volumes item : items) {
            VolumesBuilder builder = new VolumesBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationVolumes(Collection<Volumes> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (Volumes item : items) {
            VolumesBuilder builder = new VolumesBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVolumes(Volumes ... items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volumes item : items) {
            VolumesBuilder builder = new VolumesBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationVolumes(Collection<Volumes> items) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        for (Volumes item : items) {
            VolumesBuilder builder = new VolumesBuilder(item);
            this._visitables.get((Object)"volumes").remove((Object)builder);
            this.volumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationVolumes(Predicate<VolumesBuilder> predicate) {
        if (this.volumes == null) {
            return (A)((Object)this);
        }
        Iterator<VolumesBuilder> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VolumesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Volumes> buildVolumes() {
        return this.volumes != null ? SpecFluent.build(this.volumes) : null;
    }

    public Volumes buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volumes buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volumes buildLastVolume() {
        return this.volumes.get(this.volumes.size() - 1).build();
    }

    public Volumes buildMatchingVolume(Predicate<VolumesBuilder> predicate) {
        for (VolumesBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolume(Predicate<VolumesBuilder> predicate) {
        for (VolumesBuilder item : this.volumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumes(List<Volumes> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").clear();
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (Volumes item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)((Object)this);
    }

    public A withVolumes(Volumes ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
            this._visitables.remove((Object)"volumes");
        }
        if (volumes != null) {
            for (Volumes item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public VolumesNested<A> addNewVolume() {
        return new VolumesNested(-1, null);
    }

    public VolumesNested<A> addNewVolumeLike(Volumes item) {
        return new VolumesNested(-1, item);
    }

    public VolumesNested<A> setNewVolumeLike(int index, Volumes item) {
        return new VolumesNested(index, item);
    }

    public VolumesNested<A> editVolume(int index) {
        if (this.volumes.size() <= index) {
            throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editFirstVolume() {
        if (this.volumes.size() == 0) {
            throw new RuntimeException("Can't edit first volumes. The list is empty.");
        }
        return this.setNewVolumeLike(0, this.buildVolume(0));
    }

    public VolumesNested<A> editLastVolume() {
        int index = this.volumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumes. The list is empty.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public VolumesNested<A> editMatchingVolume(Predicate<VolumesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumes.size(); ++i) {
            if (!predicate.test(this.volumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumes. No match found.");
        }
        return this.setNewVolumeLike(index, this.buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpecFluent that = (SpecFluent)((Object)o);
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.containers, that.containers)) {
            return false;
        }
        if (!Objects.equals(this.dnsPolicy, that.dnsPolicy)) {
            return false;
        }
        if (!Objects.equals(this.ephemeralContainers, that.ephemeralContainers)) {
            return false;
        }
        if (!Objects.equals(this.initContainers, that.initContainers)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.securityContext, (Object)that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.terminationGracePeriodSeconds, that.terminationGracePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.topologySpreadConstraints, that.topologySpreadConstraints)) {
            return false;
        }
        return Objects.equals(this.volumes, that.volumes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.activeDeadlineSeconds, this.containers, this.dnsPolicy, this.ephemeralContainers, this.initContainers, this.nodeSelector, this.restartPolicy, this.securityContext, this.terminationGracePeriodSeconds, this.topologySpreadConstraints, this.volumes, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers + ",");
        }
        if (this.dnsPolicy != null) {
            sb.append("dnsPolicy:");
            sb.append(this.dnsPolicy + ",");
        }
        if (this.ephemeralContainers != null && !this.ephemeralContainers.isEmpty()) {
            sb.append("ephemeralContainers:");
            sb.append(this.ephemeralContainers + ",");
        }
        if (this.initContainers != null && !this.initContainers.isEmpty()) {
            sb.append("initContainers:");
            sb.append(this.initContainers + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.terminationGracePeriodSeconds != null) {
            sb.append("terminationGracePeriodSeconds:");
            sb.append(this.terminationGracePeriodSeconds + ",");
        }
        if (this.topologySpreadConstraints != null && !this.topologySpreadConstraints.isEmpty()) {
            sb.append("topologySpreadConstraints:");
            sb.append(this.topologySpreadConstraints + ",");
        }
        if (this.volumes != null && !this.volumes.isEmpty()) {
            sb.append("volumes:");
            sb.append(this.volumes);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ContainersNested<N>
    extends ContainersFluent<ContainersNested<N>>
    implements Nested<N> {
        ContainersBuilder builder;
        int index;

        ContainersNested(int index, Containers item) {
            this.index = index;
            this.builder = new ContainersBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endIntegrationContainer() {
            return this.and();
        }
    }

    public class EphemeralContainersNested<N>
    extends EphemeralContainersFluent<EphemeralContainersNested<N>>
    implements Nested<N> {
        EphemeralContainersBuilder builder;
        int index;

        EphemeralContainersNested(int index, EphemeralContainers item) {
            this.index = index;
            this.builder = new EphemeralContainersBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.setToEphemeralContainers(this.index, this.builder.build());
        }

        public N endIntegrationEphemeralContainer() {
            return this.and();
        }
    }

    public class InitContainersNested<N>
    extends InitContainersFluent<InitContainersNested<N>>
    implements Nested<N> {
        InitContainersBuilder builder;
        int index;

        InitContainersNested(int index, InitContainers item) {
            this.index = index;
            this.builder = new InitContainersBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.setToInitContainers(this.index, this.builder.build());
        }

        public N endIntegrationInitContainer() {
            return this.and();
        }
    }

    public class SecurityContextNested<N>
    extends SecurityContextFluent<SecurityContextNested<N>>
    implements Nested<N> {
        SecurityContextBuilder builder;

        SecurityContextNested(SecurityContext item) {
            this.builder = new SecurityContextBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.withSecurityContext(this.builder.build());
        }

        public N endSecurityContext() {
            return this.and();
        }
    }

    public class TopologySpreadConstraintsNested<N>
    extends TopologySpreadConstraintsFluent<TopologySpreadConstraintsNested<N>>
    implements Nested<N> {
        TopologySpreadConstraintsBuilder builder;
        int index;

        TopologySpreadConstraintsNested(int index, TopologySpreadConstraints item) {
            this.index = index;
            this.builder = new TopologySpreadConstraintsBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.setToTopologySpreadConstraints(this.index, this.builder.build());
        }

        public N endIntegrationTopologySpreadConstraint() {
            return this.and();
        }
    }

    public class VolumesNested<N>
    extends VolumesFluent<VolumesNested<N>>
    implements Nested<N> {
        VolumesBuilder builder;
        int index;

        VolumesNested(int index, Volumes item) {
            this.index = index;
            this.builder = new VolumesBuilder(this, item);
        }

        public N and() {
            return (N)SpecFluent.this.setToVolumes(this.index, this.builder.build());
        }

        public N endIntegrationVolume() {
            return this.and();
        }
    }
}

