/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilespec.build;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import java.util.Map;
import org.apache.camel.v1.integrationprofilespec.build.maven.CaSecrets;
import org.apache.camel.v1.integrationprofilespec.build.maven.Extension;
import org.apache.camel.v1.integrationprofilespec.build.maven.Profiles;
import org.apache.camel.v1.integrationprofilespec.build.maven.Settings;
import org.apache.camel.v1.integrationprofilespec.build.maven.SettingsSecurity;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"caSecrets", "cliOptions", "extension", "localRepository", "profiles", "properties", "settings", "settingsSecurity"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Maven
implements KubernetesResource {
    @JsonProperty(value="caSecrets")
    @JsonPropertyDescription(value="The Secrets name and key, containing the CA certificate(s) used to connect to remote Maven repositories. It can contain X.509 certificates, and PKCS#7 formatted certificate chains. A JKS formatted keystore is automatically created to store the CA certificate(s), and configured to be used as a trusted certificate(s) by the Maven commands. Note that the root CA certificates are also imported into the created keystore.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<CaSecrets> caSecrets;
    @JsonProperty(value="cliOptions")
    @JsonPropertyDescription(value="The CLI options that are appended to the list of arguments for Maven commands, e.g., `-V,--no-transfer-progress,-Dstyle.color=never`. See https://maven.apache.org/ref/3.8.4/maven-embedder/cli.html.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> cliOptions;
    @JsonProperty(value="extension")
    @JsonPropertyDescription(value="The Maven build extensions. See https://maven.apache.org/guides/mini/guide-using-extensions.html.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Extension> extension;
    @JsonProperty(value="localRepository")
    @JsonPropertyDescription(value="The path of the local Maven repository.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String localRepository;
    @JsonProperty(value="profiles")
    @JsonPropertyDescription(value="A reference to the ConfigMap or Secret key that contains the Maven profile.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Profiles> profiles;
    @JsonProperty(value="properties")
    @JsonPropertyDescription(value="The Maven properties.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> properties;
    @JsonProperty(value="settings")
    @JsonPropertyDescription(value="A reference to the ConfigMap or Secret key that contains the Maven settings.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Settings settings;
    @JsonProperty(value="settingsSecurity")
    @JsonPropertyDescription(value="A reference to the ConfigMap or Secret key that contains the security of the Maven settings.")
    @JsonSetter(nulls=Nulls.SKIP)
    private SettingsSecurity settingsSecurity;

    public List<CaSecrets> getCaSecrets() {
        return this.caSecrets;
    }

    public void setCaSecrets(List<CaSecrets> caSecrets) {
        this.caSecrets = caSecrets;
    }

    public List<String> getCliOptions() {
        return this.cliOptions;
    }

    public void setCliOptions(List<String> cliOptions) {
        this.cliOptions = cliOptions;
    }

    public List<Extension> getExtension() {
        return this.extension;
    }

    public void setExtension(List<Extension> extension) {
        this.extension = extension;
    }

    public String getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(String localRepository) {
        this.localRepository = localRepository;
    }

    public List<Profiles> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<Profiles> profiles) {
        this.profiles = profiles;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public SettingsSecurity getSettingsSecurity() {
        return this.settingsSecurity;
    }

    public void setSettingsSecurity(SettingsSecurity settingsSecurity) {
        this.settingsSecurity = settingsSecurity;
    }

    public String toString() {
        return "Maven(caSecrets=" + this.getCaSecrets() + ", cliOptions=" + this.getCliOptions() + ", extension=" + this.getExtension() + ", localRepository=" + this.getLocalRepository() + ", profiles=" + this.getProfiles() + ", properties=" + this.getProperties() + ", settings=" + this.getSettings() + ", settingsSecurity=" + this.getSettingsSecurity() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Maven)) {
            return false;
        }
        Maven other = (Maven)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<CaSecrets> this$caSecrets = this.getCaSecrets();
        List<CaSecrets> other$caSecrets = other.getCaSecrets();
        if (this$caSecrets == null ? other$caSecrets != null : !((Object)this$caSecrets).equals(other$caSecrets)) {
            return false;
        }
        List<String> this$cliOptions = this.getCliOptions();
        List<String> other$cliOptions = other.getCliOptions();
        if (this$cliOptions == null ? other$cliOptions != null : !((Object)this$cliOptions).equals(other$cliOptions)) {
            return false;
        }
        List<Extension> this$extension = this.getExtension();
        List<Extension> other$extension = other.getExtension();
        if (this$extension == null ? other$extension != null : !((Object)this$extension).equals(other$extension)) {
            return false;
        }
        String this$localRepository = this.getLocalRepository();
        String other$localRepository = other.getLocalRepository();
        if (this$localRepository == null ? other$localRepository != null : !this$localRepository.equals(other$localRepository)) {
            return false;
        }
        List<Profiles> this$profiles = this.getProfiles();
        List<Profiles> other$profiles = other.getProfiles();
        if (this$profiles == null ? other$profiles != null : !((Object)this$profiles).equals(other$profiles)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        Settings this$settings = this.getSettings();
        Settings other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        SettingsSecurity this$settingsSecurity = this.getSettingsSecurity();
        SettingsSecurity other$settingsSecurity = other.getSettingsSecurity();
        return !(this$settingsSecurity == null ? other$settingsSecurity != null : !((Object)this$settingsSecurity).equals(other$settingsSecurity));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Maven;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<CaSecrets> $caSecrets = this.getCaSecrets();
        result = result * 59 + ($caSecrets == null ? 43 : ((Object)$caSecrets).hashCode());
        List<String> $cliOptions = this.getCliOptions();
        result = result * 59 + ($cliOptions == null ? 43 : ((Object)$cliOptions).hashCode());
        List<Extension> $extension = this.getExtension();
        result = result * 59 + ($extension == null ? 43 : ((Object)$extension).hashCode());
        String $localRepository = this.getLocalRepository();
        result = result * 59 + ($localRepository == null ? 43 : $localRepository.hashCode());
        List<Profiles> $profiles = this.getProfiles();
        result = result * 59 + ($profiles == null ? 43 : ((Object)$profiles).hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        Settings $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        SettingsSecurity $settingsSecurity = this.getSettingsSecurity();
        result = result * 59 + ($settingsSecurity == null ? 43 : ((Object)$settingsSecurity).hashCode());
        return result;
    }
}

