/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationkitspec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import org.apache.camel.v1.integrationkitspec.traits.Addons;
import org.apache.camel.v1.integrationkitspec.traits.Builder;
import org.apache.camel.v1.integrationkitspec.traits.Camel;
import org.apache.camel.v1.integrationkitspec.traits.Quarkus;
import org.apache.camel.v1.integrationkitspec.traits.Registry;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"addons", "builder", "camel", "quarkus", "registry"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Traits
implements KubernetesResource {
    @JsonProperty(value="addons")
    @JsonPropertyDescription(value="The collection of addon trait configurations")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Addons> addons;
    @JsonProperty(value="builder")
    @JsonPropertyDescription(value="The builder trait is internally used to determine the best strategy to build and configure IntegrationKits.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Builder builder;
    @JsonProperty(value="camel")
    @JsonPropertyDescription(value="The Camel trait sets up Camel configuration.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Camel camel;
    @JsonProperty(value="quarkus")
    @JsonPropertyDescription(value="The Quarkus trait configures the Quarkus runtime. It's enabled by default. NOTE: Compiling to a native executable, requires at least 4GiB of memory, so the Pod running the native build must have enough memory available.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Quarkus quarkus;
    @JsonProperty(value="registry")
    @JsonPropertyDescription(value="The Registry trait sets up Maven to use the Image registry as a Maven repository. Deprecated: use jvm trait or read documentation.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Registry registry;

    public Map<String, Addons> getAddons() {
        return this.addons;
    }

    public void setAddons(Map<String, Addons> addons) {
        this.addons = addons;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public void setBuilder(Builder builder) {
        this.builder = builder;
    }

    public Camel getCamel() {
        return this.camel;
    }

    public void setCamel(Camel camel) {
        this.camel = camel;
    }

    public Quarkus getQuarkus() {
        return this.quarkus;
    }

    public void setQuarkus(Quarkus quarkus) {
        this.quarkus = quarkus;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public String toString() {
        return "Traits(addons=" + this.getAddons() + ", builder=" + this.getBuilder() + ", camel=" + this.getCamel() + ", quarkus=" + this.getQuarkus() + ", registry=" + this.getRegistry() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Traits)) {
            return false;
        }
        Traits other = (Traits)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Addons> this$addons = this.getAddons();
        Map<String, Addons> other$addons = other.getAddons();
        if (this$addons == null ? other$addons != null : !((Object)this$addons).equals(other$addons)) {
            return false;
        }
        Builder this$builder = this.getBuilder();
        Builder other$builder = other.getBuilder();
        if (this$builder == null ? other$builder != null : !((Object)this$builder).equals(other$builder)) {
            return false;
        }
        Camel this$camel = this.getCamel();
        Camel other$camel = other.getCamel();
        if (this$camel == null ? other$camel != null : !((Object)this$camel).equals(other$camel)) {
            return false;
        }
        Quarkus this$quarkus = this.getQuarkus();
        Quarkus other$quarkus = other.getQuarkus();
        if (this$quarkus == null ? other$quarkus != null : !((Object)this$quarkus).equals(other$quarkus)) {
            return false;
        }
        Registry this$registry = this.getRegistry();
        Registry other$registry = other.getRegistry();
        return !(this$registry == null ? other$registry != null : !((Object)this$registry).equals(other$registry));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Traits;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Addons> $addons = this.getAddons();
        result = result * 59 + ($addons == null ? 43 : ((Object)$addons).hashCode());
        Builder $builder = this.getBuilder();
        result = result * 59 + ($builder == null ? 43 : ((Object)$builder).hashCode());
        Camel $camel = this.getCamel();
        result = result * 59 + ($camel == null ? 43 : ((Object)$camel).hashCode());
        Quarkus $quarkus = this.getQuarkus();
        result = result * 59 + ($quarkus == null ? 43 : ((Object)$quarkus).hashCode());
        Registry $registry = this.getRegistry();
        result = result * 59 + ($registry == null ? 43 : ((Object)$registry).hashCode());
        return result;
    }
}

