/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.camel.v1.integrationstatus.Conditions;
import org.apache.camel.v1.integrationstatus.Configuration;
import org.apache.camel.v1.integrationstatus.GeneratedSources;
import org.apache.camel.v1.integrationstatus.IntegrationKit;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"capabilities", "conditions", "configuration", "dependencies", "digest", "generatedSources", "image", "integrationKit", "lastInitTimestamp", "observedGeneration", "phase", "platform", "profile", "replicas", "runtimeProvider", "runtimeVersion", "selector", "version"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class IntegrationStatus
implements KubernetesResource {
    @JsonProperty(value="capabilities")
    @JsonPropertyDescription(value="features offered by the Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> capabilities;
    @JsonProperty(value="conditions")
    @JsonPropertyDescription(value="a list of events happened for the Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Conditions> conditions;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Deprecated: a list of configuration specification")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<Configuration> configuration;
    @JsonProperty(value="dependencies")
    @JsonPropertyDescription(value="a list of dependencies needed by the application")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> dependencies;
    @JsonProperty(value="digest")
    @JsonPropertyDescription(value="the digest calculated for this Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private String digest;
    @JsonProperty(value="generatedSources")
    @JsonPropertyDescription(value="a list of sources generated for this Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<GeneratedSources> generatedSources;
    @JsonProperty(value="image")
    @JsonPropertyDescription(value="the container image used")
    @JsonSetter(nulls=Nulls.SKIP)
    private String image;
    @JsonProperty(value="integrationKit")
    @JsonPropertyDescription(value="the reference of the `IntegrationKit` which is used for this Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private IntegrationKit integrationKit;
    @JsonProperty(value="lastInitTimestamp")
    @JsonPropertyDescription(value="the timestamp representing the last time when this integration was initialized.")
    @JsonSetter(nulls=Nulls.SKIP)
    private ZonedDateTime lastInitTimestamp;
    @JsonProperty(value="observedGeneration")
    @JsonPropertyDescription(value="ObservedGeneration is the most recent generation observed for this Integration.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long observedGeneration;
    @JsonProperty(value="phase")
    @JsonPropertyDescription(value="the actual phase")
    @JsonSetter(nulls=Nulls.SKIP)
    private String phase;
    @JsonProperty(value="platform")
    @JsonPropertyDescription(value="The IntegrationPlatform watching this Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private String platform;
    @JsonProperty(value="profile")
    @JsonPropertyDescription(value="the profile needed to run this Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private String profile;
    @JsonProperty(value="replicas")
    @JsonPropertyDescription(value="the number of replicas")
    @JsonSetter(nulls=Nulls.SKIP)
    private Integer replicas;
    @JsonProperty(value="runtimeProvider")
    @JsonPropertyDescription(value="the runtime provider targeted for this Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeProvider;
    @JsonProperty(value="runtimeVersion")
    @JsonPropertyDescription(value="the runtime version targeted for this Integration")
    @JsonSetter(nulls=Nulls.SKIP)
    private String runtimeVersion;
    @JsonProperty(value="selector")
    @JsonPropertyDescription(value="label selector")
    @JsonSetter(nulls=Nulls.SKIP)
    private String selector;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="the operator version")
    @JsonSetter(nulls=Nulls.SKIP)
    private String version;

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(List<String> capabilities) {
        this.capabilities = capabilities;
    }

    public List<Conditions> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Conditions> conditions) {
        this.conditions = conditions;
    }

    public List<Configuration> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(List<Configuration> configuration) {
        this.configuration = configuration;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public List<GeneratedSources> getGeneratedSources() {
        return this.generatedSources;
    }

    public void setGeneratedSources(List<GeneratedSources> generatedSources) {
        this.generatedSources = generatedSources;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public IntegrationKit getIntegrationKit() {
        return this.integrationKit;
    }

    public void setIntegrationKit(IntegrationKit integrationKit) {
        this.integrationKit = integrationKit;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ssVV")
    public ZonedDateTime getLastInitTimestamp() {
        return this.lastInitTimestamp;
    }

    @JsonFormat(pattern="yyyy-MM-dd'T'HH:mm:ss[XXX][VV]")
    public void setLastInitTimestamp(ZonedDateTime lastInitTimestamp) {
        this.lastInitTimestamp = lastInitTimestamp;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public void setRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public void setRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return "IntegrationStatus(capabilities=" + this.getCapabilities() + ", conditions=" + this.getConditions() + ", configuration=" + this.getConfiguration() + ", dependencies=" + this.getDependencies() + ", digest=" + this.getDigest() + ", generatedSources=" + this.getGeneratedSources() + ", image=" + this.getImage() + ", integrationKit=" + this.getIntegrationKit() + ", lastInitTimestamp=" + this.getLastInitTimestamp() + ", observedGeneration=" + this.getObservedGeneration() + ", phase=" + this.getPhase() + ", platform=" + this.getPlatform() + ", profile=" + this.getProfile() + ", replicas=" + this.getReplicas() + ", runtimeProvider=" + this.getRuntimeProvider() + ", runtimeVersion=" + this.getRuntimeVersion() + ", selector=" + this.getSelector() + ", version=" + this.getVersion() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationStatus)) {
            return false;
        }
        IntegrationStatus other = (IntegrationStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$observedGeneration = this.getObservedGeneration();
        Long other$observedGeneration = other.getObservedGeneration();
        if (this$observedGeneration == null ? other$observedGeneration != null : !((Object)this$observedGeneration).equals(other$observedGeneration)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        List<String> this$capabilities = this.getCapabilities();
        List<String> other$capabilities = other.getCapabilities();
        if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
            return false;
        }
        List<Conditions> this$conditions = this.getConditions();
        List<Conditions> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        List<Configuration> this$configuration = this.getConfiguration();
        List<Configuration> other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<String> this$dependencies = this.getDependencies();
        List<String> other$dependencies = other.getDependencies();
        if (this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        if (this$digest == null ? other$digest != null : !this$digest.equals(other$digest)) {
            return false;
        }
        List<GeneratedSources> this$generatedSources = this.getGeneratedSources();
        List<GeneratedSources> other$generatedSources = other.getGeneratedSources();
        if (this$generatedSources == null ? other$generatedSources != null : !((Object)this$generatedSources).equals(other$generatedSources)) {
            return false;
        }
        String this$image = this.getImage();
        String other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        IntegrationKit this$integrationKit = this.getIntegrationKit();
        IntegrationKit other$integrationKit = other.getIntegrationKit();
        if (this$integrationKit == null ? other$integrationKit != null : !((Object)this$integrationKit).equals(other$integrationKit)) {
            return false;
        }
        ZonedDateTime this$lastInitTimestamp = this.getLastInitTimestamp();
        ZonedDateTime other$lastInitTimestamp = other.getLastInitTimestamp();
        if (this$lastInitTimestamp == null ? other$lastInitTimestamp != null : !((Object)this$lastInitTimestamp).equals(other$lastInitTimestamp)) {
            return false;
        }
        String this$phase = this.getPhase();
        String other$phase = other.getPhase();
        if (this$phase == null ? other$phase != null : !this$phase.equals(other$phase)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        String this$profile = this.getProfile();
        String other$profile = other.getProfile();
        if (this$profile == null ? other$profile != null : !this$profile.equals(other$profile)) {
            return false;
        }
        String this$runtimeProvider = this.getRuntimeProvider();
        String other$runtimeProvider = other.getRuntimeProvider();
        if (this$runtimeProvider == null ? other$runtimeProvider != null : !this$runtimeProvider.equals(other$runtimeProvider)) {
            return false;
        }
        String this$runtimeVersion = this.getRuntimeVersion();
        String other$runtimeVersion = other.getRuntimeVersion();
        if (this$runtimeVersion == null ? other$runtimeVersion != null : !this$runtimeVersion.equals(other$runtimeVersion)) {
            return false;
        }
        String this$selector = this.getSelector();
        String other$selector = other.getSelector();
        if (this$selector == null ? other$selector != null : !this$selector.equals(other$selector)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IntegrationStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $observedGeneration = this.getObservedGeneration();
        result = result * 59 + ($observedGeneration == null ? 43 : ((Object)$observedGeneration).hashCode());
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 43 : ((Object)$replicas).hashCode());
        List<String> $capabilities = this.getCapabilities();
        result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
        List<Conditions> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        List<Configuration> $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<String> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        List<GeneratedSources> $generatedSources = this.getGeneratedSources();
        result = result * 59 + ($generatedSources == null ? 43 : ((Object)$generatedSources).hashCode());
        String $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        IntegrationKit $integrationKit = this.getIntegrationKit();
        result = result * 59 + ($integrationKit == null ? 43 : ((Object)$integrationKit).hashCode());
        ZonedDateTime $lastInitTimestamp = this.getLastInitTimestamp();
        result = result * 59 + ($lastInitTimestamp == null ? 43 : ((Object)$lastInitTimestamp).hashCode());
        String $phase = this.getPhase();
        result = result * 59 + ($phase == null ? 43 : $phase.hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        String $profile = this.getProfile();
        result = result * 59 + ($profile == null ? 43 : $profile.hashCode());
        String $runtimeProvider = this.getRuntimeProvider();
        result = result * 59 + ($runtimeProvider == null ? 43 : $runtimeProvider.hashCode());
        String $runtimeVersion = this.getRuntimeVersion();
        result = result * 59 + ($runtimeVersion == null ? 43 : $runtimeVersion.hashCode());
        String $selector = this.getSelector();
        result = result * 59 + ($selector == null ? 43 : $selector.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

