/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Reader;

public class NonBlockingReader
extends Reader
implements Runnable {
    private Reader in;
    private int ch = -2;
    private String name;
    private boolean threadIsReading = false;
    private IOException exception = null;
    private long threadDelay = 60000L;
    private Thread thread;

    public NonBlockingReader(String name2, Reader in) {
        this.in = in;
        this.name = name2;
    }

    private synchronized void startReadingThreadIfNeeded() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setName(this.name + " non blocking reader thread");
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public synchronized void shutdown() {
        if (this.thread != null) {
            this.notify();
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.shutdown();
    }

    @Override
    public int read() throws IOException {
        return this.read(0L, false);
    }

    public int peek(long timeout) throws IOException {
        return this.read(timeout, true);
    }

    public int read(long timeout) throws IOException {
        return this.read(timeout, false);
    }

    @Override
    public synchronized boolean ready() throws IOException {
        return this.ch >= 0 || this.in.ready();
    }

    private synchronized int read(long timeout, boolean isPeek) throws IOException {
        if (this.exception != null) {
            assert (this.ch == -2);
            IOException toBeThrown = this.exception;
            if (!isPeek) {
                this.exception = null;
            }
            throw toBeThrown;
        }
        if (this.ch >= -1) {
            assert (this.exception == null);
        } else if (!isPeek && timeout <= 0L && !this.threadIsReading) {
            this.ch = this.in.read();
        } else {
            boolean isInfinite;
            if (!this.threadIsReading) {
                this.threadIsReading = true;
                this.startReadingThreadIfNeeded();
                this.notifyAll();
            }
            boolean bl = isInfinite = timeout <= 0L;
            while (isInfinite || timeout > 0L) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(timeout);
                }
                catch (InterruptedException e) {
                    this.exception = (IOException)new InterruptedIOException().initCause(e);
                }
                if (this.exception != null) {
                    assert (this.ch == -2);
                    IOException toBeThrown = this.exception;
                    if (!isPeek) {
                        this.exception = null;
                    }
                    throw toBeThrown;
                }
                if (this.ch >= -1) {
                    assert (this.exception == null);
                    break;
                }
                if (isInfinite) continue;
                timeout -= System.currentTimeMillis() - start;
            }
        }
        int ret = this.ch;
        if (!isPeek) {
            this.ch = -2;
        }
        return ret;
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read(0L);
        if (c == -1) {
            return -1;
        }
        b[off] = (char)c;
        return 1;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[UNCONDITIONALDOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

