/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverloadChecker;
import org.jetbrains.kotlin.resolve.scopes.AbstractLocalRedeclarationChecker;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0014J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/scopes/ThrowingLocalRedeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/scopes/AbstractLocalRedeclarationChecker;", "overloadChecker", "Lorg/jetbrains/kotlin/resolve/OverloadChecker;", "(Lorg/jetbrains/kotlin/resolve/OverloadChecker;)V", "handleConflictingOverloads", "", "first", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "second", "handleRedeclaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "frontend"})
public final class ThrowingLocalRedeclarationChecker
extends AbstractLocalRedeclarationChecker {
    public ThrowingLocalRedeclarationChecker(@NotNull OverloadChecker overloadChecker) {
        Intrinsics.checkNotNullParameter(overloadChecker, "overloadChecker");
        super(overloadChecker);
    }

    @Override
    protected void handleRedeclaration(@NotNull DeclarationDescriptor first, @NotNull DeclarationDescriptor second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        String string2 = "Redeclaration: %s (%s) and %s (%s) (no line info available)";
        Object[] objectArray = new Object[]{DescriptorUtils.getFqName(first), first, DescriptorUtils.getFqName(second), second};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        throw new IllegalStateException(string3);
    }

    @Override
    protected void handleConflictingOverloads(@NotNull CallableMemberDescriptor first, @NotNull CallableMemberDescriptor second) {
        Intrinsics.checkNotNullParameter(first, "first");
        Intrinsics.checkNotNullParameter(second, "second");
        String string2 = "Conflicting overloads: %s (%s) and %s (%s) (no line info available)";
        Object[] objectArray = new Object[]{DescriptorUtils.getFqName(first), first, DescriptorUtils.getFqName(second), second};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        throw new IllegalStateException(string3);
    }
}

