/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.ints.IntIterable;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSpliterator;
import it.unimi.dsi.fastutil.ints.IntSpliterators;
import java.util.Collection;
import java.util.Objects;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface IntCollection
extends IntIterable,
Collection<Integer> {
    @Override
    public IntIterator iterator();

    @Override
    default public IntSpliterator spliterator() {
        return IntSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this), 320);
    }

    @Override
    public boolean add(int var1);

    public boolean contains(int var1);

    public boolean rem(int var1);

    @Override
    @Deprecated
    default public boolean add(Integer key) {
        return this.add((int)key);
    }

    @Override
    @Deprecated
    default public boolean contains(Object key) {
        if (key == null) {
            return false;
        }
        return this.contains((Integer)key);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key) {
        if (key == null) {
            return false;
        }
        return this.rem((Integer)key);
    }

    public int[] toIntArray();

    public boolean addAll(IntCollection var1);

    @Override
    @Deprecated
    default public boolean removeIf(Predicate<? super Integer> filter2) {
        return this.removeIf(filter2 instanceof IntPredicate ? (IntPredicate)((Object)filter2) : key -> filter2.test(key));
    }

    default public boolean removeIf(IntPredicate filter2) {
        Objects.requireNonNull(filter2);
        boolean removed2 = false;
        IntIterator each = this.iterator();
        while (each.hasNext()) {
            if (!filter2.test(each.nextInt())) continue;
            each.remove();
            removed2 = true;
        }
        return removed2;
    }

    @Override
    @Deprecated
    default public Stream<Integer> stream() {
        return Collection.super.stream();
    }

    @Override
    @Deprecated
    default public Stream<Integer> parallelStream() {
        return Collection.super.parallelStream();
    }
}

