/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.internal.impl.filter;

import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.kotlin.org.eclipse.aether.repository.RemoteRepository;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.ArtifactDownload;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.MetadataDownload;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.RepositoryConnector;
import org.jetbrains.kotlin.org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.jetbrains.kotlin.org.eclipse.aether.transfer.MetadataNotFoundException;

public final class FilteringRepositoryConnector
implements RepositoryConnector {
    private final RemoteRepository remoteRepository;
    private final RepositoryConnector delegate;
    private final RemoteRepositoryFilter remoteRepositoryFilter;

    public FilteringRepositoryConnector(RemoteRepository remoteRepository, RepositoryConnector delegate, RemoteRepositoryFilter remoteRepositoryFilter) {
        RemoteRepository remoteRepository2 = remoteRepository;
        remoteRepository2.getClass();
        this.remoteRepository = remoteRepository2;
        RepositoryConnector repositoryConnector = delegate;
        repositoryConnector.getClass();
        this.delegate = repositoryConnector;
        RemoteRepositoryFilter remoteRepositoryFilter2 = remoteRepositoryFilter;
        remoteRepositoryFilter2.getClass();
        this.remoteRepositoryFilter = remoteRepositoryFilter2;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        ArrayList<ArtifactDownload> filteredArtifactDownloads = null;
        if (artifactDownloads != null && !artifactDownloads.isEmpty()) {
            filteredArtifactDownloads = new ArrayList<ArtifactDownload>(artifactDownloads.size());
            for (ArtifactDownload artifactDownload : artifactDownloads) {
                RemoteRepositoryFilter.Result result = this.remoteRepositoryFilter.acceptArtifact(this.remoteRepository, artifactDownload.getArtifact());
                if (result.isAccepted()) {
                    filteredArtifactDownloads.add(artifactDownload);
                    continue;
                }
                artifactDownload.setException(new ArtifactNotFoundException(artifactDownload.getArtifact(), this.remoteRepository, result.reasoning()));
            }
        }
        ArrayList<MetadataDownload> filteredMetadataDownloads = null;
        if (metadataDownloads != null && !metadataDownloads.isEmpty()) {
            filteredMetadataDownloads = new ArrayList<MetadataDownload>(metadataDownloads.size());
            for (MetadataDownload metadataDownload : metadataDownloads) {
                RemoteRepositoryFilter.Result result = this.remoteRepositoryFilter.acceptMetadata(this.remoteRepository, metadataDownload.getMetadata());
                if (result.isAccepted()) {
                    filteredMetadataDownloads.add(metadataDownload);
                    continue;
                }
                metadataDownload.setException(new MetadataNotFoundException(metadataDownload.getMetadata(), this.remoteRepository, result.reasoning()));
            }
        }
        this.delegate.get(filteredArtifactDownloads, filteredMetadataDownloads);
    }

    public String toString() {
        return "filtered(" + this.delegate.toString() + ")";
    }
}

