/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.protocol;

import java.io.IOException;
import java.net.InetAddress;
import org.jetbrains.kotlin.org.apache.http.HttpConnection;
import org.jetbrains.kotlin.org.apache.http.HttpException;
import org.jetbrains.kotlin.org.apache.http.HttpHost;
import org.jetbrains.kotlin.org.apache.http.HttpInetConnection;
import org.jetbrains.kotlin.org.apache.http.HttpRequest;
import org.jetbrains.kotlin.org.apache.http.HttpRequestInterceptor;
import org.jetbrains.kotlin.org.apache.http.HttpVersion;
import org.jetbrains.kotlin.org.apache.http.ProtocolException;
import org.jetbrains.kotlin.org.apache.http.ProtocolVersion;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpCoreContext;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

