/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.metadata;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.LegacyDescriptorUtilsKt;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializer;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializerExtension;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataSerializerKt;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.library.metadata.KlibMetadataProtoBuf;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.ApproximatingStringTable;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.serialization.StringTableImpl;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001:\u0001OBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\rJ\b\u0010$\u001a\u00020\u001eH\u0004J\b\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+H\u0004J*\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u000f0.0-2\u0006\u00100\u001a\u00020)2\u0006\u00101\u001a\u000202H\u0002J0\u00103\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u000f0.0-2\u0006\u00100\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J2\u00107\u001a\b\u0012\u0004\u0012\u0002080-2\u0006\u00109\u001a\u00020)2\f\u0010:\u001a\b\u0012\u0004\u0012\u0002060-2\f\u0010;\u001a\b\u0012\u0004\u0012\u0002060-H\u0004J*\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020+2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0-2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020@0-J2\u0010B\u001a\u0002HC\"\u0004\b\u0000\u0010C2\u0019\b\u0004\u0010D\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u0002HC0E\u00a2\u0006\u0002\bFH\u0084\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010GJ>\u0010H\u001a\u000208*\u00020\u001e2\u0006\u0010I\u001a\u00020&2\u0018\u0010J\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020\u000f0.0-2\u0006\u00109\u001a\u00020)2\u0006\u0010K\u001a\u00020\tH\u0002J\"\u0010L\u001a\u00020&*\u00020\u001e2\u0006\u00109\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u0002060-H\u0002J\u0018\u0010M\u001a\b\u0012\u0004\u0012\u0002060-*\b\u0012\u0004\u0012\u0002060-H\u0004J\u0018\u0010N\u001a\b\u0012\u0004\u0012\u0002060-*\b\u0012\u0004\u0012\u0002060-H\u0002R\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializer;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "project", "Lcom/intellij/openapi/project/Project;", "exportKDoc", "", "skipExpects", "includeOnlyModuleContent", "allowErrorTypes", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lcom/intellij/openapi/project/Project;ZZZZ)V", "TOP_LEVEL_CLASS_DECLARATION_COUNT_PER_FILE", "", "getTOP_LEVEL_CLASS_DECLARATION_COUNT_PER_FILE", "()Ljava/lang/Integer;", "TOP_LEVEL_DECLARATION_COUNT_PER_FILE", "getTOP_LEVEL_DECLARATION_COUNT_PER_FILE", "getExportKDoc", "()Z", "getIncludeOnlyModuleContent", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getProject", "()Lcom/intellij/openapi/project/Project;", "serializerContext", "Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializer$SerializerContext;", "getSerializerContext", "()Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializer$SerializerContext;", "setSerializerContext", "(Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializer$SerializerContext;)V", "getSkipExpects", "createNewContext", "emptyPackageProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package;", "getPackagesFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "serializeClass", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class;", "packageName", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "serializeClasses", "descriptors", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "serializeDescriptors", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$PackageFragment;", "fqName", "allClassifierDescriptors", "allTopLevelDescriptors", "serializeHeader", "Lorg/jetbrains/kotlin/library/metadata/KlibMetadataProtoBuf$Header;", "moduleDescriptor", "fragmentNames", "", "emptyPackages", "withNewContext", "T", "block", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "buildFragment", "packageProto", "classesProto", "isEmpty", "buildPackageProto", "filterOutExpects", "filterOutExpectsWithActuals", "SerializerContext", "ir.serialization.common"})
public abstract class KlibMetadataSerializer {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final BinaryVersion metadataVersion;
    @Nullable
    private final Project project;
    private final boolean exportKDoc;
    private final boolean skipExpects;
    private final boolean includeOnlyModuleContent;
    private final boolean allowErrorTypes;
    public SerializerContext serializerContext;

    public KlibMetadataSerializer(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull BinaryVersion metadataVersion, @Nullable Project project, boolean exportKDoc, boolean skipExpects, boolean includeOnlyModuleContent, boolean allowErrorTypes) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        this.languageVersionSettings = languageVersionSettings;
        this.metadataVersion = metadataVersion;
        this.project = project;
        this.exportKDoc = exportKDoc;
        this.skipExpects = skipExpects;
        this.includeOnlyModuleContent = includeOnlyModuleContent;
        this.allowErrorTypes = allowErrorTypes;
    }

    public /* synthetic */ KlibMetadataSerializer(LanguageVersionSettings languageVersionSettings, BinaryVersion binaryVersion, Project project, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        this(languageVersionSettings, binaryVersion, project, bl, bl2, bl3, bl4);
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final BinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public final boolean getExportKDoc() {
        return this.exportKDoc;
    }

    public final boolean getSkipExpects() {
        return this.skipExpects;
    }

    public final boolean getIncludeOnlyModuleContent() {
        return this.includeOnlyModuleContent;
    }

    @NotNull
    public final SerializerContext getSerializerContext() {
        SerializerContext serializerContext = this.serializerContext;
        if (serializerContext != null) {
            return serializerContext;
        }
        Intrinsics.throwUninitializedPropertyAccessException("serializerContext");
        return null;
    }

    public final void setSerializerContext(@NotNull SerializerContext serializerContext) {
        Intrinsics.checkNotNullParameter(serializerContext, "<set-?>");
        this.serializerContext = serializerContext;
    }

    @NotNull
    protected final SerializerContext createNewContext() {
        KlibMetadataSerializerExtension extension = new KlibMetadataSerializerExtension(this.languageVersionSettings, this.metadataVersion, new ApproximatingStringTable(), this.allowErrorTypes, this.exportKDoc);
        return new SerializerContext(extension, DescriptorSerializer.Companion.createTopLevel(extension), null, 4, null);
    }

    protected final <T> T withNewContext(@NotNull Function1<? super SerializerContext, ? extends T> block) {
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withNewContext = false;
        this.setSerializerContext(this.createNewContext());
        SerializerContext serializerContext = this.getSerializerContext();
        boolean bl = false;
        boolean bl2 = false;
        return block.invoke(serializerContext);
    }

    /*
     * WARNING - void declaration
     */
    private final ProtoBuf.PackageFragment buildFragment(SerializerContext $this$buildFragment, ProtoBuf.Package packageProto, List<Pair<ProtoBuf.Class, Integer>> classesProto, FqName fqName2, boolean isEmpty2) {
        Collection<ProtoBuf.Class> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = $this$buildFragment.getSerializerExtension().getStringTable().buildProto();
        ProtoBuf.StringTable stringTableProto = pair.component1();
        ProtoBuf.QualifiedNameTable nameTableProto = pair.component2();
        Object object = classesProto;
        ProtoBuf.PackageFragment.Builder builder2 = ProtoBuf.PackageFragment.newBuilder().setPackage(packageProto);
        boolean $i$f$map = false;
        void var12_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ProtoBuf.Class clazz = (ProtoBuf.Class)it.getFirst();
            collection.add(clazz);
        }
        collection = (List)destination$iv$iv;
        object = builder2.addAllClass_((Iterable<? extends ProtoBuf.Class>)collection).setStrings(stringTableProto).setQualifiedNames(nameTableProto);
        boolean bl = false;
        boolean bl2 = false;
        Object packageFragment = object;
        boolean bl3 = false;
        Iterable $this$forEach$iv = classesProto;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl4 = false;
            ((GeneratedMessageLite.ExtendableBuilder)packageFragment).addExtension(KlibMetadataProtoBuf.className, it.getSecond());
        }
        ((GeneratedMessageLite.ExtendableBuilder)packageFragment).setExtension(KlibMetadataProtoBuf.isEmpty, isEmpty2);
        ((GeneratedMessageLite.ExtendableBuilder)packageFragment).setExtension(KlibMetadataProtoBuf.fqName, fqName2.asString());
        ProtoBuf.PackageFragment packageFragment2 = ((ProtoBuf.PackageFragment.Builder)object).build();
        Intrinsics.checkNotNullExpressionValue(packageFragment2, "newBuilder()\n           \u2026   }\n            .build()");
        return packageFragment2;
    }

    private final List<Pair<ProtoBuf.Class, Integer>> serializeClass(FqName packageName, ClassDescriptor classDescriptor) {
        SerializerContext serializerContext = this.getSerializerContext();
        boolean bl = false;
        boolean bl2 = false;
        SerializerContext $this$serializeClass_u24lambda_u2d3 = serializerContext;
        boolean bl3 = false;
        DescriptorSerializer previousSerializer = $this$serializeClass_u24lambda_u2d3.getClassSerializer();
        $this$serializeClass_u24lambda_u2d3.setClassSerializer(DescriptorSerializer.Companion.create(classDescriptor, $this$serializeClass_u24lambda_u2d3.getSerializerExtension(), $this$serializeClass_u24lambda_u2d3.getClassSerializer(), this.getProject()));
        ProtoBuf.Class clazz = $this$serializeClass_u24lambda_u2d3.getClassSerializer().classProto(classDescriptor).build();
        if (clazz == null) {
            String string2 = Intrinsics.stringPlus("Class not serialized: ", classDescriptor);
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ProtoBuf.Class classProto = clazz;
        int index2 = $this$serializeClass_u24lambda_u2d3.getClassSerializer().getStringTable().getFqNameIndex(classDescriptor);
        MemberScope memberScope2 = classDescriptor.getUnsubstitutedInnerClassesScope();
        Intrinsics.checkNotNullExpressionValue(memberScope2, "classDescriptor.unsubstitutedInnerClassesScope");
        List<Pair<ProtoBuf.Class, Integer>> classes2 = this.serializeClasses(packageName, ResolutionScope.DefaultImpls.getContributedDescriptors$default(memberScope2, DescriptorKindFilter.CLASSIFIERS, null, 2, null));
        $this$serializeClass_u24lambda_u2d3.setClassSerializer(previousSerializer);
        return CollectionsKt.plus((Collection)classes2, new Pair<ProtoBuf.Class, Integer>(classProto, index2));
    }

    /*
     * WARNING - void declaration
     */
    private final List<DeclarationDescriptor> filterOutExpectsWithActuals(List<? extends DeclarationDescriptor> $this$filterOutExpectsWithActuals) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        DeclarationDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterOutExpectsWithActuals;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DeclarationDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(!LegacyDescriptorUtilsKt.isExpectMember(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (DeclarationDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ClassId classId = ClassId.topLevel(DescriptorUtilsKt.getFqNameSafe(it));
            collection.add(classId);
        }
        List actualClassIds = (List)destination$iv$iv;
        Iterable $this$filterNot$iv = $this$filterOutExpectsWithActuals;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (DeclarationDescriptor)element$iv$iv;
            boolean bl = false;
            if (it instanceof ClassDescriptor && ((ClassDescriptor)it).isExpect() && actualClassIds.contains(ClassId.topLevel(DescriptorUtilsKt.getFqNameSafe(it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<DeclarationDescriptor> filterOutExpects(@NotNull List<? extends DeclarationDescriptor> $this$filterOutExpects) {
        List list2;
        Intrinsics.checkNotNullParameter($this$filterOutExpects, "<this>");
        if (this.skipExpects) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = $this$filterOutExpects;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                boolean bl = false;
                if (LegacyDescriptorUtilsKt.isExpectMember(it) && !LegacyDescriptorUtilsKt.isSerializableExpectClass(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = this.filterOutExpectsWithActuals($this$filterOutExpects);
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<ProtoBuf.Class, Integer>> serializeClasses(FqName packageName, Collection<? extends DeclarationDescriptor> descriptors) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = descriptors;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ClassDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ClassDescriptor it = (ClassDescriptor)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.serializeClass(packageName, it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final ProtoBuf.Package emptyPackageProto() {
        ProtoBuf.Package package_ = ProtoBuf.Package.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue(package_, "newBuilder().build()");
        return package_;
    }

    private final ProtoBuf.Package buildPackageProto(SerializerContext $this$buildPackageProto, FqName fqName2, List<? extends DeclarationDescriptor> descriptors) {
        ProtoBuf.Package package_ = $this$buildPackageProto.getTopSerializer().packagePartProto(fqName2, (Collection<? extends DeclarationDescriptor>)descriptors).build();
        if (package_ == null) {
            String string2 = Intrinsics.stringPlus("Package fragments not serialized: for ", descriptors);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return package_;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<ProtoBuf.PackageFragment> serializeDescriptors(@NotNull FqName fqName2, @NotNull List<? extends DeclarationDescriptor> allClassifierDescriptors2, @NotNull List<? extends DeclarationDescriptor> allTopLevelDescriptors) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(allClassifierDescriptors2, "allClassifierDescriptors");
        Intrinsics.checkNotNullParameter(allTopLevelDescriptors, "allTopLevelDescriptors");
        List<DeclarationDescriptor> classifierDescriptors2 = this.filterOutExpects(allClassifierDescriptors2);
        List<DeclarationDescriptor> topLevelDescriptors = this.filterOutExpects(allTopLevelDescriptors);
        if (this.getTOP_LEVEL_CLASS_DECLARATION_COUNT_PER_FILE() == null && this.getTOP_LEVEL_DECLARATION_COUNT_PER_FILE() == null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = classifierDescriptors2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TypeAliasDescriptor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List typeAliases = (List)destination$iv$iv;
            List nonCassDescriptors = CollectionsKt.plus((Collection)topLevelDescriptors, (Iterable)typeAliases);
            KlibMetadataSerializer this_$iv = this;
            boolean $i$f$withNewContext = false;
            this_$iv.setSerializerContext(this_$iv.createNewContext());
            SerializerContext serializerContext = this_$iv.getSerializerContext();
            boolean bl = false;
            boolean bl2 = false;
            SerializerContext $this$serializeDescriptors_u24lambda_u2d9 = serializerContext;
            boolean bl3 = false;
            ProtoBuf.Package packageProto = nonCassDescriptors.isEmpty() ? this.emptyPackageProto() : this.buildPackageProto($this$serializeDescriptors_u24lambda_u2d9, fqName2, nonCassDescriptors);
            return CollectionsKt.listOf(this.buildFragment($this$serializeDescriptors_u24lambda_u2d9, packageProto, this.serializeClasses(fqName2, classifierDescriptors2), fqName2, topLevelDescriptors.isEmpty() && classifierDescriptors2.isEmpty()));
        }
        boolean bl = false;
        List result2 = new ArrayList();
        Collection collection = result2;
        Object this_$iv = KlibMetadataSerializerKt.maybeChunked((Iterable)classifierDescriptors2, this.getTOP_LEVEL_CLASS_DECLARATION_COUNT_PER_FILE(), (Function1)new Function1<List<? extends DeclarationDescriptor>, ProtoBuf.PackageFragment>(this, fqName2){
            final /* synthetic */ KlibMetadataSerializer this$0;
            final /* synthetic */ FqName $fqName;
            {
                this.this$0 = $receiver;
                this.$fqName = $fqName;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ProtoBuf.PackageFragment invoke(@NotNull List<? extends DeclarationDescriptor> descriptors) {
                void $this$filterIsInstanceTo$iv$iv;
                void this_$iv;
                Intrinsics.checkNotNullParameter(descriptors, "descriptors");
                KlibMetadataSerializer klibMetadataSerializer = this.this$0;
                KlibMetadataSerializer klibMetadataSerializer2 = this.this$0;
                FqName fqName2 = this.$fqName;
                boolean $i$f$withNewContext = false;
                this_$iv.setSerializerContext(KlibMetadataSerializer.access$createNewContext((KlibMetadataSerializer)this_$iv));
                SerializerContext serializerContext = this_$iv.getSerializerContext();
                boolean bl = false;
                boolean bl2 = false;
                SerializerContext $this$invoke_u24lambda_u2d0 = serializerContext;
                boolean bl3 = false;
                List classesProto = KlibMetadataSerializer.access$serializeClasses(klibMetadataSerializer2, fqName2, descriptors);
                Iterable $this$filterIsInstance$iv = descriptors;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof TypeAliasDescriptor)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List typeAliases = (List)destination$iv$iv;
                Collection collection = typeAliases;
                boolean bl4 = false;
                ProtoBuf.Package packageProto = !collection.isEmpty() ? KlibMetadataSerializer.access$buildPackageProto(klibMetadataSerializer2, $this$invoke_u24lambda_u2d0, fqName2, typeAliases) : KlibMetadataSerializer.access$emptyPackageProto(klibMetadataSerializer2);
                return KlibMetadataSerializer.access$buildFragment(klibMetadataSerializer2, $this$invoke_u24lambda_u2d0, packageProto, classesProto, fqName2, descriptors.isEmpty());
            }
        });
        boolean $i$f$withNewContext = false;
        CollectionsKt.addAll(collection, this_$iv);
        collection = result2;
        this_$iv = KlibMetadataSerializerKt.maybeChunked((Iterable)topLevelDescriptors, this.getTOP_LEVEL_DECLARATION_COUNT_PER_FILE(), (Function1)new Function1<List<? extends DeclarationDescriptor>, ProtoBuf.PackageFragment>(this, fqName2){
            final /* synthetic */ KlibMetadataSerializer this$0;
            final /* synthetic */ FqName $fqName;
            {
                this.this$0 = $receiver;
                this.$fqName = $fqName;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ProtoBuf.PackageFragment invoke(@NotNull List<? extends DeclarationDescriptor> descriptors) {
                void this_$iv;
                Intrinsics.checkNotNullParameter(descriptors, "descriptors");
                KlibMetadataSerializer klibMetadataSerializer = this.this$0;
                KlibMetadataSerializer klibMetadataSerializer2 = this.this$0;
                FqName fqName2 = this.$fqName;
                boolean $i$f$withNewContext = false;
                this_$iv.setSerializerContext(KlibMetadataSerializer.access$createNewContext((KlibMetadataSerializer)this_$iv));
                SerializerContext serializerContext = this_$iv.getSerializerContext();
                boolean bl = false;
                boolean bl2 = false;
                SerializerContext $this$invoke_u24lambda_u2d0 = serializerContext;
                boolean bl3 = false;
                return KlibMetadataSerializer.access$buildFragment(klibMetadataSerializer2, $this$invoke_u24lambda_u2d0, KlibMetadataSerializer.access$buildPackageProto(klibMetadataSerializer2, $this$invoke_u24lambda_u2d0, fqName2, descriptors), CollectionsKt.emptyList(), fqName2, descriptors.isEmpty());
            }
        });
        $i$f$withNewContext = false;
        CollectionsKt.addAll(collection, this_$iv);
        if (result2.isEmpty()) {
            collection = result2;
            this_$iv = this;
            $i$f$withNewContext = false;
            ((KlibMetadataSerializer)this_$iv).setSerializerContext(((KlibMetadataSerializer)this_$iv).createNewContext());
            SerializerContext serializerContext = ((KlibMetadataSerializer)this_$iv).getSerializerContext();
            boolean bl4 = false;
            boolean bl5 = false;
            SerializerContext $this$serializeDescriptors_u24lambda_u2d10 = serializerContext;
            boolean bl6 = false;
            ProtoBuf.PackageFragment packageFragment = this.buildFragment($this$serializeDescriptors_u24lambda_u2d10, this.emptyPackageProto(), CollectionsKt.emptyList(), fqName2, true);
            boolean bl7 = false;
            collection.add(packageFragment);
        }
        return result2;
    }

    @NotNull
    protected final Set<FqName> getPackagesFqNames(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        boolean bl = false;
        Set result2 = new LinkedHashSet();
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue(fqName2, "ROOT");
        KlibMetadataSerializer.getPackagesFqNames$getSubPackages(result2, this, module2, fqName2);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KlibMetadataProtoBuf.Header serializeHeader(@NotNull ModuleDescriptor moduleDescriptor, @NotNull List<String> fragmentNames, @NotNull List<String> emptyPackages) {
        String it;
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(fragmentNames, "fragmentNames");
        Intrinsics.checkNotNullParameter(emptyPackages, "emptyPackages");
        KlibMetadataProtoBuf.Header.Builder header = KlibMetadataProtoBuf.Header.newBuilder();
        header.setModuleName(moduleDescriptor.getName().asString());
        if (this.languageVersionSettings.isPreRelease()) {
            header.setFlags(1);
        }
        List<String> experimentalAnnotationFqNames = this.languageVersionSettings.getFlag(AnalysisFlags.getExperimental());
        Object object = experimentalAnnotationFqNames;
        boolean bl = false;
        if (!object.isEmpty()) {
            StringTableImpl stringTable = new StringTableImpl();
            for (String fqName2 : experimentalAnnotationFqNames) {
                void $this$serializeHeader_u24lambda_u2d12;
                Object object2 = DescriptorUtilKt.resolveClassByFqName(moduleDescriptor, new FqName(fqName2), NoLookupLocation.FOR_ALREADY_TRACKED);
                if (object2 == null) continue;
                ClassDescriptor descriptor2 = object2;
                object2 = ProtoBuf.Annotation.newBuilder();
                boolean bl2 = false;
                boolean bl3 = false;
                Object object3 = object2;
                KlibMetadataProtoBuf.Header.Builder builder2 = header;
                boolean bl4 = false;
                $this$serializeHeader_u24lambda_u2d12.setId(stringTable.getFqNameIndex(descriptor2));
                Unit unit = Unit.INSTANCE;
                builder2.addAnnotation((ProtoBuf.Annotation.Builder)object2);
            }
            Pair<ProtoBuf.StringTable, ProtoBuf.QualifiedNameTable> pair = stringTable.buildProto();
            ProtoBuf.StringTable strings2 = (ProtoBuf.StringTable)pair.component1();
            ProtoBuf.QualifiedNameTable qualifiedNames = (ProtoBuf.QualifiedNameTable)pair.component2();
            header.setStrings(strings2);
            header.setQualifiedNames(qualifiedNames);
        }
        Iterable $this$forEach$iv = fragmentNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl5 = false;
            header.addPackageFragmentName(it);
        }
        $this$forEach$iv = emptyPackages;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl6 = false;
            header.addEmptyPackage(it);
        }
        object = header.build();
        Intrinsics.checkNotNullExpressionValue(object, "header.build()");
        return object;
    }

    @Nullable
    protected abstract Integer getTOP_LEVEL_DECLARATION_COUNT_PER_FILE();

    @Nullable
    protected abstract Integer getTOP_LEVEL_CLASS_DECLARATION_COUNT_PER_FILE();

    private static final Collection<FqName> getPackagesFqNames$getSubPackagesOfModule(KlibMetadataSerializer this$0, ModuleDescriptor $module, FqName fqName2) {
        return this$0.includeOnlyModuleContent ? KlibMetadataSerializerKt.getPackageFragmentProviderForModuleContentWithoutDependencies($module).getSubPackagesOf(fqName2, getPackagesFqNames.getSubPackagesOfModule.1.INSTANCE) : $module.getSubPackagesOf(fqName2, getPackagesFqNames.getSubPackagesOfModule.2.INSTANCE);
    }

    private static final void getPackagesFqNames$getSubPackages(Set<FqName> result2, KlibMetadataSerializer this$0, ModuleDescriptor $module, FqName fqName2) {
        result2.add(fqName2);
        Iterable $this$forEach$iv = KlibMetadataSerializer.getPackagesFqNames$getSubPackagesOfModule(this$0, $module, fqName2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FqName it = (FqName)element$iv;
            boolean bl = false;
            KlibMetadataSerializer.getPackagesFqNames$getSubPackages(result2, this$0, $module, it);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializer$SerializerContext;", "", "serializerExtension", "Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializerExtension;", "topSerializer", "Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "classSerializer", "(Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializerExtension;Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;)V", "getClassSerializer", "()Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;", "setClassSerializer", "(Lorg/jetbrains/kotlin/serialization/DescriptorSerializer;)V", "getSerializerExtension", "()Lorg/jetbrains/kotlin/backend/common/serialization/metadata/KlibMetadataSerializerExtension;", "getTopSerializer", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ir.serialization.common"})
    public static final class SerializerContext {
        @NotNull
        private final KlibMetadataSerializerExtension serializerExtension;
        @NotNull
        private final DescriptorSerializer topSerializer;
        @NotNull
        private DescriptorSerializer classSerializer;

        public SerializerContext(@NotNull KlibMetadataSerializerExtension serializerExtension, @NotNull DescriptorSerializer topSerializer, @NotNull DescriptorSerializer classSerializer) {
            Intrinsics.checkNotNullParameter(serializerExtension, "serializerExtension");
            Intrinsics.checkNotNullParameter(topSerializer, "topSerializer");
            Intrinsics.checkNotNullParameter(classSerializer, "classSerializer");
            this.serializerExtension = serializerExtension;
            this.topSerializer = topSerializer;
            this.classSerializer = classSerializer;
        }

        public /* synthetic */ SerializerContext(KlibMetadataSerializerExtension klibMetadataSerializerExtension, DescriptorSerializer descriptorSerializer, DescriptorSerializer descriptorSerializer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                descriptorSerializer2 = descriptorSerializer;
            }
            this(klibMetadataSerializerExtension, descriptorSerializer, descriptorSerializer2);
        }

        @NotNull
        public final KlibMetadataSerializerExtension getSerializerExtension() {
            return this.serializerExtension;
        }

        @NotNull
        public final DescriptorSerializer getTopSerializer() {
            return this.topSerializer;
        }

        @NotNull
        public final DescriptorSerializer getClassSerializer() {
            return this.classSerializer;
        }

        public final void setClassSerializer(@NotNull DescriptorSerializer descriptorSerializer) {
            Intrinsics.checkNotNullParameter(descriptorSerializer, "<set-?>");
            this.classSerializer = descriptorSerializer;
        }

        @NotNull
        public final KlibMetadataSerializerExtension component1() {
            return this.serializerExtension;
        }

        @NotNull
        public final DescriptorSerializer component2() {
            return this.topSerializer;
        }

        @NotNull
        public final DescriptorSerializer component3() {
            return this.classSerializer;
        }

        @NotNull
        public final SerializerContext copy(@NotNull KlibMetadataSerializerExtension serializerExtension, @NotNull DescriptorSerializer topSerializer, @NotNull DescriptorSerializer classSerializer) {
            Intrinsics.checkNotNullParameter(serializerExtension, "serializerExtension");
            Intrinsics.checkNotNullParameter(topSerializer, "topSerializer");
            Intrinsics.checkNotNullParameter(classSerializer, "classSerializer");
            return new SerializerContext(serializerExtension, topSerializer, classSerializer);
        }

        public static /* synthetic */ SerializerContext copy$default(SerializerContext serializerContext, KlibMetadataSerializerExtension klibMetadataSerializerExtension, DescriptorSerializer descriptorSerializer, DescriptorSerializer descriptorSerializer2, int n, Object object) {
            if ((n & 1) != 0) {
                klibMetadataSerializerExtension = serializerContext.serializerExtension;
            }
            if ((n & 2) != 0) {
                descriptorSerializer = serializerContext.topSerializer;
            }
            if ((n & 4) != 0) {
                descriptorSerializer2 = serializerContext.classSerializer;
            }
            return serializerContext.copy(klibMetadataSerializerExtension, descriptorSerializer, descriptorSerializer2);
        }

        @NotNull
        public String toString() {
            return "SerializerContext(serializerExtension=" + this.serializerExtension + ", topSerializer=" + this.topSerializer + ", classSerializer=" + this.classSerializer + ')';
        }

        public int hashCode() {
            int result2 = this.serializerExtension.hashCode();
            result2 = result2 * 31 + this.topSerializer.hashCode();
            result2 = result2 * 31 + this.classSerializer.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SerializerContext)) {
                return false;
            }
            SerializerContext serializerContext = (SerializerContext)other;
            if (!Intrinsics.areEqual(this.serializerExtension, serializerContext.serializerExtension)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.topSerializer, serializerContext.topSerializer)) {
                return false;
            }
            return Intrinsics.areEqual(this.classSerializer, serializerContext.classSerializer);
        }
    }
}

